package outsideapi.service.handler.impl;

import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import cart.api.dto.order.SubOrderItemDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.model.GoodsPicture;
import goods.model.repository.GoodsPictureRepos;
import jd.api.request.order.JdOrderIdEntity;
import jd.api.request.order.OrderEntity;
import jd.api.request.order.OrderFreightEntity;
import jd.api.request.product.SkuEntity;
import jd.api.request.product.SkuIdAndNumEntity;
import jd.api.request.product.SkuIdsAndAreaEntity;
import jd.api.request.product.StockForOrderEntity;
import jd.api.response.order.OrderFreightResp;
import jd.api.response.order.OrderTrackResp;
import jd.api.vo.order.OrderFreightVO;
import jd.api.vo.order.OrdertrackResultVO;
import jd.api.vo.order.OrdertrackVO;
import jd.api.vo.product.PriceVO;
import jd.api.vo.product.ProductStateVO;
import jd.api.vo.product.StockNewResultVo;
import jd.api.vo.product.StockVO;
import jd.model.address.NationalAddress;
import jd.model.repository.NationalAddressRepos;
import lombok.extern.slf4j.Slf4j;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.dto.common.AddressDto;
import member.model.common.Address;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.AddressCommonApiStub;
import outsideapi.service.service.stub.JdOrderApiStub;
import outsideapi.service.service.stub.JdProductApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.vo.*;
import outsideapi.vo.jdorder.JdOrderConstant;
import outsideapi.vo.jdorder.OrderPriceSnap;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderRequst;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import utils.GlobalContants;
import utils.Lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//import jd.service.jdapi.order.JdOrderApiImpl;
//import jd.service.jdapi.product.JdProductApiImpl;

/**
 * Created by Liang Wenxu on 2016/11/24.
 */
@Slf4j
@Component
@Transactional(readOnly = true)
public class JdOutsideApiHandler implements OutsideApiHandler, ApplicationContextAware {
    /**
     * 查询产品规格对应的第三方库存信息
     *
     * @param requet FashionStatusRequetVo
     * @return
     */
    @Override
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        System.out.println("JdOutsideApiHandler.queryFashionStockState invoked...");
        HandlerRespVo<List<FashionStockStateVo>> handlerRespVo = new HandlerRespVo<>();
        List resStateVoList = new ArrayList<FashionStockStateVo>(); //返回数据
        handlerRespVo.setData(resStateVoList);
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);

        //根据国标码对照京东地区编码
//        String jdLvOne = addressApi.transTotrdCode(requet.getProvinceCode(), 1, "jdAddressId", "0");
        /** 直辖市判断 */
        String jdLvTwo = "0";
        String jdLvThree = "0";
        String areaCode = null;
        NationalAddress na = null;

        long transToNationAddressTime = System.currentTimeMillis();
        na = transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        log.info("第三方地址转换耗时 {} ms", System.currentTimeMillis() - transToNationAddressTime);

        if (!Lang.isEmpty(na)) {
            List<Map<String, Object>> resDataList = new ArrayList<>();
            Map<String, Object> resData = null;

            StringBuilder productCodeIds = new StringBuilder();
            List<Long> skuidList = new ArrayList<>();
            StockForOrderEntity stockForOrderEntity = new StockForOrderEntity();
            stockForOrderEntity.setSkuNums(new ArrayList<StockVO>());
            for (FashionNumsVo numsVo : requet.getFashionNums()) {
                productCodeIds.append(",").append(numsVo.getProductCode());
                skuidList.add(Long.parseLong(numsVo.getProductCode()));
                stockForOrderEntity.getSkuNums().add(new StockVO(Long.parseLong(numsVo.getProductCode()), numsVo.getCounts().intValue()));
            }
            stockForOrderEntity.setArea(na.getAreaString());


            SkuIdsAndAreaEntity skuIdsAndAreaEntity = new SkuIdsAndAreaEntity(productCodeIds.substring(1),
                    na.getLeveloneAddress(), na.getLeveltwoAddress(), na.getLevelthreeAddress(), na.getLevelfourAddress());

            Map<String, Object> resMapTmp = null;
            FashionStockStateVo stockStateVoTmp = null;

            /** 查询上下架状态 */
            long getProductStateTime = System.currentTimeMillis();
            List<ProductStateVO> productStateRes = jdProductApi.getProductState(skuidList);
            log.info("查询上下架状态耗时 {} 秒", (System.currentTimeMillis() - getProductStateTime) / 1000.0);

            if (!Lang.isEmpty(productStateRes)) {
                /** 处理销售状态返回 */
                for (ProductStateVO i : productStateRes) {
                    stockStateVoTmp = (FashionStockStateVo) findObjectInList(resStateVoList.toArray(new Object[0]), "productCode", i.getSku().toString());
                    if (stockStateVoTmp == null) {
                        stockStateVoTmp = new FashionStockStateVo();
                        stockStateVoTmp.setProductCode(i.getSku().toString());
                        for (FashionNumsVo numsVo : requet.getFashionNums()) {
                            if (i.getSku().toString().equals(numsVo.getProductCode())) {
                                stockStateVoTmp.setFashionId(numsVo.getFactionId());
                                break;
                            }
                        }
                        resStateVoList.add(stockStateVoTmp);
                    }
                    stockStateVoTmp.setOnSale(i.getState() == 1);
                    /** 默认非地区限制 */
                    stockStateVoTmp.setAreaRestrict(false);
                }

                /** 查询实时库存 */
                long getStockForOrderTime = System.currentTimeMillis();
                List<StockNewResultVo> stockForOrderRes = jdProductApi.getStockForOrder(stockForOrderEntity);
                log.info("查询实时库存耗时 {} 秒", (System.currentTimeMillis() - getStockForOrderTime) / 1000.0);

                if (!Lang.isEmpty(stockForOrderRes)) {
                    /** 处理剩余库存返回 */
                    for (StockNewResultVo i : stockForOrderRes) {
                        stockStateVoTmp = (FashionStockStateVo) findObjectInList(resStateVoList.toArray(new Object[0]), "productCode", i.getSkuId().toString());
                        if (stockStateVoTmp == null) {
                            stockStateVoTmp = new FashionStockStateVo();
                            stockStateVoTmp.setProductCode(i.getSkuId().toString());
                            for (FashionNumsVo numsVo : requet.getFashionNums()) {
                                if (i.getSkuId().toString().equals(numsVo.getProductCode())) {
                                    stockStateVoTmp.setFashionId(numsVo.getFactionId());
                                    break;
                                }
                            }
                            resStateVoList.add(stockStateVoTmp);
                        }
                        stockStateVoTmp.setStockCount(i.getRemainNum());
//                        stockStateVoTmp.setStockCount(12);
                        /** 判断有货无货标识 */
                        if (i.getStockStateId() == 34) { // 京东无货
                            stockStateVoTmp.setStockFlag(FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                            stockStateVoTmp.setStockCount(-1);
                        } else if (i.getStockStateId() == 36) { // 京东预定
                           // stockStateVoTmp.setStockFlag(FashionStockStateVo.STOCK_FLAG_PRE_ORDER);
                            stockStateVoTmp.setStockFlag(FashionStockStateVo.STOCK_FLAG_HAS_STOCK);
                        } else { // 京东可发货
                            stockStateVoTmp.setStockFlag(FashionStockStateVo.STOCK_FLAG_HAS_STOCK);
                        }
                    }
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                    handlerRespVo.setErrorCode(0);
                } else {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("第三方接口调用失败：getStockForOrder 接口返回为空");
                    handlerRespVo.setErrorCode(3);
                }
                /**LWX 2017/1/6修改： 不判断地区限制 START */
//                /** 获取是否地区限制购买 */
//                List<SkuIdsAndAreaVO> productLimitRes = jdProductApi.getProductLimit(skuIdsAndAreaEntity);
//                /** 处理地区限制返回 */
//                if(!Lang.isEmpty(productLimitRes)) {
//                    for(SkuIdsAndAreaVO i : productLimitRes) {
//                        stockStateVoTmp = (FashionStockStateVo) findObjectInList(resStateVoList.toArray(new Object[0]), "productCode", i.getSkuId().toString());
//                        if(stockStateVoTmp == null) {
//                            stockStateVoTmp = new FashionStockStateVo();
//                            stockStateVoTmp.setProductCode(i.getSkuId().toString());
//                            for(FashionNumsVo numsVo : requet.getFashionNums()) {
//                                if(i.getSkuId().toString().equals(numsVo.getProductCode())) {
//                                    stockStateVoTmp.setFashionId(numsVo.getFactionId());
//                                    break;
//                                }
//                            }
//                            resStateVoList.add(stockStateVoTmp);
//                        }
//                        stockStateVoTmp.setAreaRestrict(i.getIsAreaRestrict());
//                    }
//                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
//                    handlerRespVo.setErrorCode(0);
//                } else {
//                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
//                    handlerRespVo.setErrorCode(2);
//                }
                /**LWX 2017/1/6修改： 不判断地区限制 END */
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                handlerRespVo.setErrorCode(0);
            } else {
                /** 京东下架商品不查询其它接口 */
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("第三方接口调用失败：getProductState 接口返回为空");
                handlerRespVo.setErrorCode(3);
            }

        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("第三方接口地区代码转换失败");
            handlerRespVo.setErrorCode(2);
        }

        handlerRespVo.setData(resStateVoList);
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        HandlerRespVo<List<FashionPriceVo>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setData(null);
        SkuEntity skuEntity;
        List<FashionPriceVo> rsData = null;
        if(requet.getFashionPriceParamVos() != null) {
            rsData = new ArrayList<>();
            FashionPriceVo rspriceVo;
            StringBuilder skuStrs = new StringBuilder();
            for(FashionPriceParamVo fpv : requet.getFashionPriceParamVos()) {
                skuStrs.append(",").append(fpv.getProductCode());
            }
            skuEntity = new SkuEntity();
            skuEntity.setSku(skuStrs.substring(1));

            // 查询售价
            long getPriceTime = System.currentTimeMillis();
            List<PriceVO> price = jdProductApi.getPrice(skuEntity);
            log.info("查询商品价格耗时 {} 秒", (System.currentTimeMillis() - getPriceTime) / 1000.0);

            if (!Lang.isEmpty(price)) {
                for(PriceVO rtnPrice : price) {
                    for(FashionPriceParamVo fpv : requet.getFashionPriceParamVos()) {
                        if(fpv.getProductCode().equals(rtnPrice.getSkuId().toString())) {
                            rspriceVo = new FashionPriceVo();
                            rspriceVo.setFashionId(fpv.getFactionId());
                            rspriceVo.setProductCode(fpv.getProductCode());
                            rspriceVo.setCostPrice(rtnPrice.getPrice());
                            rspriceVo.setSalePrice(rtnPrice.getPrice());
                            rspriceVo.setMarketPrice(rtnPrice.getJdPrice());
                            rsData.add(rspriceVo);
                            break;
                        }
                    }
                }

            }
            handlerRespVo.setData(rsData);
        }


        return handlerRespVo;
    }

    /**
     * 查询第三方配送费用
     *
     * @param requet ShippingFeeRequetVo
     * @return HandlerRespVo<Map<String, Object>>
     * 返回的data示意：
     * data:[
     * freight: BigDecimal, // 总运费
     * baseFreight: BigDecimal, // 基础运费
     * remoteRegionFreight: BigDecimal, // 偏远运费
     * remoteFashions: String, // 需收取偏远运费的Fashion的id,多个ID使用","连接
     * ]
     */
    @Override
    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        NationalAddress na = transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        HandlerRespVo<Map<String, Object>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        if (na == null) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(1);
            handlerRespVo.setMessage("该店铺不支持当前配送地址");
        } else {
            OrderFreightEntity orderFreightEntity = new OrderFreightEntity();
            orderFreightEntity.setProvince(na.getLeveloneAddress());
            orderFreightEntity.setCity(na.getLeveltwoAddress());
            orderFreightEntity.setCounty(Lang.isEmpty(na.getLevelthreeAddress()) ? 0 : na.getLevelthreeAddress());
            orderFreightEntity.setTown(Lang.isEmpty(na.getLevelfourAddress()) ? 0 : na.getLevelfourAddress());
            if (Lang.isEmpty(requet.getPayType())) {
                requet.setPayType("4");
            } else {
                requet.setPayType(requet.getPayType().trim());
            }
            orderFreightEntity.setPaymentType(Integer.parseInt(requet.getPayType()));
            List<SkuIdAndNumEntity> skuLst = new ArrayList<>();
            SkuIdAndNumEntity skuIdAndNumEntity;
            if (!Lang.isEmpty(requet.getFashionNums())) {
                for (FashionNumsVo fnVo : requet.getFashionNums()) {
                    if (!Lang.isEmpty(fnVo.getProductCode()) && !Lang.isEmpty(fnVo.getCounts()) && fnVo.getCounts() > 0) {
                        skuIdAndNumEntity = new SkuIdAndNumEntity();
                        skuIdAndNumEntity.setId(Long.parseLong(fnVo.getProductCode()));
                        skuIdAndNumEntity.setNum(fnVo.getCounts().intValue());
                        skuLst.add(skuIdAndNumEntity);
                    }
                }
            }
            orderFreightEntity.setSku(skuLst);
//        京东运费查询接口调用
            OrderFreightVO apiRes = null;
            OrderFreightResp orderFreightResp =null;
            try {
                long queryFreightTime = System.currentTimeMillis();
                 orderFreightResp = jdOrderApi.queryFreight(orderFreightEntity);
                apiRes = orderFreightResp.getResult();
                log.info("京东运费查询接口调用耗时 {} 秒", (System.currentTimeMillis() - queryFreightTime) / 1000.0);
            } catch (Exception e) {
                e.printStackTrace();
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setErrorCode(1);
                handlerRespVo.setMessage("调用京东接口出错:" + e.getLocalizedMessage());
            }

            if (apiRes != null) {
                Map<String, Object> d = new HashMap<>();
                d.put("freight", apiRes.getFreight());
                d.put("baseFreight", apiRes.getBaseFreight());
                d.put("remoteRegionFreight", apiRes.getRemoteRegionFreight());
                /** 处理偏远运费需要显示的FashionId */
                if (!Lang.isEmpty(apiRes.getRemoteSku())) {
                    apiRes.setRemoteSku(apiRes.getRemoteSku().trim());
                    if (apiRes.getRemoteSku().contains("[") && apiRes.getRemoteSku().contains("]")) {
                        apiRes.setRemoteSku(apiRes.getRemoteSku().substring(apiRes.getRemoteSku().indexOf("[") + 1, apiRes.getRemoteSku().lastIndexOf("]")).trim());
                    }

                    if (!Lang.isEmpty(apiRes.getRemoteSku())) {
                        String[] fids = apiRes.getRemoteSku().split(",");
                        StringBuilder sb = new StringBuilder();
                        FashionNumsVo fashionNumsVo;
                        for (String id : fids) {
                            id = id.trim();
                            if (id.length() > 0) {
                                fashionNumsVo = (FashionNumsVo) findObjectInList(requet.getFashionNums().toArray(new Object[0]), "productCode", id);
                                if (fashionNumsVo != null) {
                                    sb.append(",").append(fashionNumsVo.getFactionId());
                                }
                            }
                        }
                        d.put("remoteFashions", sb.substring(1));
                    }
                }

                handlerRespVo.setData(d);

            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setErrorCode(1);
                handlerRespVo.setMessage(StringUtils.isEmpty(orderFreightResp.getResultMessage())?"调用京东接口出错，无数据返回":orderFreightResp.getResultMessage());
            }
        }
        return handlerRespVo;
    }

    @Override
    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        try {
            if (!Lang.isEmpty(areaCode)) {
                /** 京东地区表，只有四级地区一定有关联关系，其它级别的地区代码，采用该地区下首个子地区进行关联 */
                if (lv == AddressCommonApi.AddressLevel.CITY || lv == AddressCommonApi.AddressLevel.PROVINCE || lv == AddressCommonApi.AddressLevel.AREA) {
                    AddressDto addr = addressCommonApi.findById(areaCode);
                    if(!addr.getStoreCode().equals(Address.STORE_CODE_COMMON) && !addr.getStoreCode().equals(Address.STORE_CODE_JD)) {
                        /** 如果当前三级地区不是公共或京东的地区代码，地区需转换为当前二级下的首个可用三级 */
                        String pCode = addr.getParent().getId();
                        addr = addressCommonApi.findFirstChild(pCode, Address.STORE_CODE_JD, false);
                        addr = addr == null ? addressCommonApi.findFirstChild(pCode, Address.STORE_CODE_COMMON, false) : addr;

                        areaCode = addr == null ? areaCode : addr.getId();
                    }


                    NationalAddress na = nationalAddressRepos.findByLinkId(areaCode);
                    if (Lang.isEmpty(na)) { // 查询不到京东三级地区时，获取任意的四级地区，将四级置空
                        addr = addressCommonApi.findFirstChild(areaCode, Address.STORE_CODE_JD, false);
                        addr = addr == null ? addressCommonApi.findFirstChild(areaCode, Address.STORE_CODE_COMMON, false) : addr;
                        if (!Lang.isEmpty(addr)) {
                            na = nationalAddressRepos.findByLinkId(addr.getId());
                            if (!Lang.isEmpty(na)) {
//                            switch (lv) {
//                                case COUNTRY:
//                                    na.setLeveloneAddress(0);
//                                    na.setLeveloneAddressName(null);
//                                case PROVINCE:
//                                    na.setLeveltwoAddress(0);
//                                    na.setLeveltwoAddressName(null);
//                                case CITY:
//                                    na.setLevelthreeAddress(0);
//                                    na.setLevelthreeAddressName(null);
//                                case AREA:
//                                    na.setLevelfourAddress(0);
//                                    na.setLevelfourAddressName(null);
//                                case TOWN:
//                                    break;
//                            }
                            }
                        }
                    }
                    return na;
                } else {
                    NationalAddress na = nationalAddressRepos.findByLinkId(areaCode);
                    if(na == null) {
                        /** 查询不到四级时，使用上级进行查询 */
                        Map<Integer, String> areaCodeNoleList = addressCommonApi.areaCodeNodeList(areaCode);
                        String pCode = areaCodeNoleList.get(AddressCommonApi.AddressLevel.AREA.getValue());
                        pCode = Lang.isEmpty(pCode) ? areaCodeNoleList.get(AddressCommonApi.AddressLevel.CITY.getValue()) : pCode;
                        pCode = Lang.isEmpty(pCode) ? areaCodeNoleList.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()) : pCode;

                        if(Lang.isEmpty(pCode)) {
                            return null;
                        }

                        return transAreaCode(pCode, AddressCommonApi.AddressLevel.AREA);
                    }
                    return na;
                }
            } else {
                return null;
            }
        } catch (Exception e) {
            log.error("转换地址失败", e);
            return null;
        }
    }

    @Override
    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        Map<Integer, String> trdAreaCodeMap = new HashMap<>();
        NationalAddress na = transToNationAddress(
                areaMap.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.CITY.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.AREA.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.TOWN.getValue()));
        if(!Lang.isEmpty(na)) {
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), na.getLeveloneAddress().toString());
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), na.getLeveltwoAddress().toString());
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), Lang.isEmpty(na.getLevelthreeAddress()) ? ""+NationalAddress.DEFULT_ADDRESS_VALUE : na.getLevelthreeAddress().toString());
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), Lang.isEmpty(na.getLevelfourAddress()) ? ""+NationalAddress.DEFULT_ADDRESS_VALUE : na.getLevelfourAddress().toString());
        }
        return trdAreaCodeMap;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /**
     * 获取商品用于费率查询的区间基准值，京东为 协议价 / 市场价
     *
     * @param fashionPricesRequestVo
     * @return BigDecimal 京东折扣率
     */
    @Override
    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        if (!Lang.isEmpty(fashionPricesRequestVo.getCostPrice()) && !Lang.isEmpty(fashionPricesRequestVo.getMarkePrice())) {
//            return fashionPricesRequestVo.getCostPrice().divide(
//                    fashionPricesRequestVo.getMarkePrice(), 2, BigDecimal.ROUND_HALF_UP);
            /** 费率采用接近0舍入模式，如0.59711111舍入成0.59 */
            //价格为0返回0，不然会/by zero
            if (fashionPricesRequestVo.getCostPrice().compareTo(new BigDecimal(0)) < 1) {
                return new BigDecimal(0);
            } else {
                return fashionPricesRequestVo.getCostPrice().divide(
                        fashionPricesRequestVo.getMarkePrice(), 2, BigDecimal.ROUND_DOWN);
            }
        }
        return new BigDecimal(1);
    }

    @Override
    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        return null;
    }

    @Override
    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    @Override
    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }


    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        Long time = System.currentTimeMillis();
        List<OrderShippingPackageVo> resultList = new ArrayList<>();
        HandlerRespVo<List<OrderShippingPackageVo>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        if(!Lang.isEmpty(trdOrderNo)) {
            time = System.currentTimeMillis();
            OrderMainDto orderMain = orderMainApi.findOrderByThirdOrderNo(trdOrderNo);
            log.info("###########获取OrderMainDto############：{}ms", System.currentTimeMillis()-time);
            // 获取子订单
            if(orderMain != null) {
                //orderMain = orderMainApi.findById(orderMain.getId());
                for(SubOrderDto subOrder: orderMain.getSubOrders()) {
                    String subOrderNo = subOrder.getSubOrderNo();
                    time = System.currentTimeMillis();
                    List<SubOrderItemDto> subOrderItems = subOrder.getSubOrderItems();//orderMainApi.findSubOrderItemBySubOrderId(subOrder.getId());
                    log.info("###########获取OrderMainDto############：{}ms", System.currentTimeMillis()-time);
                    List<String> goodsIds = new ArrayList();
                    for (SubOrderItemDto subOrderItem : subOrderItems) {
                        if(!Lang.isEmpty(subOrderItem.getOrderItem())) {
                            goodsIds.add(subOrderItem.getOrderItem().getGoodsId());
                        }
                    }
                    time = System.currentTimeMillis();
                    List<GoodsPicture> goodsPictures = goodsPictureRepos.findByShowIndexAndGoodsIdIn(0, goodsIds);//goodsPictureRepos.findByGoods_IdIn(goodsIds);
                    log.info("###########获取goodsPictures############：{}ms", System.currentTimeMillis()-time);
                    List<GoodsInfoVo> goodsInfos = new ArrayList<>();
                    for (GoodsPicture picture : goodsPictures) {
                        GoodsInfoVo goodsInfo = new GoodsInfoVo();
                        goodsInfo.setGoodsId(picture.getGoods().getId());
                        goodsInfo.setGoodsName(picture.getGoods().getName());
                        goodsInfo.setGoodsPictrue(picture.getPicturePath());
                        goodsInfos.add(goodsInfo);
                    }
                    OrderShippingPackageVo orderShippingPackageVo = new OrderShippingPackageVo();
                    orderShippingPackageVo.setGoodsInfos(goodsInfos);
                    orderShippingPackageVo.setTrdSubOrderNo(subOrderNo);
                    orderShippingPackageVo.setPackageId(subOrderNo);
                    if(!Lang.isEmpty(subOrder.getTrdSpState())&& Lang.equals(subOrder.getTrdSpState(),SubOrderDto.TRD_SP_HAS_BEEN_PUT)){
                        orderShippingPackageVo.setReceiptsFlag(true);
                    }else{
                        orderShippingPackageVo.setReceiptsFlag(false);
                    }
                    List<OrderShippingTrackVo> trackInfoList = new ArrayList<>();

                    // 每个子订单号调用一次接口
                    JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
                    jdOrderIdEntity.setJdOrderId(Long.parseLong(subOrderNo));
                    time = System.currentTimeMillis();
                    OrderTrackResp orderTrackResp = jdOrderApi.queryOrderTrack(jdOrderIdEntity);
                    log.info("###########调用京东物流接口############：{}ms", System.currentTimeMillis()-time);
                    OrdertrackResultVO result = orderTrackResp.getResult();
                    if(result != null) {
                        List<OrdertrackVO> ordertracks = result.getOrderTrack();

                        OrderShippingTrackVo orderShippingTrackVo;
                        for(OrdertrackVO track : ordertracks) {
                            orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(track.getContent());
                            orderShippingTrackVo.setMsgTime(track.getMsgTime());
                            orderShippingTrackVo.setOperator(track.getOperator());
                            trackInfoList.add(orderShippingTrackVo);
                        }
                    }
                    orderShippingPackageVo.setTrackInfoList(trackInfoList);
                    resultList.add(orderShippingPackageVo);
                }
            }

            handlerRespVo.setData(resultList);
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(0);
        }
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        HandlerRespVo<String> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        if(!Lang.isEmpty(trdOrderNo)) {
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(Long.parseLong(trdOrderNo));
            Map<String, Object> queryOrder = jdOrderApi.queryOrder(jdOrderIdEntity);
            if(queryOrder != null) {
                if("1".equals(queryOrder.get("submitState").toString())) {
                    // 已确认订单
                    handlerRespVo.setData(OutsideProductApi.TRD_ORDER_STATUS_COMFIRMED);

                } else if("0".equals(queryOrder.get("orderState").toString())) {
                    // 正常订单
                    handlerRespVo.setData(OutsideProductApi.TRD_ORDER_STATUS_CANCELED);
                } else if("1".equals(queryOrder.get("orderState").toString())) {
                    // 已取消订单
                    handlerRespVo.setData(OutsideProductApi.TRD_ORDER_STATUS_NORMAL);
                }
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
                handlerRespVo.setErrorCode(0);
                handlerRespVo.setData(OutsideProductApi.TRD_ORDER_NO_ORDER);
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(0);
            handlerRespVo.setData(OutsideProductApi.TRD_ORDER_NO_ORDER);
        }
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo){
        List<OrderShippingPackageVo> resultList = new ArrayList<>();
        HandlerRespVo<List<OrderShippingPackageVo>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        if(!Lang.isEmpty(trdOrderNo)) {
            OrderMainDto orderMain = orderMainApi.findOrderByThirdOrderNo(trdOrderNo);
            // 获取子订单
            if(orderMain != null) {
                List<String> trdOrderNos = new ArrayList<>();
//                if(orderMain.getSubOrders().size() > 1) {
                // 拆单
                orderMain = orderMainApi.findById(orderMain.getId());
                for(SubOrderDto subOrder : orderMain.getSubOrders()) {
                    trdOrderNos.add(subOrder.getSubOrderNo());
                }
//                } else {
//                     不拆单
//                    trdOrderNos.add(orderMain.getThirdOrderNo());
//                }
                for(String subOrderNo : trdOrderNos) {
                    OrderShippingPackageVo orderShippingPackageVo = new OrderShippingPackageVo();
                    orderShippingPackageVo.setPackageId(subOrderNo);
                    List<OrderShippingTrackVo> trackInfoList = new ArrayList<>();

                    // 每个子订单号调用一次接口
                    JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
                    jdOrderIdEntity.setJdOrderId(Long.parseLong(subOrderNo));
                    OrderTrackResp orderTrackResp = jdOrderApi.queryOrderTrack(jdOrderIdEntity);
                    OrdertrackResultVO result = orderTrackResp.getResult();
                    if(result != null) {
                        List<OrdertrackVO> ordertracks = result.getOrderTrack();

                        OrderShippingTrackVo orderShippingTrackVo;
                        for(OrdertrackVO track : ordertracks) {
                            orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(track.getContent());
                            orderShippingTrackVo.setMsgTime(track.getMsgTime());
                            orderShippingTrackVo.setOperator(track.getOperator());
                            trackInfoList.add(orderShippingTrackVo);
                        }
                    }
                    orderShippingPackageVo.setTrackInfoList(trackInfoList);
                    resultList.add(orderShippingPackageVo);
                }
            }

            handlerRespVo.setData(resultList);
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(0);
        }
        return handlerRespVo;
    }

    /**
     * 生成预占单
     *
     * @param reserveOrderVo
     * @param storeCode
     * @return 预订单ｉｄ对象
     */
    @Override
    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo<>(null);
    }

    /**
     * 删除预占单
     *
     * @param reserveOrderIdVo
     * @param storeCode
     * @return true/false
     */
    @Override
    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo<>(true);
    }


    public String getAreaString(Map addrMap) {
        StringBuilder sb = new StringBuilder();
        if(!Lang.isEmpty(addrMap.get(GlobalContants.AREA_MAP_KEY_PROVINCE_ID))) {
            sb.append(addrMap.get(GlobalContants.AREA_MAP_KEY_PROVINCE_ID)).append("_");
            sb.append(Lang.isEmpty(addrMap.get(GlobalContants.AREA_MAP_KEY_CITY_ID)) ? "0" : addrMap.get(GlobalContants.AREA_MAP_KEY_CITY_ID)).append("_");
            sb.append(Lang.isEmpty(addrMap.get(GlobalContants.AREA_MAP_KEY_COUNTY_ID)) ? "0" : addrMap.get(GlobalContants.AREA_MAP_KEY_COUNTY_ID)).append("_");
            sb.append(Lang.isEmpty(addrMap.get(GlobalContants.AREA_MAP_KEY_TOWN_ID)) ? "0" : addrMap.get(GlobalContants.AREA_MAP_KEY_TOWN_ID));
        } else {
            sb.append("0_0_0_0");
        }

        return sb.toString();
    }

    private Object findObjectInList(Object[] list, Object key, Object value) {
        String getterMethodName = "";
        for (Object v : list) {
            for (Field f : v.getClass().getDeclaredFields()) {
                if (f.getName().equals(key)) {
                    try {
                        StringBuilder sb = new StringBuilder(f.getName());
                        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
                        sb.insert(0, "get");
                        getterMethodName = sb.toString();
                        if (value.equals(v.getClass().getDeclaredMethod(getterMethodName).invoke(v))) {
                            return v;
                        }
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return null;
                    } catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return null;
                    } catch (InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }

        return null;
    }

    private Map<String, Object> findInMappedList(List<Map<String, Object>> list, String key, Object value) {
        Object valInList = null;
        for (Map m : list) {
            valInList = m.get(key);
            if (valInList != null && value.equals(valInList)) {
                return m;
            }
        }

        return null;
    }

    /**
     * 国标-京东地址转换
     * @param provinceCode 省
     * @param cityCode 市
     * @param countyCode 区
     * @param areaCode 县
     * @return 京东地址
     */
    private NationalAddress transToNationAddress(String provinceCode, String cityCode, String countyCode, String areaCode) {
        NationalAddress na = null;
        if (!Lang.isEmpty(areaCode)) {
            /** 四级地区 */
            na = (NationalAddress) this.transAreaCode(areaCode, AddressCommonApi.AddressLevel.TOWN);
        }
        if (Lang.isEmpty(na) && !Lang.isEmpty(countyCode)) {
            /** 三级地区 */
            na = (NationalAddress) this.transAreaCode(countyCode, AddressCommonApi.AddressLevel.AREA);
        }
        if (Lang.isEmpty(na) && !Lang.isEmpty(cityCode)) {
            /** 二级地区 */
            na = (NationalAddress) this.transAreaCode(cityCode, AddressCommonApi.AddressLevel.CITY);
            /** 至少要以二级地区查询（市） */
        }
        if (Lang.isEmpty(na) && !Lang.isEmpty(provinceCode)) {
            /** 一级地区 */
            na = (NationalAddress) this.transAreaCode(provinceCode, AddressCommonApi.AddressLevel.PROVINCE);
        }

        return na;
    }

    /**
     * 检查京东配置下单预警，直接进行拦截
     * @return
     */
    private void checkOrderWanner() throws SupplierTakeOrderFalidException {
        String jdOrderWarnStr = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON,
                SystemConfigDto.CONFIG_CODE_JD_ORDER_CONFIG_WARN, SystemConfigValueDto.CONFIG_VALUE_TYPE_JD_ORDER_CONSTANT_WARN,
                true, true);
        if(!Lang.isEmpty(jdOrderWarnStr)) {
            if(!TrdOrderHandlerUtils.checkOrderWannerConfigJson(jdOrderWarnStr)) {
                throw new SupplierTakeOrderFalidException("下单拦截已配置", SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
            }
        }
    }

    //京东下单参数使用配置化
    private void gennerJdOrderConstant(OrderEntity orderEntity){
        String jdOrderConstantStr = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON,
                SystemConfigDto.CONFIG_CODE_JD_ORDER_CONFIG, SystemConfigValueDto.CONFIG_VALUE_TYPE_JD_ORDER_CONSTANT,
                true, true);
        if(!Lang.isEmpty(jdOrderConstantStr)) {
            try{
                JSONObject obj = JSON.parseObject(jdOrderConstantStr);

                Integer invoiceState = (Integer) obj.get("invoiceState");
                Integer invoiceType = (Integer) obj.get("invoiceType");
                Integer selectedInvoiceTitle = (Integer) obj.get("selectedInvoiceTitle");
                String invoiceName = (String) obj.get("invoiceName");
                Integer invoiceContent = (Integer) obj.get("invoiceContent");
                Integer paymentType = (Integer) obj.get("paymentType");
                Integer isUseBalance = (Integer) obj.get("isUseBalance");
                Integer submitState =(Integer) obj.get("submitState");
                Integer doOrderPriceMode = (Integer) obj.get("doOrderPriceMode");
                String email = (String) obj.get("email");
                orderEntity.setEmail(email);//邮箱 Y-
                orderEntity.setInvoiceState(invoiceState);
                orderEntity.setInvoiceType(invoiceType);
                orderEntity.setSelectedInvoiceTitle(selectedInvoiceTitle);
                orderEntity.setInvoiceName(invoiceName);
                orderEntity.setInvoiceContent(invoiceContent);
                orderEntity.setPaymentType(paymentType);
                orderEntity.setIsUseBalance(isUseBalance);
                orderEntity.setSubmitState(submitState);
                orderEntity.setDoOrderPriceMode(doOrderPriceMode);
            } catch (Exception e) {
                log.info("数据库保存的参数信息是错误的，请修改");
                e.printStackTrace();
                //defaultGennerJdOrderConstant(orderEntity);
            }

        }else {//系统参数未进行配置的时候，使用默认的，避免下单报错
            defaultGennerJdOrderConstant(orderEntity);
        }
    }

    private void defaultGennerJdOrderConstant(OrderEntity orderEntity){
        orderEntity.setEmail(JdOrderConstant.email);//邮箱 Y-
        orderEntity.setInvoiceState(JdOrderConstant.invoiceState);
        orderEntity.setInvoiceType(JdOrderConstant.invoiceType);
        orderEntity.setSelectedInvoiceTitle(JdOrderConstant.selectedInvoiceTitle);
        orderEntity.setInvoiceName(JdOrderConstant.invoiceName);
        orderEntity.setInvoiceContent(JdOrderConstant.invoiceContent);
        orderEntity.setPaymentType(JdOrderConstant.paymentType);
        orderEntity.setIsUseBalance(JdOrderConstant.isUseBalance);
        orderEntity.setSubmitState(JdOrderConstant.submitState);
        orderEntity.setDoOrderPriceMode(JdOrderConstant.doOrderPriceMode);
    }

    /**
     * 从OrderMain拷贝出商品列表
     *
     * @param orderItems
     * @return
     */
    List<SkuIdAndNumEntity> cpySkuList(List<OrderItemVo> orderItems) {
        List<SkuIdAndNumEntity> retSku = new ArrayList<>();
        for (OrderItemVo orderItem : orderItems) {
            //第三方商品编号
            Long skuId = Long.parseLong(orderItem.getSku());
            //商品数量
            Integer num = orderItem.getCount();
            retSku.add(new SkuIdAndNumEntity(skuId, num));
        }
        return retSku;
    }

    /**
     * 生成下单时的价格快照
     *
     * @param orderMain
     * @return
     */
    String generateOrderPriceSnap(OrderRequst orderMain) {
        List<OrderPriceSnap> snaps = new ArrayList<>();
        List<OrderItemVo> orderItems = orderMain.getOrderItems();
        for (OrderItemVo orderItem : orderItems) {
            Long skuId = Long.parseLong(orderItem.getSku());
            snaps.add(new OrderPriceSnap(orderItem.getCostPrice(), skuId));
        }
        return JSON.toJSONString(snaps);
    }
    
    private ApplicationContext applicationContext;

    @Autowired
    JdProductApiStub jdProductApi;

    @Autowired
    JdOrderApiStub jdOrderApi;

    @Autowired
    OrderMainApiStub orderMainApi;

    @Autowired
    NationalAddressRepos nationalAddressRepos;

    @Autowired
    AddressCommonApiStub addressCommonApi;

    @Autowired
    GoodsPictureRepos goodsPictureRepos;

    @Autowired
    OutsideProductApi outsideProductApi;

    @MotanReferer
    MemberAddressApi memberAddressApi;

    @MotanReferer
    SystemConfigApi systemConfigApi;

}
