package outsideapi.service.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import localstore.api.LocalStoreApi;
import localstore.api.LocalStoreProductApi;
import lombok.extern.slf4j.Slf4j;
import member.api.AddressCommonApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.vo.*;
import outsideapi.vo.order.OrderMainDto;
import pool.vo.ProviderGoodsVo;
import shipping.api.LogisticFollowApi;
import shipping.api.LogisticsQueryApi;
import shipping.api.definition.LogisticStatus;
import shipping.api.dto.LogisticFollowDto;
import shipping.api.showapi.LogisticsFollowOutApi;
import shipping.api.vo.showapi.LogisticsFollowVo;
import sinomall.global.common.response.BaseResponse;
import store.api.dto.mapdto.MallShippingDto;
import utils.Lang;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
@Slf4j
@Component("localStoreHandler")
@Transactional(readOnly = true)
public class LocalStoreApiHandler implements OutsideApiHandler,ApplicationContextAware {

    private static Logger logger = LoggerFactory.getLogger(LocalStoreApiHandler.class);

    @MotanReferer
    LocalStoreProductApi localStoreProductApi;

    @MotanReferer
    LocalStoreApi localStoreApi;

    @MotanReferer
    LogisticsQueryApi logisticsQueryApi;

    @MotanReferer
    LogisticsFollowOutApi logisticsFollowOutApi;
    @MotanReferer
    LogisticFollowApi logisticFollowApi;

    private ApplicationContext applicationContext;

    @Override
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        System.out.println("LocalStoreApiHandler.queryFashionStockState invoked...");
        HandlerRespVo<List<FashionStockStateVo>> handlerRespVo = new HandlerRespVo<>();
        List<FashionStockStateVo> fashionStockStateVos = new ArrayList<>();
        List<String> skus =  requet.getFashionNums().stream().filter(f -> !Lang.isEmpty(f.getProductCode())).map(i -> i.getProductCode()).collect(Collectors.toList());
        Map<String,String> map= requet.getFashionNums().stream().collect(Collectors.toMap(FashionNumsVo::getProductCode,FashionNumsVo::getFactionId));
        if(Lang.isEmpty(requet.getStoreId())){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("第三方接口调用失败：storeId为空");
            handlerRespVo.setErrorCode(3);
            return handlerRespVo;
        }
        if(Lang.isEmpty(skus)){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("第三方接口调用失败：sku为空");
            handlerRespVo.setErrorCode(3);
            return handlerRespVo;
        }
        BaseResponse baseResponse= localStoreProductApi.queryFashionStockState(skus,requet.getStoreId());

        List<ProviderGoodsVo> providerGoodsVoList = (List<ProviderGoodsVo>) baseResponse.getResult();
        for(int i=0;i<providerGoodsVoList.size();i++){
            FashionStockStateVo fashionStockStateVo=new FashionStockStateVo();
            if(providerGoodsVoList.get(i).getStatus().equals('0')){
                fashionStockStateVo.setOnSale(false);
            }
            if(providerGoodsVoList.get(i).getStatus().equals('1')){
                fashionStockStateVo.setOnSale(true);
            }
            if (providerGoodsVoList.get(i).getStockCount()>0){
                fashionStockStateVo.setStockFlag(1);
            }
            if (providerGoodsVoList.get(i).getStockCount()<=0){
                fashionStockStateVo.setStockFlag(0);
            }
            fashionStockStateVo.setFashionId(map.get(providerGoodsVoList.get(i).getSku()));
            fashionStockStateVo.setProductCode(providerGoodsVoList.get(i).getSku());
            fashionStockStateVo.setStockCount(providerGoodsVoList.get(i).getStockCount());
            fashionStockStateVo.setIsAreaRestrict(false);
            fashionStockStateVo.setOnSale(true);
            fashionStockStateVos.add(fashionStockStateVo);
        }
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        handlerRespVo.setMessage("第三方接口调用成功：queryGoodsShelves接口调用成功");
        handlerRespVo.setData(fashionStockStateVos);
        return handlerRespVo;

    }

    @Override
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        System.out.println("LocalStoreApiHandler.queryFashionPrice invoked...");
        HandlerRespVo<List<FashionPriceVo>> handlerRespVo = new HandlerRespVo<>();
        List<FashionPriceVo> fashionPriceVos = new ArrayList<>();
        FashionPriceVo fashionPriceVo=new FashionPriceVo();
        List<String> skus =  requet.getFashionPriceParamVos().stream().filter(f -> !Lang.isEmpty(f.getProductCode())).map(i -> i.getProductCode()).collect(Collectors.toList());
        Map<String,String> map=requet.getFashionPriceParamVos().stream().collect(Collectors.toMap(FashionPriceParamVo::getProductCode,FashionPriceParamVo::getFactionId));
        if(Lang.isEmpty(requet.getStoreId())){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("第三方接口调用失败：storeId为空");
            handlerRespVo.setErrorCode(3);
            return handlerRespVo;
        }
        if(Lang.isEmpty(skus)){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("第三方接口调用失败：sku为空");
            handlerRespVo.setErrorCode(3);
            return handlerRespVo;
        }
        BaseResponse baseResponse= localStoreProductApi.queryFashionStockState(skus,requet.getStoreId());
        List<ProviderGoodsVo> providerGoodsVoList = (List<ProviderGoodsVo>) baseResponse.getResult();
        for(int i=0;i<providerGoodsVoList.size();i++){
            fashionPriceVo.setFashionId(map.get(providerGoodsVoList.get(i).getSku()));
            fashionPriceVo.setProductCode(providerGoodsVoList.get(i).getSku());
            fashionPriceVo.setCostPrice(providerGoodsVoList.get(i).getCostPrice());
            fashionPriceVo.setSalePrice(providerGoodsVoList.get(i).getSalePrice());
            fashionPriceVo.setMarketPrice(providerGoodsVoList.get(i).getMarketPrice());
            fashionPriceVos.add(fashionPriceVo);
        }
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        handlerRespVo.setMessage("第三方接口调用成功：queryGoodsShelves接口调用成功");
        handlerRespVo.setData(fashionPriceVos);
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        HandlerRespVo<Map<String, Object>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        Map<String, Object> d = new HashMap<>();
        d.put("freight",BigDecimal.ZERO);
        d.put("baseFreight", BigDecimal.ZERO);
        d.put("remoteRegionFreight", BigDecimal.ZERO);
        handlerRespVo.setData(d);
        return handlerRespVo;
    }

    @Override
    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return areaCode;
    }

    @Override
    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        return areaMap;
    }

    @Override
    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        return BigDecimal.ONE;
    }

    @Override
    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        return null;
    }

    @Override
    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    @Override
    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }

    /**
     * 查询物流
     * @param thirdOrderNo 第三方订单号
     * @return
     */
    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String thirdOrderNo) {
        // 存放需同步到本地的物流信息
        List<LogisticFollowDto> saveLocalLogistics = new ArrayList<>();
        BaseResponse orderLogisticsResponse = localStoreProductApi.findOrderLogistics(thirdOrderNo);
        if (!Lang.isEmpty(orderLogisticsResponse.getResult())){
            List<MallShippingDto> mallShippingDtos = (List<MallShippingDto>) orderLogisticsResponse.getResult();
            // 多包裹
            List<OrderShippingPackageVo> orderShippingPackageVos = new ArrayList<>(mallShippingDtos.size());
            OrderShippingPackageVo orderShippingPackageVo = null;
            try {
                JSONArray logisticInfos = null;
                List<OrderShippingTrackVo> orderShippingPackages = null;
                for (MallShippingDto mallShipping : mallShippingDtos) {
                    orderShippingPackageVo = new OrderShippingPackageVo();
                    // 先到本地找信息
                    LogisticFollowDto logisticFollowDto = logisticsQueryApi.findByLogisticNo(mallShipping.getShippingNo());
                    if (!Lang.isEmpty(logisticFollowDto) && LogisticStatus.finallyStatus.contains(logisticFollowDto.getLogisticStatus())
                            && !Lang.isEmpty(logisticFollowDto.getLogisticData())){
                        logisticInfos = JSONArray.parseArray(logisticFollowDto.getLogisticData());
                        // 封装物流跟踪栈信息
                        orderShippingPackages = new ArrayList<>(logisticInfos.size());
                        buildOrderShippingTrack(logisticInfos,orderShippingPackages,logisticFollowDto,orderShippingPackageVo,mallShipping);
                    }else{
                        LogisticsFollowVo logisticsFollowVo = logisticsFollowOutApi.findLogisticsInfo(mallShipping.getShippingCode(),
                                mallShipping.getShippingNo());
                        if (!Lang.isEmpty(logisticsFollowVo)){
                            LogisticFollowDto logisticFollow = new LogisticFollowDto();
                            logisticFollow.setLogisticStatus(logisticsFollowVo.getStatus());
                            logisticFollow.setLogisticData(logisticsFollowVo.getData());
                            logisticFollow.setLogisticCompany(logisticsFollowVo.getExpTextName());
                            logisticFollow.setThirdOrderNo(mallShipping.getShippingNo());
                            logisticFollow.setOrderNo(mallShipping.getOrderNo());
                            // 判断本次调用第三方接口查询到的物流状态是否最终状态
                            if (LogisticStatus.finallyStatus.contains(logisticsFollowVo.getStatus())){
                                saveLocalLogistics.add(logisticFollow);
                            }
                            if (!Lang.isEmpty(logisticsFollowVo.getData())){
                                logisticInfos = JSONArray.parseArray(logisticsFollowVo.getData());
                                // 封装物流跟踪栈信息
                                orderShippingPackages = new ArrayList<>(logisticInfos.size());
                                buildOrderShippingTrack(logisticInfos,orderShippingPackages,logisticFollow, orderShippingPackageVo, mallShipping);
                            }
                        }
                    }
                    orderShippingPackageVos.add(orderShippingPackageVo);
                }
                if (!Lang.isEmpty(saveLocalLogistics)){
                    logisticFollowApi.batchSaveLogisticInfo(saveLocalLogistics);
                }
            }catch (Exception e){
                logger.info("#####{}",e);
            }
            return new HandlerRespVo<>(orderShippingPackageVos);
        }
        return new HandlerRespVo<>(HandlerRespVo.RESPONSE_STATUS_ERROR,HandlerRespVo.RESPONSE_STATUS_ERROR,"未查询到物流信息");
    }
    /**
     * 封装物流信息跟踪栈信息
     * @param logisticInfos 物流动态json数组
     * @param orderShippingPackages 物流信息跟踪栈集合
     * @param logisticFollowDto 查询出来的物流信息
     * @param orderShippingPackageVo 当前包裹
     * @param mallShipping
     */
    private void buildOrderShippingTrack(JSONArray logisticInfos, List<OrderShippingTrackVo> orderShippingPackages,
                                         LogisticFollowDto logisticFollowDto, OrderShippingPackageVo orderShippingPackageVo, MallShippingDto mallShipping){
        orderShippingPackageVo.setTrdSubOrderNo(logisticFollowDto.getThirdOrderNo());
        orderShippingPackageVo.setPackageName(mallShipping.getShippingCompany());
        orderShippingPackageVo.setReceiptsFlag(LogisticStatus.LOGISTIC_STATUS_RECEIVING.getValue().equals(logisticFollowDto.getLogisticStatus()));
        orderShippingPackageVo.setStatus(LogisticStatus.logisticStatusMap.get(logisticFollowDto.getLogisticStatus()));
        OrderShippingTrackVo orderShippingTrackVo = null;
        JSONObject jsonObject = null;
        for (Object obj : logisticInfos) {
            jsonObject = (JSONObject) obj;
            orderShippingTrackVo = new OrderShippingTrackVo();
            orderShippingTrackVo.setMsgTime(jsonObject.getDate("time"));
            orderShippingTrackVo.setContent(jsonObject.getString("context"));
            orderShippingPackages.add(orderShippingTrackVo);
        }
        orderShippingPackageVo.setTrackInfoList(orderShippingPackages);
    }

    @Override
    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {

        return null;
    }

    @Override
    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo,String storeId) {
        HandlerRespVo<String> respVo = new HandlerRespVo<>();
        BaseResponse orderStatus = localStoreApi.findOrderStatus(trdOrderNo, storeId);
        if(Lang.isEmpty(orderStatus.getResult())){
            respVo.setErrorCode(3);
            respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            respVo.setMessage("第三方订单状态查询失败");
            respVo.setData(null);
            return respVo;
        }
        OrderMainDto result = (OrderMainDto)orderStatus.getResult();
        respVo.setErrorCode(0);
        respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        respVo.setMessage("第三方订单号查询成功");
        respVo.setData(result.getOutsideStatus());
        return respVo;
    }

    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        return null;
    }

    /**
     * 生成预占单
     *
     * @param reserveOrderVo
     * @param storeCode
     * @return 预订单ｉｄ对象
     */
    @Override
    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo<>(null);
    }

    /**
     * 删除预占单
     *
     * @param reserveOrderIdVo
     * @param storeCode
     * @return true/false
     */
    @Override
    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo<>(true);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
