package outsideapi.service.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import goods.dto.product.ProductFashionDto;
import member.api.AddressCommonApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.ProductFashionApiStub;
import outsideapi.service.service.stub.ProtocolApiStub;
import outsideapi.vo.*;
import shipping.api.definition.LogisticStatus;
import shipping.api.dto.LogisticFollowDto;
import shipping.api.vo.showapi.LogisticsFollowVo;
import uninogift.vo.protocol.ProductQueryVo;
import uninogift.vo.protocol.ProtocolFashionStateVo;
import uninogift.vo.protocol.ProtocolOrderLogisticDto;
import utils.Lang;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Liang Wenxu
 * @since 2018-01-16
 */
@Component
@Transactional(readOnly = true, propagation = Propagation.REQUIRES_NEW)
public class ProtocolOutsideApiHandler implements OutsideApiHandler {
    private static Logger logger = LoggerFactory.getLogger(ProtocolOutsideApiHandler.class);

    @Autowired
    ProtocolApiStub protocolApi;

    @Autowired
    ProductFashionApiStub productFashionApi;

    @Override
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        // 协议供应商，所有均为可售
        List<FashionStockStateVo> fashionStockStateVos = new ArrayList<>();
        HandlerRespVo<List<FashionStockStateVo>> respVo = new HandlerRespVo<>();
        FashionStockStateVo temp;

        List<String> fashionIds =  requet.getFashionNums().stream().filter(f -> !Lang.isEmpty(f.getFactionId())).map(i -> i.getFactionId()).collect(Collectors.toList());

        List<ProductFashionDto> productFashionList = productFashionApi.findByIds(fashionIds);
//        productFashionList = productFashionList == null ? new ArrayList<>() : productFashionList;
        // 过滤在售商品，并创建需要查询协议状态的产品请求对象
        List<ProductQueryVo> productQueryList = productFashionList.stream()
                .filter(p -> p!=null && p.getOnSale()).map(p -> {
                    ProductQueryVo queryVo = new ProductQueryVo();
                    queryVo.setProductFashionId(p.getId());
                    return queryVo;
                }).collect(Collectors.toList());
        // 过滤不可售的产品
        List<ProductFashionDto> notOnSaleFashions = productFashionList.stream()
                .filter(p -> p!=null && !p.getOnSale()).collect(Collectors.toList());

        // 先判断Fashion表自身状态 过滤不可售的产品
        for(ProductFashionDto f : notOnSaleFashions) { // onSale为false的直接返回不可售
            FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
            fashionStockStateVo.setFashionId(f.getId());
            fashionStockStateVo.setProductCode(f.getProductCode());
            fashionStockStateVo.setIsAreaRestrict(false);
            fashionStockStateVo.setStockCount(-1); // -1表示不做库存校验
            fashionStockStateVo.setOnSale(false);
            fashionStockStateVos.add(fashionStockStateVo);
        }

        // 可售产品再根据协议状态再次筛选

        // 查询协议里的产品状态
        if(productQueryList != null && productQueryList.size() > 0) {
            List<ProtocolFashionStateVo> procFashionStates = protocolApi.queryFashionState(productQueryList, requet.getCompanyId());
            // 根据协议产品的状态，返回商品状态
            for(ProtocolFashionStateVo state : procFashionStates) {
                FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
                fashionStockStateVo.setFashionId(state.getFashionId());
                fashionStockStateVo.setProductCode(state.getSku());
                fashionStockStateVo.setIsAreaRestrict(false);
                fashionStockStateVo.setStockCount(-1); // -1表示不做库存校验
                fashionStockStateVo.setOnSale(state.getOnSale());
                switch (state.getStockState()) { // 转换库存代码，消除供应商的库存个性
                    case ProtocolFashionStateVo.STOCK_STATE_CODE_NORMAL:
                        fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_HAS_STOCK);
                        break;
                    case ProtocolFashionStateVo.STOCK_STATE_CODE_OUTOFSTOCK:
                        fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                        break;
                    case ProtocolFashionStateVo.STOCK_STATE_CODE_PRESALE:
                        fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_PRE_ORDER);
                        break;
                    default:
                        fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                }

                if(ProtocolFashionStateVo.NOTSALE_REASON_NOCOMPANY_PREM.equals(state.getNotsaleReason())) {
                    fashionStockStateVo.setNotsaleReason(FashionStockStateVo.NOTSALE_REASON_NOCOMPANY_PREM);
                } else if(ProtocolFashionStateVo.NOTSALE_REASON_PRODUCT_DOWN.equals(state.getNotsaleReason())) {
                    fashionStockStateVo.setNotsaleReason(FashionStockStateVo.NOTSALE_REASON_PRODUCT_DOWN);
                }

                fashionStockStateVos.add(fashionStockStateVo);
            }
        }


        respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        respVo.setData(fashionStockStateVos);
        return respVo;
    }

    @Override
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        return null;
    }

    @Override
    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        // 协议供应商无运费
        HandlerRespVo<Map<String, Object>> respVo = new HandlerRespVo<>();
        Map data = new HashMap();

        data.put("freight", BigDecimal.ZERO); // 总运费
        data.put("baseFreight", BigDecimal.ZERO); // 基础运费
        data.put("remoteRegionFreight", BigDecimal.ZERO); // 偏远运费
        respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        respVo.setData(data);
        return respVo;
    }

    @Override
    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return areaCode;
    }

    @Override
    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        return areaMap;
    }

    @Override
    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        return BigDecimal.ONE;
    }

//    @Override
//    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ProtocolLogistRequestVo requet) {
//        return null;
//    }

    @Override
    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    @Override
    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }

    /**
     * 说明：trdOrderNo 协议订单此第三方订单号为集采订单号
     * @param trdOrderNo 第三方订单号(集采订单号)
     * @return
     */
    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        // 存放需同步到本地的物流信息
        List<LogisticFollowDto> saveLocalLogistics = new ArrayList<>();
        // 查询协议订单物流信息
        List<ProtocolOrderLogisticDto> orderLogisticDtos = protocolApi.queryProtocolOrderLogistic(trdOrderNo);
        // 协议订单有几个物流信息分为几个包裹
        if (!Lang.isEmpty(orderLogisticDtos)){
            List<OrderShippingPackageVo> orderShippingPackageVos = new ArrayList<>(orderLogisticDtos.size());
            // 一个协议订单物流信息可能有多条，但不会太多
            OrderShippingPackageVo orderShippingPackageVo = null;
            try {
                JSONArray logisticInfos = null;
                List<OrderShippingTrackVo> orderShippingPackages = null;
                for (ProtocolOrderLogisticDto orderLogisticDto : orderLogisticDtos) {
                    orderShippingPackageVo = new OrderShippingPackageVo();
                    // 先到本地找信息
                    LogisticFollowDto logisticFollowDto = protocolApi.queryLocalLogisticByLogisticNo(orderLogisticDto.getLogisticNo());
                    if (!Lang.isEmpty(logisticFollowDto) && LogisticStatus.finallyStatus.contains(logisticFollowDto.getLogisticStatus())
                            && !Lang.isEmpty(logisticFollowDto.getLogisticData())){
                        logisticInfos = JSONArray.parseArray(logisticFollowDto.getLogisticData());
                        // 封装物流跟踪栈信息
                        orderShippingPackages = new ArrayList<>(logisticInfos.size());
                        buildOrderShippingTrack(logisticInfos,orderShippingPackages,logisticFollowDto,orderShippingPackageVo);
                    }else{
                        LogisticsFollowVo logisticsFollowVo = protocolApi.queryLogisticsFollow(orderLogisticDto.getLogisticCompanySimpleName(),
                                orderLogisticDto.getLogisticNo());
                        if (!Lang.isEmpty(logisticsFollowVo)){
                            LogisticFollowDto logisticFollow = new LogisticFollowDto();
                            logisticFollow.setLogisticStatus(logisticsFollowVo.getStatus());
                            logisticFollow.setLogisticData(logisticsFollowVo.getData());
                            logisticFollow.setLogisticCompany(logisticsFollowVo.getExpTextName());
                            logisticFollow.setThirdOrderNo(orderLogisticDto.getLogisticNo());
                            logisticFollow.setOrderNo(trdOrderNo);
                            // 判断本次调用第三方接口查询到的物流状态是否最终状态
                            if (LogisticStatus.finallyStatus.contains(logisticsFollowVo.getStatus())){
                               saveLocalLogistics.add(logisticFollow);
                           }
                            if (!Lang.isEmpty(logisticsFollowVo.getData())){
                                logisticInfos = JSONArray.parseArray(logisticsFollowVo.getData());
                                // 封装物流跟踪栈信息
                                orderShippingPackages = new ArrayList<>(logisticInfos.size());
                                buildOrderShippingTrack(logisticInfos,orderShippingPackages,logisticFollow, orderShippingPackageVo);
                            }
                        }
                    }
                    orderShippingPackageVos.add(orderShippingPackageVo);
                }
                if (!Lang.isEmpty(saveLocalLogistics)){
                    protocolApi.syncLogisticLocal(saveLocalLogistics);
                }
            }catch (Exception e){
                logger.info("#####{}",e);
            }
            return new HandlerRespVo<>(orderShippingPackageVos);
        }
        return new HandlerRespVo<>(HandlerRespVo.RESPONSE_STATUS_ERROR,HandlerRespVo.RESPONSE_STATUS_ERROR,"未查询到物流信息");
    }

    /**
     * 封装物流信息跟踪栈信息
     * @param logisticInfos 物流动态json数组
     * @param orderShippingPackages 物流信息跟踪栈集合
     * @param logisticFollowDto 查询出来的物流信息
     * @param orderShippingPackageVo 当前包裹
     */
    private void buildOrderShippingTrack(JSONArray logisticInfos, List<OrderShippingTrackVo> orderShippingPackages,
                                         LogisticFollowDto logisticFollowDto, OrderShippingPackageVo orderShippingPackageVo){
        orderShippingPackageVo.setPackageId(logisticFollowDto.getThirdOrderNo());
        orderShippingPackageVo.setReceiptsFlag(LogisticStatus.LOGISTIC_STATUS_RECEIVING.getValue().equals(logisticFollowDto.getLogisticStatus()));
        orderShippingPackageVo.setStatus(LogisticStatus.logisticStatusMap.get(logisticFollowDto.getLogisticStatus()));
        OrderShippingTrackVo orderShippingTrackVo = null;
        JSONObject jsonObject = null;
        for (Object obj : logisticInfos) {
            jsonObject = (JSONObject) obj;
            orderShippingTrackVo = new OrderShippingTrackVo();
            orderShippingTrackVo.setMsgTime(jsonObject.getDate("time"));
            orderShippingTrackVo.setContent(jsonObject.getString("context"));
            orderShippingPackages.add(orderShippingTrackVo);
        }
        orderShippingPackageVo.setTrackInfoList(orderShippingPackages);
    }

    @Override
    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        return null;
    }

    @Override
    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        return null;
    }

    /**
     * 生成预占单
     *
     * @param reserveOrderVo
     * @param storeCode
     * @return 预订单ｉｄ对象
     */
    @Override
    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo<>(null);
    }

    /**
     * 删除预占单
     *
     * @param reserveOrderIdVo
     * @param storeCode
     * @return true/false
     */
    @Override
    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo<>(true);
    }

    @Override
    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        return null;
    }
}
