package outsideapi.service.handler.impl;

import cart.api.dto.order.SubOrderDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.suning.api.entity.govbus.*;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.dto.goods.GoodsPictureDto;
import lombok.extern.slf4j.Slf4j;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import member.model.common.Address;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.AddressCommonApiStub;
import outsideapi.service.service.stub.GoodsPictureApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.service.service.stub.SnCommonConvertApiStub;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.vo.*;
import outsideapi.vo.jdorder.SnOrderConstant;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderReceiver;
import outsideapi.vo.orderrequest.OrderRequst;
import suning.api.SnCommonConvertApi;
import suning.api.order.SnOrderApi;
import suning.model.SnAddressRelation;
import suning.model.SnNationalAddress;
import suning.model.repository.SnAddressRelationRepos;
import suning.model.repository.SnNationalAddressRepos;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import utils.GlobalContants;
import utils.Lang;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by Dy on 2017/04/12.
 */
@Slf4j
@Component
@Transactional
public class SnOutsideApiHandler implements OutsideApiHandler, ApplicationContextAware {


    @Override
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        System.out.println("SnOutsideApiHandler.queryFashionStockState invoked...");
        HandlerRespVo<List<FashionStockStateVo>> handlerRespVo = new HandlerRespVo<>();
        List<FashionStockStateVo> resStateVoList = new ArrayList<FashionStockStateVo>(); //返回数据
        handlerRespVo.setData(resStateVoList);
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);

        Map<String,String> factionIdMap = new HashMap<String,String>();
        List<FashionNumsVo> fashionNumsVos = requet.getFashionNums();
        Map<String,String> addrMap = transToNationAddress(requet.getProvinceCode(),requet.getCityCode(),requet.getCountyCode(),requet.getTownCode());
        if(!Lang.isEmpty(addrMap)) {
            List<Map<String,String>> paramList = new ArrayList<Map<String,String>>();
            for (FashionNumsVo fashionNumsVo : fashionNumsVos){

                Map<String,String> map = new HashMap<String,String>();
                map.put("skuId",fashionNumsVo.getProductCode());
                if(!Lang.isEmpty(fashionNumsVo.getCounts())){
                    map.put("num",fashionNumsVo.getCounts().toString());
                }
                factionIdMap.put(fashionNumsVo.getProductCode(),fashionNumsVo.getFactionId());
                paramList.add(map);
            }

            if(fashionNumsVos.get(0).getCounts()==null){
                List<Map<String,String>> goodsMprodStock = snCommonConvertApi.queryGoodsMprodStock(paramList,addrMap.get("cityId"));
                if(Lang.isEmpty(goodsMprodStock)){
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("第三方接口调用失败：queryGoodsMprodStock 接口返回为空");
                    handlerRespVo.setErrorCode(3);
                    return handlerRespVo;
                }
                for (Map<String,String> map : goodsMprodStock){
                    FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
                    fashionStockStateVo.setProductCode(map.get("skuId"));
                    fashionStockStateVo.setFashionId(factionIdMap.get(map.get("skuId")));
                    Integer state = Integer.valueOf(map.get("state"));
                    switch (state){
                        case 0:
                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_HAS_STOCK);
                            break;
                        case 1:
//                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_PRE_ORDER);
                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_HAS_STOCK);
                            break;
                        case 2:
                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                            break;
                    }
                    fashionStockStateVo.setStockCount(-1);
                    resStateVoList.add(fashionStockStateVo);
                }
            }else{
                List<Map<String,String>> inventoryList = snCommonConvertApi.getGoodsInventory(paramList,addrMap.get("cityId"),addrMap.get("countyId"));
                if(Lang.isEmpty(inventoryList)){
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("第三方接口调用失败：getGoodsInventory 接口返回为空");
                    handlerRespVo.setErrorCode(3);
                    return handlerRespVo;
                }
                for(Map<String ,String> map :inventoryList){
                    map.get("state");
                    FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
                    fashionStockStateVo.setProductCode(map.get("skuId"));
                    fashionStockStateVo.setFashionId(factionIdMap.get(map.get("skuId")));
                    String state = map.get("state");
                    fashionStockStateVo.setOnSale(!"01".equals(state));
                    // 库存状态.00：有货01：暂不销售 02：无货 03：库存不足
                    switch (state){
                        case "00":
                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_HAS_STOCK);
                            break;
                        case "01":
                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                            break;
                        case "02":
                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                            break;
                        case "03":
                            fashionStockStateVo.setStockFlag(FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                            break;
                    }
                    fashionStockStateVo.setStockCount(-1);
                    resStateVoList.add(fashionStockStateVo);
                }
            }

            List<Map<String,String>> batchProdSaleStatuList = snCommonConvertApi.getBatchProdSaleStatus(paramList);
            if(Lang.isEmpty(batchProdSaleStatuList)){
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("第三方接口调用失败：getBatchProdSaleStatus 接口返回为空");
                handlerRespVo.setErrorCode(3);
                return handlerRespVo;
            }
            for (Map<String,String> map : batchProdSaleStatuList){
                String skuId = map.get("skuId");
                String state = map.get("state");
                for (FashionStockStateVo vo : resStateVoList){
                    vo.setIsAreaRestrict(false);
                    if(Lang.equals(vo.getProductCode(),skuId)){
                        vo.setOnSale(true);
                        continue;
                    }
                }
            }

        }else{
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("第三方接口地区代码转换失败");
            handlerRespVo.setErrorCode(2);
        }

        handlerRespVo.setData(resStateVoList);
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        Map<String,String> addrMap = transToNationAddress(requet.getProvinceCode(),requet.getCityCode(),requet.getCountyCode(),requet.getTownCode());
        HandlerRespVo<Map<String, Object>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        if(Lang.isEmpty(requet.getAddrDetail())){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(1);
            handlerRespVo.setMessage("详细地址为空");
            return handlerRespVo;
        }
        if(Lang.isEmpty(addrMap)) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(1);
            handlerRespVo.setMessage("该店铺不支持当前配送地址");
        } else {
            ShipCarriageGetRequest request = new ShipCarriageGetRequest();
            List<FashionNumsVo> fashionNumsVos = requet.getFashionNums();
            Map<String,String> fashionIdMap = new HashMap<String,String>();
            List<ShipCarriageGetRequest.SkuIds> skuIdses = new ArrayList<ShipCarriageGetRequest.SkuIds>();
            for (FashionNumsVo fashionNumsVo:fashionNumsVos){
                ShipCarriageGetRequest.SkuIds skuIds = new ShipCarriageGetRequest.SkuIds();
                skuIds.setSkuId(fashionNumsVo.getProductCode());
                skuIds.setPiece(String.valueOf(fashionNumsVo.getCounts()));
                skuIdses.add(skuIds);
            }
            request.setCityId(addrMap.get("cityId"));
            request.setAddrDetail(requet.getAddrDetail());
            request.setTownId(addrMap.get("townId"));
            request.setDistrictId(addrMap.get("countyId"));
            request.setSkuIds(skuIdses);
            String respJson = snCommonConvertApi.getShipCarriage(JSON.toJSONString(request));
            if(!Lang.isEmpty(respJson)) {
                ShipCarriageGetResponse response = JSON.parseObject(respJson, ShipCarriageGetResponse.class);
                if(response.getSnerror()!=null){
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setErrorCode(1);
                    handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
                }
                Map<String,Object> d = new HashMap<String,Object>();
                String freightFare = response.getSnbody().getGetShipCarriage().getFreightFare();
                BigDecimal freightBigDecimal = Lang.isEmpty(freightFare) ? BigDecimal.ZERO : new BigDecimal(freightFare);
                d.put("freight", freightBigDecimal);
                d.put("baseFreight", freightBigDecimal);
                d.put("remoteRegionFreight", freightBigDecimal);
                handlerRespVo.setData(d);
            }
        }
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        List<OrderShippingPackageVo> resultList = new ArrayList<>();
        HandlerRespVo<List<OrderShippingPackageVo>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if(!Lang.isEmpty(trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();

            // 先获取第三方订单的sku和item
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(orderStatusGetRequest),
                    SnCommonConvertApi.API_NAME_SN_ORDERSE,
                    "getOrderStatus",
                    OrderStatusGetRequest.class
            );

            OrderStatusGetResponse response = JSON.parseObject(respJson, OrderStatusGetResponse.class);

            if(response != null &&
                    (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {

                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                List<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<>();
                for(OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);


                respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(logistnewGetRequest),
                        SnCommonConvertApi.API_NAME_SN_SHIPPING,
                        "getOrderLogistNew",
                        OrderlogistnewGetRequest.class
                );

                OrderlogistnewGetResponse logistnewGetResponse = JSON.parseObject(respJson, OrderlogistnewGetResponse.class);
                if(logistnewGetResponse != null &&
                        (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {

                    for(OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if(o != null) {
                            String trdSubOrderNo = logistnewGetResponse.getSnbody().getGetOrderlogistnew().getOrderId();
                            OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                            packageVo.setTrdSubOrderNo(trdSubOrderNo);
                            packageVo.setPackageId(o.getPackageId());
                            packageVo.setShippingTime(o.getShippingTime());
                            packageVo.setReceiveTime(o.getReceiveTime());
                            SubOrderDto subOrder = orderMainApi.findSubOrderBySubOrderNo(trdSubOrderNo);
                            if(!Lang.isEmpty(subOrder)) {
                                if (!Lang.isEmpty(subOrder.getTrdSpState()) && Lang.equals(subOrder.getTrdSpState(), SubOrderDto.TRD_SP_HAS_BEEN_PUT)) {
                                    packageVo.setReceiptsFlag(true);
                                } else {
                                    packageVo.setReceiptsFlag(false);
                                }
                            }else {
                                packageVo.setReceiptsFlag(false);
                            }
                            List<String> skuses = new ArrayList<>();
                            for (OrderlogistnewGetResponse.OrderItemIds orderItemIds : o.getOrderItemIds()) {
                                skuses.add(orderItemIds.getSkuId());
                            }
                            List<GoodsPictureDto> goodsPicturees = goodsPictureApi.findByGoods_Skuses(skuses);
                            //Map去重
                            Map<String,GoodsPictureDto> picMap = Lang.beanListToKeyMap(goodsPicturees,GoodsPictureDto.class,"picturePath");
                            Collection<GoodsPictureDto> pictures = picMap.values();
                            List<GoodsInfoVo> goodsInfos = new ArrayList<>();
                            for (GoodsPictureDto picture : pictures) {
                                GoodsInfoVo goodsInfo = new GoodsInfoVo();
                                goodsInfo.setGoodsId(picture.getGoods().getId());
                                goodsInfo.setGoodsName(picture.getGoods().getName());
                                goodsInfo.setGoodsPictrue(picture.getPicturePath());
                                goodsInfos.add(goodsInfo);
                            }
                            packageVo.setGoodsInfos(goodsInfos);
                            List<OrderShippingTrackVo> trackVoList = new ArrayList<>();
                            for(OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                                OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                                orderShippingTrackVo.setContent(logistics.getOperateState());
                                try {
                                    orderShippingTrackVo.setMsgTime(Lang.isEmpty(logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                                } catch (ParseException e) {
                                    orderShippingTrackVo.setMsgTime(null);
                                }
                                trackVoList.add(orderShippingTrackVo);
                            }
                            packageVo.setTrackInfoList(trackVoList);
                            resultList.add(packageVo);
                        }
                    }
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                    handlerRespVo.setErrorCode(0);
                    handlerRespVo.setData(resultList);

                } else {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                    handlerRespVo.setErrorCode(1);
                }

            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                handlerRespVo.setErrorCode(1);
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(2);
        }
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        HandlerRespVo<String> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);

        if(!Lang.isEmpty(trdOrderNo)) {
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(orderStatusGetRequest),
                    SnCommonConvertApi.API_NAME_SN_ORDERSE,
                    "getOrderStatus",
                    OrderStatusGetRequest.class
            );

            OrderStatusGetResponse response = JSON.parseObject(respJson, OrderStatusGetResponse.class);
            if(response != null &&
                    (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {
                if("4".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) {
                    // 已完成订单
                    handlerRespVo.setData(OutsideProductApi.TRD_ORDER_STATUS_COMFIRMED);
                } else if("5".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) {
                    // 已取消订单
                    handlerRespVo.setData(OutsideProductApi.TRD_ORDER_STATUS_CANCELED);
                } else {
                    // 正常订单
                    handlerRespVo.setData(OutsideProductApi.TRD_ORDER_STATUS_NORMAL);
                }
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                handlerRespVo.setErrorCode(1);
                handlerRespVo.setData(OutsideProductApi.TRD_ORDER_NO_ORDER);
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(0);
            handlerRespVo.setData(OutsideProductApi.TRD_ORDER_NO_ORDER);
        }


        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo){
        List<OrderShippingPackageVo> resultList = new ArrayList<>();
        HandlerRespVo<List<OrderShippingPackageVo>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if(!Lang.isEmpty(trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();

            // 先获取第三方订单的sku和item
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(orderStatusGetRequest),
                    SnCommonConvertApi.API_NAME_SN_ORDERSE,
                    "getOrderStatus",
                    OrderStatusGetRequest.class
            );

            OrderStatusGetResponse response = JSON.parseObject(respJson, OrderStatusGetResponse.class);

            if(response != null &&
                    (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {

                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                List<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<>();
                for(OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);


                respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(logistnewGetRequest),
                        SnCommonConvertApi.API_NAME_SN_SHIPPING,
                        "getOrderLogistNew",
                        OrderlogistnewGetRequest.class
                );

                OrderlogistnewGetResponse logistnewGetResponse = JSON.parseObject(respJson, OrderlogistnewGetResponse.class);
                if(logistnewGetResponse != null &&
                        (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {

                    for(OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if(o != null) {
                            OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                            packageVo.setPackageId(o.getPackageId());
                            packageVo.setShippingTime(o.getShippingTime());
                            packageVo.setReceiveTime(o.getReceiveTime());

                            List<OrderShippingTrackVo> trackVoList = new ArrayList<>();
                            for(OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                                OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                                orderShippingTrackVo.setContent(logistics.getOperateState());
                                try {
                                    orderShippingTrackVo.setMsgTime(Lang.isEmpty(logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                                } catch (ParseException e) {
                                    orderShippingTrackVo.setMsgTime(null);
                                }
                                trackVoList.add(orderShippingTrackVo);
                            }
                            packageVo.setTrackInfoList(trackVoList);
                            resultList.add(packageVo);
                        }
                    }
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                    handlerRespVo.setErrorCode(0);
                    handlerRespVo.setData(resultList);

                } else {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                    handlerRespVo.setErrorCode(1);
                }

            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                handlerRespVo.setErrorCode(1);
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(2);
        }
        return handlerRespVo;
    }

    /**
     * 生成预占单
     *
     * @param reserveOrderVo
     * @param storeCode
     * @return 预订单ｉｄ对象
     */
    @Override
    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo<>(null);
    }

    /**
     * 删除预占单
     *
     * @param reserveOrderIdVo
     * @param storeCode
     * @return true/false
     */
    @Override
    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo<>(true);
    }

    private Map transToNationAddress(String provinceCode, String cityCode, String countyCode, String areaCode) {
        HashMap<String,String> addrMap = new HashMap<String,String>();
        if(!Lang.isEmpty(areaCode) && !"0".equals(areaCode)) {
            /** 四级地区 */
            SnNationalAddress sna = transSingleToNationAddress(areaCode, AddressCommonApi.AddressLevel.TOWN);

            if(Lang.isEmpty(sna)) {
                // 查找不到四级的时候，使用当前供应商的任意四级地址
                AddressDto address = addressCommonApi.findFirstChild(countyCode, Address.STORE_CODE_SUNING, false);
                address = address == null ? addressCommonApi.findFirstChild(countyCode, Address.STORE_CODE_COMMON, false) : address;
                if(!Lang.isEmpty(address)) {
                    sna = transSingleToNationAddress(address.getId(), AddressCommonApi.AddressLevel.TOWN);
                }
            }

            addrMap.put(GlobalContants.AREA_MAP_KEY_TOWN_ID, sna == null ? "" : sna.getId());
        }
        if( !Lang.isEmpty(countyCode) && !"0".equals(countyCode)) {
            /** 三级地区 */
            AddressDto addr = addressCommonApi.findById(countyCode);
            if(!addr.getStoreCode().equals(Address.STORE_CODE_COMMON) && !addr.getStoreCode().equals(Address.STORE_CODE_SUNING)) {
                /** 如果当前三级地区不是公共或苏宁的地区代码，地区需转换为当前二级下的首个可用三级 */
                String pCode = addr.getParent().getId();
                addr = addressCommonApi.findFirstChild(pCode, Address.STORE_CODE_SUNING, false);
                addr = addr == null ? addressCommonApi.findFirstChild(pCode, Address.STORE_CODE_COMMON, false) : addr;

                countyCode = addr == null ? countyCode : addr.getId();
            }

            SnNationalAddress county = transSingleToNationAddress(countyCode, AddressCommonApi.AddressLevel.AREA);
            addrMap.put(GlobalContants.AREA_MAP_KEY_CITY_ID, county == null ? "" : county.getpId());
            addrMap.put(GlobalContants.AREA_MAP_KEY_COUNTY_ID, county == null ? "" : county.getId());
        }
        if( !Lang.isEmpty(cityCode) && !"0".equals(cityCode)) {
            /** 二级地区 */
            SnNationalAddress snCity = transSingleToNationAddress(cityCode, AddressCommonApi.AddressLevel.CITY);
            addrMap.put(GlobalContants.AREA_MAP_KEY_CITY_ID, snCity == null ? "" : snCity.getId());
            addrMap.put(GlobalContants.AREA_MAP_KEY_PROVINCE_ID, snCity == null ? "" : snCity.getpId());
            /** 至少要以二级地区查询（市） */
        }
        if(!Lang.isEmpty(provinceCode) && !"0".equals(provinceCode)) {
            /** 一级地区 */
            SnNationalAddress snProvince = transSingleToNationAddress(provinceCode, AddressCommonApi.AddressLevel.PROVINCE);
            addrMap.put(GlobalContants.AREA_MAP_KEY_PROVINCE_ID, snProvince == null ? "" : snProvince.getId());
        }
        if(addrMap.size()<2){
            return null;
        }
        return addrMap;
    }

    @Transactional(readOnly = true)
    public SnNationalAddress transSingleToNationAddress(String code, AddressCommonApi.AddressLevel lv) {
        SnNationalAddress nAddr = null;
        List<SnNationalAddress> snNationalAddressList = snNationalAddressRepos.findByLinkId(code);
        if(!Lang.isEmpty(code) && !"0".equals(code)) {
            if(snNationalAddressList != null && snNationalAddressList.size() > 0) {
                nAddr = snNationalAddressList.get(0);
            } else {
                if(lv == AddressCommonApi.AddressLevel.TOWN) {
                    SnAddressRelation snAddressRelation = snAddressRelationRepos.findByAddressId(code);
                    if(!Lang.isEmpty(snAddressRelation)){
                        SnNationalAddress snNationalAddress = snNationalAddressRepos.findOne(snAddressRelation.getSuningId());
                        nAddr = snNationalAddress;
                    }
                }
            }
        }

        return nAddr;
    }

    @Override
    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        Map<Integer, String> trdAreaMap = new HashMap<>();
        Map<String,String> na = transToNationAddress(
                areaMap.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.CITY.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.AREA.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.TOWN.getValue()));
        if(na != null) {
            trdAreaMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), na.get("provinceId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), na.get("cityId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), na.get("countyId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), na.get("townId"));
            return trdAreaMap;
        }
        return null;
    }

    @Override
    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return null;
        /*Map<String,String> addrMap = new HashMap<String,String>();
        SnNationalAddress na = null;
        if(!Lang.isEmpty(areaCode)) {
            if(lv == AddressCommonApi.AddressLevel.CITY || lv == AddressCommonApi.AddressLevel.PROVINCE || lv == AddressCommonApi.AddressLevel.AREA) {
                na = snNationalAddressRepos.findByLinkId(areaCode);
                if(Lang.isEmpty(na)) {
                    Address addr = addressCommonApi.findFirstChild(areaCode, false);
                    if(!Lang.isEmpty(addr)) {
                        na = snNationalAddressRepos.findByLinkId(addr.getId());
                    }
                }
            } else {
                na = snNationalAddressRepos.findByLinkId(areaCode);
            }
        } else {
            return null;
        }
        String snLevel = na.getSnLevel();
        switch (snLevel){
            case SnNationalAddress.ADDRESS_LEVEL_PROVINCE:
                Address province = addressCommonApi.findFirstChild(na.getLinkId(),false);
                na = snNationalAddressRepos.findByLinkId(province.getId());
                if("2".equals(na.getSnLevel())){
                    Address city = addressCommonApi.findFirstChild(na.getLinkId(),false);
                    na = snNationalAddressRepos.findByLinkId(city.getId());
                }
                break;
            case SnNationalAddress.ADDRESS_LEVEL_CITY:
                Address city = addressCommonApi.findFirstChild(na.getLinkId(),false);
                na = snNationalAddressRepos.findByLinkId(city.getId());
                break;
        }

        return na;*/
    }


    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet){
        System.out.println("SnOutsideApiHandler.queryFashionPrice invoked...");
        HandlerRespVo<List<FashionPriceVo>> handlerRespVo = new HandlerRespVo<>();
        List<FashionPriceVo> resPriceVoList = new ArrayList<FashionPriceVo>(); //返回数据
        handlerRespVo.setData(resPriceVoList);
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);

        Map<String,String> fashionIdMap = new HashMap<String,String>();
        List<FashionPriceParamVo> priceParamVos = requet.getFashionPriceParamVos();
        Map<String,String> addrMap = transToNationAddress(requet.getProvinceCode(),requet.getCityCode(),requet.getCountyCode(),requet.getTownCode());
        if(!Lang.isEmpty(addrMap)){
            List<Map<String,String>> priceParam = new ArrayList<Map<String,String>>();
            for(FashionPriceParamVo priceParamVo :priceParamVos){
                Map<String,String> map = new HashMap<String,String>();
                map.put("skuId",priceParamVo.getProductCode());
                fashionIdMap.put(priceParamVo.getProductCode(),priceParamVo.getFactionId());
                priceParam.add(map);
            }
            List<Map<String,String>> priceResult = snCommonConvertApi.queryGoodsPrice(priceParam,addrMap.get("cityId"));
            if(Lang.isEmpty(priceResult)){
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("第三方接口调用失败：queryGoodsPrice 接口返回为空");
                handlerRespVo.setErrorCode(3);
                return handlerRespVo;
            }
            for (Map<String,String> map:priceResult){
                FashionPriceVo fashionPriceVo = new FashionPriceVo();
                fashionPriceVo.setProductCode(map.get("skuId"));
                fashionPriceVo.setFashionId(fashionIdMap.get(map.get("skuId")));
                if(Lang.isEmpty(map.get("discountRate"))){
                    fashionPriceVo.setDiscountRate(new BigDecimal(1.0));
                }else{
                    fashionPriceVo.setDiscountRate(new BigDecimal(map.get("discountRate")));
                }
                /** 苏宁返回snPrice 为苏宁销售价格，price为苏宁原始价格（市场价） */
//                fashionPriceVo.setMarketPrice(new BigDecimal(Lang.isEmpty(map.get("price")) ? "0" : map.get("price")));
//                fashionPriceVo.setCostPrice(new BigDecimal(Lang.isEmpty(map.get("snPrice")) ? "0" : map.get("snPrice")));
//                fashionPriceVo.setSalePrice(new BigDecimal(Lang.isEmpty(map.get("snPrice")) ? "0" : map.get("snPrice")));
                fashionPriceVo.setMarketPrice(new BigDecimal(Lang.isEmpty(map.get("snPrice")) ? "0" : map.get("snPrice")));
                fashionPriceVo.setCostPrice(new BigDecimal(Lang.isEmpty(map.get("price")) ? "0" : map.get("price")));
                fashionPriceVo.setSalePrice(new BigDecimal(Lang.isEmpty(map.get("price")) ? "0" : map.get("price")));
                resPriceVoList.add(fashionPriceVo);
            }
        }else{
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("第三方接口地区代码转换失败");
            handlerRespVo.setErrorCode(2);
        }
        return handlerRespVo;
    }

    @Override
    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo requet) {
        if (!Lang.isEmpty(requet.getCostPrice()) && !Lang.isEmpty(requet.getMarkePrice())) {
            /** 费率采用接近0舍入模式，如0.59711111舍入成0.59 */
            //价格为0返回0，不然会/by zero
            if (requet.getCostPrice().compareTo(BigDecimal.ZERO) < 1
                    || requet.getMarkePrice().compareTo(BigDecimal.ZERO) < 1) {
                return BigDecimal.ZERO;
            } else {
                BigDecimal rate = requet.getCostPrice().divide(
                        requet.getMarkePrice(), 2, BigDecimal.ROUND_DOWN);
                /** 费率如果大于1，强制转换为1 */
                return rate.compareTo(BigDecimal.ONE) > 0 ? BigDecimal.ONE : rate;
            }
        }
        return new BigDecimal(1);
    }


    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        HandlerRespVo<ShippLogistResVo> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        OrderLogistGetRequest request = new OrderLogistGetRequest();

        request.setOrderId(requet.getOrderNo());
        request.setOrderItemId(requet.getOrderLineNo());
        request.setSkuId(requet.getProductCode());
        String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(request),
                SnCommonConvertApi.API_NAME_SN_SHIPPING, "getOrderLogist", request.getClass());
//        OrderLogistGetResponse response = snShippingApi.getOrderLogist(request);
        OrderLogistGetResponse response = JSON.parseObject(respJson, OrderLogistGetResponse.class);
        if(response.getSnerror()!=null){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
            handlerRespVo.setErrorCode(1);
            return handlerRespVo;
        }
        OrderLogistGetResponse.GetOrderLogist getOrderLogist = response.getSnbody().getGetOrderLogist();
        List<OrderLogistGetResponse.OrderLogisticStatus> statusList = getOrderLogist.getOrderLogisticStatus();
        List<OrderLogisticStatusVo> orderLogisticStatusVos = new ArrayList<OrderLogisticStatusVo>();
        for (OrderLogistGetResponse.OrderLogisticStatus orderLogisticStatus : statusList){
            OrderLogisticStatusVo vo = new OrderLogisticStatusVo();
            vo.setOperateState(orderLogisticStatus.getOperateState());
            vo.setOperateTime(orderLogisticStatus.getOperateTime());
            orderLogisticStatusVos.add(vo);
        }
        ShippLogistResVo shippLogistResVo = new ShippLogistResVo();
        shippLogistResVo.setOrderLogisticStatusVoList(orderLogisticStatusVos);
        shippLogistResVo.setOrderLineId(getOrderLogist.getOrderItemId());
        shippLogistResVo.setOrderThirdId(getOrderLogist.getOrderId());
        shippLogistResVo.setReceiveTime(getOrderLogist.getReceiveTime());
        shippLogistResVo.setShippingTime(getOrderLogist.getShippingTime());
        shippLogistResVo.setProductCode(getOrderLogist.getSkuId());
        handlerRespVo.setData(shippLogistResVo);
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet){
        Map<String,String> addrMap = transToNationAddress(requet.getProvinceCode(),requet.getCityCode(),requet.getCountyCode(),requet.getTownCode());
        HandlerRespVo<List<ShipTimeResVo>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        if(Lang.isEmpty(requet.getAddrDetail())){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(1);
            handlerRespVo.setMessage("详细地址为空");
            return handlerRespVo;
        }
        if(Lang.isEmpty(addrMap)) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(1);
            handlerRespVo.setMessage("该店铺不支持当前配送地址");
        } else {
            ShipTimeGetRequest request = new ShipTimeGetRequest();
            request.setCityId(addrMap.get("cityId"));
            request.setAddrDetail(requet.getAddrDetail());
            request.setTownId(addrMap.get("townId"));
            request.setDistrictId(addrMap.get("countyId"));
            List<ShipTimeGetRequest.SkuIds> skuIdses = new ArrayList<>();
            List<FashionNumsVo> fashionNumsVos = requet.getFashionNums();
            for (FashionNumsVo fashionNumsVo:fashionNumsVos){
                ShipTimeGetRequest.SkuIds skuIds = new ShipTimeGetRequest.SkuIds();
                skuIds.setSkuId(fashionNumsVo.getProductCode());
                skuIdses.add(skuIds);
            }
            request.setSkuIds(skuIdses);
            String respJson = snCommonConvertApi.getShipTime(JSON.toJSONString(request));
            if(!Lang.isEmpty(respJson)) {
                ShipTimeGetResponse response = JSON.parseObject(respJson, ShipTimeGetResponse.class);
                if(response.getSnerror()!=null){
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setErrorCode(1);
                    handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
                    return handlerRespVo;
                }
                List<ShipTimeGetResponse.ResultInfo> resultInfos = response.getSnbody().getGetShipTime().getResultInfo();
                List<ShipTimeResVo> returnList = new ArrayList<>();
                for(ShipTimeGetResponse.ResultInfo resultInfo :resultInfos){
                    ShipTimeResVo vo = new ShipTimeResVo();
                    vo.setDeliveryToVillageFlag(resultInfo.getDeliveryToVillageFlag());
                    vo.setInstallType(resultInfo.getInstallType());
                    vo.setIsDelivery(resultInfo.getIsDelivery());
                    vo.setProductCode(resultInfo.getSkuId());
                    vo.setSrvCmmdtyCode(resultInfo.getSrvCmmdtyCode());
                    vo.setSupplierTel(resultInfo.getSupplierTel());
                    returnList.add(vo);
                }
                handlerRespVo.setData(returnList);
            }

        }
        return handlerRespVo;

    }

    @Override
    public HandlerRespVo<Map<String,Object>> facProductConfirm(FacProductConfirmRequestVo requst){
        HandlerRespVo<Map<String,Object>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);
        FacProductConfirmRequest request = new FacProductConfirmRequest();
        request.setOrderId(requst.getOrderThirdNo());
        List<FacProductConfirmRequest.SkuConfirmList> skuConfirmList = new ArrayList<>();
        List<FacProductConfirmVo> facProductConfirmVos = requst.getFacProductConfirmVos();
        for (FacProductConfirmVo facProductConfirmVo:facProductConfirmVos){
            FacProductConfirmRequest.SkuConfirmList skuConfirm = new FacProductConfirmRequest.SkuConfirmList();
            skuConfirm.setConfirmTime(facProductConfirmVo.getConfirmTime());
            skuConfirm.setSkuId(facProductConfirmVo.getProductCode());
            skuConfirmList.add(skuConfirm);
        }
        String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(request),
                SnCommonConvertApi.API_NAME_SN_SHIPPING, "confirmFacProduct", request.getClass());
        FacProductConfirmResponse response = JSON.parseObject(respJson, FacProductConfirmResponse.class);
//        FacProductConfirmResponse response =  snShippingApi.confirmFacProduct(request);
        if(response.getSnerror()!=null){
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(1);
            handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
            return handlerRespVo;
        }
        Map<String,Object> returnMap = new HashMap<>();
        returnMap.put("apiIsSuccess","N");
        if("Y".equalsIgnoreCase(response.getSnbody().getConfirmFacProduct().getApiIsSuccess())){
            returnMap.put("apiIsSuccess","Y");
        }
        handlerRespVo.setData(returnMap);
        return handlerRespVo;

    }

    /**
     * 检查苏宁配置下单预警，直接进行拦截
     * @return
     */
    private void checkOrderWanner() throws SupplierTakeOrderFalidException {
        String snOrderWarnStr = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON,
                SystemConfigDto.CONFIG_CODE_SUNING_ORDER_CONFIG_WARN, SystemConfigValueDto.CONFIG_VALUE_TYPE_SUNING_ORDER_CONSTANT_WARN,
                true, true);
        if(!Lang.isEmpty(snOrderWarnStr)) {
            if(!TrdOrderHandlerUtils.checkOrderWannerConfigJson(snOrderWarnStr)) {
                throw new SupplierTakeOrderFalidException("下单拦截已配置", SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
            }
        }
    }

    //苏宁下单参数使用配置化
    private void gennerSuningOrderConstant(OrderAddRequest request){
        String suningOrderConstantStr = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON,
                SystemConfigDto.CONFIG_CODE_SUNING_ORDER_CONFIG, SystemConfigValueDto.CONFIG_VALUE_TYPE_SUNING_ORDER_CONSTANT,
                true, true);
        if(!Lang.isEmpty(suningOrderConstantStr)) {
            try{
                JSONObject obj = JSON.parseObject(suningOrderConstantStr);

                String invoiceContent = (String) obj.get("invoiceContent");
                String invoiceType = (String) obj.get("invoiceType");
                String invoiceState = (String) obj.get("invoiceState");
                String invoiceName = (String) obj.get("invoiceName");
                String orderType = (String) obj.get("orderType");
                String paymentType = (String) obj.get("paymentType");
                request.setInvoiceContent(invoiceContent);
                request.setInvoiceType(invoiceType);
                request.setInvoiceState(invoiceState);
                request.setInvoiceTitle(invoiceName);
                request.setOrderType(orderType);
                request.setPayment(paymentType);
            } catch (Exception e) {
                log.info("数据库保存的参数信息是错误的，请修改");
                e.printStackTrace();
                defaultGennerSuningOrderConstant(request);
            }

        }else {//系统参数未进行配置的时候，使用默认的，避免下单报错
            defaultGennerSuningOrderConstant(request);
        }
    }

    private void defaultGennerSuningOrderConstant(OrderAddRequest request){
        request.setInvoiceContent(SnOrderConstant.invoiceContent);
        request.setInvoiceType(SnOrderConstant.invoiceType);
        request.setInvoiceState(SnOrderConstant.invoiceState);
        request.setInvoiceTitle(SnOrderConstant.invoiceName);
        request.setOrderType(SnOrderConstant.orderType);
        request.setPayment(SnOrderConstant.paymentType);
    }

    /**
     * 查找苏宁地址
     * @param receiver
     * @return
     */
    public AddressVo findSnAddressId(OrderReceiver receiver){
        AddressVo addressVo = new AddressVo();
//        HandlerRespVo apiAddrRs = outsideProductApi.transToNationAddress("suning", memberAddress.getProvinceCode(), memberAddress.getCityCode(), memberAddress.getAreaCode(), memberAddress.getTownCode());
        Map<Integer, String> areaCodeMap = new HashMap<>();
        areaCodeMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), receiver.getProvinceCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), receiver.getCityCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), receiver.getAreaCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), receiver.getTownCode());

        Map<Integer, String> apiAddrRs = this.transAreaCodeMap(areaCodeMap);

        String snProvince = apiAddrRs.get(AddressCommonApi.AddressLevel.PROVINCE.getValue());
        String snCity = apiAddrRs.get(AddressCommonApi.AddressLevel.CITY.getValue());
        String snTown = apiAddrRs.get(AddressCommonApi.AddressLevel.TOWN.getValue());

        if(Lang.isEmpty(snProvince)&&Lang.isEmpty(snCity)&&Lang.isEmpty(snTown)){
            return null;
        }
        if(!Lang.isEmpty(receiver.getTownCode())){
            addressVo.setTownId(snTown);
        }
        addressVo.setProvinceId(snProvince);
        addressVo.setCityId(snCity);
        addressVo.setAreaId(apiAddrRs.get(AddressCommonApi.AddressLevel.AREA.getValue()));

        if(snProvince == null && snCity == null) {
            return null;
        }
        return addressVo;
    }

    /**
     * 生成sku请求vo
     * @param orderRequst 订单
     * @param snPriceLinks 产品ID、苏宁商品代码、苏宁价格关联列表
     *                    <br> 列表中每个Map必须包含以下几项：
     *                    <br> <b>productId:</b> String类型，product表id
     *                    <br> <b>sku:</b> String类型，苏宁商品代码
     *                    <br> <b>snPrice:</b> BigDecimal类型，苏宁协议价
     * @return
     */
    private List<OrderAddRequest.Sku> genSkuReqList(OrderRequst orderRequst, List<Map> snPriceLinks) {
        List<OrderAddRequest.Sku> retList = new ArrayList<>();
        OrderAddRequest.Sku returnSku;
        for (OrderItemVo orderItem : orderRequst.getOrderItems()) {
            returnSku = new OrderAddRequest.Sku();
            //第三方商品编号
            returnSku.setSkuId(orderItem.getSku());
            //商品数量
            if(!Lang.isEmpty(orderItem.getSalePrice()) && !Lang.isEmpty(orderItem.getCount())) {
                returnSku.setNum(orderItem.getCount().toString());
                Map snPriceLink = Lang.findInBeanList(snPriceLinks, "productId", orderItem.getProductId());
                if(snPriceLink != null) {
                    BigDecimal snPrice = (BigDecimal) snPriceLink.get("price");
                    if(snPrice != null) {
                        returnSku.setUnitPrice(snPrice.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
                        retList.add(returnSku);
                    }
                }

            }
        }
        return retList;
    }

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }


    @Autowired
    SnNationalAddressRepos snNationalAddressRepos;

    @Autowired
    SnAddressRelationRepos snAddressRelationRepos;

    @Autowired
    AddressCommonApiStub addressCommonApi;

    @Autowired
    SnCommonConvertApiStub snCommonConvertApi;

    @Autowired
    GoodsPictureApiStub goodsPictureApi;

    @Autowired
    OrderMainApiStub orderMainApi;

    @Autowired
    OutsideProductApi outsideProductApi;

    @MotanReferer
    SystemConfigApi systemConfigApi;

    @MotanReferer
    SnOrderApi snOrderApi;
}
