package outsideapi.service.handler.impl;

import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.suning.api.entity.govbus.*;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.dto.goods.GoodsPictureDto;
import goods.vo.SalesPriceCalVo;
import lombok.extern.slf4j.Slf4j;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import member.model.common.Address;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.SupplierOrderApiHandler;
import outsideapi.service.service.stub.AddressCommonApiStub;
import outsideapi.service.service.stub.GoodsPictureApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.service.service.stub.SnCommonConvertApiStub;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.utils.Constants;
import outsideapi.vo.*;
import outsideapi.vo.jdorder.SnOrderConstant;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.order.TrdOrderSku;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderReceiver;
import outsideapi.vo.orderrequest.OrderRequst;
import suning.api.SnCommonConvertApi;
import suning.api.order.SnOrderApi;
import suning.model.SnAddressRelation;
import suning.model.SnNationalAddress;
import suning.model.repository.SnAddressRelationRepos;
import suning.model.repository.SnNationalAddressRepos;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import utils.GlobalContants;
import utils.Lang;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by Dy on 2017/04/12.
 */
@Slf4j
@Component
@Transactional
public class SnSupplierOrderApiHandler implements SupplierOrderApiHandler, ApplicationContextAware {
    /**
     * 订单号反查接口
     *
     *
     * @param trdOrderKey@return 第三方供应商订单号
     */
    @Override
    public String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        //TODO: 苏宁这个接口不存在，目前也没有调用的地方，将使用OrderMain的数据进行返显
        OrderMainDto orderMainDto = orderMainApi.findOrderByThirdOrderNo(trdOrderKey.getTrdOrderNo());
        return orderMainDto == null ? null : orderMainDto.getThirdOrderNo();
    }

    /**
     * 取消订单
     *
     * @param trdOrderKey 第三方订单唯一标识，storeCdoe + trdOrderNo
     * @return
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    @Override
    public Boolean cancelOrder(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException, OrderCancelException {
        Map<String,Object> returnMap = new HashMap<String,Object>();
        RejectOrderDeleteRequest request = new RejectOrderDeleteRequest();
        request.setOrderId(trdOrderKey.getTrdOrderNo());
        String returnStr=snCommonConvertApi.cancelOrder(JSON.toJSONString(request));
//        OrderAddResponse response = snOrderApi.addOrder(request);
        if(Lang.isEmpty(returnStr)) {
            throw new SupplierInterfaceInvokeException("接口返回为空", SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
        }
        RejectOrderDeleteResponse response = JSON.parseObject(returnStr, RejectOrderDeleteResponse.class);
        //  RejectOrderDeleteResponse response = snOrderApi.deleteRejectOrder(request);
        if(response.getSnerror()!=null){
            returnMap.put(GlobalContants.ResponseString.STATUS,GlobalContants.ResponseStatus.ERROR);
            /**
             * 转换错误代码
             * 106	订单已确认，无法再次操作
             * 104	系统异常
             */
            String errorCode = "";
            if("106".equals(response.getSnerror().getErrorCode())) {
                // 106 订单已确认/已生产，无法通过接口取消
                throw new OrderCancelException(OrderCancelException.ERROR_CODES.TRD_ORDER_COMFIRMED);
            } else if("104".equals(response.getSnerror().getErrorCode())) {
                throw new OrderCancelException(response.getSnerror().getErrorMsg(), OrderCancelException.ERROR_CODES.API_ERROR);
            } else {
                throw new OrderCancelException(response.getSnerror().getErrorCode() + ":"+response.getSnerror().getErrorMsg(), OrderCancelException.ERROR_CODES.API_ERROR);
            }
        }
        return true;
    }

    @Override
    public List<OrderShippingPackageVo> getShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        List<OrderShippingPackageVo> resultList = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if(!Lang.isEmpty(trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();

            // 先获取第三方订单的sku和item
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(orderStatusGetRequest),
                    SnCommonConvertApi.API_NAME_SN_ORDERSE,
                    "getOrderStatus",
                    OrderStatusGetRequest.class
            );

            OrderStatusGetResponse response = JSON.parseObject(respJson, OrderStatusGetResponse.class);

            if(response != null &&
                    (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {

                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                List<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<>();
                for(OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);


                respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(logistnewGetRequest),
                        SnCommonConvertApi.API_NAME_SN_SHIPPING,
                        "getOrderLogistNew",
                        OrderlogistnewGetRequest.class
                );

                OrderlogistnewGetResponse logistnewGetResponse = JSON.parseObject(respJson, OrderlogistnewGetResponse.class);
                if(logistnewGetResponse != null &&
                        (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {

                    for(OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if(o != null) {
                            String trdSubOrderNo = logistnewGetResponse.getSnbody().getGetOrderlogistnew().getOrderId();
                            OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                            packageVo.setTrdSubOrderNo(trdSubOrderNo);
                            packageVo.setPackageId(o.getPackageId());
                            packageVo.setShippingTime(o.getShippingTime());
                            packageVo.setReceiveTime(o.getReceiveTime());
                            SubOrderDto subOrder = orderMainApi.findSubOrderBySubOrderNo(trdSubOrderNo);
                            if(!Lang.isEmpty(subOrder)) {
                                if (!Lang.isEmpty(subOrder.getTrdSpState()) && Lang.equals(subOrder.getTrdSpState(), SubOrderDto.TRD_SP_HAS_BEEN_PUT)) {
                                    packageVo.setReceiptsFlag(true);
                                } else {
                                    packageVo.setReceiptsFlag(false);
                                }
                            }else {
                                packageVo.setReceiptsFlag(false);
                            }
                            List<String> skuses = new ArrayList<>();
                            for (OrderlogistnewGetResponse.OrderItemIds orderItemIds : o.getOrderItemIds()) {
                                skuses.add(orderItemIds.getSkuId());
                            }
                            List<GoodsPictureDto> goodsPicturees = goodsPictureApi.findByGoods_Skuses(skuses);
                            //Map去重
                            Map<String,GoodsPictureDto> picMap = Lang.beanListToKeyMap(goodsPicturees,GoodsPictureDto.class,"picturePath");
                            Collection<GoodsPictureDto> pictures = picMap.values();
                            List<GoodsInfoVo> goodsInfos = new ArrayList<>();
                            for (GoodsPictureDto picture : pictures) {
                                GoodsInfoVo goodsInfo = new GoodsInfoVo();
                                goodsInfo.setGoodsId(picture.getGoods().getId());
                                goodsInfo.setGoodsName(picture.getGoods().getName());
                                goodsInfo.setGoodsPictrue(picture.getPicturePath());
                                goodsInfos.add(goodsInfo);
                            }
                            packageVo.setGoodsInfos(goodsInfos);
                            List<OrderShippingTrackVo> trackVoList = new ArrayList<>();
                            for(OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                                OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                                orderShippingTrackVo.setContent(logistics.getOperateState());
                                try {
                                    orderShippingTrackVo.setMsgTime(Lang.isEmpty(logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                                } catch (ParseException e) {
                                    orderShippingTrackVo.setMsgTime(null);
                                }
                                trackVoList.add(orderShippingTrackVo);
                            }
                            packageVo.setTrackInfoList(trackVoList);
                            resultList.add(packageVo);
                        }
                    }
                    return resultList;

                } else {
                    throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);

                }

            } else {
                throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);

            }
        } else {
            throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
        }
    }

    @Override
    public String getOrderStatus(String trdOrderNo) throws SupplierInterfaceInvokeException {
        String status = null;
        if(!Lang.isEmpty(trdOrderNo)) {
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(orderStatusGetRequest),
                    SnCommonConvertApi.API_NAME_SN_ORDERSE,
                    "getOrderStatus",
                    OrderStatusGetRequest.class
            );

            OrderStatusGetResponse response = JSON.parseObject(respJson, OrderStatusGetResponse.class);
            if(response != null &&
                    (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {
                if("4".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) {
                    // 已完成订单
                    status = OutsideProductApi.TRD_ORDER_STATUS_COMFIRMED;
                } else if("5".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) {
                    // 已取消订单
                    status = OutsideProductApi.TRD_ORDER_STATUS_CANCELED;
                } else {
                    // 正常订单
                    status = OutsideProductApi.TRD_ORDER_STATUS_NORMAL;
                }
            } else {
                throw new SupplierInterfaceInvokeException(
                        SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);

            }
        } else {
            throw new SupplierInterfaceInvokeException(
                    SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);

        }


        return status;
    }

    @Override
    public List<OrderShippingPackageVo> getCTShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        List<OrderShippingPackageVo> resultList = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if(!Lang.isEmpty(trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();

            // 先获取第三方订单的sku和item
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(orderStatusGetRequest),
                    SnCommonConvertApi.API_NAME_SN_ORDERSE,
                    "getOrderStatus",
                    OrderStatusGetRequest.class
            );

            OrderStatusGetResponse response = JSON.parseObject(respJson, OrderStatusGetResponse.class);

            if(response != null &&
                    (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {

                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                List<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<>();
                for(OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);


                respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(logistnewGetRequest),
                        SnCommonConvertApi.API_NAME_SN_SHIPPING,
                        "getOrderLogistNew",
                        OrderlogistnewGetRequest.class
                );

                OrderlogistnewGetResponse logistnewGetResponse = JSON.parseObject(respJson, OrderlogistnewGetResponse.class);
                if(logistnewGetResponse != null &&
                        (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {

                    for(OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if(o != null) {
                            OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                            packageVo.setPackageId(o.getPackageId());
                            packageVo.setShippingTime(o.getShippingTime());
                            packageVo.setReceiveTime(o.getReceiveTime());

                            List<OrderShippingTrackVo> trackVoList = new ArrayList<>();
                            for(OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                                OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                                orderShippingTrackVo.setContent(logistics.getOperateState());
                                try {
                                    orderShippingTrackVo.setMsgTime(Lang.isEmpty(logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                                } catch (ParseException e) {
                                    orderShippingTrackVo.setMsgTime(null);
                                }
                                trackVoList.add(orderShippingTrackVo);
                            }
                            packageVo.setTrackInfoList(trackVoList);
                            resultList.add(packageVo);
                        }
                    }
                    return resultList;

                } else {
                    throw new SupplierInterfaceInvokeException(
                            SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);

                }

            } else {
                throw new SupplierInterfaceInvokeException(
                        SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);

            }
        } else {
            throw new SupplierInterfaceInvokeException(
                    SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
        }
    }

    /**
     * 向第三方供应商下单
     *
     * @param orderRequst 商城订单信息
     * @return 返回生产成功的第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口调用异常
     * @throws SupplierTakeOrderFalidException  供应商下单失败异常
     */
    @Override
    public TrdOrder takeOrder(OrderRequst orderRequst) throws SupplierInterfaceInvokeException, SupplierTakeOrderFalidException {
        log.info("### 苏宁预占库存 ###");

        log.info("开始查询订单...");
        long orderMainTime = System.currentTimeMillis();
        log.info("查询订单耗时 {} ms", System.currentTimeMillis() - orderMainTime);

        log.info("开始查询配置下单预警...");
        long warnOrderMessageTime = System.currentTimeMillis();
        // 配置下单预警
        checkOrderWanner();
        log.info("查询配置下单预警耗时 {} ms", System.currentTimeMillis() - warnOrderMessageTime);

        OrderReceiver receiver = orderRequst.getOrderReceiver();

        log.info("开始转换苏宁地址...");
        long orderAddressSNTime = System.currentTimeMillis();
        AddressVo addr = this.findSnAddressId(receiver);
        log.info("转换苏宁地址耗时 {} ms", System.currentTimeMillis() - orderAddressSNTime);

        log.info("苏宁地址 : {}", JSON.toJSONString(addr));

        if(Lang.isEmpty(addr)){
            throw new SupplierTakeOrderFalidException(SupplierTakeOrderFalidException.ERROR_CODES.ADDRESS_TRANS_ERROR);
        }

        OrderAddRequest request = new OrderAddRequest();

        List<Map<String, String>> priceParam = new ArrayList<>();

        List<Map> productSnPriceLinks = new ArrayList<>();
        for(OrderItemVo oi : orderRequst.getOrderItems()) {
            if(oi != null) {
                Map<String, String> map = new HashMap<>();
                Map snPriceLinkMap = Lang.findInBeanList(productSnPriceLinks, "productId", oi.getProductId());
                boolean newNodeFlag = false;
                if(snPriceLinkMap == null) {
                    newNodeFlag = true;
                    snPriceLinkMap = new HashMap();
                }
                snPriceLinkMap.put("sku", oi.getSku());
                snPriceLinkMap.put("productId", oi.getProductId());
                map.put("skuId", oi.getSku());
                priceParam.add(map);
                if(newNodeFlag) {
                    productSnPriceLinks.add(snPriceLinkMap);
                }
            }
        }

        log.info("开始查询价格...");
        long queryGoodsPriceTime = System.currentTimeMillis();
        List<Map<String,String>> priceResult = snCommonConvertApi.queryGoodsPrice(priceParam, addr.getCityId());
        log.info("查询价格耗时 {} ms", System.currentTimeMillis() - queryGoodsPriceTime);

        log.info("苏宁第三方接口返回 : {}", JSON.toJSONString(priceResult));

        if(Lang.isEmpty(priceResult)){
            log.error("苏宁价格获取接口报错，接口返回为空");
            throw new SupplierInterfaceInvokeException("苏宁价格获取接口报错，接口返回为空"
                    , SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
        }

        /** 重新计算苏宁订单价格 */
        BigDecimal snOrderPriceSum = BigDecimal.ZERO;
        for (Map<String,String> map:priceResult){
            /** 苏宁返回snPrice 为苏宁销售价格，price为苏宁原始价格（市场价） */
            BigDecimal snPrice = new BigDecimal(Lang.isEmpty(map.get("snPrice")) ? (Lang.isEmpty(map.get("price")) ? "0" : map.get("price")) : map.get("snPrice"));
            BigDecimal price = new BigDecimal(Lang.isEmpty(map.get("price")) ? "0" : map.get("price"));
            BigDecimal count = BigDecimal.ONE;
            for(OrderItemVo oi : orderRequst.getOrderItems()) {
                if(oi.getSku().equals(map.get("skuId"))) {
                    count = new BigDecimal(oi.getCount());
                }
            }
            snOrderPriceSum = snOrderPriceSum.add(price.multiply(count));
            Map snPriceLinkMap = Lang.findInBeanList(productSnPriceLinks, "sku", map.get("skuId"));
            if(snPriceLinkMap != null) {
                snPriceLinkMap.put("snPrice", snPrice);
                snPriceLinkMap.put("price", price);
            }
        }


        log.info("开始生成sku请求VO ...");
        long genSkuReqListTime = System.currentTimeMillis();
        request.setSku(genSkuReqList(orderRequst, productSnPriceLinks));
        log.info("生成sku请求VO耗时 {} ms", System.currentTimeMillis() - genSkuReqListTime);

        request.setServFee(orderRequst.getFreight().toString());
        request.setAmount(snOrderPriceSum.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        request.setTradeNo(orderRequst.getOrderNo());
        request.setAddress(receiver.getAddressDetail());
        request.setReceiverName(receiver.getUsername());
        request.setMobile(receiver.getPhone());
        request.setProvinceId(addr.getProvinceId());
        request.setCityId(addr.getCityId());
        request.setCountyId(addr.getAreaId());
        request.setTownId(addr.getTownId());

        log.info("开始查询苏宁下单配置化参数...");
        long gennerSuningOrderConstantTime = System.currentTimeMillis();
        gennerSuningOrderConstant(request);
        log.info("生成sku请求VO耗时 {} ms", System.currentTimeMillis() - gennerSuningOrderConstantTime);

        log.info("开始苏宁第三方接口预占库存调用...");
        long addOrderTime = System.currentTimeMillis();
        String returnStr = snCommonConvertApi.addOrder(JSON.toJSONString(request));
        log.info("苏宁预占库存返回信息{}",returnStr);
        log.info("苏宁第三方接口预占库存调用耗时 {} ms", System.currentTimeMillis() - addOrderTime);

        if(Lang.isEmpty(returnStr)) {
            throw new SupplierInterfaceInvokeException("苏宁预占库存接口返回为空", SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
        }
        OrderAddResponse response = JSON.parseObject(returnStr, OrderAddResponse.class);
        log.info("苏宁预占库存返回response信息{}",JSON.toJSONString(response));
        if(response.getSnerror()!=null){
            throw new SupplierTakeOrderFalidException(response.getSnerror().getErrorMsg(), SupplierTakeOrderFalidException.ERROR_CODES.SUPPLIER_CUSTOM_ERROR);
        }
        OrderAddResponse.AddOrder addOrder = response.getSnbody().getAddOrder();
        List<OrderAddResponse.Skus> skusesRes = addOrder.getSkus();
        List<OrderItemVo> updateOrderItems = orderRequst.getOrderItems();
        List<SalesPriceCalVo> salesPriceCalVoList = new ArrayList<>();

        List<TrdOrder> cOrders = new ArrayList<>();
        for (OrderAddResponse.Skus sku : skusesRes) {
            for(OrderItemVo orderItem : updateOrderItems){
                Map snPriceLinkMap = Lang.findInBeanList(productSnPriceLinks, "productId", orderItem.getProductId());
                BigDecimal price = (BigDecimal) snPriceLinkMap.get("price");
                if(Lang.equals(orderItem.getSku(),sku.getSkuId())){
                    orderItem.setArriveDate(sku.getArriveData());
                    orderItem.setOrderLineNumId(sku.getOrderItemId());

                    /** 生成子订单 */
                    TrdOrder corder = new TrdOrder();
                    // 苏宁订单行号
                    corder.setTrdOrderNo(sku.getOrderItemId());
                    corder.setOrderstate(TrdOrder.ORDER_STATE_VALID); // 苏宁接口不返回orderState
                    corder.setSubmitstate(TrdOrder.SUBMIT_STATE_SUBMITED); //苏宁没有 submitState
                    corder.setOrderPrice(price.multiply(new BigDecimal(orderItem.getCount())));
                    corder.setFreight(new BigDecimal(0));//苏宁没有运费

                    TrdOrderSku corderSku = new TrdOrderSku();
                    corderSku.setNum(Integer.parseInt(sku.getNum()));
                    corderSku.setSkuId(sku.getSkuId());
                    corderSku.setPrice(price);
                    corderSku.setName(orderItem.getProductName());

                    corder.setSku(new ArrayList<>());
                    corder.getSku().add(corderSku);
                    cOrders.add(corder);
                }
            }
        }

        // 组织返回的TrdOrder
        TrdOrder trdOrder = new TrdOrder();
        trdOrder.setCorders(cOrders);
        trdOrder.setTrdOrderNo(addOrder.getOrderId());
        trdOrder.setOrderPrice(new BigDecimal(addOrder.getAmount()));
        List<TrdOrderSku> orderSkus = new ArrayList<>();
        for(TrdOrder corder : cOrders) {
            orderSkus.addAll(corder.getSku());
        }
        trdOrder.setSku(orderSkus);
        trdOrder.setOrderstate(TrdOrder.ORDER_STATE_VALID); // 苏宁接口不返回orderState
        trdOrder.setSubmitstate(TrdOrder.SUBMIT_STATE_SUBMITED); //苏宁没有 submitState
        trdOrder.setFreight(new BigDecimal(0));//苏宁没有运费
        // 处理订单状态
        trdOrder.setFinalStatus(TrdOrderHandlerUtils.judteStatus(trdOrder));
        return trdOrder;
    }

    /**
     * 确认下单，调用时记得处理所有的异常噢！
     *
     * @param orderMain 商城订单信息
     * @throws SupplierInterfaceInvokeException   供应商接口调用异常
     * @throws SupplierOrderComfirmFalidException 供应商下单失败异常，其中错误代码3103表示已确认下单无需重复确认
     */
    @Override
    public void confirmOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        Map<String,Object> returnMap = new HashMap<String,Object>();
        try {
            ConfirmOrderAddRequest request = new ConfirmOrderAddRequest();
            request.setOrderId(orderMain.getThirdOrderNo());

            String returnStr = snCommonConvertApi.addConfirmOrder(JSON.toJSONString(request));
            //        OrderAddResponse response = snOrderApi.addOrder(request);
            if(Lang.isEmpty(returnStr)) {
                throw new SupplierInterfaceInvokeException("苏宁价格获取接口报错，接口返回为空"
                        , SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
            }
            ConfirmOrderAddResponse response = JSON.parseObject(returnStr, ConfirmOrderAddResponse.class);

            if(response.getSnerror()!=null){
                if("105".equals(response.getSnerror().getErrorCode())) {
                    throw new SupplierOrderComfirmFalidException(SupplierOrderComfirmFalidException.ERROR_CODES.ALREADY_COMFIRMED_ORDER);
                }
                if("107".equals(response.getSnerror().getErrorCode()) || "108".equals(response.getSnerror().getErrorCode())) {
                    throw new SupplierOrderComfirmFalidException(SupplierOrderComfirmFalidException.ERROR_CODES.ACCOUNT_BALANCE_ERROR);
                }
                if("106".equals(response.getSnerror().getErrorCode())) {
                    throw new SupplierOrderComfirmFalidException(SupplierOrderComfirmFalidException.ERROR_CODES.ORDER_CANCELED);
                }
                throw new SupplierOrderComfirmFalidException(response.getSnerror().getErrorMsg(), SupplierOrderComfirmFalidException.ERROR_CODES.SUPPLIER_COMFIRMED_ERROR);
            }
            returnMap.put("returnCode", "success");
        }catch (Exception e){
            returnMap.put("returnCode", "fail");
            returnMap.put("returnMsg", e.getMessage());
        }
    }

    @Override
    public BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException {
        BackOrderResp resp = new BackOrderResp();
        ApplyRejectedAddRequest request = new ApplyRejectedAddRequest();
        request.setOrderId(orderMain.getThirdOrderNo());
        List<ApplyRejectedAddRequest.Skus> skuses = new ArrayList<ApplyRejectedAddRequest.Skus>();
        for (String skuId:skuIds) {
            ApplyRejectedAddRequest.Skus skus = new ApplyRejectedAddRequest.Skus();
            skus.setSkuId(skuId);
            skuses.add(skus);
        }
        request.setSkus(skuses);
        ApplyRejectedAddResponse response = snOrderApi.addApplyRejected(request);
        if(response.getSnerror()!=null){
            resp.setStatus(Constants.ResponseStatus.ERROR);
            resp.setMessage(response.getSnerror().getErrorMsg());
            return resp;
        }
        List<ApplyRejectedAddResponse.InfoList> infoLists = response.getSnbody().getAddApplyRejected().getInfoList();
        resp.setBackOrderDetails(new ArrayList<>());
        for (ApplyRejectedAddResponse.InfoList infoList : infoLists){
            if("0".equals(infoList.getStatus())){
                BackOrderDetail detail = new BackOrderDetail();
                detail.setSkuId(infoList.getSkuId());
                detail.setStatus(infoList.getStatus());
                detail.setUnableReason(infoList.getUnableReason());
                resp.getBackOrderDetails().add(detail);
            }
        }
        return resp;
    }

    /**
     * 获取订单详情
     *
     * @param trdOrderKey 第三方订单唯一标识，采用storeCode + trdOrderNo作为唯一标识
     * @return 返回第三方订单详情
     * @throws SupplierInterfaceInvokeException 供应商接口链接异常
     */
    @Override
    public TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        //TODO: 苏宁这个接口不存在，目前也没有调用的地方，将使用OrderMain的数据进行返显
        OrderMainDto orderMainDto = orderMainApi.findOrderByThirdOrderNo(trdOrderKey.getTrdOrderNo());
        TrdOrder trdOrder = new TrdOrder();
        trdOrder.setOrderPrice(orderMainDto.getOrderPrice());
        trdOrder.setTrdOrderNo(trdOrderKey.getTrdOrderNo());
        trdOrder.setPOrderNo(trdOrderKey.getTrdOrderNo());

        // 订单状态使用苏宁接口返回值
        trdOrder.setSubmitstate(TrdOrder.SUBMIT_STATE_SUBMITED);
        trdOrder.setOrderstate(TrdOrder.ORDER_STATE_VALID);

        // trdOrder.setFinalStatus(orderMainDto.getStatus());


        return trdOrder;
    }

    /**
     * 检查苏宁配置下单预警，直接进行拦截
     * @return
     */
    private void checkOrderWanner() throws SupplierTakeOrderFalidException {
        String snOrderWarnStr = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON,
                SystemConfigDto.CONFIG_CODE_SUNING_ORDER_CONFIG_WARN, SystemConfigValueDto.CONFIG_VALUE_TYPE_SUNING_ORDER_CONSTANT_WARN,
                true, true);
        if(!Lang.isEmpty(snOrderWarnStr)) {
            if(!TrdOrderHandlerUtils.checkOrderWannerConfigJson(snOrderWarnStr)) {
                throw new SupplierTakeOrderFalidException("下单拦截已配置", SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
            }
        }
    }

    //苏宁下单参数使用配置化
    private void gennerSuningOrderConstant(OrderAddRequest request){
        String suningOrderConstantStr = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON,
                SystemConfigDto.CONFIG_CODE_SUNING_ORDER_CONFIG, SystemConfigValueDto.CONFIG_VALUE_TYPE_SUNING_ORDER_CONSTANT,
                true, true);
        if(!Lang.isEmpty(suningOrderConstantStr)) {
            try{
                JSONObject obj = JSON.parseObject(suningOrderConstantStr);

                String invoiceContent = (String) obj.get("invoiceContent");
                String invoiceType = (String) obj.get("invoiceType");
                String invoiceState = (String) obj.get("invoiceState");
                String invoiceName = (String) obj.get("invoiceName");
                String orderType = (String) obj.get("orderType");
                String paymentType = (String) obj.get("paymentType");
                request.setInvoiceContent(invoiceContent);
                request.setInvoiceType(invoiceType);
                request.setInvoiceState(invoiceState);
                request.setInvoiceTitle(invoiceName);
                request.setOrderType(orderType);
                request.setPayment(paymentType);
            } catch (Exception e) {
                log.info("数据库保存的参数信息是错误的，请修改");
                e.printStackTrace();
                defaultGennerSuningOrderConstant(request);
            }

        }else {//系统参数未进行配置的时候，使用默认的，避免下单报错
            defaultGennerSuningOrderConstant(request);
        }
    }

    private void defaultGennerSuningOrderConstant(OrderAddRequest request){
        request.setInvoiceContent(SnOrderConstant.invoiceContent);
        request.setInvoiceType(SnOrderConstant.invoiceType);
        request.setInvoiceState(SnOrderConstant.invoiceState);
        request.setInvoiceTitle(SnOrderConstant.invoiceName);
        request.setOrderType(SnOrderConstant.orderType);
        request.setPayment(SnOrderConstant.paymentType);
    }

    /**
     * 查找苏宁地址
     * @param receiver
     * @return
     */
    public AddressVo findSnAddressId(OrderReceiver receiver){
        AddressVo addressVo = new AddressVo();
//        HandlerRespVo apiAddrRs = outsideProductApi.transToNationAddress("suning", memberAddress.getProvinceCode(), memberAddress.getCityCode(), memberAddress.getAreaCode(), memberAddress.getTownCode());
        Map<Integer, String> areaCodeMap = new HashMap<>();
        areaCodeMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), receiver.getProvinceCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), receiver.getCityCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), receiver.getAreaCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), receiver.getTownCode());

        Map<Integer, String> apiAddrRs = this.transAreaCodeMap(areaCodeMap);

        String snProvince = apiAddrRs.get(AddressCommonApi.AddressLevel.PROVINCE.getValue());
        String snCity = apiAddrRs.get(AddressCommonApi.AddressLevel.CITY.getValue());
        String snTown = apiAddrRs.get(AddressCommonApi.AddressLevel.TOWN.getValue());

        if(Lang.isEmpty(snProvince)&&Lang.isEmpty(snCity)&&Lang.isEmpty(snTown)){
            return null;
        }
        if(!Lang.isEmpty(receiver.getTownCode())){
            addressVo.setTownId(snTown);
        }
        addressVo.setProvinceId(snProvince);
        addressVo.setCityId(snCity);
        addressVo.setAreaId(apiAddrRs.get(AddressCommonApi.AddressLevel.AREA.getValue()));

        if(snProvince == null && snCity == null) {
            return null;
        }
        return addressVo;
    }

    /**
     * 生成sku请求vo
     * @param orderRequst 订单
     * @param snPriceLinks 产品ID、苏宁商品代码、苏宁价格关联列表
     *                    <br> 列表中每个Map必须包含以下几项：
     *                    <br> <b>productId:</b> String类型，product表id
     *                    <br> <b>sku:</b> String类型，苏宁商品代码
     *                    <br> <b>snPrice:</b> BigDecimal类型，苏宁协议价
     * @return
     */
    private List<OrderAddRequest.Sku> genSkuReqList(OrderRequst orderRequst, List<Map> snPriceLinks) {
        List<OrderAddRequest.Sku> retList = new ArrayList<>();
        OrderAddRequest.Sku returnSku;
        for (OrderItemVo orderItem : orderRequst.getOrderItems()) {
            returnSku = new OrderAddRequest.Sku();
            //第三方商品编号
            returnSku.setSkuId(orderItem.getSku());
            //商品数量
            if(!Lang.isEmpty(orderItem.getSalePrice()) && !Lang.isEmpty(orderItem.getCount())) {
                returnSku.setNum(orderItem.getCount().toString());
                Map snPriceLink = Lang.findInBeanList(snPriceLinks, "productId", orderItem.getProductId());
                if(snPriceLink != null) {
                    BigDecimal snPrice = (BigDecimal) snPriceLink.get("price");
                    if(snPrice != null) {
                        returnSku.setUnitPrice(snPrice.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
                        retList.add(returnSku);
                    }
                }

            }
        }
        return retList;
    }

    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        Map<Integer, String> trdAreaMap = new HashMap<>();
        Map<String,String> na = transToNationAddress(
                areaMap.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.CITY.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.AREA.getValue()),
                areaMap.get(AddressCommonApi.AddressLevel.TOWN.getValue()));
        if(na != null) {
            trdAreaMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), na.get("provinceId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), na.get("cityId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), na.get("countyId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), na.get("townId"));
            return trdAreaMap;
        }
        return null;
    }

    private Map transToNationAddress(String provinceCode, String cityCode, String countyCode, String areaCode) {
        HashMap<String,String> addrMap = new HashMap<String,String>();
        if(!Lang.isEmpty(areaCode) && !"0".equals(areaCode)) {
            /** 四级地区 */
            SnNationalAddress sna = transSingleToNationAddress(areaCode, AddressCommonApi.AddressLevel.TOWN);

            if(Lang.isEmpty(sna)) {
                // 查找不到四级的时候，使用当前供应商的任意四级地址
                AddressDto address = addressCommonApi.findFirstChild(countyCode, Address.STORE_CODE_SUNING, false);
                address = address == null ? addressCommonApi.findFirstChild(countyCode, Address.STORE_CODE_COMMON, false) : address;
                if(!Lang.isEmpty(address)) {
                    sna = transSingleToNationAddress(address.getId(), AddressCommonApi.AddressLevel.TOWN);
                }
            }

            addrMap.put(GlobalContants.AREA_MAP_KEY_TOWN_ID, sna == null ? "" : sna.getId());
        }
        if( !Lang.isEmpty(countyCode) && !"0".equals(countyCode)) {
            /** 三级地区 */
            AddressDto addr = addressCommonApi.findById(countyCode);
            if(!addr.getStoreCode().equals(Address.STORE_CODE_COMMON) && !addr.getStoreCode().equals(Address.STORE_CODE_SUNING)) {
                /** 如果当前三级地区不是公共或苏宁的地区代码，地区需转换为当前二级下的首个可用三级 */
                String pCode = addr.getParent().getId();
                addr = addressCommonApi.findFirstChild(pCode, Address.STORE_CODE_SUNING, false);
                addr = addr == null ? addressCommonApi.findFirstChild(pCode, Address.STORE_CODE_COMMON, false) : addr;

                countyCode = addr == null ? countyCode : addr.getId();
            }

            SnNationalAddress county = transSingleToNationAddress(countyCode, AddressCommonApi.AddressLevel.AREA);
            addrMap.put(GlobalContants.AREA_MAP_KEY_CITY_ID, county == null ? "" : county.getpId());
            addrMap.put(GlobalContants.AREA_MAP_KEY_COUNTY_ID, county == null ? "" : county.getId());
        }
        if( !Lang.isEmpty(cityCode) && !"0".equals(cityCode)) {
            /** 二级地区 */
            SnNationalAddress snCity = transSingleToNationAddress(cityCode, AddressCommonApi.AddressLevel.CITY);
            addrMap.put(GlobalContants.AREA_MAP_KEY_CITY_ID, snCity == null ? "" : snCity.getId());
            addrMap.put(GlobalContants.AREA_MAP_KEY_PROVINCE_ID, snCity == null ? "" : snCity.getpId());
            /** 至少要以二级地区查询（市） */
        }
        if(!Lang.isEmpty(provinceCode) && !"0".equals(provinceCode)) {
            /** 一级地区 */
            SnNationalAddress snProvince = transSingleToNationAddress(provinceCode, AddressCommonApi.AddressLevel.PROVINCE);
            addrMap.put(GlobalContants.AREA_MAP_KEY_PROVINCE_ID, snProvince == null ? "" : snProvince.getId());
        }
        if(addrMap.size()<2){
            return null;
        }
        return addrMap;
    }

    @Transactional(readOnly = true)
    public SnNationalAddress transSingleToNationAddress(String code, AddressCommonApi.AddressLevel lv) {
        SnNationalAddress nAddr = null;
        List<SnNationalAddress> snNationalAddressList = snNationalAddressRepos.findByLinkId(code);
        if(!Lang.isEmpty(code) && !"0".equals(code)) {
            if(snNationalAddressList != null && snNationalAddressList.size() > 0) {
                nAddr = snNationalAddressList.get(0);
            } else {
                if(lv == AddressCommonApi.AddressLevel.TOWN) {
                    SnAddressRelation snAddressRelation = snAddressRelationRepos.findByAddressId(code);
                    if(!Lang.isEmpty(snAddressRelation)){
                        SnNationalAddress snNationalAddress = snNationalAddressRepos.findOne(snAddressRelation.getSuningId());
                        nAddr = snNationalAddress;
                    }
                }
            }
        }

        return nAddr;
    }

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }


    @Autowired
    SnNationalAddressRepos snNationalAddressRepos;

    @Autowired
    SnAddressRelationRepos snAddressRelationRepos;

    @Autowired
    AddressCommonApiStub addressCommonApi;

    @Autowired
    SnCommonConvertApiStub snCommonConvertApi;

    @Autowired
    GoodsPictureApiStub goodsPictureApi;

    @Autowired
    OrderMainApiStub orderMainApi;

    @Autowired
    OutsideProductApi outsideProductApi;

    @MotanReferer
    SystemConfigApi systemConfigApi;

    @MotanReferer
    SnOrderApi snOrderApi;
}
