package outsideapi.service.handler.impl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import jd.api.request.product.SkuIdsAndAreaEntity;
import jd.api.request.product.StockForOrderEntity;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.ProductStateVO;
import jd.api.vo.product.SkuIdsAndAreaVO;
import jd.api.vo.product.StockNewResultVo;
import jd.api.vo.product.StockVO;
import jd.model.address.NationalAddress;
import jd.model.repository.NationalAddressRepos;
import member.api.AddressCommonApi;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import utils.Lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Liang Wenxu on 2016/11/24.
 */
@Component
public class TestingJdOutsideApiHandler extends JdOutsideApiHandler implements OutsideApiHandler, ApplicationContextAware {

    @Override
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        List<String> errorAreaCode = new ArrayList<>();
        errorAreaCode.add("500100");

        System.out.println("JdOutsideApiHandler.queryFashionStockState invoked...");
        HandlerRespVo<List<FashionStockStateVo>> handlerRespVo = new HandlerRespVo<>();
        List resStateVoList = new ArrayList<FashionStockStateVo>(); //返回数据
        handlerRespVo.setData(resStateVoList);
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(0);

        for(FashionNumsVo vo : requet.getFashionNums()) {
            FashionStockStateVo resVo = new FashionStockStateVo();
            resVo.setStockCount(errorAreaCode.contains(requet.getCityCode()) ? 0 : 100);
            resVo.setAreaRestrict(errorAreaCode.contains(requet.getCityCode()) ? true : false);
            resVo.setOnSale(errorAreaCode.contains(requet.getCityCode()) ? false : true);
            resVo.setFashionId(vo.getFactionId());
            resVo.setProductCode(vo.getProductCode());
            resStateVoList.add(resVo);
        }

        handlerRespVo.setData(resStateVoList);
        return handlerRespVo;
    }

    private Object findObjectInList(Object[] list, Object key, Object value) {
        String getterMethodName = "";
        for(Object v : list) {
            for(Field f : v.getClass().getDeclaredFields()) {
                if(f.getName().equals(key)) {
                    try {
                        StringBuilder sb = new StringBuilder(f.getName());
                        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
                        sb.insert(0, "get");
                        getterMethodName = sb.toString();
                        return value.equals(v.getClass().getDeclaredMethod(getterMethodName).invoke(v)) ? v : null;
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return null;
                    }catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return null;
                    } catch (InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }

        return null;
    }

    private Map<String, Object> findInMappedList(List<Map<String, Object>> list, String key, Object value) {
        Object valInList = null;
        for(Map m : list) {
            valInList = m.get(key);
            if(valInList != null && value.equals(valInList)) {
                return m;
            }
        }

        return null;
    }
    @Autowired
    NationalAddressRepos nationalAddressRepos;
}
