package outsideapi.service.handler.impl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.AddressCommonApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.StoreApiStub;
import outsideapi.vo.*;
import outsideapi.vo.ReserveVo;
import provider.trdsp.api.TrdspApi;
import provider.trdsp.vo.BusinessResponseVo;
import provider.trdsp.vo.in.FreightVo;
import provider.trdsp.vo.in.SkuVo;
import provider.trdsp.vo.in.SkuVoInput;
import provider.trdsp.vo.in.SubOrderNoVo;
import provider.trdsp.vo.out.*;
import utils.Lang;
import utils.data.BeanMapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Lans
 * @date 2018-8-14 11:23
 */
@Component("trdspOutsideApiHandler")
public class TrdspOutsideApiHandler  implements OutsideApiHandler {
    @MotanReferer
    TrdspApi trdspApi;

    @Autowired
    StoreApiStub storeApi;


    /**
     * 8.6
     * @param requet FashionStatusRequetVo
     * @return
     */
    @Override
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        SkuVoInput skuVoInput = new SkuVoInput();
        List<String> skuList = new ArrayList<>();
        List<FashionNumsVo> fashionNumsVos = requet.getFashionNums();
               Map<String,String>skuFahshionMap = new HashMap<>();

        for (FashionNumsVo fashionNumsvo:fashionNumsVos
             ) {
            String sku = fashionNumsvo.getProductCode();
            skuFahshionMap.put(fashionNumsvo.getProductCode(),fashionNumsvo.getFactionId());
            skuList.add(sku);
        }
        skuVoInput.setSkus(skuList);
        skuVoInput.setCity(requet.getCityCode());
        skuVoInput.setCounty(requet.getCountyCode());
        skuVoInput.setProvince(requet.getProvinceCode());
        skuVoInput.setTown(requet.getTownCode());

        String storeId = requet.getStoreId();
        BusinessResponseVo<StockResultVo> businessResponseVo =  trdspApi.getStock(skuVoInput,storeId);


        //success
        if( businessResponseVo.getSuccess()){
            StockResultVo stockResultVo =  businessResponseVo.getResult();
            List<StockVo> stockVoList = stockResultVo.getSuccessList();
            List<FashionStockStateVo> fashionStockStateVoList = new ArrayList<>();
            for (StockVo stockVo: stockVoList
                 ) {
                FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
                fashionStockStateVo.setProductCode(stockVo.getSku());
                fashionStockStateVo.setStockCount(stockVo.getCount());
                fashionStockStateVo.setStockFlag(Integer.valueOf(stockVo.getStatus()));
                fashionStockStateVo.setOnSale(true);
                fashionStockStateVo.setIsAreaRestrict(false);
                fashionStockStateVo.setFashionId(skuFahshionMap.get(stockVo.getSku()));

                fashionStockStateVoList.add(fashionStockStateVo);
            }
            //TODO failList未查到的怎么办？
//            List<FailSkuVo> failStockVoList = stockResultVo.getFailList();


            return new HandlerRespVo(fashionStockStateVoList);
        }
        //fail
        else {
            return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR,Integer.valueOf(businessResponseVo.getResultCode()),businessResponseVo.getResultMessage());
        }


    }

    /**
     * 8.7
     * @param requet
     * @return
     */
    @Override
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        SkuVoInput skuVoInput = new SkuVoInput();
        List<String> skuList = new ArrayList<>();
        List<FashionPriceParamVo> fashionPriceParamVos = requet.getFashionPriceParamVos();
        Map<String,String>skuFashinMap = new HashMap<>();
        for (FashionPriceParamVo fashionPriceParamVo:fashionPriceParamVos
                ) {
            String sku = fashionPriceParamVo.getProductCode();
            skuFashinMap.put(sku,fashionPriceParamVo.getFactionId());
            skuList.add(sku);
        }
        skuVoInput.setSkus(skuList);
        skuVoInput.setCity(requet.getCityCode());
        skuVoInput.setCounty(requet.getCountyCode());
        skuVoInput.setProvince(requet.getProvinceCode());
        skuVoInput.setTown(requet.getTownCode());

        String storeId = requet.getStoreId();
        BusinessResponseVo<PriceResultVo> businessResponseVo =  trdspApi.getPrice(skuVoInput,storeId);

        //success
        if( businessResponseVo.getSuccess()){
            PriceResultVo priceResultVo =  businessResponseVo.getResult();
            List<PriceVo> priceVoList = priceResultVo.getSuccessList();
            List<FashionPriceVo> fashionPriceVoList = new ArrayList<>();
            for (PriceVo priceVo: priceVoList
                    ) {
                FashionPriceVo fashionPriceVo = new FashionPriceVo();
                fashionPriceVo.setProductCode(priceVo.getSku());
                fashionPriceVo.setCostPrice(priceVo.getCostPrice());
                fashionPriceVo.setMarketPrice(priceVo.getMarketPrice());
                fashionPriceVo.setSalePrice(priceVo.getCostPrice());
                fashionPriceVo.setFashionId(skuFashinMap.get(priceVo.getSku()));
                //TODO failList未查到的怎么办？
                fashionPriceVoList.add(fashionPriceVo);
            }
            return new HandlerRespVo(fashionPriceVoList);
        }
        //fail
        else {
            return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR,Integer.valueOf(businessResponseVo.getResultCode()),businessResponseVo.getResultMessage());
        }

    }

    /**
     *8.4
     * @param requet ShippingFeeRequetVo
     * @return
     */
    @Override
    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        String storeId=requet.getStoreId();
        FreightVo freightVo = new FreightVo();
        List<SkuVo> skuVoList = new ArrayList<>();
        List<FashionNumsVo> fashionNums =  requet.getFashionNums();
//        Map<String,String> skuFashionMap = new HashMap<>();
        if (Lang.isEmpty(fashionNums))
        {
            return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR,6006,"fashionNums为空");
        }
        else{
            for (FashionNumsVo fashionNumsVo:fashionNums) {
                SkuVo skuVo = new SkuVo();
                skuVo.setSku(fashionNumsVo.getProductCode());
                skuVo.setCount(fashionNumsVo.getCounts().intValue());
//                skuFashionMap.put(fashionNumsVo.getProductCode(),fashionNumsVo.getFactionId());
                skuVoList.add(skuVo);
            }
        }
        freightVo.setSkuVos(skuVoList);
        freightVo.setCity(requet.getCityCode());
        freightVo.setCounty(requet.getCountyCode());
        freightVo.setProvince(requet.getProvinceCode());
        freightVo.setTown(requet.getTownCode());
        BusinessResponseVo<TrdSpFreightVo> businessResponseVo = trdspApi.getFreight(freightVo,storeId);
           //success
       if( businessResponseVo.getSuccess()){
           TrdSpFreightVo trdSpFreightVo =  businessResponseVo.getResult();
           Map<String, Object> resultMap = new HashMap<>();
           resultMap.put("freight",trdSpFreightVo.getFreight());
           return new HandlerRespVo(resultMap);
       }
       //fail
       else {
           return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR,Integer.valueOf(businessResponseVo.getResultCode()),businessResponseVo.getResultMessage());
       }
    }


    @Override
    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return null;
    }

    @Override
    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        return null;
    }

    @Override
    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        return null;
    }


    /**
     * 8.3
     * @param request
     * @return
     */
    @Override
    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo request) {

        String storeId = request.getStoreId();
        SubOrderNoVo subOrderNoVo = new SubOrderNoVo();
        //     setSubOrderNo　==private String orderNo;//第三方订单号
        subOrderNoVo.setSubOrderNo(request.getOrderNo());
        BusinessResponseVo<LogisticsVo> businessResponseVo = trdspApi.getLogistics(subOrderNoVo,storeId);

        //success
        if( businessResponseVo.getSuccess()){
            ShippLogistResVo shippLogistResVo = new ShippLogistResVo();
            List<OrderLogisticStatusVo> orderLogisticStatusVoList = new ArrayList<>();

            LogisticsVo logisticsVo =  businessResponseVo.getResult();
         List<OrderTrackVo> OrderTrackVoList =  logisticsVo.getOrderTrack();
            for (OrderTrackVo orderTrackVo:OrderTrackVoList
                 ) {
                OrderLogisticStatusVo orderLogisticStatusVo= new OrderLogisticStatusVo();
                orderLogisticStatusVo.setOperateTime(orderTrackVo.getMsgTime().toString());
//                orderTrackVo.getContent();
//                orderTrackVo.getMsgTime();
//                orderTrackVo.getOperator();
                orderLogisticStatusVoList.add(orderLogisticStatusVo);
            }
            shippLogistResVo.setOrderLogisticStatusVoList(orderLogisticStatusVoList);
            //           logisticsVo.getSubOrderNo();
            return new HandlerRespVo(shippLogistResVo);
        }
        //fail
        else {
            return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR,Integer.valueOf(businessResponseVo.getResultCode()),businessResponseVo.getResultMessage());
        }
    }

    @Override
    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    @Override
    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }

    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        HandlerRespVo<List<OrderShippingPackageVo>> handlerRespVo = new HandlerRespVo<>();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
        handlerRespVo.setMessage("STORE_NOT_SHIPPING");
        handlerRespVo.setErrorCode(1);
        return handlerRespVo;
    }

    @Override
    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        return null;
    }

    @Override
    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    @Override
    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        return null;
    }

    /**
     * 生成预占单
     *
     * @param reserveOrderVo
     * @param storeCode
     * @return 预订单ｉｄ对象
     */
    @Override
    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        provider.trdsp.vo.in.ReserveOrderVo req =
                BeanMapper.map(reserveOrderVo, BeanMapper.getType(ReserveOrderVo.class)
                        , BeanMapper.getType(provider.trdsp.vo.in.ReserveOrderVo.class));
        provider.trdsp.vo.out.ReserveVo outReserveVo = trdspApi.createReservation(req, storeApi.findStoreIdByCode(storeCode));
        return outReserveVo == null ? null : new HandlerRespVo<>(BeanMapper.map(outReserveVo
                , BeanMapper.getType(provider.trdsp.vo.out.ReserveVo.class)
                , BeanMapper.getType(ReserveVo.class)));
    }

    /**
     * 删除预占单
     *
     * @param reserveOrderIdVo
     * @param storeCode
     * @return true/false
     */
    @Override
    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        provider.trdsp.vo.in.ReserveOrderIdVo req =
                BeanMapper.map(reserveOrderIdVo
                        , BeanMapper.getType(ReserveOrderIdVo.class)
                        , BeanMapper.getType(provider.trdsp.vo.in.ReserveOrderIdVo.class));
        Boolean r = trdspApi.delReservation(req, storeApi.findStoreIdByCode(storeCode));
        return r == null ? new HandlerRespVo<>(false) : new HandlerRespVo<>(r);
    }
}
