package outsideapi.service.handler.impl;

import cart.api.OrderMainApi;
import cart.api.difinication.OrderMessageContent;
import cart.api.difinication.TrdSpOrderStatus;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import member.api.MemberAddressApi;
import org.springframework.stereotype.Component;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.SupplierOrderApiHandler;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.order.TrdOrderSku;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderReceiver;
import outsideapi.vo.orderrequest.OrderRequst;
import provider.message.api.ProviderMessageApi;
import provider.message.dto.ProviderMessageQueueDto;
import provider.trdsp.api.TrdspApi;
import provider.trdsp.vo.BusinessResponseVo;
import provider.trdsp.vo.in.MemberAddress;
import provider.trdsp.vo.in.PreOrderVo;
import provider.trdsp.vo.in.ProviderOrderNoVo;
import store.api.StoreApi;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Lans
 * @date 2018-9-3 10:33
 */
@Slf4j
@Component
public class TrdspSupplierOrderApiHandler implements SupplierOrderApiHandler {
    @MotanReferer
    private TrdspApi trdspApi;

    @MotanReferer
    private OrderMainApi orderMainApi;

    @MotanReferer
    private ProviderMessageApi providerMessageApi;

    @MotanReferer
    private StoreApi storeApi;
//    @Autowired
//    private OrderRepos orderRepos;

    @MotanReferer
    private MemberAddressApi memberAddressApi;

    @Override
    public Boolean cancelOrder(TrdOrderKey trdOrderKey) throws OrderCancelException,SupplierInterfaceInvokeException {

//        try {
            // 调用预订单取消接口
            ProviderOrderNoVo providerOrderNoVo = new ProviderOrderNoVo();
            providerOrderNoVo.setProviderOrderNo(trdOrderKey.getTrdOrderNo());
            BusinessResponseVo<Boolean> businessResponseVo = trdspApi.delPreOrder(providerOrderNoVo, trdOrderKey.getStoreCode());

            if (businessResponseVo.getSuccess()) {
                if (businessResponseVo.getResult()) {
                    return true;
                } else {
                    throw new OrderCancelException(businessResponseVo.getResultMessage(),OrderCancelException.ERROR_CODES.API_ERROR);
                }
            } else {
                throw new SupplierInterfaceInvokeException(businessResponseVo.getResultMessage(),SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
            }
//        }catch (Exception e)
//        {
//            throw new OrderCancelException(OrderCancelException.ERROR_CODES.API_ERROR,e);
//        }
    }


    @Override
    public TrdOrder takeOrder(OrderRequst orderRequst) throws SupplierTakeOrderFalidException {
//    public TakeOrderResp takeOrder(OrderMainDto orderMain) {

        TrdOrder trdOrder = new TrdOrder();
        //调用预订单接口

        List<OrderItemVo> orderItemVos   = orderRequst.getOrderItems();

        List<provider.trdsp.vo.in.OrderItem>  preOrderItems = new ArrayList<>();
        for (OrderItemVo orderItemVo:orderItemVos) {
            provider.trdsp.vo.in.OrderItem preOrderItem = new provider.trdsp.vo.in.OrderItem();
            preOrderItem.setCount(orderItemVo.getCount());
            preOrderItem.setSkuId(orderItemVo.getSku());
            preOrderItem.setCostPrice(orderItemVo.getCostPrice());
            preOrderItem.setName(orderItemVo.getProductName());
            preOrderItems.add(preOrderItem);
        }

//        List<PreOrderItem> preOrderItems = new ArrayList<>();
//       for (OrderItem orderItem:orderItems) {
//            PreOrderItem preOrderItem = new PreOrderItem();
//            preOrderItem.setCount(orderItem.getCount());
//            preOrderItem.setSku(orderItem.getSku());
//            //TODO 哪个价格？time和duration
//            preOrderItem.setPrice(orderItem.getCostPrice());
//            preOrderItem.setDemandDuration(1);
//            preOrderItem.setDemandTime(new Date());
//            preOrderItems.add(preOrderItem);
//        }
//        ReserveOrderVo reserveOrderVo = new ReserveOrderVo();
        //  reserveOrderVo.setPreOrderItems(preOrderItems);

        PreOrderVo preOrderVo = new PreOrderVo();
        preOrderVo.setOrderItems(preOrderItems);
        preOrderVo.setCreateTime(orderRequst.getCreateTime());
        preOrderVo.setOrderNo(orderRequst.getOrderNo());
        //TODO 字段对应
        preOrderVo.setReserveOrderId(orderRequst.getThirdOrderNo());

        preOrderVo.setSumPrice(orderRequst.getSumPrice());
        preOrderVo.setPrice(orderRequst.getOrderPrice());
        preOrderVo.setFreight(orderRequst.getFreight());
        preOrderVo.setPrice(orderRequst.getSumNofreightPrice());
        preOrderVo.setReserveOrderId(orderRequst.getReservationCode());

        OrderReceiver orderReceiver=  orderRequst.getOrderReceiver();
        MemberAddress ma = new MemberAddress();

        ma.setReceiverName(orderReceiver.getUsername());
        ma.setReceiverPhone(orderReceiver.getPhone());
        ma.setReceiverProvince(orderReceiver.getProvinceName());
        ma.setReceiverProvinceCode(orderReceiver.getProvinceCode());
        ma.setReceiverCtiy(orderReceiver.getCityName());
        ma.setReceiverCityCode(orderReceiver.getCityCode());
        ma.setReceiverCounty(orderReceiver.getAreaName());
        ma.setReceiverCountyCode(orderReceiver.getAreaCode());
        ma.setReceivertown(orderReceiver.getTownName());
        ma.setReceivertownCode(orderReceiver.getTownCode());
        ma.setReceiverAddressDetails(orderReceiver.getAddressDetail());

        preOrderVo.setMemberAddress(ma);
        //预订单
        BusinessResponseVo<ProviderOrderNoVo> businessResponseVo = trdspApi.createPreOrder(preOrderVo,orderRequst.getStoreCode());

        if(businessResponseVo.getSuccess()){

            trdOrder.setOrderPrice(orderRequst.getOrderPrice());
            trdOrder.setFreight(orderRequst.getFreight());
            trdOrder.setPOrderNo(orderRequst.getPOrder());
            // 外部供应商无详情接口，只要预占成功，即视为订单有效
            // 订单物流状态：新建
            trdOrder.setState(TrdOrder.STATE_NEW);
            // 订单确认状态：未确认
            trdOrder.setSubmitstate(TrdOrder.SUBMIT_STATE_UNSUBMIT);
            // 订单有效状态：有效
            trdOrder.setOrderstate(TrdOrder.ORDER_STATE_VALID);
            // 通过细分状态判断订单状态
            trdOrder.setFinalStatus(TrdOrderHandlerUtils.judteStatus(trdOrder));

            // 接口无订单详情返回，原样返回
            List<TrdOrderSku> trdOrderSkuList = orderRequst.getOrderItems().stream().map(it -> {
                TrdOrderSku trdOrderSku = new TrdOrderSku();
                trdOrderSku.setSkuId(it.getSku());
                trdOrderSku.setNum(it.getCount());
                trdOrderSku.setName(it.getProductName());
                trdOrderSku.setNakedPrice(it.getCostPrice());
                trdOrderSku.setPrice(it.getCostPrice());
                trdOrderSku.setType(TrdOrderSku.TYPE_GENERAL);
                return trdOrderSku;
            }).collect(Collectors.toList());

            trdOrder.setSku(trdOrderSkuList);


            ProviderOrderNoVo providerOrderNoVo = businessResponseVo.getResult();
            trdOrder.setTrdOrderNo(providerOrderNoVo.getProviderOrderNo());

        }else {
            throw new SupplierTakeOrderFalidException(businessResponseVo.getResultMessage(),SupplierTakeOrderFalidException.ERROR_CODES.SUPPLIER_CUSTOM_ERROR);

        }

//        log.info("方法结束返回对象 : {}", JSON.toJSONString(takeOrderResp));
       return trdOrder;



    }

    @Override
    public void confirmOrder(OrderRequst orderRequst) throws SupplierOrderComfirmFalidException {
//    public ConfirmOrderResp confirmOrder(String trdOrderNo, String storeId) {
//        cart.api.dto.order.OrderMainDto orderMainDto= orderMainApi.findOrderByThirdOrderNoAndProviderId(trdOrderNo,storeId);
        //将ordermain里面的trdspstatus改为0
        orderMainApi.updateTrdSpStatus(TrdSpOrderStatus.TrdSpNew.getCode(),orderRequst.getThirdOrderNo(),orderRequst.getStoreCode());
//        orderRepos.updateTrdSpStatusById(TrdSpOrderStatus.TrdSpNew.getCode(),orderMainDto.getId());

        //向消息表写入订单消息
        ProviderMessageQueueDto providerMessageQueueDto = new ProviderMessageQueueDto();
        providerMessageQueueDto.setType("1");
        providerMessageQueueDto.setProviderId(storeApi.findStoreIdByCode(orderRequst.getStoreCode()));

        OrderMessageContent orderMessageContent = new OrderMessageContent();
        orderMessageContent.setOrderNo(orderRequst.getOrderNo());
        orderMessageContent.setProviderOrderNo(orderRequst.getThirdOrderNo());
        orderMessageContent.setStatus("0");
        providerMessageQueueDto.setMessageContent(JSON.toJSONString(orderMessageContent));
        try {
            providerMessageApi.saveMessage(providerMessageQueueDto);
        } catch (Exception e) {
            throw new SupplierOrderComfirmFalidException(
                    e.getMessage(),
                    SupplierOrderComfirmFalidException.ERROR_CODES.SUPPLIER_COMFIRMED_ERROR
            );
        }
    }

    @Override
    public BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException {
        return null;
    }

    @Override
    public TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return null;
    }

    @Override
    public List<OrderShippingPackageVo> getShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        return null;
    }

    @Override
    public String getOrderStatus(String trdOrderNo) throws SupplierInterfaceInvokeException {
        return null;
    }

    @Override
    public List<OrderShippingPackageVo> getCTShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        return null;
    }

    @Override
    public String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return null;
    }



}
