package outsideapi.service.handler.proxy;

import org.apache.log4j.Logger;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * ApiHandler代理
 * Created by Liang Wenxu on 2016/11/24.
 */
public class OutsideApiHandlerProxy implements InvocationHandler {
    Logger log  = Logger.getLogger(OutsideApiHandlerProxy.class);

    //　代理对象
    private Object subject;

    public OutsideApiHandlerProxy(Object subject) {
        this.subject = subject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.info("before invoke handler method: " + subject.getClass().getName() + "->" + method.getName());
        Object invokeRes = method.invoke(subject, args);
        log.info("after invoked handler method: " + subject.getClass().getName() + "->" + method.getName());
        return invokeRes;
    }
}
