package outsideapi.service.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.model.OutsideapiHandlerConfigs;
import outsideapi.model.OutsideapiHandlerConfigs_;
import outsideapi.model.repository.OutsideapiHandlerConfigsRepos;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerKey;
import outsideapi.vo.HandlerRespVo;
import utils.Lang;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Liang Wenxu on 2016/12/8.
 */
@Component
@Service
@Slf4j
@Transactional(readOnly = true, propagation = Propagation.REQUIRES_NEW)
public class OutsideApiService {
    @Autowired
    OutsideapiHandlerConfigsRepos outsideapiHandlerConfigsRepos;

    /**
     * 查询产品规格对应的第三方库存信息
     * @param requet FashionStatusRequetVo
     * @return
     */
    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(OutsideApiHandler handler, FashionStatusRequetVo requet) {
        // 提供handler调用的事务支持
        return handler.queryFashionStockState(requet);
    }

    /**
     * 获取配置表中的配置记录
     * @param handlerKey
     * @return
     */
    public OutsideapiHandlerConfigs getHandlerConfigs(HandlerKey handlerKey) {
        List<OutsideapiHandlerConfigs> dbRs = outsideapiHandlerConfigsRepos.findAll((root, query, cb) -> {
            List<Predicate> andQuerys = new ArrayList<>();
            if(!Lang.isEmpty(handlerKey.getStoreType())) {
                andQuerys.add(cb.equal(root.get(OutsideapiHandlerConfigs_.storeType), handlerKey.getStoreType()));
            }
            if(!Lang.isEmpty(handlerKey.getStoreCode())) {
                andQuerys.add(cb.equal(root.get(OutsideapiHandlerConfigs_.storeCode), handlerKey.getStoreCode()));
            }
            if(!Lang.isEmpty(handlerKey.getProductType())) {
                andQuerys.add(cb.equal(root.get(OutsideapiHandlerConfigs_.productType), handlerKey.getProductType()));
            }
            if(!Lang.isEmpty(handlerKey.getInterfaceName())) {
                andQuerys.add(cb.equal(root.get(OutsideapiHandlerConfigs_.handlerInterfaceName), handlerKey.getInterfaceName()));
            }

            andQuerys.add(cb.notEqual(root.get(OutsideapiHandlerConfigs_.isDelete), true));
            return cb.and(andQuerys.toArray(new Predicate[0]));
        });
        return dbRs != null && dbRs.size() > 0 ? dbRs.get(0) : null;
    }

}
