package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressCodeDTO;
import member.api.dto.common.AddressDto;
import member.api.dto.common.IpAddressDto;
import member.api.vo.AddressVo;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class AddressCommonApiStub {
    public IpAddressDto findByIp(Long ipL) {
        return addressCommonApi.findByIp(ipL);
    }

    public AddressDto findAreaByIp(Long ipL, int areaLevelProvince) {
        return addressCommonApi.findAreaByIp(ipL, areaLevelProvince);
    }

    public AddressDto findById(String id) {
        return addressCommonApi.findById(id);
    }

    public AddressDto findByIdSimple(String id) {
        return addressCommonApi.findByIdSimple(id);
    }

    public AddressVo findVoById(String id, Boolean withChild) {
        return addressCommonApi.findVoById(id, withChild);
    }

    public List<AddressDto> addressList(AddressCommonApi.AddressLevel level, String parentId, Boolean withChildren) {
        return addressCommonApi.addressList(level, parentId, withChildren);
    }

    public List<AddressDto> addressList(AddressCommonApi.AddressLevel level, Boolean withChildren) {
        return addressCommonApi.addressList(level, withChildren);
    }

    public List<AddressVo> addressVoList(AddressCommonApi.AddressLevel level, String parentId, Boolean withChildren) {
        return addressCommonApi.addressVoList(level, parentId, withChildren);
    }

    public AddressDto findFirstChild(String parentId, Boolean withChildren) {
        return addressCommonApi.findFirstChild(parentId, withChildren);
    }

    public AddressDto findFirstChild(String parentId, String storeCode, Boolean withChildren) {
        return addressCommonApi.findFirstChild(parentId, storeCode, withChildren);
    }

    public List<AddressDto> findByFirstChar(String firstChar, AddressCommonApi.AddressLevel level, Boolean withChildren) {
        return addressCommonApi.findByFirstChar(firstChar, level, withChildren);
    }

    public List<AddressDto> findByPingYin(String pingYing, AddressCommonApi.AddressLevel level, Boolean withChildren) {
        return addressCommonApi.findByPingYin(pingYing, level, withChildren);
    }

    public List<AddressDto> findByJianPing(String jp, AddressCommonApi.AddressLevel level, Boolean withChildren) {
        return addressCommonApi.findByJianPing(jp, level, withChildren);
    }

    public List<AddressDto> findByCoordinates(String level, Float lng, Float lat, Float lngRange, Float latRange, Boolean withChildren) {
        return addressCommonApi.findByCoordinates(level, lng, lat, lngRange, latRange, withChildren);
    }

    public Map<Integer, String> areaCodeNodeList(String areaCode) {
        return addressCommonApi.areaCodeNodeList(areaCode);
    }

    public Map<Integer, AddressDto> areaNodeList(String areaCode) {
        return addressCommonApi.areaNodeList(areaCode);
    }

    public Long childrenCounts(String areaCode) {
        return addressCommonApi.childrenCounts(areaCode);
    }

    public Long childrenCounts(AddressDto address) {
        return addressCommonApi.childrenCounts(address);
    }

    public AddressDto findByCityCode(String cityCode) {
        return addressCommonApi.findByCityCode(cityCode);
    }

    public Map getAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String proviceId) {
        return addressCommonApi.getAddressIdSByParams(request, response, proviceId);
    }

    public void setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        addressCommonApi.setAddressIdSByParams(request, response, areaId);
    }

    public Map getIpAddressIds(HttpServletRequest request, HttpServletResponse response) {
        return addressCommonApi.getIpAddressIds(request, response);
    }

    public Map<String, Map<String, String>> transAreaCode(List<String> code) {
        return addressCommonApi.transAreaCode(code);
    }

    public List<AddressDto> findByNameAndLevelType(String name, String addressLevelType) {
        return addressCommonApi.findByNameAndLevelType(name, addressLevelType);
    }

    public List<AddressDto> findByShortNameLikeAndLevelType(String name, String addressLevelType) {
        return addressCommonApi.findByShortNameLikeAndLevelType(name, addressLevelType);
    }

    public AddressCodeDTO findThreeLevelAddreesCodeByIP(Long ip) {
        return addressCommonApi.findThreeLevelAddreesCodeByIP(ip);
    }

    public AddressCodeDTO findThreeLevelAddreesCodeByProviceCode(String proviceCode) {
        return addressCommonApi.findThreeLevelAddreesCodeByProviceCode(proviceCode);
    }

    @MotanReferer
    AddressCommonApi addressCommonApi;
}
