package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import recharge.center.api.emay.api.request.OrderEntity;
import recharge.center.api.emay.api.request.OrderQueryEntity;
import recharge.center.api.emay.api.response.OrderQueryResp;
import recharge.center.api.emay.api.response.OrderResp;
import recharge.center.api.emay.api.service.RechargeYiMeiApi;

/**
 * 亿美订单API
 *
 * @author Drury
 * @date 2018/6/12
 */
@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class EmayOrderApiStub {

    /**
     * 亿美充值下单
     * @param orderEntity OrderEntity
     * @return OrderResp
     */
    public OrderResp takeOrder(OrderEntity orderEntity) {
        return rechargeYiMeiApi.getEmOrder(orderEntity);
    }

    /**
     * 亿美查询订单
     * @param orderQueryEntity OrderQueryEntity
     * @return OrderQueryResp
     */
    public OrderQueryResp queryOrder(OrderQueryEntity orderQueryEntity) {
        return rechargeYiMeiApi.queryEmOrder(orderQueryEntity);
    }

    @MotanReferer
    private RechargeYiMeiApi rechargeYiMeiApi;
}
