package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsPictureApi;
import goods.dto.goods.GoodsDto;
import goods.dto.goods.GoodsPictureDto;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class GoodsPictureApiStub {
    public List<GoodsPictureDto> findGoodsPictures(String goodsId) {
        return goodsPictureApi.findGoodsPictures(goodsId);
    }

    public GoodsPictureDto findGoodsPicture(String goodsId) {
        return goodsPictureApi.findGoodsPicture(goodsId);
    }

    public GoodsPictureDto findGoodsPictureSimple(String goodsId) {
        return goodsPictureApi.findGoodsPictureSimple(goodsId);
    }

    public List<GoodsPictureDto> findGoodsPicture(List<String> goodsIds) {
        return goodsPictureApi.findGoodsPicture(goodsIds);
    }

    public List<GoodsPictureDto> findByGoods_Skuses(List<String> skuses) {
        return goodsPictureApi.findByGoods_Skuses(skuses);
    }

    public GoodsPictureDto findMinIndexPictrueByGoodsId(GoodsDto goods) {
        return goodsPictureApi.findMinIndexPictrueByGoodsId(goods);
    }

    @MotanReferer
    GoodsPictureApi goodsPictureApi;


}
