package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import jd.api.request.order.*;
import jd.api.response.order.*;
import jd.api.service.order.JdOrderApi;
import jd.api.vo.order.OrderFreightVO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;

import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class JdOrderApiStub {
    public OrderUniteSubmitResp placeOrder(OrderEntity orderEntity) {
        return jdOrderApi.placeOrder(orderEntity);
    }

    public OccupyStockResp confirmOccupyStock(JdOrderIdEntity jdOrderIdEntity) {
        return jdOrderApi.confirmOccupyStock(jdOrderIdEntity);
    }

    public OrderCancelOrderResp cancelOrder(JdOrderIdEntity jdOrderIdEntity) {
        return jdOrderApi.cancelOrder(jdOrderIdEntity);
    }

    public Map<String, Object> queryOrder(JdOrderIdEntity jdOrderIdEntity) {
        return jdOrderApi.queryOrder(jdOrderIdEntity);
    }

    public OrderFreightResp queryFreight(OrderFreightEntity orderFreightEntity) {
        return jdOrderApi.queryFreight(orderFreightEntity);
    }

    public OrderRevResp queryOrderByThirdOrder(ThirdOrder thirdOrder) {
        return jdOrderApi.queryOrderByThirdOrder(thirdOrder);
    }

    public CheckOrderResp checkNewOrder(CheckOrderEntity checkOrderEntity) {
        return jdOrderApi.checkNewOrder(checkOrderEntity);
    }

    public CheckOrderResp checkDlokOrder(CheckOrderEntity checkOrderEntity) {
        return jdOrderApi.checkDlokOrder(checkOrderEntity);
    }

    public CheckOrderResp checkRefuseOrder(CheckOrderEntity checkOrderEntity) {
        return jdOrderApi.checkRefuseOrder(checkOrderEntity);
    }

    public OrderTrackResp queryOrderTrack(JdOrderIdEntity jdOrderIdEntity) {
        return jdOrderApi.queryOrderTrack(jdOrderIdEntity);
    }

    public Map<String, Object> getBalance(OrderBalanceEntity orderBalanceEntity) {
        return jdOrderApi.getBalance(orderBalanceEntity);
    }

    @MotanReferer
    JdOrderApi jdOrderApi;
}
