package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import jd.api.request.product.*;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.CategorysResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.*;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class JdProductApiStub {
    @MotanReferer
    JdProductApi jdProductApi;
    /**
     * 1.1.1 查询所有商品池
     *
     * @return
     * @throws Exception
     */
    public List<ProductPoolVO> getProductPool() {
        return jdProductApi.getProductPool();
    }

    /**
     * 1.1.2 查询池内商品编号
     *
     * @return 商品编号的列表
     * @throws Exception
     */
    public List<Long> getProductPoolProduct(PageNumEntity pageNumEntity) {
        return jdProductApi.getProductPoolProduct(pageNumEntity);
    }

    /**
     * 1.1.2 查询池内商品编号
     *
     * 查询返回列表
     * @return 商品编号的列表
     * @throws Exception
     */
    public String getProductPoolProductResult(PageNumEntity pageNumEntity) {
        return jdProductApi.getProductPoolProductResult(pageNumEntity);
    }

    /**
     * 1.1.2 查询池内商品编号
     *
     * @return 商品编号的列表
     * @throws Exception
     */
    public List<Long> getProductPoolProductOld(PageNumEntity pageNumEntity) {
        return jdProductApi.getProductPoolProductOld(pageNumEntity);
    }
    /**
     * 1.1.3 查询具体商品信息
     *
     * @return 单个商品信息
     * @throws Exception
     */
    public ProductDetailVO getProductDetail(ProductDetailEntity productDetailEntity) {
        return jdProductApi.getProductDetail(productDetailEntity);
    }

    /**
     * 1.1.4 查询商品上下架状态接口
     *
     * @param skus
     * @return
     * @throws Exception
     */
    public List<ProductStateVO> getProductState(List<Long> skus) {
        return jdProductApi.getProductState(skus);
    }

    /**
     * 1.1.5 查询所有图片信息接口
     *
     * @param skus
     * @return
     * @throws Exception
     */
    public Map<Long, List<ProductSkuImageVO>> getProductSkuImage(List<Long> skus) {
        return jdProductApi.getProductSkuImage(skus);
    }

    /**
     * 1.1.6 查询商品好评度接口
     *
     * @param skus
     * @return
     * @throws Exception
     */
    public List<ProductCommentSummarysVO> getProductCommentSummarys(List<Long> skus) {
        return jdProductApi.getProductCommentSummarys(skus);
    }

    /**
     * 1.1.7 查询商品区域购买限制接口
     *
     * @return
     * @throws Exception
     */
    public List<SkuIdsAndAreaVO> getProductLimit(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        return jdProductApi.getProductLimit(skuIdsAndAreaEntity);
    }

    /**
     * 1.1.8 查询商品区域是否支持货到付款接口
     *
     * @return
     * @throws Exception
     */
    public Boolean getProductIsCod(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        return jdProductApi.getProductIsCod(skuIdsAndAreaEntity);
    }

    /**
     * 1.1.11	商品可售验证接口（新增）
     * @param skus
     * @return
     */
    public ProductCheckResp getSkuCheck(List<Long> skus) {
        return jdProductApi.getSkuCheck(skus);
    }

    /**
     * 3.17 同类商品查询
     * @param skuEntity
     * @return
     */
    public List<SimilarProduct> getSimilarProduct(String skuId) {
        return jdProductApi.getSimilarProduct(skuId);
    }

    /**
     * 1.2.1 批量查询价格
     *
     * @param skuEntity
     * @return
     * @throws Exception
     */
    public List<PriceVO> getPrice(SkuEntity skuEntity) {
        return jdProductApi.getPrice(skuEntity);
    }

    /**
     * 1.4.1 批量获取库存接口
     *
     * @param stockForOrderEntity
     * @return
     * @throws Exception
     */
    public List<StockNewResultVo> getStockForOrder(StockForOrderEntity stockForOrderEntity) {
        return jdProductApi.getStockForOrder(stockForOrderEntity);
    }

    /**
     * 1.5.1 信息推送接口
     *
     * @param messageTypeEntity
     * @return
     * @throws Exception
     */
    public List<MessageGetVO> getMessage(MessageTypeEntity messageTypeEntity) {
        return jdProductApi.getMessage(messageTypeEntity);
    }

    /**
     * 1.5.2 删除推送信息接口
     *
     * @param messageDelEntity
     * @throws Exception
     */
    public Boolean delMessage(MessageDelEntity messageDelEntity) {
        return jdProductApi.delMessage(messageDelEntity);
    }

    /**
     * 1.1.14 查询分类列表信息接口
     * @param categoryEntity
     * @return
     */
    public CategoryResp getCategory(CategoryEntity categoryEntity) {
        return jdProductApi.getCategory(categoryEntity);
    }



    /**
     * 1.1.15 查询分类信息接口
     * @param categorysEntity
     * @return
     */
    public CategorysResp getCategorys(CategorysEntity categorysEntity){
        return jdProductApi.getCategorys(categorysEntity);
    }
}
