package outsideapi.service.service.stub;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderMainAttrDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import cart.api.dto.order.SubOrderItemDto;
import cart.api.dto.payment.PaymentReturnVo;
import cart.api.dto.response.PayResultDto;
import cart.api.vo.*;
import cart.api.vo.response.CreateBatchGoodsOrderRespVo;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.rpc.motan.ApiResponseVo;
import utils.sql.PageVo;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Component
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class OrderMainApiStub {
    public OrderMainDto save(OrderMainDto orderMain) {
        return orderMainApi.save(orderMain);
    }

    public OrderMainDto saveOrder(OrderMainDto orderMain) {
        return orderMainApi.saveOrder(orderMain);
    }

    public void saveSubOrder(SubOrderDto subOrder) {
        orderMainApi.saveSubOrder(subOrder);
    }

    public void saveSubOrder(List<SubOrderDto> subOrders) {
        orderMainApi.saveSubOrder(subOrders);
    }

    public Map saveVirtualGoodsToOrder(TpScoreGoodsVo goodsVo, String memberId, String jiFenMemberId, String loginName) {
        return orderMainApi.saveVirtualGoodsToOrder(goodsVo, memberId, jiFenMemberId, loginName);
    }

    public OrderMainDto findOrderByOrderNo(String s) {
        return orderMainApi.findOrderByOrderNo(s);
    }

    public List<OrderMainDto> findOrderByStatusAndIsDelete(String status, boolean isDelete) {
        return orderMainApi.findOrderByStatusAndIsDelete(status, isDelete);
    }

    public void updateOrderStatus(String orderId, String orderStatus) {
        orderMainApi.updateOrderStatus(orderId, orderStatus);
    }

    public List<OrderMainAttrDto> getOrderAttrByOrderNo(String orderNo) {
        return orderMainApi.getOrderAttrByOrderNo(orderNo);
    }

    public void updateTpOrderScoreAndFreight(List<OrderMainDto> sucOrders) {
        orderMainApi.updateTpOrderScoreAndFreight(sucOrders);
    }

    public OrderMainDto findOrderByThirdOrderNo(String s) {
        return orderMainApi.findOrderByThirdOrderNo(s);
    }

    public Page queryForInvoicePrint(String companyCodeTpds, String storeId, String orderNo, String compName, String orgId, String payMethod, Date createTimeLower, Date createTimeHigher, String invoiceType, Pageable pageable) {
        return orderMainApi.queryForInvoicePrint(companyCodeTpds, storeId, orderNo, compName, orgId, payMethod, createTimeLower, createTimeHigher, invoiceType, pageable);
    }

    public void ctOutTimeOrderCancel() {
        orderMainApi.ctOutTimeOrderCancel();
    }

    public void itaipingOutTimeOrderCancel() {
        orderMainApi.itaipingOutTimeOrderCancel();
    }

    public List<OrderMainDto> findByOrderNos(List<String> orderNos) {
        return orderMainApi.findByOrderNos(orderNos);
    }

    public OrderMainDto findById(String id) {
        return orderMainApi.findById(id);
    }

    public OrderMainDto findByIdAndIsDelete(String id) {
        return orderMainApi.findByIdAndIsDelete(id);
    }

    public List<OrderMainDto> findByIds(List<String> ids) {
        return orderMainApi.findByIds(ids);
    }

    public OrderMainDto findByOrderNo(String orderNo) {
        return orderMainApi.findByOrderNo(orderNo);
    }

    public List<OrderMainDto> findAllByMemberId(String memberId) {
        return orderMainApi.findAllByMemberId(memberId);
    }

    public void confirmOrder(String orderNo) {
        orderMainApi.confirmOrder(orderNo);
    }

    public ApiResponseVo cancelOrder(String orderNo, OrderMainApi.CancelOrderType cancelType) {
        return orderMainApi.cancelOrder(orderNo, cancelType);
    }

    public Map<String, Object> createOrder(TempOrderVo tempOrderVo, String addressId, String usrId, String memberId, String payMethodCode) {
        return orderMainApi.createOrder(tempOrderVo, addressId, usrId, memberId, payMethodCode);
    }

    public Map<String, Object> createOrder(TempOrderVo tempOrderVo, String addressId, String usrId, String memberId, String payMethodCode, String invoiceId) {
        return orderMainApi.createOrder(tempOrderVo, addressId, usrId, memberId, payMethodCode, invoiceId);
    }

    public ApiResponseVo<CreateBatchGoodsOrderRespVo> createBatchGoodsOrder(CreateBatchGoodsOrderRequestVo request) {
        return orderMainApi.createBatchGoodsOrder(request);
    }

    public PageVo findReceiptOrderInfo(Pageable pageable, Map<String, Object> receiptQueryVo) {
        return orderMainApi.findReceiptOrderInfo(pageable, receiptQueryVo);
    }

    public PageVo findOrderInfo(Pageable pageable, Map<String, Object> orderQueryVo) {
        return orderMainApi.findOrderInfo(pageable, orderQueryVo);
    }

    public List<Map<String, Object>> findOrderInfo(Map<String, Object> orderQueryVo) {
        return orderMainApi.findOrderInfo(orderQueryVo);
    }

    public List<Map<String, Object>> findReturnInfo(Map<String, Object> orderQueryVo) {
        return orderMainApi.findReturnInfo(orderQueryVo);
    }

    public Map updateOrderList(String[] orderNos, String[] invoiceIds, String[] tradeNos) {
        return orderMainApi.updateOrderList(orderNos, invoiceIds, tradeNos);
    }

    public Page<OrderMainDto> findOrdersByOrganization(String organizationId, Date createTimeStart, Date createTimeEnd, List<String> status, List<String> memberIds, String orderNo, Pageable pageable) {
        return orderMainApi.findOrdersByOrganization(organizationId, createTimeStart, createTimeEnd, status, memberIds, orderNo, pageable);
    }

    public Page<OrderMainDto> findOrdersByAllOrganization(Date createTimeStart, Date createTimeEnd, List<String> status, List<String> memberIds, String orderNo, Pageable pageable) {
        return orderMainApi.findOrdersByAllOrganization(createTimeStart, createTimeEnd, status, memberIds, orderNo, pageable);
    }

    public List<OrderMainDto> findOrdersByOrganization(String organizationId, Date createTimeStart, Date createTimeEnd, List<String> status, List<String> memberIds, String orderNo) {
        return orderMainApi.findOrdersByOrganization(organizationId, createTimeStart, createTimeEnd, status, memberIds, orderNo);
    }

    public String payConfirm(PaymentReturnVo paymentReturnVo) {
        return orderMainApi.payConfirm(paymentReturnVo);
    }

    public JSONObject findUserCenterOrders(String orderNo, List<String> status, String memberId, Date startDate, Date endDate, Pageable pageable) {
        return orderMainApi.findUserCenterOrders(orderNo, status, memberId, startDate, endDate, pageable);
    }

    public JSONObject findOrderDetail(String orderNo, String memberId) {
        return orderMainApi.findOrderDetail(orderNo, memberId);
    }

    public Map<String, Object> occupyStock(OrderMainDto orderMain) {
        return orderMainApi.occupyStock(orderMain);
    }

    public Map<String, Object> confirmOccupyStock(OrderMainDto orderMain) {
        return orderMainApi.confirmOccupyStock(orderMain);
    }

    public BigDecimal queryShippingFee(String storeId, List<TempOrderItemVo> tempOrderItemVos, String addressId) {
        return orderMainApi.queryShippingFee(storeId, tempOrderItemVos, addressId);
    }

    public BigDecimal queryShippingFee(String storeId, List<TempOrderItemVo> tempOrderItemVos, String addressId, Boolean useCache) {
        return orderMainApi.queryShippingFee(storeId, tempOrderItemVos, addressId, useCache);
    }

    public BigDecimal queryCartShippingFee(String storeId, List<CartItemVo> cartItemVoList, String addressId) {
        return orderMainApi.queryCartShippingFee(storeId, cartItemVoList, addressId);
    }

    public JSONObject findDisscussByOrderNo(String orderNo) {
        return orderMainApi.findDisscussByOrderNo(orderNo);
    }

    public JSONObject findOrderItemsPageByOrderNo(Pageable pageable, String orderNo) {
        return orderMainApi.findOrderItemsPageByOrderNo(pageable, orderNo);
    }

    public void dealWithRefuseOrder() {
        orderMainApi.dealWithRefuseOrder();
    }

    public TempOrderVo newTempOrderByFasions(List<FashionDetailVo> fashionDetailVoList, String organizationCode, String areaCode) {
        return orderMainApi.newTempOrderByFasions(fashionDetailVoList, organizationCode, areaCode);
    }

    public TempOrderVo newTempOrderByCartItems(List<String> cartItemIds, String userId, String organizationCode, String areaCode) {
        return orderMainApi.newTempOrderByCartItems(cartItemIds, userId, organizationCode, areaCode);
    }

    public BaseResponse<List<TempOrderVo>> batchTempOrderByBatchPurchase(List<TempBatchPurchaseOrderVo> batchPurchaseOrderVos) {
        return orderMainApi.batchTempOrderByBatchPurchase(batchPurchaseOrderVos);
    }

    public BaseResponse<List<OrderMainDto>> batchCreateOrder(List<TempOrderVo> tempOrderVos, String memberId, String usageCode, String payMethodCode) {
        return orderMainApi.batchCreateOrder(tempOrderVos, memberId, usageCode, payMethodCode);
    }

    public String generateOrderNo() {
        return orderMainApi.generateOrderNo();
    }

    public void splitOrderById(String id) {
        orderMainApi.splitOrderById(id);
    }

    public ApiResponseVo splitOrderById(String id, Boolean isOccupyStock) {
        return orderMainApi.splitOrderById(id, isOccupyStock);
    }

    public OrderMainDto comfirmDeliver(OrderMainDto orderMain) {
        return orderMainApi.comfirmDeliver(orderMain);
    }

    public void takeOrderForVirtualProductCards(OrderMainDto orderMain, Map<String, Object> orderAttrMap) {
        orderMainApi.takeOrderForVirtualProductCards(orderMain, orderAttrMap);
    }

    public Boolean findJdekIsError(String goodsCode) {
        return orderMainApi.findJdekIsError(goodsCode);
    }

    public Map deleteOrder(String orderNo) {
        return orderMainApi.deleteOrder(orderNo);
    }

    public List<Map<String, Object>> findSubOrderItemBySubOrderNo(String subOrderNo) {
        return orderMainApi.findSubOrderItemBySubOrderNo(subOrderNo);
    }

    public SubOrderDto findSubOrderBySubOrderNo(String subOrderNo) {
        return orderMainApi.findSubOrderBySubOrderNo(subOrderNo);
    }

    public List<SubOrderItemDto> findSubOrderItemBySubOrderId(String subOrderId) {
        return orderMainApi.findSubOrderItemBySubOrderId(subOrderId);
    }

    public int updateOrderAuditeTime(String orderId) {
        return orderMainApi.updateOrderAuditeTime(orderId);
    }

    public List<SubOrderDto> findSubOrderByOrderMainId(String orderMainId) {
        return orderMainApi.findSubOrderByOrderMainId(orderMainId);
    }

    public ApiResponseVo comfirmBatchDeliver(BatchDeliverOrderVo request) {
        return orderMainApi.comfirmBatchDeliver(request);
    }

    public PayResultDto finishPay(PaymentReturnVo paymentReturnVo) {
        return orderMainApi.finishPay(paymentReturnVo);
    }

    public Page<OrderMainDto> findAll(OrderMainDto orderMainDtoSpec, Pageable pageable) {
        return orderMainApi.findAll(orderMainDtoSpec, pageable);
    }

    public List<OrderMainDto> findAll(OrderMainDto orderMainDtoSpec) {
        return orderMainApi.findAll(orderMainDtoSpec);
    }

    public List<OrderMainDto> findDtoByIds(Collection<String> ids) {
        return orderMainApi.findDtoByIds(ids);
    }

    public OrderMainDto findDtoById(String id) {
        return orderMainApi.findDtoById(id);
    }

    public OrderMainDto changeStatus(String orderId, String status) {
        return orderMainApi.changeStatus(orderId, status);
    }

    public List<OrderMainDto> changeStatus(List<String> orderIds, String status) {
        return orderMainApi.changeStatus(orderIds, status);
    }

    public void triggerEvent(String orderNo, String event) {
        orderMainApi.triggerEvent(orderNo, event);
    }

    public Long countOrder(String memberId, List<String> status, boolean isDelete) {
        return orderMainApi.countOrder(memberId, status, isDelete);
    }

    public Long countOrderNotCommemted(String memberId, List<String> status, boolean isDelete, boolean haveReview) {
        return orderMainApi.countOrderNotCommemted(memberId, status, isDelete, haveReview);
    }

    public OrderMainDto findByOrderNoAndMemberId(String orderNo, String memberId) {
        return orderMainApi.findByOrderNoAndMemberId(orderNo, memberId);
    }

    public void saveAndFlush(OrderMainDto orderMain) {
        orderMainApi.saveAndFlush(orderMain);
    }

    public OrderMainDto findByOrderNoAndStatusIn(String orderNo, List<String> status) {
        return orderMainApi.findByOrderNoAndStatusIn(orderNo, status);
    }

    public void saveOrderParity(String orderNo) {
        orderMainApi.saveOrderParity(orderNo);
    }

    public Boolean checkSuccessedByRequestId(String requestId) {
        return orderMainApi.checkSuccessedByRequestId(requestId);
    }

    /**
     * 获取订单号
     * @param thirdOrderNo 供应商订单号
     * @return orderMain.orderNo
     */
    public String findOrderNoByThirdOrderNo(String thirdOrderNo) {
        return orderMainApi.findOrderNoByThirdOrderNo(thirdOrderNo);
    }

    @MotanReferer
    OrderMainApi orderMainApi;
}
