package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductFashionApi;
import goods.dto.product.ProductDto;
import goods.dto.product.ProductFashionDto;
import goods.dto.store.StoreDto;
import goods.vo.FashionIdAndCountVo;
import goods.vo.FashionStatusRequetVo;
import goods.vo.ProductFashionVo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class ProductFashionApiStub {
    public ProductFashionDto findById(String id) {
        return productFashionApi.findById(id);
    }

    public ProductFashionDto findDtoById(String id) {
        return productFashionApi.findDtoById(id);
    }

    public ProductFashionDto findSimple(String id) {
        return productFashionApi.findSimple(id);
    }

    public List<ProductFashionDto> findByProduct(ProductDto product) {
        return productFashionApi.findByProduct(product);
    }

    public ProductFashionVo findByGoodsId(String goodsId) {
        return productFashionApi.findByGoodsId(goodsId);
    }

    public List<ProductFashionDto> findAllBySku(List<String> skus) {
        return productFashionApi.findAllBySku(skus);
    }

    public List<String> findProductFashionIdBySku(String sku) {
        return productFashionApi.findProductFashionIdBySku(sku);
    }

    public Map<String, Object> getStockCounts(List<String> fashionIds, String areaCode) {
        return productFashionApi.getStockCounts(fashionIds, areaCode);
    }

    public ProductFashionDto findOne(String id) {
        return productFashionApi.findOne(id);
    }

    public void saveFashion(ProductFashionDto productFashion) {
        productFashionApi.saveFashion(productFashion);
    }

    public void save(ProductFashionVo productFashionVo) {
        productFashionApi.save(productFashionVo);
    }

    public List<ProductFashionDto> refreshFactionStatus(FashionStatusRequetVo fashionStatusRequetVo, StoreDto store) {
        return productFashionApi.refreshFactionStatus(fashionStatusRequetVo, store);
    }

    public List<ProductFashionDto> findByIds(List<String> ids) {
        return productFashionApi.findByIds(ids);
    }

    public Map queryFashionStockStatus(List<FashionIdAndCountVo> fashionIdAndCountVoList, String areaCode, String orgId) {
        return productFashionApi.queryFashionStockStatus(fashionIdAndCountVoList, areaCode, orgId);
    }

    public List<ProductFashionVo> findByProductId(String productId) {
        return productFashionApi.findByProductId(productId);
    }

    public List<String> findIdsByProductId(String productId) {
        return productFashionApi.findIdsByProductId(productId);
    }

    public String findIdByGoodsId(String goodsId) {
        return productFashionApi.findIdByGoodsId(goodsId);
    }

    public void updateSaleStatus(List<String> productIds, Boolean onSale) {
        productFashionApi.updateSaleStatus(productIds, onSale);
    }

    @MotanReferer
    ProductFashionApi productFashionApi;


}
