package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import shipping.api.LogisticFollowApi;
import shipping.api.LogisticsQueryApi;
import shipping.api.dto.LogisticFollowDto;
import shipping.api.showapi.LogisticsFollowOutApi;
import shipping.api.vo.showapi.LogisticsFollowVo;
import uninogift.api.protocol.ProtocolApi;
import uninogift.api.protocol.ProtocolOrderApi;
import uninogift.api.protocol.ProtocolOrderLogisticApi;
import uninogift.vo.protocol.*;
import uninogift.vo.protocol.outside.AgreementDetailDto;
import uninogift.vo.protocol.outside.Response;
import uninogift.vo.protocol.outside.VendorDto;
import utils.Lang;

import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class ProtocolApiStub {
    public ProtocolDto findOne(ProtocolDto protocolDtoSpec) {
        return protocolApi.findOne(protocolDtoSpec);
    }

    public List<ProtocolDto> findAll(ProtocolDto protocolDtoSpec) {
        return protocolApi.findAll(protocolDtoSpec);
    }

    public List<ProtocolDto> findSimpleAll(ProtocolDto protocolDtoSpec) {
        return protocolApi.findSimpleAll(protocolDtoSpec);
    }

    public List<ProtocolDto> findAll(ProtocolDto protocolDtoSpec, Sort sort) {
        return protocolApi.findAll(protocolDtoSpec, sort);
    }

    public Page<ProtocolDto> findAll(ProtocolDto protocolDtoSpec, Pageable pageable) {
        return protocolApi.findAll(protocolDtoSpec, pageable);
    }

    public ProtocolDto modifyRefusedProtocol(String memberId, String memberName, ProtocolDto protocolDto) {
        return protocolApi.modifyRefusedProtocol(memberId, memberName, protocolDto);
    }

    public ProtocolDto temporarySaveProtocol(String memberId, String memberName, ProtocolDto protocolDto) {
        return protocolApi.temporarySaveProtocol(memberId, memberName, protocolDto);
    }

    public ProtocolDto auditorSaveProtocol(String auditorId, String auditorName, ProtocolDto protocolDto) {
        return protocolApi.auditorSaveProtocol(auditorId, auditorName, protocolDto);
    }

    public void auditorModifyTechEmail(String auditorId, String auditorName, String protocolId, String techAuditorEmail, String techAuditorMemberId) {
        protocolApi.auditorModifyTechEmail(auditorId, auditorName, protocolId, techAuditorEmail, techAuditorMemberId);
    }

    public void submitAudit(String memberId, String memberName, String... protocolIds) {
        protocolApi.submitAudit(memberId, memberName, protocolIds);
    }

    public ProtocolDto editProtocol(String memberId, String memberName, ProtocolDto protocolDto) {
        return protocolApi.editProtocol(memberId, memberName, protocolDto);
    }

    public ProtocolDto auditEditProtocol(String auditorId, String auditorName, ProtocolDto protocolDto) {
        return protocolApi.auditEditProtocol(auditorId, auditorName, protocolDto);
    }

    public void normalAudit(String protocolId, String auditType, String auditorId, String auditorName, String remark) {
        protocolApi.normalAudit(protocolId, auditType, auditorId, auditorName, remark);
    }

    public void techAudit(String protocolId, String auditType, String auditorId, String auditorName, String remark) {
        protocolApi.techAudit(protocolId, auditType, auditorId, auditorName, remark);
    }

    public void delete(String protocolId, String memberId, String memberName) {
        protocolApi.delete(protocolId, memberId, memberName);
    }

    public Response<VendorDto> getGysxx(String gysbh) {
        return protocolApi.getGysxx(gysbh);
    }

    public Response<AgreementDetailDto> getHtxx(String htbh) {
        return protocolApi.getHtxx(htbh);
    }

    public String generateSeriesNumber() {
        return protocolApi.generateSeriesNumber();
    }

    public ProtocolDto queryByProductId(String productId) {
        return protocolApi.queryByProductId(productId);
    }

    public List<ProtocolDto> queryByProductId(List<String> productIds) {
        return protocolApi.queryByProductId(productIds);
    }

    public Map<String, List<ProtocolDto>> queryMapedProtocolByProduct(List<ProductQueryVo> productList, Boolean onlyValid) {
        return protocolApi.queryMapedProtocolByProduct(productList, onlyValid);
    }

    public List<ProtocolFashionStateVo> queryFashionState(List<ProductQueryVo> productList, String companyId) {
        return protocolApi.queryFashionState(productList, companyId);
    }

    public void onSaleProtocolProduct() {
        protocolApi.onSaleProtocolProduct();
    }

    public void offSaleProtocolProduct() {
        protocolApi.offSaleProtocolProduct();
    }

    /**
     * 根据订单号查询协议订单
     * @param orderNo
     * @return
     */
    public ProtocolOrderDto queryProtocolOrderNo(String orderNo){
        ProtocolOrderDto protocolOrderSpec = new ProtocolOrderDto();
        protocolOrderSpec.setOrderNo(orderNo);
        return protocolOrderApi.findOne(protocolOrderSpec);
    }

    /**
     * 根据订单id查询协议订单
     * @param orderId
     * @return
     */
    public ProtocolOrderDto queryProtocolOrderId(String orderId){
        ProtocolOrderDto protocolOrderSpec = new ProtocolOrderDto();
        protocolOrderSpec.setOrderId(orderId);
        return protocolOrderApi.findOne(protocolOrderSpec);
    }

    /**
     * 查询协议订单物流
     * @param orderNo 集采订单号
     * @return
     */
    public List<ProtocolOrderLogisticDto> queryProtocolOrderLogistic(String orderNo){
        ProtocolOrderDto protocolOrderSpec = new ProtocolOrderDto();
        protocolOrderSpec.setOrderNo(orderNo);
        // 查询协议订单
        ProtocolOrderDto protocolOrderDto = protocolOrderApi.findOne(protocolOrderSpec);
        if (!Lang.isEmpty(protocolOrderDto)){
            List<ProtocolOrderLogisticDto> orderLogisticDtos = protocolOrderLogisticApi.findByOrderId(protocolOrderDto.getId());
            return orderLogisticDtos;
        }
        return null;
    }

    /**
     * 调用第三方接口查询 物流动态
     * @param com 物流公司名称缩写
     * @param nu 物流单号
     * @return
     */
    public LogisticsFollowVo queryLogisticsFollow(String com,String nu){
        return logisticsFollowOutApi.findLogisticsInfo(com,nu);
    }

    /**
     * 查询本地物流信息（在调用第三方接口查询之前）
     * @param orderNo 集采订单号
     * @return
     */
    public List<LogisticFollowDto> queryLocalLogisticByOrderNo(String orderNo){
        return logisticsQueryApi.findByOrderNo(orderNo);
    }
    /**
     * 查询本地物流信息（在调用第三方接口查询之前）
     * @param logisticNo 物流单号
     * @return
     */
    public LogisticFollowDto queryLocalLogisticByLogisticNo(String logisticNo){
        return logisticsQueryApi.findByLogisticNo(logisticNo);
    }

    /**
     * 同步物流信息到本地
     */
    public void syncLogisticLocal(List<LogisticFollowDto> logisticFollowDtos){
        logisticFollowApi.batchSaveLogisticInfo(logisticFollowDtos);
    }


    @MotanReferer
    ProtocolApi protocolApi;
    @MotanReferer
    ProtocolOrderLogisticApi protocolOrderLogisticApi;
    @MotanReferer
    ProtocolOrderApi protocolOrderApi;
    @MotanReferer
    LogisticsFollowOutApi logisticsFollowOutApi;
    @MotanReferer
    LogisticsQueryApi logisticsQueryApi;
    @MotanReferer
    LogisticFollowApi  logisticFollowApi;
}
