package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import suning.api.SnCommonConvertApi;

import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
@Service
@Slf4j
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class SnCommonConvertApiStub {
    public List<Map<String, String>> queryGoodsMprodStock(List<Map<String, String>> paramList, String cityId) {
        return snCommonConvertApi.queryGoodsMprodStock(paramList, cityId);
    }

    public List<Map<String, String>> getGoodsInventory(List<Map<String, String>> paramList, String cityId, String countyId) {
        return snCommonConvertApi.getGoodsInventory(paramList, cityId, countyId);
    }

    public List<Map<String, String>> getBatchProdSaleStatus(List<Map<String, String>> paramList) {
        return snCommonConvertApi.getBatchProdSaleStatus(paramList);
    }

    public List<Map<String, String>> queryGoodsPrice(List<Map<String, String>> priceParam, String cityId) {
        return snCommonConvertApi.queryGoodsPrice(priceParam, cityId);
    }

    public String addOrder(String requestJson) {
        return snCommonConvertApi.addOrder(requestJson);
    }

    public String addConfirmOrder(String requestJson) {
        return snCommonConvertApi.addConfirmOrder(requestJson);
    }

    public String cancelOrder(String requestJson) {
        return snCommonConvertApi.cancelOrder(requestJson);
    }

    public String getShipTime(String requestJson) {
        return snCommonConvertApi.getShipTime(requestJson);
    }

    public String getShipCarriage(String requestJson) {
        return snCommonConvertApi.getShipCarriage(requestJson);
    }

    public String commonJsonInvoke(String requestJson, String requestApiName, String requestMethodName, Class requestType) {
        return snCommonConvertApi.commonJsonInvoke(requestJson, requestApiName, requestMethodName, requestType);
    }

    public Map addProdBySkus(Map resMap, String skuids, String categoryId, String categoryName, String cmmdtyType) {
        return snCommonConvertApi.addProdBySkus(resMap, skuids, categoryId, categoryName, cmmdtyType);
    }

    @MotanReferer
    SnCommonConvertApi snCommonConvertApi;
}
