package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.mapdto.UnreviewedStoreDto;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreExtDto;
import utils.Lang;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * StoreApi的本地代理
 * @author Liang Wenxu
 * @since 2018-06-11
 */
@Service
@Slf4j
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class StoreApiStub {
    public static final String STORE_ID_CODE_CACHE_KEY = "OUTSIDE:STORE:ID_CODE_CACHE";
    public static final String STORE_OBJECT_CACHE_KEY = "OUTSIDE:STORE:OBJECT_CACHE";

    public List<StoreDto> findByTpye(String type) {
        return storeApi.findByTpye(type);
    }

    public StoreDto findByStoreId(String storeId) {
        String key = String.format("%s:%s", STORE_OBJECT_CACHE_KEY, storeId);
        BoundValueOperations<String, StoreDto> opt = redisTemplate.boundValueOps(key);
        opt.expire(30, TimeUnit.SECONDS);
        StoreDto v = opt.get();
        if(v == null) {
            v = storeApi.findByStoreId(storeId);
        }

        return v;
    }

    public List<StoreDto> findByStoreIds(List<String> storeIds) {
        return storeApi.findByStoreIds(storeIds);
    }

    public StoreDto getStoreInfo(String storeId) {
        return storeApi.getStoreInfo(storeId);
    }

    public List<StoreDto> getStoreList() {
        return storeApi.getStoreList();
    }

    public List<StoreDto> findStoreList() {
        return storeApi.findStoreList();
    }

    public UnreviewedStoreDto getUnreviewedStores(String name, Pageable pageable) {
        return storeApi.getUnreviewedStores(name, pageable);
    }

    public Map loadStoreVoByStoreExt(StoreExtDto storeExt) {
        return storeApi.loadStoreVoByStoreExt(storeExt);
    }

    public Map<String, List<StoreDto>> listStoreForIndex() {
        return storeApi.listStoreForIndex();
    }

    public List<StoreDto> findStoreByMember(String memberId) {
        return storeApi.findStoreByMember(memberId);
    }

    public Map listToMap() {
        return storeApi.listToMap();
    }

    public String getStoreCode(String storeId) {
        return storeApi.getStoreCode(storeId);
    }

    public List<StoreDto> findPassStore() {
        return storeApi.findPassStore();
    }

    public StoreDto findByCode(String code) {
        return storeApi.findByCode(code);
    }

    public List<String> getMemberStoreIds(String memberId) {
        return storeApi.getMemberStoreIds(memberId);
    }

    public StoreDto saveStore(StoreDto store) {
        return storeApi.saveStore(store);
    }

    public String findStoreIdByCode(String storeCode) {
        BoundHashOperations<String, String, String> ops = redisTemplate.boundHashOps(STORE_ID_CODE_CACHE_KEY);
        String id = null;
        for(Map.Entry<String, String> entry : ops.entries().entrySet()) {
            if(entry.getValue().equals(storeCode)) {
                id = entry.getKey();
                break;
            }
        }

        if(Lang.isEmpty(id)) {
            id = storeApi.findStoreIdByCode(storeCode);
            ops.expire(100, TimeUnit.SECONDS);
            ops.put(storeCode, id);
        }

        return id;
    }

    public String findStoreCodeById(String id) {
        BoundHashOperations<String, String, String> ops = redisTemplate.boundHashOps(STORE_ID_CODE_CACHE_KEY);
        String v = ops.get(id);
        if(Lang.isEmpty(v)) {
            v = storeApi.findStoreCodeById(id);
            ops.put(id, v);
        }

        return v;
    }

    public StoreDto findByDVendorId(String dVendorId) {
        return storeApi.findByDVendorId(dVendorId);
    }

    @MotanReferer
    StoreApi storeApi;

    @Autowired
    RedisTemplate redisTemplate;
}
