package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import recharge.center.api.weineng.api.request.OrderEntity;
import recharge.center.api.weineng.api.response.OrderResp;
import recharge.center.api.weineng.api.service.RechargeWeiNengApi;

/**
 * 微能订单API
 *
 * @author Drury
 * @date 2018/6/12
 */
@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class WnOrderApiStub {

    /**
     * 微能充值下单
     * @param orderEntity OrderEntity
     * @return OrderResp
     */
    public OrderResp takeOrder(OrderEntity orderEntity) {
        return rechargeWeiNengApi.getOrderCard(orderEntity);
    }

    @MotanReferer
    private RechargeWeiNengApi rechargeWeiNengApi;

}
