package outsideapi.service.utils;

import outsideapi.utils.FlgAseUtil;

import java.lang.reflect.Field;

/**
 * Created by oracle on 2017-04-16.
 */

/**
 * 福利高通讯安全加密
 *
 * @param <T>
 */
public class FlgVoReflectUtil<T> {
    /**
     * 对信息传输中使用AES/CBC/PKCS5Padding加密模式，对HTTP请求、返回数据（除平台编号外）进行加密后再由base64加密
     * 为保证积分商城可以正确获得合作平台的密钥信息，对交易中的平台编号(firmNo)不进行加密。
     *
     * @param flgVo
     * @param aseKey
     * @return
     */
    public String encryptVo(T flgVo, String aseKey) {
        Class<?> flgVoClass = flgVo.getClass();
        StringBuilder params = new StringBuilder("?");
        while (flgVoClass != null) {
            Field[] declaredFields = flgVoClass.getDeclaredFields();
            for (Field declaredField : declaredFields) {
                declaredField.setAccessible(true);
                String declaredFieldName = declaredField.getName();
                Object o = null;
                Object encriptStr = null;
                try {
                    encriptStr = declaredField.get(flgVo);
                    if (encriptStr != null) {
                        if (!declaredFieldName.equals("firmNo")&&!declaredFieldName.equals("token")) {
                            o = declaredField.get(flgVo);
                            encriptStr = FlgAseUtil.encrypt(o.toString(), aseKey);
                        }
                        if (encriptStr != null) {
                            declaredField.set(flgVo, encriptStr);
                            params.append(declaredFieldName + "=" + encriptStr + "&");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            flgVoClass = flgVoClass.getSuperclass();
        }
        if (params.length() > 1) {
            return params.substring(0, params.length() - 1);
        }
        return null;
    }

    /**
     * 由合作平台base64第一次解密后再aes解密后处理。
     *
     * @param flgVo
     * @param aseKey
     * @return
     */
    public T decryptVo(T flgVo, String aseKey) {
        Class<?> flgVoClass = flgVo.getClass();
        while (flgVoClass != null) {
            Field[] declaredFields = flgVoClass.getDeclaredFields();
            for (Field declaredField : declaredFields) {
                declaredField.setAccessible(true);
                String declaredFieldName = declaredField.getName();
                if (!declaredFieldName.equals("data") ) {
                    try {
                        Object o = declaredField.get(flgVo);
                        if (o != null) {
                            declaredField.set(flgVo, FlgAseUtil.decrypt(o.toString(), aseKey));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            flgVoClass = flgVoClass.getSuperclass();
        }

        return flgVo;
    }
}
