package outsideapi.service.utils;


import outsideapi.utils.jd.JdSkuUtil;
import outsideapi.vo.jdorder.Corder;
import outsideapi.vo.jdorder.JdOrder;
import outsideapi.vo.order.TrdOrder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by xujingfeng on 2016年12月16日
 */
public class JdOrderUtil {

    public static TrdOrder createTrdOrderByJdOrder(JdOrder jdOrder) {
        if(jdOrder == null) {
            return null;
        }
        TrdOrder trdOrder = new TrdOrder();
        trdOrder.setFreight(BigDecimal.valueOf(jdOrder.getPorder().getFreight()));
        trdOrder.setTrdOrderNo(jdOrder.getPorder().getJdorderid());
        trdOrder.setOrderNakedPrice(BigDecimal.valueOf(jdOrder.getPorder().getOrdernakedprice()));
        trdOrder.setOrderPrice(BigDecimal.valueOf(jdOrder.getPorder().getOrderprice()));
//		trdOrder.set(corder.getOrdertaxprice());
        trdOrder.setOrderstate(jdOrder.getOrderstate());
        trdOrder.setSubmitstate(jdOrder.getSubmitstate());
        trdOrder.setType(TrdOrder.TYPE_PARENT);
        trdOrder.setSku(JdSkuUtil.createTrdSkuByPSku(jdOrder.getPorder().getSku()));

        List<TrdOrder> cTOrders = new ArrayList<>();
        for(Corder corder : jdOrder.getCorder()) {
            cTOrders.add(createTrdOrderByCorder(corder));
        }
        trdOrder.setCorders(cTOrders);

        return trdOrder;
    }

    /**
     * 从京东子订单转换为统一的第三方订单返回
     * @param corder
     * @return
     */
	public static TrdOrder createTrdOrderByCorder(Corder corder){
        if(corder == null) {
            return null;
        }
		TrdOrder trdOrder = new TrdOrder();
		trdOrder.setFreight(BigDecimal.valueOf(corder.getFreight()));
		trdOrder.setTrdOrderNo(corder.getJdorderid());
		trdOrder.setOrderNakedPrice(BigDecimal.valueOf(corder.getOrdernakedprice()));
		trdOrder.setOrderPrice(BigDecimal.valueOf(corder.getOrderprice()));
//		trdOrder.set(corder.getOrdertaxprice());
        trdOrder.setOrderstate(corder.getOrderstate());
        trdOrder.setSubmitstate(corder.getSubmitstate());
        trdOrder.setType(TrdOrder.TYPE_CHILD);
        trdOrder.setSku(JdSkuUtil.createTrdSkuByCSku(corder.getSku()));
		
		return trdOrder;
	}
}










