package outsideapi.service.utils;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;

import java.util.Hashtable;

/**
 * Created by Liang Wenxu on 2016/11/24.
 */
@Component
public class OutsideApiFactoryUtil implements ApplicationContextAware {
    private static final String FACTORY_NAME_CONFIG_KEY = "outside.common.apihandler.factor";
    private static final String FACTORY_BEAN_CONFIG_KEY = "outside.common.apihandler.factor.bean";
    private ApplicationContext applicationContext;

    @Autowired
    private Environment env;

    public OutsideApiHandlerFactory getFactory() {
        return getFactory(readProp(FACTORY_BEAN_CONFIG_KEY));
    }

    public OutsideApiHandlerFactory getFactory(String factoryBeanName) {
        OutsideApiHandlerFactory factory = (OutsideApiHandlerFactory)applicationContext.getBean(factoryBeanName);
        return factory;
    }
    public OutsideApiHandlerFactory getFactory(Class factoryBeanName) {
        OutsideApiHandlerFactory factory = (OutsideApiHandlerFactory)applicationContext.getBean(factoryBeanName);
        return factory;
    }
    public String readProp(String key) {
        return env.getProperty(key);
    }

    public StoreDto findStoreById(String id) {
        return storeApi.getStoreInfo(id);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @MotanReferer
    StoreApi storeApi;
}
