/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import outsideapi.api.OutsideOrderApi;
import outsideapi.exception.HandlerNotFoundException;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.handler.OutsideOrderApiHandler;
import outsideapi.service.service.stub.StoreApiStub;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.utils.Constants;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.CancelOrderResp;
import outsideapi.vo.ConfirmOrderResp;
import outsideapi.vo.HandlerKey;
import outsideapi.vo.TakeOrderResp;
import outsideapi.vo.order.OrderMainDto;
import outsideapi.vo.order.TrdOrderResp;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;

@Component
@MotanService(basicService="motanServerBasicConfig")
public class OutsideOrderApiImpl
implements OutsideOrderApi {
    private static final Logger log = LoggerFactory.getLogger(OutsideOrderApiImpl.class);
    @Autowired
    StoreApiStub storeApi;
    @Autowired
    OutsideApiFactoryUtil outsideApiFactoryUtil;

    public CancelOrderResp cancelOrder(String storeId, String trdOrderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = this.getOutsideApiHandler(storeId);
        return handler.cancelOrder(trdOrderNo, storeId);
    }

    public TakeOrderResp takeOrder(OrderMainDto orderMain) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = this.getOutsideApiHandler(orderMain.getStoreId());
        return handler.takeOrder(orderMain);
    }

    public ConfirmOrderResp confirmOrder(String storeId, String trdOrderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = this.getOutsideApiHandler(storeId);
        return handler.confirmOrder(trdOrderNo, storeId);
    }

    public BackOrderResp backOrder(OrderMainDto orderMain, List<String> skuIds) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = this.getOutsideApiHandler(orderMain.getStoreId());
        return handler.backOrder(orderMain, skuIds);
    }

    public String queryTrdOrderNo(String storeId, String orderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = this.getOutsideApiHandler(storeId);
        return handler.queryTrdOrderNo(orderNo);
    }

    public TrdOrderResp queryOrder(String storeId, String trdOrderNo) throws HandlerNotFoundException {
        OutsideOrderApiHandler handler = this.getOutsideApiHandler(storeId);
        return handler.queryOrder(trdOrderNo);
    }

    private OutsideOrderApiHandler getOutsideApiHandler(String storeId) {
        long startTime = System.currentTimeMillis();
        StoreDto store = this.storeApi.findByStoreId(storeId);
        if (!(store == null || Lang.isEmpty((Object)store.getId()) && store.getStoreExt() == null)) {
            OutsideOrderApiHandler handler = null;
            OutsideApiHandlerFactory factory = null;
            factory = this.outsideApiFactoryUtil.getFactory();
            if (Lang.isEmpty((Object)factory)) {
                throw new RuntimeException("outside.common.apihandler.factory not config !");
            }
            HandlerKey handlerKey = new HandlerKey();
            handlerKey.setStoreType(store.getStoreExt().getType());
            handlerKey.setStoreCode(store.getStoreExt().getCode());
            handlerKey.setProductType("ALL");
            handlerKey.setInterfaceName(Constants.HandlerInterfaceNames.OUTSIDE_ORDER_API_HANDLER.toString());
            handler = (OutsideOrderApiHandler)factory.getOutsideApiHandler(handlerKey, OutsideOrderApiHandler.class);
            if (handler == null) {
                throw new HandlerNotFoundException();
            }
            return handler;
        }
        throw new HandlerNotFoundException();
    }
}

