/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.apiImpl;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderMainDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import member.api.AddressCommonApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.factory.impl.DbSpringBeanApiHandlerFactory;
import outsideapi.service.factory.impl.StoreTypeSpringBeanApiHandlerFactory;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.OutsideApiService;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.utils.Constants;
import outsideapi.vo.BatchAreaRequestVo;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.FashionPricesRequestVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerKey;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.ReserveOrderIdVo;
import outsideapi.vo.ReserveOrderVo;
import outsideapi.vo.ReserveVo;
import outsideapi.vo.ShippingFeeRequetVo;
import spider.api.PriceSpiderApi;
import spider.dto.SpiderLogsDto;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.rpc.motan.ApiResponseVo;

@MotanService(basicService="motanServerBasicConfig")
@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class OutsideProductApiImpl
implements OutsideProductApi {
    private static Log log = Logs.getLog((String)OutsideProductApiImpl.class.getName());
    @Autowired
    OutsideApiService outsideApiService;
    @Resource(name="redisTemplate")
    private ValueOperations<String, Object> commonCache;
    private static final String STORE_DTO_BY_ID_CACHE_KEY = "OUTSIDE-SERVICE:STORE-DTO:ID:";
    private static final String STORE_DTO_BY_CODE_CACHE_KEY = "OUTSIDE-SERVICE:STORE-DTO:CODE:";
    @MotanReferer
    PriceSpiderApi priceSpiderApi;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    @Autowired
    OutsideApiFactoryUtil outsideApiFactoryUtil;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    StoreApi storeApi;

    public HandlerRespVo<List<FashionStockStateVo>> getFashionStockState(StoreDto store, FashionStatusRequetVo requetVo) {
        if (!(store == null || Lang.isEmpty((Object)store.getId()) && store.getStoreExt() == null || requetVo == null)) {
            OutsideApiHandler handler = this.getOutsideApiHandler(store.getId());
            if (handler == null) {
                return this.handlerNotFoundResp();
            }
            requetVo.setStoreId(store.getId());
            return this.outsideApiService.queryFashionStockState(handler, requetVo);
        }
        HandlerRespVo resp = new HandlerRespVo();
        resp.setData(null);
        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
        resp.setErrorCode(Integer.valueOf(1));
        resp.setMessage("Required params [" + (store == null ? "store ," : "") + (requetVo == null ? "requetVo" : "") + "] CAN NOT Be Null");
        return resp;
    }

    public HandlerRespVo<Boolean> isOutsideStore(StoreDto store) {
        return this.isOutsideStore(store.getId());
    }

    public HandlerRespVo<Boolean> isOutsideStore(String storeId) {
        HandlerRespVo resp = new HandlerRespVo();
        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        resp.setErrorCode(Integer.valueOf(0));
        if (!Lang.isEmpty((Object)storeId)) {
            OutsideApiHandler handler = this.getOutsideApiHandler(storeId);
            if (handler == null) {
                resp = this.handlerNotFoundResp();
            } else {
                resp.setData((Object)true);
            }
            return resp;
        }
        resp.setData(null);
        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
        resp.setErrorCode(Integer.valueOf(1));
        resp.setMessage("Required params [" + (storeId == null ? "storeId ," : "") + "] CAN NOT Be Null");
        return resp;
    }

    public HandlerRespVo<Map<String, Object>> queryShippingFee(String storeId, ShippingFeeRequetVo requet) {
        OutsideApiHandler handler = this.getOutsideApiHandler(storeId);
        if (handler == null) {
            return this.handlerNotFoundResp();
        }
        HashMap<String, FashionNumsVo> fashionNumsVoMap = new HashMap<String, FashionNumsVo>();
        for (FashionNumsVo v : requet.getFashionNums()) {
            FashionNumsVo tempVo = (FashionNumsVo)fashionNumsVoMap.get(v.getProductCode());
            if (tempVo != null) {
                tempVo.setCounts(Long.valueOf(tempVo.getCounts() + v.getCounts()));
                continue;
            }
            fashionNumsVoMap.put(v.getProductCode(), v);
        }
        ArrayList newList = new ArrayList();
        for (Map.Entry entry : fashionNumsVoMap.entrySet()) {
            newList.add(entry.getValue());
        }
        requet.setFashionNums(newList);
        requet.setStoreId(storeId);
        return handler.queryShippingFee(requet);
    }

    public HandlerRespVo<BigDecimal> getSalesPriceRateRangeVal(FashionPricesRequestVo requestVo) {
        OutsideApiHandler handler = this.getOutsideApiHandler(Lang.isEmpty((Object)requestVo.getStoreCode()) ? requestVo.getStoreId() : requestVo.getStoreCode());
        HandlerRespVo resp = new HandlerRespVo();
        if (handler == null) {
            resp = this.handlerNotFoundResp();
        } else {
            resp.setData((Object)handler.getSalesPriceRateRangeVal(requestVo));
            resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        }
        return resp;
    }

    private OutsideApiHandler getOutsideApiHandler(String storeKey) {
        StoreDto store = null;
        if (Lang.isEmpty(store) && !Lang.isEmpty((Object)(store = this.storeApi.findByStoreId(storeKey)))) {
            this.commonCache.set((Object)(STORE_DTO_BY_ID_CACHE_KEY + storeKey), (Object)store, 1L, TimeUnit.DAYS);
        }
        if (Lang.isEmpty(store) && !Lang.isEmpty((Object)(store = this.storeApi.findByCode(storeKey)))) {
            this.commonCache.set((Object)(STORE_DTO_BY_CODE_CACHE_KEY + storeKey), (Object)store, 1L, TimeUnit.DAYS);
        }
        if (!(store == null || Lang.isEmpty((Object)store.getId()) && store.getStoreExt() == null)) {
            OutsideApiHandler handler = null;
            OutsideApiHandlerFactory factory = null;
            if (store.getStoreExt() != null && "2".equals(store.getStoreExt().getType())) {
                factory = this.outsideApiFactoryUtil.getFactory(DbSpringBeanApiHandlerFactory.class);
            } else {
                if (store.getStoreExt() != null && "33".equals(store.getStoreExt().getType())) {
                    handler = this.outsideApiFactoryUtil.getFactory(StoreTypeSpringBeanApiHandlerFactory.class).getOutsideApiHandlerByStoreType("33");
                    return handler;
                }
                if (store.getStoreExt() != null && "7".equals(store.getStoreExt().getType())) {
                    HandlerKey handlerKey = new HandlerKey();
                    handlerKey.setStoreType("7");
                    handlerKey.setInterfaceName(Constants.HandlerInterfaceNames.OUTSIDE_API_HANDLER.toString());
                    handler = (OutsideApiHandler)this.outsideApiFactoryUtil.getFactory().getOutsideApiHandler(handlerKey, OutsideApiHandler.class);
                    return handler;
                }
                factory = this.outsideApiFactoryUtil.getFactory();
            }
            if (Lang.isEmpty((Object)factory)) {
                throw new RuntimeException("outside.common.apihandler.factory not config !");
            }
            HandlerKey handlerKey = new HandlerKey();
            handlerKey.setStoreType(store.getStoreExt().getType());
            if (store.getStoreExt() != null && "2".equals(store.getStoreExt().getType())) {
                handlerKey.setStoreCode("ALL");
            } else {
                handlerKey.setStoreCode(store.getStoreExt().getCode());
            }
            handlerKey.setProductType("ALL");
            handlerKey.setInterfaceName(Constants.HandlerInterfaceNames.OUTSIDE_API_HANDLER.toString());
            handler = (OutsideApiHandler)factory.getOutsideApiHandler(handlerKey, OutsideApiHandler.class);
            return handler;
        }
        return null;
    }

    public HandlerRespVo<List<BigDecimal>> getBatchSalesPriceRateRangeVal(List<FashionPricesRequestVo> requestVoList) {
        HandlerRespVo resp = new HandlerRespVo();
        Vector<Object> rsList = new Vector<Object>();
        for (FashionPricesRequestVo aRequestVoList : requestVoList) {
            HandlerRespVo r = this.getSalesPriceRateRangeVal(aRequestVoList);
            if (r.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                rsList.add(r.getData());
                continue;
            }
            rsList.add(null);
        }
        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        resp.setData(rsList);
        return resp;
    }

    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(String storeKey, FashionPriceRequestVo request) {
        HandlerRespVo resp;
        long methodStartTime = System.currentTimeMillis();
        OutsideApiHandler handler = this.getOutsideApiHandler(storeKey);
        request.setStoreId(storeKey);
        if (handler == null) {
            resp = this.handlerNotFoundResp();
        } else {
            resp = new HandlerRespVo();
            HandlerRespVo queryResp = handler.queryFashionPrice(request);
            if (queryResp != null && queryResp.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS) {
                resp.setData(queryResp.getData());
                resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
            } else {
                resp = queryResp;
            }
        }
        log.info((Object)"\u67e5\u8be2\u7b2c\u4e09\u65b9\u5b9e\u65f6\u4ef7\u683c\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - methodStartTime});
        return resp;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String orderNo) {
        HandlerRespVo resp = new HandlerRespVo();
        OrderMainDto orderMain = this.orderMainApi.findByOrderNo(orderNo);
        if (orderMain != null) {
            OutsideApiHandler handler = this.getOutsideApiHandler(orderMain.getStoreId());
            if (handler == null) {
                resp.setData(null);
                resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                resp.setErrorCode(Integer.valueOf(2));
                resp.setMessage("Handler Not Found!");
            } else {
                HandlerRespVo handlerRespVo = handler.getShipingTrace(orderMain.getThirdOrderNo());
                if (handlerRespVo.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                    resp.setData(handlerRespVo.getData());
                    resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                } else {
                    resp = handlerRespVo;
                }
            }
        }
        return resp;
    }

    public HandlerRespVo<String> orderStatus(String orderNo) {
        HandlerRespVo resp = new HandlerRespVo();
        OrderMainDto orderMain = this.orderMainApi.findByOrderNo(orderNo);
        if (orderMain != null) {
            OutsideApiHandler handler = this.getOutsideApiHandler(orderMain.getStoreId());
            if (handler == null) {
                resp.setData(null);
                resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                resp.setErrorCode(Integer.valueOf(2));
                resp.setMessage("Handler Not Found!");
            } else {
                HandlerRespVo handlerRespVo = handler.getOrderStatus(orderMain.getThirdOrderNo());
                if (handlerRespVo.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                    resp.setData(handlerRespVo.getData());
                    resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                } else {
                    resp = handlerRespVo;
                }
            }
        }
        return resp;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public HandlerRespVo<BigDecimal> runPriceSpider(String storeId, FashionPriceParamVo request, String areaCode, String triggerType, Boolean async) {
        OutsideApiHandler handler = this.getOutsideApiHandler(storeId);
        HandlerRespVo resp = new HandlerRespVo();
        if (handler == null) {
            resp = this.handlerNotFoundResp();
        } else {
            Map areaCodeMap = this.addressCommonApi.areaCodeNodeList(areaCode);
            if (areaCodeMap != null) {
                Map trdAreaCodeMap = handler.transAreaCodeMap(areaCodeMap);
                try {
                    ApiResponseVo apiResponseVo = this.priceSpiderApi.getSalesPrice(storeId, request.getProductCode(), trdAreaCodeMap, triggerType);
                    if (apiResponseVo != null && "success".equals(apiResponseVo.getStatus())) {
                        resp.setData((Object)((SpiderLogsDto)apiResponseVo.getData()).getSalesPrice());
                        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                    } else {
                        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                        resp.setMessage("SpiderApi\u672a\u8fd4\u56de\u6570\u636e");
                        resp.setData(null);
                        resp.setErrorCode(Integer.valueOf(3));
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e, (Object)"\u8c03\u7528\u4ef7\u683c\u722c\u866bAPI\u5931\u8d25...", new Object[0]);
                    resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    resp.setMessage(e.getLocalizedMessage());
                    resp.setData(null);
                    resp.setErrorCode(Integer.valueOf(2));
                }
            }
        }
        return resp;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public HandlerRespVo<Map<String, BigDecimal>> runPriceSpider(String storeId, FashionPriceRequestVo request, String triggerType, Boolean async) {
        OutsideApiHandler handler = this.getOutsideApiHandler(storeId);
        HandlerRespVo resp = new HandlerRespVo();
        if (handler == null) {
            resp = this.handlerNotFoundResp();
        } else {
            HashMap<Integer, String> areaCodeMap = null;
            if (!(Lang.isEmpty((Object)request.getTownCode()) && Lang.isEmpty((Object)request.getCityCode()) && Lang.isEmpty((Object)request.getCountyCode()) && Lang.isEmpty((Object)request.getProvinceCode()))) {
                areaCodeMap = new HashMap<Integer, String>();
                areaCodeMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), request.getProvinceCode());
                areaCodeMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), request.getCityCode());
                areaCodeMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), request.getCountyCode());
                areaCodeMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), request.getTownCode());
            }
            Long time = System.currentTimeMillis();
            Map trdAreaCodeMap = areaCodeMap == null ? null : handler.transAreaCodeMap(areaCodeMap);
            log.info((Object)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5730\u5740\uff1a{}ms", new Object[]{System.currentTimeMillis() - time});
            try {
                ArrayList<String> skuIds = new ArrayList<String>();
                request.getFashionPriceParamVos();
                for (FashionPriceParamVo f : request.getFashionPriceParamVos()) {
                    if (Lang.isEmpty((Object)f.getProductCode())) continue;
                    skuIds.add(f.getProductCode());
                }
                time = System.currentTimeMillis();
                ApiResponseVo apiResponseVo = this.priceSpiderApi.getBatchSalesPrice(storeId, skuIds, trdAreaCodeMap, triggerType);
                log.info((Object)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u9500\u552e\u4ef7\u683c\u63a5\u53e3\uff1a{}ms", new Object[]{System.currentTimeMillis() - time});
                if (apiResponseVo != null && "success".equals(apiResponseVo.getStatus())) {
                    HashMap<String, BigDecimal> resData = new HashMap<String, BigDecimal>();
                    SpiderLogsDto l = null;
                    for (FashionPriceParamVo f : request.getFashionPriceParamVos()) {
                        l = (SpiderLogsDto)((Map)apiResponseVo.getData()).get(f.getProductCode());
                        if (l == null) continue;
                        resData.put(f.getProductCode(), l.getSalesPrice());
                    }
                    resp.setData(resData);
                    resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, (Object)"\u8c03\u7528\u4ef7\u683c\u722c\u866bAPI\u5931\u8d25...", new Object[0]);
                resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                resp.setMessage(e.getLocalizedMessage());
                resp.setData(null);
                resp.setErrorCode(Integer.valueOf(2));
            }
        }
        return resp;
    }

    public HandlerRespVo<Map<Integer, String>> transAreaCodeMap(String storeKey, Map<Integer, String> areaCodeMap) {
        OutsideApiHandler handler = this.getOutsideApiHandler(storeKey);
        HandlerRespVo resp = new HandlerRespVo();
        if (handler == null) {
            resp = this.handlerNotFoundResp();
        } else {
            resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
            resp.setData((Object)handler.transAreaCodeMap(areaCodeMap));
        }
        return resp;
    }

    private HandlerRespVo handlerNotFoundResp() {
        HandlerRespVo resp = new HandlerRespVo();
        resp.setData(null);
        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
        resp.setErrorCode(Integer.valueOf(2));
        resp.setMessage("Handler Not Found!");
        return resp;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getManyOrderShipingTrace(List<String> orderNos) {
        HandlerRespVo resp = new HandlerRespVo();
        ArrayList orderShippingPackageVos = new ArrayList();
        for (String orderNo : orderNos) {
            OrderMainDto orderMain = this.orderMainApi.findByOrderNo(orderNo);
            if (orderMain == null) continue;
            OutsideApiHandler handler = this.getOutsideApiHandler(orderMain.getStoreId());
            if (handler == null) {
                resp.setData(null);
                resp.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                resp.setErrorCode(Integer.valueOf(2));
                resp.setMessage("Handler Not Found!");
                return resp;
            }
            HandlerRespVo handlerRespVo = handler.getShipingTrace(orderMain.getThirdOrderNo());
            if (handlerRespVo.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                orderShippingPackageVos.addAll((Collection)handlerRespVo.getData());
                continue;
            }
            return handlerRespVo;
        }
        for (OrderShippingPackageVo packageVo : orderShippingPackageVos) {
            packageVo.getTrackInfoList().sort(new /* Unavailable Anonymous Inner Class!! */);
        }
        resp.setData(orderShippingPackageVos);
        resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        return resp;
    }

    public String toString() {
        System.out.println("method called........");
        return "OutsideProductApiImpl{}";
    }

    public HandlerRespVo<List<BatchAreaRequestVo>> batchTransAreaCodeMap(String storeKey, List<BatchAreaRequestVo> requestVos) {
        OutsideApiHandler handler = this.getOutsideApiHandler(storeKey);
        HandlerRespVo resp = new HandlerRespVo();
        if (handler == null) {
            resp = this.handlerNotFoundResp();
        } else {
            resp.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
            ArrayList<BatchAreaRequestVo> result = new ArrayList<BatchAreaRequestVo>();
            for (BatchAreaRequestVo batchAreaRequestVo : requestVos) {
                BatchAreaRequestVo batchAreaRequestVoResult = new BatchAreaRequestVo();
                batchAreaRequestVoResult.setIndexKey(batchAreaRequestVo.getIndexKey());
                Map areaCodeMap = batchAreaRequestVo.getAreaCodeMap();
                batchAreaRequestVoResult.setAreaCodeMap(handler.transAreaCodeMap(areaCodeMap));
                result.add(batchAreaRequestVoResult);
            }
            resp.setData(result);
        }
        return resp;
    }

    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        OutsideApiHandler handler = this.getOutsideApiHandler(storeCode);
        HandlerRespVo resp = new HandlerRespVo();
        resp = handler == null ? this.handlerNotFoundResp() : handler.createReservation(reserveOrderVo, storeCode);
        return resp;
    }

    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        OutsideApiHandler handler = this.getOutsideApiHandler(storeCode);
        HandlerRespVo resp = new HandlerRespVo();
        resp = handler == null ? this.handlerNotFoundResp() : handler.delReservation(reserveOrderIdVo, storeCode);
        return resp;
    }
}

