/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import outsideapi.api.SupplierOrderApi;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.factory.impl.DbSpringBeanApiHandlerFactory;
import outsideapi.service.handler.SupplierOrderApiHandler;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.utils.Constants;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.HandlerKey;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.orderrequest.OrderRequst;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;

@MotanService
public class SupplierOrderApiImpl
implements SupplierOrderApi {
    private static final Logger log = LoggerFactory.getLogger(SupplierOrderApiImpl.class);
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    OutsideApiFactoryUtil outsideApiFactoryUtil;

    public Boolean cancelOrder(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException, OrderCancelException {
        return this.getOutsideApiHandler(trdOrderKey.getStoreCode()).cancelOrder(trdOrderKey);
    }

    public TrdOrder takeOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierTakeOrderFalidException {
        return this.getOutsideApiHandler(orderMain.getStoreCode()).takeOrder(orderMain);
    }

    public void confirmOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        this.getOutsideApiHandler(orderMain.getStoreCode()).confirmOrder(orderMain);
    }

    public BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException {
        return this.getOutsideApiHandler(orderMain.getStoreCode()).backOrder(orderMain, skuIds);
    }

    public TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return this.getOutsideApiHandler(trdOrderKey.getStoreCode()).getDetail(trdOrderKey);
    }

    public String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return this.getOutsideApiHandler(trdOrderKey.getStoreCode()).queryTrdOrderNo(trdOrderKey);
    }

    private SupplierOrderApiHandler getOutsideApiHandler(String storeKey) {
        long startTime = System.currentTimeMillis();
        StoreDto store = this.storeApi.findByStoreId(storeKey);
        StoreDto storeDto = store = store == null ? this.storeApi.findByCode(storeKey) : store;
        if (!(store == null || Lang.isEmpty((Object)store.getId()) && store.getStoreExt() == null)) {
            SupplierOrderApiHandler handler = null;
            OutsideApiHandlerFactory factory = null;
            factory = store.getStoreExt() != null && "2".equals(store.getStoreExt().getType()) ? this.outsideApiFactoryUtil.getFactory(DbSpringBeanApiHandlerFactory.class) : this.outsideApiFactoryUtil.getFactory();
            if (Lang.isEmpty((Object)factory)) {
                throw new RuntimeException("outside.common.apihandler.factory not config !");
            }
            HandlerKey handlerKey = new HandlerKey();
            handlerKey.setStoreType(store.getStoreExt().getType());
            if (store.getStoreExt() != null && "2".equals(store.getStoreExt().getType())) {
                handlerKey.setStoreCode("ALL");
            } else {
                handlerKey.setStoreCode(store.getStoreExt().getCode());
            }
            handlerKey.setProductType("ALL");
            handlerKey.setInterfaceName(Constants.HandlerInterfaceNames.SUPPLIER_ORDER_API_HANDLER.toString());
            handler = (SupplierOrderApiHandler)factory.getOutsideApiHandler(handlerKey, SupplierOrderApiHandler.class);
            log.info("\u83b7\u53d6 handler \u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
            return handler;
        }
        log.info("\u83b7\u53d6 handler \u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
        return null;
    }
}

