/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.config;

import com.weibo.api.motan.config.springsupport.AnnotationBean;
import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.Lang;
import utils.spring.ApplicationContextProvider;

@Configuration
public class MotanConfig {
    @Value(value="${motan.client.group}")
    private String motanClientGroup;
    @Value(value="${motan.client.access.log}")
    private Boolean motanClientAccessLog;
    @Value(value="${motan.server.group}")
    private String motanServerGroup;
    @Value(value="${motan.server.access.log}")
    private Boolean motanServerAccessLog;
    @Value(value="${motan.server.maxWorkerThread:800}")
    private Integer maxWorkerThread;
    @Value(value="${motan.server.minWorkerThread:20}")
    private Integer minWorkerThread;

    @Bean
    ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public AnnotationBean motanAnnotationBean() {
        AnnotationBean motanAnnotationBean = new AnnotationBean();
        motanAnnotationBean.setPackage("utils.rpc.motan, outsideapi.service.apiImpl, outsideapi.service.service, outsideapi.service.handler, outsideapi.service.controller, outsideapi.api, outsideapi.service.utils,jd.service.jdapi,jd.api.service,suning.api");
        if (motanAnnotationBean.getPackage() == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6ematon api \u5305");
        }
        return motanAnnotationBean;
    }

    @Bean(name={"motan"})
    public ProtocolConfigBean protocolConfig() {
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setMaxClientConnection(Integer.valueOf(30));
        config.setDefault(true);
        config.setSerialization("hibernateHessian2");
        config.setName("motan");
        config.setMaxContentLength(Integer.valueOf(0x100000));
        config.setMaxWorkerThread(Integer.valueOf(this.maxWorkerThread == null ? 800 : this.maxWorkerThread));
        config.setMinWorkerThread(Integer.valueOf(this.minWorkerThread == null ? 20 : this.minWorkerThread));
        return config;
    }

    @Bean(name={"registry"})
    public RegistryConfigBean registryConfigSit(@Value(value="${motan.zookeeper.host}") String zookeeperAddress) {
        RegistryConfigBean config = new RegistryConfigBean();
        config.setDefault(true);
        config.setRegProtocol("commondZookeeper");
        config.setAddress(zookeeperAddress);
        return config;
    }

    @Bean(name={"motanServerBasicConfig"})
    public BasicServiceConfigBean baseServiceConfig(@Value(value="${motan.export.port}") String port, @Value(value="${spring.zipkin.tarcer.brave.enable:false}") Boolean opentracingEnabled) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        config.setExport("motan:" + port);
        if (Lang.isEmpty((Object)this.motanServerGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(this.motanServerGroup);
        }
        if (Lang.isEmpty((Object)this.motanServerAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(this.motanServerAccessLog.booleanValue());
        }
        config.setShareChannel(Boolean.valueOf(true));
        config.setRequestTimeout(Integer.valueOf(9000000));
        config.setRegistry("registry");
        config.setFilter("openjpasession");
        return config;
    }

    @Bean(name={"motanClientBasicConfig"})
    public BasicRefererConfigBean baseRefererConfig(@Value(value="${spring.zipkin.tarcer.brave.enable:false}") Boolean opentracingEnabled) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (Lang.isEmpty((Object)this.motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(this.motanClientGroup);
        }
        if (Lang.isEmpty((Object)this.motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(this.motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setThrowException(Boolean.valueOf(true));
        config.setRequestTimeout(Integer.valueOf(120000));
        config.setDefault(true);
        return config;
    }

    @Bean(name={"motanClientFastFailConfig"})
    public BasicRefererConfigBean clientFastFailConfig(@Value(value="${spring.zipkin.tarcer.brave.enable:false}") Boolean opentracingEnabled) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if (Lang.isEmpty((Object)this.motanClientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(this.motanClientGroup);
        }
        if (Lang.isEmpty((Object)this.motanClientAccessLog)) {
            config.setAccessLog(false);
        } else {
            config.setAccessLog(this.motanClientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(Integer.valueOf(120000));
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        config.setFilter("openjpasession");
        return config;
    }
}

