/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.factory.impl;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;
import outsideapi.model.OutsideapiHandlerConfigs;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.OutsideApiService;
import outsideapi.service.utils.OutsideApiFactoryUtil;
import outsideapi.vo.HandlerKey;
import utils.Lang;

@Component(value="dbSpringBeanApiHandlerFactory")
public class DbSpringBeanApiHandlerFactory
implements OutsideApiHandlerFactory,
ApplicationContextAware {
    Logger logger = Logger.getLogger(DbSpringBeanApiHandlerFactory.class);
    private static String HANDLER_CACHE_KEY_TPL = "cache:outsideservice:apihandler:%s.%s";
    private static String HANDLER_INTF_PACKAGE = "outsideapi.service.handler";
    @Resource(name="redisTemplate")
    private ValueOperations<String, Object> outsideHandlerCache;
    private ApplicationContext applicationContext;
    private OutsideApiFactoryUtil outsideApiFactoryUtil;
    @Autowired
    OutsideApiService outsideApiService;

    public <T> T getOutsideApiHandler(HandlerKey handlerKey, Class<T> clazz) {
        if (handlerKey == null || Lang.isEmpty((Object)handlerKey.getStoreType()) && Lang.isEmpty((Object)handlerKey.getInterfaceName()) && Lang.isEmpty((Object)handlerKey.getStoreCode()) && Lang.isEmpty((Object)handlerKey.getProductType())) {
            return null;
        }
        handlerKey.setInterfaceName(clazz.getSimpleName());
        Object handler = this.getHandlerInCache(handlerKey, clazz);
        OutsideapiHandlerConfigs configs = this.outsideApiService.getHandlerConfigs(handlerKey);
        if (configs != null) {
            handler = this.applicationContext.getBean(configs.getHandlerBean());
        }
        return (T)handler;
    }

    public OutsideApiHandler getOutsideApiHandlerByStoreType(String storeType) {
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private <T> T getHandlerInCache(HandlerKey handlerKey, Class<T> clazz) {
        Object obj = this.outsideHandlerCache.get((Object)String.format(HANDLER_CACHE_KEY_TPL, clazz.getSimpleName(), handlerKey.toKeyString()));
        return (T)obj;
    }

    private <T> void putHandlerToCache(HandlerKey handlerKey, T value) {
        this.outsideHandlerCache.set((Object)String.format(HANDLER_CACHE_KEY_TPL, value.getClass().getSimpleName(), handlerKey.toKeyString()), value, 10L, TimeUnit.MINUTES);
    }
}

