/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.service.handler.OutsideOrderApiHandler;
import outsideapi.service.service.stub.EmayOrderApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.utils.Constants;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.CancelOrderResp;
import outsideapi.vo.ConfirmOrderResp;
import outsideapi.vo.OrderResp;
import outsideapi.vo.TakeOrderResp;
import outsideapi.vo.order.OrderItemDto;
import outsideapi.vo.order.OrderMainDto;
import outsideapi.vo.order.TrdOrderResp;
import recharge.center.api.emay.api.definition.ErrorInfo;
import recharge.center.api.emay.api.request.OrderEntity;
import recharge.center.api.emay.api.request.OrderQueryEntity;
import recharge.center.api.emay.api.response.OrderQueryResp;

@Component
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class EmayOutsideOrderApiHandler
implements OutsideOrderApiHandler {
    private static final Logger log = LoggerFactory.getLogger(EmayOutsideOrderApiHandler.class);
    private final EmayOrderApiStub orderApi;
    private final OrderMainApiStub orderMainApi;

    public CancelOrderResp cancelOrder(String trdOrderNo, String storeId) {
        CancelOrderResp cancelOrderResp = new CancelOrderResp();
        cancelOrderResp.setCode("0");
        cancelOrderResp.setMessage("success");
        cancelOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        return cancelOrderResp;
    }

    public TakeOrderResp takeOrder(OrderMainDto orderMain) {
        recharge.center.api.emay.api.response.OrderResp orderResp;
        TakeOrderResp takeOrderResp = new TakeOrderResp();
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setClientTaskNo(orderMain.getOrderNo());
        orderEntity.setMobile(((OrderItemDto)orderMain.getOrderItems().get(0)).getBusinessCode());
        orderEntity.setProductCode(((OrderItemDto)orderMain.getOrderItems().get(0)).getSku());
        log.info("\u4ebf\u7f8e\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570 : {}", (Object)JSON.toJSONString((Object)orderEntity));
        long takeOrderTime = System.currentTimeMillis();
        log.info("\u6b63\u5728\u8c03\u7528\u4ebf\u7f8e\u4f9b\u5e94\u5546\u63a5\u53e3\u4e0b\u5355...");
        try {
            orderResp = this.orderApi.takeOrder(orderEntity);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4ebf\u7f8e\u4f9b\u5e94\u5546\u4e0b\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            takeOrderResp.setReturnCode("1");
            takeOrderResp.setReturnMsg("\u8c03\u7528\u4ebf\u7f8e\u4f9b\u5e94\u5546\u4e0b\u5355\u63a5\u53e3\u5f02\u5e38 : " + e.getMessage());
            takeOrderResp.setStatus(Constants.ResponseStatus.ERROR);
            return takeOrderResp;
        }
        log.info("\u8c03\u7528\u4ebf\u7f8e\u4f9b\u5e94\u5546\u63a5\u53e3\u8fd4\u56de\u6570\u636e : {}", (Object)orderResp);
        log.info("\u8c03\u7528\u4ebf\u7f8e\u4f9b\u5e94\u5546\u63a5\u53e3\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - takeOrderTime));
        String successCode = "SUCCESS";
        if ("SUCCESS".equals(orderResp.getResponseCode())) {
            OrderResp returnOrderResp = new OrderResp();
            returnOrderResp.setTrdOrderNo(orderResp.getTaskNo());
            takeOrderResp.setOrderResp(returnOrderResp);
            takeOrderResp.setReturnCode("0");
            takeOrderResp.setReturnMsg("\u4f9b\u5e94\u5546\u4e0b\u5355\u6210\u529f");
            takeOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        } else {
            takeOrderResp.setReturnCode("2");
            takeOrderResp.setReturnMsg("\u4ebf\u7f8e\u4f9b\u5e94\u5546\u4e0b\u5355\u5931\u8d25. " + orderResp.getResponseCode() + " : " + (String)ErrorInfo.ERRORS.get(orderResp.getResponseCode()));
            takeOrderResp.setStatus(Constants.ResponseStatus.ERROR);
        }
        log.info("\u65b9\u6cd5\u7ed3\u675f\u8fd4\u56de\u5bf9\u8c61 : {}", (Object)JSON.toJSONString((Object)takeOrderResp));
        return takeOrderResp;
    }

    public ConfirmOrderResp confirmOrder(String trdOrderNo, String storeId) {
        ConfirmOrderResp confirmOrderResp = new ConfirmOrderResp();
        confirmOrderResp.setCode("0");
        confirmOrderResp.setMessage("SUCCESS");
        confirmOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        return confirmOrderResp;
    }

    public BackOrderResp backOrder(OrderMainDto orderMain, List<String> skuIds) {
        BackOrderResp backOrderResp = new BackOrderResp();
        backOrderResp.setCode("0");
        backOrderResp.setMessage("SUCCESS");
        backOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        return backOrderResp;
    }

    public String queryTrdOrderNo(String orderNo) {
        return orderNo + "_TRD";
    }

    public TrdOrderResp queryOrder(String trdOrderNo) {
        OrderQueryResp orderQueryResp;
        TrdOrderResp queryOrderResp = new TrdOrderResp();
        String orderNo = this.orderMainApi.findOrderNoByThirdOrderNo(trdOrderNo);
        OrderQueryEntity orderQueryEntity = new OrderQueryEntity(orderNo, trdOrderNo);
        try {
            orderQueryResp = this.orderApi.queryOrder(orderQueryEntity);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4ebf\u7f8e\u4f9b\u5e94\u5546\u8ba2\u5355\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            queryOrderResp.setCode("ERROR");
            queryOrderResp.setMessage("\u8c03\u7528\u4ebf\u7f8e\u4f9b\u5e94\u5546\u8ba2\u5355\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38 : " + e.getMessage());
            queryOrderResp.setStatus(Constants.ResponseStatus.ERROR);
            return queryOrderResp;
        }
        log.info("\u8fd4\u56de\u4ee3\u7801 = {}, \u4ee3\u7801\u6ce8\u91ca = {}", (Object)orderQueryResp.getResponseCode(), ErrorInfo.ERRORS.get(orderQueryResp.getResponseCode()));
        queryOrderResp.setCode(orderQueryResp.getResponseCode());
        queryOrderResp.setMessage("SUCCESS");
        queryOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        if ("TIME_OUT".equals(orderQueryResp.getResponseCode())) {
            queryOrderResp.setMessage("TIME_OUT");
            queryOrderResp.setStatus(Constants.ResponseStatus.TIME_OUT);
        }
        return queryOrderResp;
    }

    @Autowired
    public EmayOutsideOrderApiHandler(EmayOrderApiStub orderApi, OrderMainApiStub orderMainApi) {
        this.orderApi = orderApi;
        this.orderMainApi = orderMainApi;
    }
}

