/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import cart.api.dto.order.SubOrderItemDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.model.GoodsPicture;
import goods.model.repository.GoodsPictureRepos;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.api.request.order.JdOrderIdEntity;
import jd.api.request.order.OrderEntity;
import jd.api.request.order.OrderFreightEntity;
import jd.api.request.product.SkuEntity;
import jd.api.request.product.SkuIdAndNumEntity;
import jd.api.request.product.SkuIdsAndAreaEntity;
import jd.api.request.product.StockForOrderEntity;
import jd.api.response.order.OrderFreightResp;
import jd.api.response.order.OrderTrackResp;
import jd.api.vo.order.OrderFreightVO;
import jd.api.vo.order.OrdertrackResultVO;
import jd.api.vo.order.OrdertrackVO;
import jd.api.vo.product.PriceVO;
import jd.api.vo.product.ProductStateVO;
import jd.api.vo.product.StockNewResultVo;
import jd.api.vo.product.StockVO;
import jd.model.address.NationalAddress;
import jd.model.repository.NationalAddressRepos;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.dto.common.AddressDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.AddressCommonApiStub;
import outsideapi.service.service.stub.JdOrderApiStub;
import outsideapi.service.service.stub.JdProductApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.vo.FacProductConfirmRequestVo;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.FashionPricesRequestVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.GoodsInfoVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.OrderShippingTrackVo;
import outsideapi.vo.ReserveOrderIdVo;
import outsideapi.vo.ReserveOrderVo;
import outsideapi.vo.ReserveVo;
import outsideapi.vo.ShipTimeResVo;
import outsideapi.vo.ShippLogistRequestVo;
import outsideapi.vo.ShippLogistResVo;
import outsideapi.vo.ShippingFeeRequetVo;
import outsideapi.vo.jdorder.JdOrderConstant;
import outsideapi.vo.jdorder.OrderPriceSnap;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderRequst;
import sysmg.api.SystemConfigApi;
import utils.Lang;

@Component
@Transactional(readOnly=true)
public class JdOutsideApiHandler
implements OutsideApiHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(JdOutsideApiHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    JdProductApiStub jdProductApi;
    @Autowired
    JdOrderApiStub jdOrderApi;
    @Autowired
    OrderMainApiStub orderMainApi;
    @Autowired
    NationalAddressRepos nationalAddressRepos;
    @Autowired
    AddressCommonApiStub addressCommonApi;
    @Autowired
    GoodsPictureRepos goodsPictureRepos;
    @Autowired
    OutsideProductApi outsideProductApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;

    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        System.out.println("JdOutsideApiHandler.queryFashionStockState invoked...");
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        ArrayList<FashionStockStateVo> resStateVoList = new ArrayList<FashionStockStateVo>();
        handlerRespVo.setData(resStateVoList);
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        String jdLvTwo = "0";
        String jdLvThree = "0";
        Object areaCode = null;
        NationalAddress na = null;
        long transToNationAddressTime = System.currentTimeMillis();
        na = this.transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        log.info("\u7b2c\u4e09\u65b9\u5730\u5740\u8f6c\u6362\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - transToNationAddressTime));
        if (!Lang.isEmpty((Object)na)) {
            ArrayList resDataList = new ArrayList();
            Object resData = null;
            StringBuilder productCodeIds = new StringBuilder();
            ArrayList<Long> skuidList = new ArrayList<Long>();
            StockForOrderEntity stockForOrderEntity = new StockForOrderEntity();
            stockForOrderEntity.setSkuNums(new ArrayList());
            for (FashionNumsVo numsVo : requet.getFashionNums()) {
                productCodeIds.append(",").append(numsVo.getProductCode());
                skuidList.add(Long.parseLong(numsVo.getProductCode()));
                stockForOrderEntity.getSkuNums().add(new StockVO(Long.valueOf(Long.parseLong(numsVo.getProductCode())), Integer.valueOf(numsVo.getCounts().intValue())));
            }
            stockForOrderEntity.setArea(na.getAreaString());
            SkuIdsAndAreaEntity skuIdsAndAreaEntity = new SkuIdsAndAreaEntity(productCodeIds.substring(1), na.getLeveloneAddress(), na.getLeveltwoAddress(), na.getLevelthreeAddress(), na.getLevelfourAddress());
            Object resMapTmp = null;
            FashionStockStateVo stockStateVoTmp = null;
            long getProductStateTime = System.currentTimeMillis();
            List productStateRes = this.jdProductApi.getProductState(skuidList);
            log.info("\u67e5\u8be2\u4e0a\u4e0b\u67b6\u72b6\u6001\u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - getProductStateTime) / 1000.0));
            if (!Lang.isEmpty((Object)productStateRes)) {
                for (ProductStateVO i : productStateRes) {
                    stockStateVoTmp = (FashionStockStateVo)this.findObjectInList(resStateVoList.toArray(new Object[0]), (Object)"productCode", (Object)i.getSku().toString());
                    if (stockStateVoTmp == null) {
                        stockStateVoTmp = new FashionStockStateVo();
                        stockStateVoTmp.setProductCode(i.getSku().toString());
                        for (FashionNumsVo numsVo : requet.getFashionNums()) {
                            if (!i.getSku().toString().equals(numsVo.getProductCode())) continue;
                            stockStateVoTmp.setFashionId(numsVo.getFactionId());
                            break;
                        }
                        resStateVoList.add(stockStateVoTmp);
                    }
                    stockStateVoTmp.setOnSale(Boolean.valueOf(i.getState() == 1));
                    stockStateVoTmp.setAreaRestrict(Boolean.valueOf(false));
                }
                long getStockForOrderTime = System.currentTimeMillis();
                List stockForOrderRes = this.jdProductApi.getStockForOrder(stockForOrderEntity);
                log.info("\u67e5\u8be2\u5b9e\u65f6\u5e93\u5b58\u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - getStockForOrderTime) / 1000.0));
                if (!Lang.isEmpty((Object)stockForOrderRes)) {
                    for (StockNewResultVo i : stockForOrderRes) {
                        stockStateVoTmp = (FashionStockStateVo)this.findObjectInList(resStateVoList.toArray(new Object[0]), (Object)"productCode", (Object)i.getSkuId().toString());
                        if (stockStateVoTmp == null) {
                            stockStateVoTmp = new FashionStockStateVo();
                            stockStateVoTmp.setProductCode(i.getSkuId().toString());
                            for (FashionNumsVo numsVo : requet.getFashionNums()) {
                                if (!i.getSkuId().toString().equals(numsVo.getProductCode())) continue;
                                stockStateVoTmp.setFashionId(numsVo.getFactionId());
                                break;
                            }
                            resStateVoList.add(stockStateVoTmp);
                        }
                        stockStateVoTmp.setStockCount(i.getRemainNum());
                        if (i.getStockStateId() == 34) {
                            stockStateVoTmp.setStockFlag(Integer.valueOf(0));
                            stockStateVoTmp.setStockCount(Integer.valueOf(-1));
                            continue;
                        }
                        if (i.getStockStateId() == 36) {
                            stockStateVoTmp.setStockFlag(Integer.valueOf(1));
                            continue;
                        }
                        stockStateVoTmp.setStockFlag(Integer.valueOf(1));
                    }
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                    handlerRespVo.setErrorCode(Integer.valueOf(0));
                } else {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1agetStockForOrder \u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                    handlerRespVo.setErrorCode(Integer.valueOf(3));
                }
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                handlerRespVo.setErrorCode(Integer.valueOf(0));
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1agetProductState \u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                handlerRespVo.setErrorCode(Integer.valueOf(3));
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u5730\u533a\u4ee3\u7801\u8f6c\u6362\u5931\u8d25");
            handlerRespVo.setErrorCode(Integer.valueOf(2));
        }
        handlerRespVo.setData(resStateVoList);
        return handlerRespVo;
    }

    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setData(null);
        ArrayList<FashionPriceVo> rsData = null;
        if (requet.getFashionPriceParamVos() != null) {
            rsData = new ArrayList<FashionPriceVo>();
            StringBuilder skuStrs = new StringBuilder();
            for (FashionPriceParamVo fpv : requet.getFashionPriceParamVos()) {
                skuStrs.append(",").append(fpv.getProductCode());
            }
            SkuEntity skuEntity = new SkuEntity();
            skuEntity.setSku(skuStrs.substring(1));
            long getPriceTime = System.currentTimeMillis();
            List price = this.jdProductApi.getPrice(skuEntity);
            log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - getPriceTime) / 1000.0));
            if (!Lang.isEmpty((Object)price)) {
                block1: for (PriceVO rtnPrice : price) {
                    for (FashionPriceParamVo fpv : requet.getFashionPriceParamVos()) {
                        if (!fpv.getProductCode().equals(rtnPrice.getSkuId().toString())) continue;
                        FashionPriceVo rspriceVo = new FashionPriceVo();
                        rspriceVo.setFashionId(fpv.getFactionId());
                        rspriceVo.setProductCode(fpv.getProductCode());
                        rspriceVo.setCostPrice(rtnPrice.getPrice());
                        rspriceVo.setSalePrice(rtnPrice.getPrice());
                        rspriceVo.setMarketPrice(rtnPrice.getJdPrice());
                        rsData.add(rspriceVo);
                        continue block1;
                    }
                }
            }
            handlerRespVo.setData(rsData);
        }
        return handlerRespVo;
    }

    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        NationalAddress na = this.transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (na == null) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(Integer.valueOf(1));
            handlerRespVo.setMessage("\u8be5\u5e97\u94fa\u4e0d\u652f\u6301\u5f53\u524d\u914d\u9001\u5730\u5740");
        } else {
            OrderFreightEntity orderFreightEntity = new OrderFreightEntity();
            orderFreightEntity.setProvince(na.getLeveloneAddress());
            orderFreightEntity.setCity(na.getLeveltwoAddress());
            orderFreightEntity.setCounty(Integer.valueOf(Lang.isEmpty((Object)na.getLevelthreeAddress()) ? 0 : na.getLevelthreeAddress()));
            orderFreightEntity.setTown(Integer.valueOf(Lang.isEmpty((Object)na.getLevelfourAddress()) ? 0 : na.getLevelfourAddress()));
            if (Lang.isEmpty((Object)requet.getPayType())) {
                requet.setPayType("4");
            } else {
                requet.setPayType(requet.getPayType().trim());
            }
            orderFreightEntity.setPaymentType(Integer.valueOf(Integer.parseInt(requet.getPayType())));
            ArrayList<SkuIdAndNumEntity> skuLst = new ArrayList<SkuIdAndNumEntity>();
            if (!Lang.isEmpty((Object)requet.getFashionNums())) {
                for (FashionNumsVo fnVo : requet.getFashionNums()) {
                    if (Lang.isEmpty((Object)fnVo.getProductCode()) || Lang.isEmpty((Object)fnVo.getCounts()) || fnVo.getCounts() <= 0L) continue;
                    SkuIdAndNumEntity skuIdAndNumEntity = new SkuIdAndNumEntity();
                    skuIdAndNumEntity.setId(Long.valueOf(Long.parseLong(fnVo.getProductCode())));
                    skuIdAndNumEntity.setNum(Integer.valueOf(fnVo.getCounts().intValue()));
                    skuLst.add(skuIdAndNumEntity);
                }
            }
            orderFreightEntity.setSku(skuLst);
            OrderFreightVO apiRes = null;
            OrderFreightResp orderFreightResp = null;
            try {
                long queryFreightTime = System.currentTimeMillis();
                orderFreightResp = this.jdOrderApi.queryFreight(orderFreightEntity);
                apiRes = orderFreightResp.getResult();
                log.info("\u4eac\u4e1c\u8fd0\u8d39\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u8017\u65f6 {} \u79d2", (Object)((double)(System.currentTimeMillis() - queryFreightTime) / 1000.0));
            }
            catch (Exception e) {
                e.printStackTrace();
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setErrorCode(Integer.valueOf(1));
                handlerRespVo.setMessage("\u8c03\u7528\u4eac\u4e1c\u63a5\u53e3\u51fa\u9519:" + e.getLocalizedMessage());
            }
            if (apiRes != null) {
                HashMap<String, Object> d = new HashMap<String, Object>();
                d.put("freight", apiRes.getFreight());
                d.put("baseFreight", apiRes.getBaseFreight());
                d.put("remoteRegionFreight", apiRes.getRemoteRegionFreight());
                if (!Lang.isEmpty((Object)apiRes.getRemoteSku())) {
                    apiRes.setRemoteSku(apiRes.getRemoteSku().trim());
                    if (apiRes.getRemoteSku().contains("[") && apiRes.getRemoteSku().contains("]")) {
                        apiRes.setRemoteSku(apiRes.getRemoteSku().substring(apiRes.getRemoteSku().indexOf("[") + 1, apiRes.getRemoteSku().lastIndexOf("]")).trim());
                    }
                    if (!Lang.isEmpty((Object)apiRes.getRemoteSku())) {
                        String[] fids = apiRes.getRemoteSku().split(",");
                        StringBuilder sb = new StringBuilder();
                        for (String id : fids) {
                            FashionNumsVo fashionNumsVo;
                            if ((id = id.trim()).length() <= 0 || (fashionNumsVo = (FashionNumsVo)this.findObjectInList(requet.getFashionNums().toArray(new Object[0]), (Object)"productCode", (Object)id)) == null) continue;
                            sb.append(",").append(fashionNumsVo.getFactionId());
                        }
                        d.put("remoteFashions", sb.substring(1));
                    }
                }
                handlerRespVo.setData(d);
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setErrorCode(Integer.valueOf(1));
                handlerRespVo.setMessage(StringUtils.isEmpty((CharSequence)orderFreightResp.getResultMessage()) ? "\u8c03\u7528\u4eac\u4e1c\u63a5\u53e3\u51fa\u9519\uff0c\u65e0\u6570\u636e\u8fd4\u56de" : orderFreightResp.getResultMessage());
            }
        }
        return handlerRespVo;
    }

    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        try {
            if (!Lang.isEmpty((Object)areaCode)) {
                if (lv == AddressCommonApi.AddressLevel.CITY || lv == AddressCommonApi.AddressLevel.PROVINCE || lv == AddressCommonApi.AddressLevel.AREA) {
                    NationalAddress na;
                    AddressDto addr = this.addressCommonApi.findById(areaCode);
                    if (!addr.getStoreCode().equals("common") && !addr.getStoreCode().equals("jd")) {
                        String pCode = addr.getParent().getId();
                        addr = (addr = this.addressCommonApi.findFirstChild(pCode, "jd", Boolean.valueOf(false))) == null ? this.addressCommonApi.findFirstChild(pCode, "common", Boolean.valueOf(false)) : addr;
                        String string = areaCode = addr == null ? areaCode : addr.getId();
                    }
                    if (Lang.isEmpty((Object)(na = this.nationalAddressRepos.findByLinkId(areaCode)))) {
                        addr = this.addressCommonApi.findFirstChild(areaCode, "jd", Boolean.valueOf(false));
                        AddressDto addressDto = addr = addr == null ? this.addressCommonApi.findFirstChild(areaCode, "common", Boolean.valueOf(false)) : addr;
                        if (Lang.isEmpty((Object)addr) || !Lang.isEmpty((Object)(na = this.nationalAddressRepos.findByLinkId(addr.getId())))) {
                            // empty if block
                        }
                    }
                    return na;
                }
                NationalAddress na = this.nationalAddressRepos.findByLinkId(areaCode);
                if (na == null) {
                    Map areaCodeNoleList = this.addressCommonApi.areaCodeNodeList(areaCode);
                    String pCode = (String)areaCodeNoleList.get(AddressCommonApi.AddressLevel.AREA.getValue());
                    pCode = Lang.isEmpty((Object)pCode) ? (String)areaCodeNoleList.get(AddressCommonApi.AddressLevel.CITY.getValue()) : pCode;
                    String string = pCode = Lang.isEmpty((Object)pCode) ? (String)areaCodeNoleList.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()) : pCode;
                    if (Lang.isEmpty((Object)pCode)) {
                        return null;
                    }
                    return this.transAreaCode(pCode, AddressCommonApi.AddressLevel.AREA);
                }
                return na;
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5730\u5740\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        HashMap<Integer, String> trdAreaCodeMap = new HashMap<Integer, String>();
        NationalAddress na = this.transToNationAddress(areaMap.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()), areaMap.get(AddressCommonApi.AddressLevel.CITY.getValue()), areaMap.get(AddressCommonApi.AddressLevel.AREA.getValue()), areaMap.get(AddressCommonApi.AddressLevel.TOWN.getValue()));
        if (!Lang.isEmpty((Object)na)) {
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), na.getLeveloneAddress().toString());
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), na.getLeveltwoAddress().toString());
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), Lang.isEmpty((Object)na.getLevelthreeAddress()) ? "0" : na.getLevelthreeAddress().toString());
            trdAreaCodeMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), Lang.isEmpty((Object)na.getLevelfourAddress()) ? "0" : na.getLevelfourAddress().toString());
        }
        return trdAreaCodeMap;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        if (!Lang.isEmpty((Object)fashionPricesRequestVo.getCostPrice()) && !Lang.isEmpty((Object)fashionPricesRequestVo.getMarkePrice())) {
            if (fashionPricesRequestVo.getCostPrice().compareTo(new BigDecimal(0)) < 1) {
                return new BigDecimal(0);
            }
            return fashionPricesRequestVo.getCostPrice().divide(fashionPricesRequestVo.getMarkePrice(), 2, 1);
        }
        return new BigDecimal(1);
    }

    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        return null;
    }

    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        Long time = System.currentTimeMillis();
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            time = System.currentTimeMillis();
            OrderMainDto orderMain = this.orderMainApi.findOrderByThirdOrderNo(trdOrderNo);
            log.info("###########\u83b7\u53d6OrderMainDto############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            if (orderMain != null) {
                for (SubOrderDto subOrder : orderMain.getSubOrders()) {
                    String subOrderNo = subOrder.getSubOrderNo();
                    time = System.currentTimeMillis();
                    List subOrderItems = subOrder.getSubOrderItems();
                    log.info("###########\u83b7\u53d6OrderMainDto############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
                    ArrayList<String> goodsIds = new ArrayList<String>();
                    for (SubOrderItemDto subOrderItem : subOrderItems) {
                        if (Lang.isEmpty((Object)subOrderItem.getOrderItem())) continue;
                        goodsIds.add(subOrderItem.getOrderItem().getGoodsId());
                    }
                    time = System.currentTimeMillis();
                    List goodsPictures = this.goodsPictureRepos.findByShowIndexAndGoodsIdIn(Integer.valueOf(0), goodsIds);
                    log.info("###########\u83b7\u53d6goodsPictures############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
                    ArrayList<GoodsInfoVo> goodsInfos = new ArrayList<GoodsInfoVo>();
                    for (GoodsPicture picture : goodsPictures) {
                        GoodsInfoVo goodsInfo = new GoodsInfoVo();
                        goodsInfo.setGoodsId(picture.getGoods().getId());
                        goodsInfo.setGoodsName(picture.getGoods().getName());
                        goodsInfo.setGoodsPictrue(picture.getPicturePath());
                        goodsInfos.add(goodsInfo);
                    }
                    OrderShippingPackageVo orderShippingPackageVo = new OrderShippingPackageVo();
                    orderShippingPackageVo.setGoodsInfos(goodsInfos);
                    orderShippingPackageVo.setTrdSubOrderNo(subOrderNo);
                    orderShippingPackageVo.setPackageId(subOrderNo);
                    if (!Lang.isEmpty((Object)subOrder.getTrdSpState()) && Lang.equals((Object)subOrder.getTrdSpState(), (Object)"1")) {
                        orderShippingPackageVo.setReceiptsFlag(Boolean.valueOf(true));
                    } else {
                        orderShippingPackageVo.setReceiptsFlag(Boolean.valueOf(false));
                    }
                    ArrayList<OrderShippingTrackVo> trackInfoList = new ArrayList<OrderShippingTrackVo>();
                    JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
                    jdOrderIdEntity.setJdOrderId(Long.valueOf(Long.parseLong(subOrderNo)));
                    time = System.currentTimeMillis();
                    OrderTrackResp orderTrackResp = this.jdOrderApi.queryOrderTrack(jdOrderIdEntity);
                    log.info("###########\u8c03\u7528\u4eac\u4e1c\u7269\u6d41\u63a5\u53e3############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
                    OrdertrackResultVO result = orderTrackResp.getResult();
                    if (result != null) {
                        List ordertracks = result.getOrderTrack();
                        for (OrdertrackVO track : ordertracks) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(track.getContent());
                            orderShippingTrackVo.setMsgTime(track.getMsgTime());
                            orderShippingTrackVo.setOperator(track.getOperator());
                            trackInfoList.add(orderShippingTrackVo);
                        }
                    }
                    orderShippingPackageVo.setTrackInfoList(trackInfoList);
                    resultList.add(orderShippingPackageVo);
                }
            }
            handlerRespVo.setData(resultList);
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(Integer.valueOf(0));
        }
        return handlerRespVo;
    }

    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(Long.valueOf(Long.parseLong(trdOrderNo)));
            Map queryOrder = this.jdOrderApi.queryOrder(jdOrderIdEntity);
            if (queryOrder != null) {
                if ("1".equals(queryOrder.get("submitState").toString())) {
                    handlerRespVo.setData((Object)"2");
                } else if ("0".equals(queryOrder.get("orderState").toString())) {
                    handlerRespVo.setData((Object)"3");
                } else if ("1".equals(queryOrder.get("orderState").toString())) {
                    handlerRespVo.setData((Object)"1");
                }
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
                handlerRespVo.setErrorCode(Integer.valueOf(0));
                handlerRespVo.setData((Object)"0");
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(Integer.valueOf(0));
            handlerRespVo.setData((Object)"0");
        }
        return handlerRespVo;
    }

    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            OrderMainDto orderMain = this.orderMainApi.findOrderByThirdOrderNo(trdOrderNo);
            if (orderMain != null) {
                ArrayList<String> trdOrderNos = new ArrayList<String>();
                orderMain = this.orderMainApi.findById(orderMain.getId());
                for (SubOrderDto subOrder : orderMain.getSubOrders()) {
                    trdOrderNos.add(subOrder.getSubOrderNo());
                }
                for (String subOrderNo : trdOrderNos) {
                    OrderShippingPackageVo orderShippingPackageVo = new OrderShippingPackageVo();
                    orderShippingPackageVo.setPackageId(subOrderNo);
                    ArrayList<OrderShippingTrackVo> trackInfoList = new ArrayList<OrderShippingTrackVo>();
                    JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
                    jdOrderIdEntity.setJdOrderId(Long.valueOf(Long.parseLong(subOrderNo)));
                    OrderTrackResp orderTrackResp = this.jdOrderApi.queryOrderTrack(jdOrderIdEntity);
                    OrdertrackResultVO result = orderTrackResp.getResult();
                    if (result != null) {
                        List ordertracks = result.getOrderTrack();
                        for (OrdertrackVO track : ordertracks) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(track.getContent());
                            orderShippingTrackVo.setMsgTime(track.getMsgTime());
                            orderShippingTrackVo.setOperator(track.getOperator());
                            trackInfoList.add(orderShippingTrackVo);
                        }
                    }
                    orderShippingPackageVo.setTrackInfoList(trackInfoList);
                    resultList.add(orderShippingPackageVo);
                }
            }
            handlerRespVo.setData(resultList);
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(Integer.valueOf(0));
        }
        return handlerRespVo;
    }

    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo(null);
    }

    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo((Object)true);
    }

    public String getAreaString(Map addrMap) {
        StringBuilder sb = new StringBuilder();
        if (!Lang.isEmpty(addrMap.get("provinceId"))) {
            sb.append(addrMap.get("provinceId")).append("_");
            sb.append((Object)(Lang.isEmpty(addrMap.get("cityId")) ? "0" : addrMap.get("cityId"))).append("_");
            sb.append((Object)(Lang.isEmpty(addrMap.get("countyId")) ? "0" : addrMap.get("countyId"))).append("_");
            sb.append((Object)(Lang.isEmpty(addrMap.get("townId")) ? "0" : addrMap.get("townId")));
        } else {
            sb.append("0_0_0_0");
        }
        return sb.toString();
    }

    private Object findObjectInList(Object[] list, Object key, Object value) {
        String getterMethodName = "";
        for (Object v : list) {
            for (Field f : v.getClass().getDeclaredFields()) {
                if (!f.getName().equals(key)) continue;
                try {
                    StringBuilder sb = new StringBuilder(f.getName());
                    sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
                    sb.insert(0, "get");
                    getterMethodName = sb.toString();
                    if (!value.equals(v.getClass().getDeclaredMethod(getterMethodName, new Class[0]).invoke(v, new Object[0]))) continue;
                    return v;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    private Map<String, Object> findInMappedList(List<Map<String, Object>> list, String key, Object value) {
        Object valInList = null;
        for (Map<String, Object> m : list) {
            valInList = m.get(key);
            if (valInList == null || !value.equals(valInList)) continue;
            return m;
        }
        return null;
    }

    private NationalAddress transToNationAddress(String provinceCode, String cityCode, String countyCode, String areaCode) {
        NationalAddress na = null;
        if (!Lang.isEmpty((Object)areaCode)) {
            na = (NationalAddress)this.transAreaCode(areaCode, AddressCommonApi.AddressLevel.TOWN);
        }
        if (Lang.isEmpty(na) && !Lang.isEmpty((Object)countyCode)) {
            na = (NationalAddress)this.transAreaCode(countyCode, AddressCommonApi.AddressLevel.AREA);
        }
        if (Lang.isEmpty(na) && !Lang.isEmpty((Object)cityCode)) {
            na = (NationalAddress)this.transAreaCode(cityCode, AddressCommonApi.AddressLevel.CITY);
        }
        if (Lang.isEmpty((Object)na) && !Lang.isEmpty((Object)provinceCode)) {
            na = (NationalAddress)this.transAreaCode(provinceCode, AddressCommonApi.AddressLevel.PROVINCE);
        }
        return na;
    }

    private void checkOrderWanner() throws SupplierTakeOrderFalidException {
        String jdOrderWarnStr = this.systemConfigApi.getConfigValue("COMMON", "JDORDERCONFIGWARN", "JDORDERCONSTANTWARN", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)jdOrderWarnStr) && !TrdOrderHandlerUtils.checkOrderWannerConfigJson((String)jdOrderWarnStr).booleanValue()) {
            throw new SupplierTakeOrderFalidException("\u4e0b\u5355\u62e6\u622a\u5df2\u914d\u7f6e", SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
        }
    }

    private void gennerJdOrderConstant(OrderEntity orderEntity) {
        String jdOrderConstantStr = this.systemConfigApi.getConfigValue("COMMON", "JDORDERCONFIG", "JDORDERCONSTANT", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)jdOrderConstantStr)) {
            try {
                JSONObject obj = JSON.parseObject((String)jdOrderConstantStr);
                Integer invoiceState = (Integer)obj.get((Object)"invoiceState");
                Integer invoiceType = (Integer)obj.get((Object)"invoiceType");
                Integer selectedInvoiceTitle = (Integer)obj.get((Object)"selectedInvoiceTitle");
                String invoiceName = (String)obj.get((Object)"invoiceName");
                Integer invoiceContent = (Integer)obj.get((Object)"invoiceContent");
                Integer paymentType = (Integer)obj.get((Object)"paymentType");
                Integer isUseBalance = (Integer)obj.get((Object)"isUseBalance");
                Integer submitState = (Integer)obj.get((Object)"submitState");
                Integer doOrderPriceMode = (Integer)obj.get((Object)"doOrderPriceMode");
                String email = (String)obj.get((Object)"email");
                orderEntity.setEmail(email);
                orderEntity.setInvoiceState(invoiceState);
                orderEntity.setInvoiceType(invoiceType);
                orderEntity.setSelectedInvoiceTitle(selectedInvoiceTitle);
                orderEntity.setInvoiceName(invoiceName);
                orderEntity.setInvoiceContent(invoiceContent);
                orderEntity.setPaymentType(paymentType);
                orderEntity.setIsUseBalance(isUseBalance);
                orderEntity.setSubmitState(submitState);
                orderEntity.setDoOrderPriceMode(doOrderPriceMode);
            }
            catch (Exception e) {
                log.info("\u6570\u636e\u5e93\u4fdd\u5b58\u7684\u53c2\u6570\u4fe1\u606f\u662f\u9519\u8bef\u7684\uff0c\u8bf7\u4fee\u6539");
                e.printStackTrace();
            }
        } else {
            this.defaultGennerJdOrderConstant(orderEntity);
        }
    }

    private void defaultGennerJdOrderConstant(OrderEntity orderEntity) {
        orderEntity.setEmail("jd@ec.cntaiping.com");
        orderEntity.setInvoiceState(JdOrderConstant.invoiceState);
        orderEntity.setInvoiceType(JdOrderConstant.invoiceType);
        orderEntity.setSelectedInvoiceTitle(JdOrderConstant.selectedInvoiceTitle);
        orderEntity.setInvoiceName("\u592a\u5e73\u91d1\u878d\u670d\u52a1\u6709\u9650\u516c\u53f8");
        orderEntity.setInvoiceContent(JdOrderConstant.invoiceContent);
        orderEntity.setPaymentType(JdOrderConstant.paymentType);
        orderEntity.setIsUseBalance(JdOrderConstant.isUseBalance);
        orderEntity.setSubmitState(JdOrderConstant.submitState);
        orderEntity.setDoOrderPriceMode(JdOrderConstant.doOrderPriceMode);
    }

    List<SkuIdAndNumEntity> cpySkuList(List<OrderItemVo> orderItems) {
        ArrayList<SkuIdAndNumEntity> retSku = new ArrayList<SkuIdAndNumEntity>();
        for (OrderItemVo orderItem : orderItems) {
            Long skuId = Long.parseLong(orderItem.getSku());
            Integer num = orderItem.getCount();
            retSku.add(new SkuIdAndNumEntity(skuId, num));
        }
        return retSku;
    }

    String generateOrderPriceSnap(OrderRequst orderMain) {
        ArrayList<OrderPriceSnap> snaps = new ArrayList<OrderPriceSnap>();
        List orderItems = orderMain.getOrderItems();
        for (OrderItemVo orderItem : orderItems) {
            Long skuId = Long.parseLong(orderItem.getSku());
            snaps.add(new OrderPriceSnap(orderItem.getCostPrice(), skuId));
        }
        return JSON.toJSONString(snaps);
    }
}

