/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import cart.api.dto.order.SubOrderItemDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.model.GoodsPicture;
import goods.model.repository.GoodsPictureRepos;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.api.request.order.JdOrderIdEntity;
import jd.api.request.order.OrderEntity;
import jd.api.request.order.ThirdOrder;
import jd.api.request.product.SkuIdAndNumEntity;
import jd.api.response.order.OccupyStockResp;
import jd.api.response.order.OrderRevResp;
import jd.api.response.order.OrderTrackResp;
import jd.api.response.order.OrderUniteSubmitResp;
import jd.api.vo.order.OrdertrackResultVO;
import jd.api.vo.order.OrdertrackVO;
import jd.api.vo.order.ParentOrderRepVO;
import jd.model.repository.NationalAddressRepos;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.SupplierOrderApiHandler;
import outsideapi.service.service.stub.AddressCommonApiStub;
import outsideapi.service.service.stub.JdOrderApiStub;
import outsideapi.service.service.stub.JdProductApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.service.utils.JdOrderUtil;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.GoodsInfoVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.OrderShippingTrackVo;
import outsideapi.vo.jdorder.Corder;
import outsideapi.vo.jdorder.JdOrder;
import outsideapi.vo.jdorder.JdOrderConstant;
import outsideapi.vo.jdorder.OrderPriceSnap;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderRequst;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;
import sysmg.api.SystemConfigApi;
import utils.Lang;

@Component
@Transactional(readOnly=true)
public class JdSupplierOrderApiHandler
implements SupplierOrderApiHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(JdSupplierOrderApiHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    JdProductApiStub jdProductApi;
    @Autowired
    JdOrderApiStub jdOrderApi;
    @Autowired
    OrderMainApiStub orderMainApi;
    @Autowired
    NationalAddressRepos nationalAddressRepos;
    @Autowired
    AddressCommonApiStub addressCommonApi;
    @Autowired
    GoodsPictureRepos goodsPictureRepos;
    @Autowired
    OutsideProductApi outsideProductApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;

    public Boolean cancelOrder(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException, OrderCancelException {
        OrderCancelOrderResp jdResp;
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (Lang.isEmpty((Object)trdOrderKey.getTrdOrderNo())) {
            throw new OrderCancelException(OrderCancelException.ERROR_CODES.TRD_ORDER_NOTFOUND);
        }
        try {
            jdResp = this.jdOrderApi.cancelOrder(new JdOrderIdEntity(Long.valueOf(Long.parseLong(trdOrderKey.getTrdOrderNo()))));
        }
        catch (NumberFormatException nfe) {
            throw new OrderCancelException(OrderCancelException.ERROR_CODES.ILLEGAL_TRD_ORDERNO);
        }
        catch (Exception e) {
            throw new SupplierInterfaceInvokeException(e.getMessage(), SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD, (Throwable)e);
        }
        if (jdResp.getResult().booleanValue()) {
            return true;
        }
        returnMap.put("status", "error");
        String errorCode = "0";
        if ("3204".equals(jdResp.getResultCode()) || "3208".equals(jdResp.getResultCode()) || "3211".equals(jdResp.getResultCode())) {
            throw new OrderCancelException(OrderCancelException.ERROR_CODES.TRD_ORDER_COMFIRMED);
        }
        if ("3212".equals(jdResp.getResultCode())) {
            throw new OrderCancelException(jdResp.getResultCode() + ": " + jdResp.getResultMessage(), OrderCancelException.ERROR_CODES.API_ERROR);
        }
        throw new OrderCancelException(jdResp.getResultCode() + ": " + jdResp.getResultMessage(), OrderCancelException.ERROR_CODES.API_ERROR);
    }

    public List<OrderShippingPackageVo> getShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        Long time = System.currentTimeMillis();
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            time = System.currentTimeMillis();
            OrderMainDto orderMain = this.orderMainApi.findOrderByThirdOrderNo(trdOrderNo);
            log.info("###########\u83b7\u53d6OrderMainDto############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            if (orderMain != null) {
                for (SubOrderDto subOrder : orderMain.getSubOrders()) {
                    String subOrderNo = subOrder.getSubOrderNo();
                    time = System.currentTimeMillis();
                    List subOrderItems = subOrder.getSubOrderItems();
                    log.info("###########\u83b7\u53d6OrderMainDto############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
                    ArrayList<String> goodsIds = new ArrayList<String>();
                    for (SubOrderItemDto subOrderItem : subOrderItems) {
                        if (Lang.isEmpty((Object)subOrderItem.getOrderItem())) continue;
                        goodsIds.add(subOrderItem.getOrderItem().getGoodsId());
                    }
                    time = System.currentTimeMillis();
                    List goodsPictures = this.goodsPictureRepos.findByShowIndexAndGoodsIdIn(Integer.valueOf(0), goodsIds);
                    log.info("###########\u83b7\u53d6goodsPictures############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
                    ArrayList<GoodsInfoVo> goodsInfos = new ArrayList<GoodsInfoVo>();
                    for (GoodsPicture picture : goodsPictures) {
                        GoodsInfoVo goodsInfo = new GoodsInfoVo();
                        goodsInfo.setGoodsId(picture.getGoods().getId());
                        goodsInfo.setGoodsName(picture.getGoods().getName());
                        goodsInfo.setGoodsPictrue(picture.getPicturePath());
                        goodsInfos.add(goodsInfo);
                    }
                    OrderShippingPackageVo orderShippingPackageVo = new OrderShippingPackageVo();
                    orderShippingPackageVo.setGoodsInfos(goodsInfos);
                    orderShippingPackageVo.setTrdSubOrderNo(subOrderNo);
                    orderShippingPackageVo.setPackageId(subOrderNo);
                    if (!Lang.isEmpty((Object)subOrder.getTrdSpState()) && Lang.equals((Object)subOrder.getTrdSpState(), (Object)"1")) {
                        orderShippingPackageVo.setReceiptsFlag(Boolean.valueOf(true));
                    } else {
                        orderShippingPackageVo.setReceiptsFlag(Boolean.valueOf(false));
                    }
                    ArrayList<OrderShippingTrackVo> trackInfoList = new ArrayList<OrderShippingTrackVo>();
                    JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
                    jdOrderIdEntity.setJdOrderId(Long.valueOf(Long.parseLong(subOrderNo)));
                    time = System.currentTimeMillis();
                    OrderTrackResp orderTrackResp = this.jdOrderApi.queryOrderTrack(jdOrderIdEntity);
                    log.info("###########\u8c03\u7528\u4eac\u4e1c\u7269\u6d41\u63a5\u53e3############\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
                    OrdertrackResultVO result = orderTrackResp.getResult();
                    if (result != null) {
                        List ordertracks = result.getOrderTrack();
                        for (OrdertrackVO track : ordertracks) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(track.getContent());
                            orderShippingTrackVo.setMsgTime(track.getMsgTime());
                            orderShippingTrackVo.setOperator(track.getOperator());
                            trackInfoList.add(orderShippingTrackVo);
                        }
                    }
                    orderShippingPackageVo.setTrackInfoList(trackInfoList);
                    resultList.add(orderShippingPackageVo);
                }
            }
            return resultList;
        }
        throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOrderStatus(String trdOrderNo) throws SupplierInterfaceInvokeException {
        String status = null;
        if (Lang.isEmpty((Object)trdOrderNo)) throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
        JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
        jdOrderIdEntity.setJdOrderId(Long.valueOf(Long.parseLong(trdOrderNo)));
        Map queryOrder = this.jdOrderApi.queryOrder(jdOrderIdEntity);
        if (queryOrder == null) throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
        if ("1".equals(queryOrder.get("submitState").toString())) {
            return "2";
        }
        if ("0".equals(queryOrder.get("orderState").toString())) {
            return "3";
        }
        if (!"1".equals(queryOrder.get("orderState").toString())) return status;
        return "1";
    }

    public List<OrderShippingPackageVo> getCTShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            OrderMainDto orderMain = this.orderMainApi.findOrderByThirdOrderNo(trdOrderNo);
            if (orderMain != null) {
                ArrayList<String> trdOrderNos = new ArrayList<String>();
                orderMain = this.orderMainApi.findById(orderMain.getId());
                for (SubOrderDto subOrder : orderMain.getSubOrders()) {
                    trdOrderNos.add(subOrder.getSubOrderNo());
                }
                for (String subOrderNo : trdOrderNos) {
                    OrderShippingPackageVo orderShippingPackageVo = new OrderShippingPackageVo();
                    orderShippingPackageVo.setPackageId(subOrderNo);
                    ArrayList<OrderShippingTrackVo> trackInfoList = new ArrayList<OrderShippingTrackVo>();
                    JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
                    jdOrderIdEntity.setJdOrderId(Long.valueOf(Long.parseLong(subOrderNo)));
                    OrderTrackResp orderTrackResp = this.jdOrderApi.queryOrderTrack(jdOrderIdEntity);
                    OrdertrackResultVO result = orderTrackResp.getResult();
                    if (result != null) {
                        List ordertracks = result.getOrderTrack();
                        for (OrdertrackVO track : ordertracks) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(track.getContent());
                            orderShippingTrackVo.setMsgTime(track.getMsgTime());
                            orderShippingTrackVo.setOperator(track.getOperator());
                            trackInfoList.add(orderShippingTrackVo);
                        }
                    }
                    orderShippingPackageVo.setTrackInfoList(trackInfoList);
                    resultList.add(orderShippingPackageVo);
                }
            }
            return resultList;
        }
        throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
    }

    public String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        ThirdOrder thirdOrder = new ThirdOrder();
        thirdOrder.setThirdOrder(trdOrderKey.getTrdOrderNo());
        try {
            OrderRevResp orderRevResp = this.jdOrderApi.queryOrderByThirdOrder(thirdOrder);
            return orderRevResp.getResult();
        }
        catch (Exception e) {
            throw new SupplierInterfaceInvokeException(e.getMessage(), SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD, (Throwable)e);
        }
    }

    public TrdOrder takeOrder(OrderRequst orderRequst) throws SupplierInterfaceInvokeException, SupplierTakeOrderFalidException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        this.checkOrderWanner();
        try {
            OrderEntity orderEntity = new OrderEntity();
            MemberAddressDto memberAddress = this.memberAddressApi.findById(orderRequst.getOrderReceiver().getId());
            orderEntity.setThirdOrder(orderRequst.getOrderNo());
            orderEntity.setSku(this.cpySkuList(orderRequst.getOrderItems()));
            orderEntity.setName(memberAddress.getUsername());
            HashMap<Integer, String> comAddrMap = new HashMap<Integer, String>();
            comAddrMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), memberAddress.getProvinceCode());
            comAddrMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), memberAddress.getCityCode());
            comAddrMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), memberAddress.getAreaCode());
            comAddrMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), memberAddress.getTownCode());
            Long addrTime = System.currentTimeMillis();
            HandlerRespVo jdAddrResp = this.outsideProductApi.transAreaCodeMap(orderRequst.getStoreCode(), comAddrMap);
            log.info("##\u8f6c\u6362\u4e3a\u4eac\u4e1c\u5730\u5740##\uff1a{}ms", (Object)(System.currentTimeMillis() - addrTime));
            if (jdAddrResp.getStatus() != HandlerRespVo.RESPONSE_STATUS_SUCCESS) {
                throw new SupplierTakeOrderFalidException(SupplierTakeOrderFalidException.ERROR_CODES.ADDRESS_TRANS_ERROR);
            }
            Map jdAddrMap = (Map)jdAddrResp.getData();
            try {
                orderEntity.setProvince(Integer.valueOf(Integer.parseInt((String)jdAddrMap.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()))));
                orderEntity.setCity(Integer.valueOf(Integer.parseInt((String)jdAddrMap.get(AddressCommonApi.AddressLevel.CITY.getValue()))));
                String countyCode = (String)jdAddrMap.get(AddressCommonApi.AddressLevel.AREA.getValue());
                if (!Lang.isEmpty((Object)countyCode)) {
                    orderEntity.setCounty(Integer.valueOf(Integer.parseInt(countyCode)));
                } else {
                    orderEntity.setCounty(Integer.valueOf(0));
                }
                String townCode = (String)jdAddrMap.get(AddressCommonApi.AddressLevel.TOWN.getValue());
                if (!Lang.isEmpty((Object)townCode)) {
                    orderEntity.setTown(Integer.valueOf(Integer.parseInt(townCode)));
                } else {
                    orderEntity.setTown(Integer.valueOf(0));
                }
                orderEntity.setAddress(memberAddress.getAddressDetail());
                orderEntity.setMobile(memberAddress.getPhone());
            }
            catch (Exception ex) {
                throw new SupplierTakeOrderFalidException(SupplierTakeOrderFalidException.ERROR_CODES.ADDRESS_TRANS_ERROR, (Throwable)ex);
            }
            this.gennerJdOrderConstant(orderEntity);
            orderEntity.setOrderPriceSnap(this.generateOrderPriceSnap(orderRequst));
            String orderNo = orderRequst.getOrderNo();
            Long stockTime = System.currentTimeMillis();
            String takeOrderFlag = this.systemConfigApi.getConfigValue("COMMON", "JD_ORDER_CONFIG", "TAKE_ORDER_FLAG", Boolean.valueOf(true), Boolean.valueOf(true));
            OrderUniteSubmitResp orderUniteSubmitResp = null;
            Boolean isTakeOrderFlag = true;
            if (!Lang.isEmpty((Object)takeOrderFlag) && takeOrderFlag.equals("0")) {
                orderUniteSubmitResp = new OrderUniteSubmitResp();
                orderUniteSubmitResp.setSuccess(Boolean.valueOf(true));
                orderUniteSubmitResp.setResultMessage("SUCCESS");
                ParentOrderRepVO reselt = new ParentOrderRepVO();
                reselt.setFreight(BigDecimal.ZERO);
                reselt.setJdOrderId(Long.valueOf((long)(Math.random() * 1000.0 + (double)System.currentTimeMillis())));
                reselt.setOrderPrice(orderRequst.getSumNofreightPrice());
                orderUniteSubmitResp.setResult(reselt);
                isTakeOrderFlag = false;
            } else {
                orderUniteSubmitResp = this.jdOrderApi.placeOrder(orderEntity);
            }
            log.info("##\u9884\u5360\u5e93\u5b58##\uff1a{}ms", (Object)(System.currentTimeMillis() - stockTime));
            if (!orderUniteSubmitResp.getSuccess().booleanValue() || Lang.isEmpty((Object)orderUniteSubmitResp.getResult())) {
                ArrayList<String> skuIds = new ArrayList<String>();
                List sku = orderEntity.getSku();
                for (SkuIdAndNumEntity skuIdAndNumEntity : sku) {
                    skuIds.add(skuIdAndNumEntity.getId().toString());
                }
                if ("3019".equals(orderUniteSubmitResp.getResultCode())) {
                    throw new SupplierTakeOrderFalidException(SupplierTakeOrderFalidException.ERROR_CODES.CREATE_ORDER_COST_CHANGED);
                }
                throw new SupplierTakeOrderFalidException(orderUniteSubmitResp.getResultMessage(), SupplierTakeOrderFalidException.ERROR_CODES.UNKNOWN);
            }
            TrdOrderKey trdOrderKey = new TrdOrderKey(orderUniteSubmitResp.getResult().getJdOrderId().toString(), orderRequst.getStoreCode());
            if (isTakeOrderFlag.booleanValue()) {
                return this.getDetail(trdOrderKey);
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u4e0b\u5355\u62a5\u9519[\u8ba2\u5355\u53f7\uff1a{}\uff0c\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7\uff1a{}]", new Object[]{orderRequst == null ? null : orderRequst.getOrderNo(), orderRequst == null ? null : orderRequst.getThirdOrderNo(), e});
            returnMap.put("returnCode", "99");
            returnMap.put("returnMsg", e.getMessage());
            throw new SupplierTakeOrderFalidException(e.getMessage(), SupplierTakeOrderFalidException.ERROR_CODES.UNKNOWN, (Throwable)e);
        }
    }

    public void confirmOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        HashMap returnMap = new HashMap();
        try {
            OccupyStockResp occupyStockResp = this.jdOrderApi.confirmOccupyStock(new JdOrderIdEntity(Long.valueOf(Long.parseLong(orderMain.getThirdOrderNo()))));
            if (!occupyStockResp.getSuccess().booleanValue()) {
                throw new SupplierOrderComfirmFalidException(occupyStockResp.getResultMessage(), SupplierOrderComfirmFalidException.ERROR_CODES.SUPPLIER_COMFIRMED_ERROR);
            }
        }
        catch (Exception e) {
            throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD, (Throwable)e);
        }
    }

    public BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException {
        return null;
    }

    public TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        long start = System.currentTimeMillis();
        log.info("start splitOrder...");
        Map queryOrder = this.jdOrderApi.queryOrder(new JdOrderIdEntity(Long.valueOf(Long.parseLong(trdOrderKey.getTrdOrderNo()))));
        TrdOrder trdOrder = null;
        if (queryOrder != null) {
            if (queryOrder.get("type").equals(2)) {
                queryOrder.put("pOrder", null);
                String jsonString = JSON.toJSONString((Object)queryOrder, (boolean)true);
                Corder corder = (Corder)JSON.parseObject((String)jsonString, Corder.class);
                trdOrder = JdOrderUtil.createTrdOrderByCorder((Corder)corder);
            } else {
                String jsonString = JSON.toJSONString((Object)queryOrder, (boolean)true);
                JdOrder jdOrder = (JdOrder)JSON.parseObject((String)jsonString, JdOrder.class);
                trdOrder = JdOrderUtil.createTrdOrderByJdOrder((JdOrder)jdOrder);
            }
        }
        log.info("splitOrder end... cost {} ms", (Object)(System.currentTimeMillis() - start));
        trdOrder.setFinalStatus(TrdOrderHandlerUtils.judteStatus(trdOrder));
        return trdOrder;
    }

    private void checkOrderWanner() throws SupplierTakeOrderFalidException {
        String jdOrderWarnStr = this.systemConfigApi.getConfigValue("COMMON", "JDORDERCONFIGWARN", "JDORDERCONSTANTWARN", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)jdOrderWarnStr) && !TrdOrderHandlerUtils.checkOrderWannerConfigJson((String)jdOrderWarnStr).booleanValue()) {
            throw new SupplierTakeOrderFalidException("\u4e0b\u5355\u62e6\u622a\u5df2\u914d\u7f6e", SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
        }
    }

    private void gennerJdOrderConstant(OrderEntity orderEntity) {
        String jdOrderConstantStr = this.systemConfigApi.getConfigValue("COMMON", "JDORDERCONFIG", "JDORDERCONSTANT", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)jdOrderConstantStr)) {
            try {
                JSONObject obj = JSON.parseObject((String)jdOrderConstantStr);
                Integer invoiceState = (Integer)obj.get((Object)"invoiceState");
                Integer invoiceType = (Integer)obj.get((Object)"invoiceType");
                Integer selectedInvoiceTitle = (Integer)obj.get((Object)"selectedInvoiceTitle");
                String invoiceName = (String)obj.get((Object)"invoiceName");
                Integer invoiceContent = (Integer)obj.get((Object)"invoiceContent");
                Integer paymentType = (Integer)obj.get((Object)"paymentType");
                Integer isUseBalance = (Integer)obj.get((Object)"isUseBalance");
                Integer submitState = (Integer)obj.get((Object)"submitState");
                Integer doOrderPriceMode = (Integer)obj.get((Object)"doOrderPriceMode");
                String email = (String)obj.get((Object)"email");
                orderEntity.setEmail(email);
                orderEntity.setInvoiceState(invoiceState);
                orderEntity.setInvoiceType(invoiceType);
                orderEntity.setSelectedInvoiceTitle(selectedInvoiceTitle);
                orderEntity.setInvoiceName(invoiceName);
                orderEntity.setInvoiceContent(invoiceContent);
                orderEntity.setPaymentType(paymentType);
                orderEntity.setIsUseBalance(isUseBalance);
                orderEntity.setSubmitState(submitState);
                orderEntity.setDoOrderPriceMode(doOrderPriceMode);
            }
            catch (Exception e) {
                log.info("\u6570\u636e\u5e93\u4fdd\u5b58\u7684\u53c2\u6570\u4fe1\u606f\u662f\u9519\u8bef\u7684\uff0c\u8bf7\u4fee\u6539");
                e.printStackTrace();
            }
        } else {
            this.defaultGennerJdOrderConstant(orderEntity);
        }
    }

    private void defaultGennerJdOrderConstant(OrderEntity orderEntity) {
        orderEntity.setEmail("jd@ec.cntaiping.com");
        orderEntity.setInvoiceState(JdOrderConstant.invoiceState);
        orderEntity.setInvoiceType(JdOrderConstant.invoiceType);
        orderEntity.setSelectedInvoiceTitle(JdOrderConstant.selectedInvoiceTitle);
        orderEntity.setInvoiceName("\u592a\u5e73\u91d1\u878d\u670d\u52a1\u6709\u9650\u516c\u53f8");
        orderEntity.setInvoiceContent(JdOrderConstant.invoiceContent);
        orderEntity.setPaymentType(JdOrderConstant.paymentType);
        orderEntity.setIsUseBalance(JdOrderConstant.isUseBalance);
        orderEntity.setSubmitState(JdOrderConstant.submitState);
        orderEntity.setDoOrderPriceMode(JdOrderConstant.doOrderPriceMode);
    }

    List<SkuIdAndNumEntity> cpySkuList(List<OrderItemVo> orderItems) {
        ArrayList<SkuIdAndNumEntity> retSku = new ArrayList<SkuIdAndNumEntity>();
        for (OrderItemVo orderItem : orderItems) {
            Long skuId = Long.parseLong(orderItem.getSku());
            Integer num = orderItem.getCount();
            retSku.add(new SkuIdAndNumEntity(skuId, num));
        }
        return retSku;
    }

    String generateOrderPriceSnap(OrderRequst orderMain) {
        ArrayList<OrderPriceSnap> snaps = new ArrayList<OrderPriceSnap>();
        List orderItems = orderMain.getOrderItems();
        for (OrderItemVo orderItem : orderItems) {
            Long skuId = Long.parseLong(orderItem.getSku());
            snaps.add(new OrderPriceSnap(orderItem.getCostPrice(), skuId));
        }
        return JSON.toJSONString(snaps);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

