/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import localstore.api.LocalStoreApi;
import localstore.api.LocalStoreProductApi;
import member.api.AddressCommonApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.vo.FacProductConfirmRequestVo;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.FashionPricesRequestVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.OrderShippingTrackVo;
import outsideapi.vo.ReserveOrderIdVo;
import outsideapi.vo.ReserveOrderVo;
import outsideapi.vo.ReserveVo;
import outsideapi.vo.ShipTimeResVo;
import outsideapi.vo.ShippLogistRequestVo;
import outsideapi.vo.ShippLogistResVo;
import outsideapi.vo.ShippingFeeRequetVo;
import outsideapi.vo.order.OrderMainDto;
import pool.vo.ProviderGoodsVo;
import shipping.api.LogisticFollowApi;
import shipping.api.LogisticsQueryApi;
import shipping.api.definition.LogisticStatus;
import shipping.api.dto.LogisticFollowDto;
import shipping.api.showapi.LogisticsFollowOutApi;
import shipping.api.vo.showapi.LogisticsFollowVo;
import sinomall.global.common.response.BaseResponse;
import store.api.dto.mapdto.MallShippingDto;
import utils.Lang;

@Component(value="localStoreHandler")
@Transactional(readOnly=true)
public class LocalStoreApiHandler
implements OutsideApiHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LocalStoreApiHandler.class);
    private static Logger logger = LoggerFactory.getLogger(LocalStoreApiHandler.class);
    @MotanReferer
    LocalStoreProductApi localStoreProductApi;
    @MotanReferer
    LocalStoreApi localStoreApi;
    @MotanReferer
    LogisticsQueryApi logisticsQueryApi;
    @MotanReferer
    LogisticsFollowOutApi logisticsFollowOutApi;
    @MotanReferer
    LogisticFollowApi logisticFollowApi;
    private ApplicationContext applicationContext;

    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        System.out.println("LocalStoreApiHandler.queryFashionStockState invoked...");
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        ArrayList<FashionStockStateVo> fashionStockStateVos = new ArrayList<FashionStockStateVo>();
        List skus = requet.getFashionNums().stream().filter(f -> !Lang.isEmpty((Object)f.getProductCode())).map(i -> i.getProductCode()).collect(Collectors.toList());
        Map<String, String> map = requet.getFashionNums().stream().collect(Collectors.toMap(FashionNumsVo::getProductCode, FashionNumsVo::getFactionId));
        if (Lang.isEmpty((Object)requet.getStoreId())) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1astoreId\u4e3a\u7a7a");
            handlerRespVo.setErrorCode(Integer.valueOf(3));
            return handlerRespVo;
        }
        if (Lang.isEmpty(skus)) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1asku\u4e3a\u7a7a");
            handlerRespVo.setErrorCode(Integer.valueOf(3));
            return handlerRespVo;
        }
        BaseResponse baseResponse = this.localStoreProductApi.queryFashionStockState(skus, requet.getStoreId());
        List providerGoodsVoList = (List)baseResponse.getResult();
        for (int i2 = 0; i2 < providerGoodsVoList.size(); ++i2) {
            FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
            if (((ProviderGoodsVo)providerGoodsVoList.get(i2)).getStatus().equals(Character.valueOf('0'))) {
                fashionStockStateVo.setOnSale(Boolean.valueOf(false));
            }
            if (((ProviderGoodsVo)providerGoodsVoList.get(i2)).getStatus().equals(Character.valueOf('1'))) {
                fashionStockStateVo.setOnSale(Boolean.valueOf(true));
            }
            if (((ProviderGoodsVo)providerGoodsVoList.get(i2)).getStockCount() > 0) {
                fashionStockStateVo.setStockFlag(Integer.valueOf(1));
            }
            if (((ProviderGoodsVo)providerGoodsVoList.get(i2)).getStockCount() <= 0) {
                fashionStockStateVo.setStockFlag(Integer.valueOf(0));
            }
            fashionStockStateVo.setFashionId(map.get(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getSku()));
            fashionStockStateVo.setProductCode(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getSku());
            fashionStockStateVo.setStockCount(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getStockCount());
            fashionStockStateVo.setIsAreaRestrict(Boolean.valueOf(false));
            fashionStockStateVo.setOnSale(Boolean.valueOf(true));
            fashionStockStateVos.add(fashionStockStateVo);
        }
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff1aqueryGoodsShelves\u63a5\u53e3\u8c03\u7528\u6210\u529f");
        handlerRespVo.setData(fashionStockStateVos);
        return handlerRespVo;
    }

    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        System.out.println("LocalStoreApiHandler.queryFashionPrice invoked...");
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        ArrayList<FashionPriceVo> fashionPriceVos = new ArrayList<FashionPriceVo>();
        FashionPriceVo fashionPriceVo = new FashionPriceVo();
        List skus = requet.getFashionPriceParamVos().stream().filter(f -> !Lang.isEmpty((Object)f.getProductCode())).map(i -> i.getProductCode()).collect(Collectors.toList());
        Map<String, String> map = requet.getFashionPriceParamVos().stream().collect(Collectors.toMap(FashionPriceParamVo::getProductCode, FashionPriceParamVo::getFactionId));
        if (Lang.isEmpty((Object)requet.getStoreId())) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1astoreId\u4e3a\u7a7a");
            handlerRespVo.setErrorCode(Integer.valueOf(3));
            return handlerRespVo;
        }
        if (Lang.isEmpty(skus)) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1asku\u4e3a\u7a7a");
            handlerRespVo.setErrorCode(Integer.valueOf(3));
            return handlerRespVo;
        }
        BaseResponse baseResponse = this.localStoreProductApi.queryFashionStockState(skus, requet.getStoreId());
        List providerGoodsVoList = (List)baseResponse.getResult();
        for (int i2 = 0; i2 < providerGoodsVoList.size(); ++i2) {
            fashionPriceVo.setFashionId(map.get(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getSku()));
            fashionPriceVo.setProductCode(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getSku());
            fashionPriceVo.setCostPrice(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getCostPrice());
            fashionPriceVo.setSalePrice(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getSalePrice());
            fashionPriceVo.setMarketPrice(((ProviderGoodsVo)providerGoodsVoList.get(i2)).getMarketPrice());
            fashionPriceVos.add(fashionPriceVo);
        }
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff1aqueryGoodsShelves\u63a5\u53e3\u8c03\u7528\u6210\u529f");
        handlerRespVo.setData(fashionPriceVos);
        return handlerRespVo;
    }

    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        HashMap<String, BigDecimal> d = new HashMap<String, BigDecimal>();
        d.put("freight", BigDecimal.ZERO);
        d.put("baseFreight", BigDecimal.ZERO);
        d.put("remoteRegionFreight", BigDecimal.ZERO);
        handlerRespVo.setData(d);
        return handlerRespVo;
    }

    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return areaCode;
    }

    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        return areaMap;
    }

    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        return BigDecimal.ONE;
    }

    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        return null;
    }

    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String thirdOrderNo) {
        ArrayList<LogisticFollowDto> saveLocalLogistics = new ArrayList<LogisticFollowDto>();
        BaseResponse orderLogisticsResponse = this.localStoreProductApi.findOrderLogistics(thirdOrderNo);
        if (!Lang.isEmpty((Object)orderLogisticsResponse.getResult())) {
            List mallShippingDtos = (List)orderLogisticsResponse.getResult();
            ArrayList<OrderShippingPackageVo> orderShippingPackageVos = new ArrayList<OrderShippingPackageVo>(mallShippingDtos.size());
            OrderShippingPackageVo orderShippingPackageVo = null;
            try {
                JSONArray logisticInfos = null;
                ArrayList orderShippingPackages = null;
                for (MallShippingDto mallShipping : mallShippingDtos) {
                    orderShippingPackageVo = new OrderShippingPackageVo();
                    LogisticFollowDto logisticFollowDto = this.logisticsQueryApi.findByLogisticNo(mallShipping.getShippingNo());
                    if (!Lang.isEmpty((Object)logisticFollowDto) && LogisticStatus.finallyStatus.contains(logisticFollowDto.getLogisticStatus()) && !Lang.isEmpty((Object)logisticFollowDto.getLogisticData())) {
                        logisticInfos = JSONArray.parseArray((String)logisticFollowDto.getLogisticData());
                        orderShippingPackages = new ArrayList(logisticInfos.size());
                        this.buildOrderShippingTrack(logisticInfos, orderShippingPackages, logisticFollowDto, orderShippingPackageVo, mallShipping);
                    } else {
                        LogisticsFollowVo logisticsFollowVo = this.logisticsFollowOutApi.findLogisticsInfo(mallShipping.getShippingCode(), mallShipping.getShippingNo());
                        if (!Lang.isEmpty((Object)logisticsFollowVo)) {
                            LogisticFollowDto logisticFollow = new LogisticFollowDto();
                            logisticFollow.setLogisticStatus(logisticsFollowVo.getStatus());
                            logisticFollow.setLogisticData(logisticsFollowVo.getData());
                            logisticFollow.setLogisticCompany(logisticsFollowVo.getExpTextName());
                            logisticFollow.setThirdOrderNo(mallShipping.getShippingNo());
                            logisticFollow.setOrderNo(mallShipping.getOrderNo());
                            if (LogisticStatus.finallyStatus.contains(logisticsFollowVo.getStatus())) {
                                saveLocalLogistics.add(logisticFollow);
                            }
                            if (!Lang.isEmpty((Object)logisticsFollowVo.getData())) {
                                logisticInfos = JSONArray.parseArray((String)logisticsFollowVo.getData());
                                orderShippingPackages = new ArrayList(logisticInfos.size());
                                this.buildOrderShippingTrack(logisticInfos, orderShippingPackages, logisticFollow, orderShippingPackageVo, mallShipping);
                            }
                        }
                    }
                    orderShippingPackageVos.add(orderShippingPackageVo);
                }
                if (!Lang.isEmpty(saveLocalLogistics)) {
                    this.logisticFollowApi.batchSaveLogisticInfo(saveLocalLogistics);
                }
            }
            catch (Exception e) {
                logger.info("#####{}", (Throwable)e);
            }
            return new HandlerRespVo(orderShippingPackageVos);
        }
        return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR, HandlerRespVo.RESPONSE_STATUS_ERROR, "\u672a\u67e5\u8be2\u5230\u7269\u6d41\u4fe1\u606f");
    }

    private void buildOrderShippingTrack(JSONArray logisticInfos, List<OrderShippingTrackVo> orderShippingPackages, LogisticFollowDto logisticFollowDto, OrderShippingPackageVo orderShippingPackageVo, MallShippingDto mallShipping) {
        orderShippingPackageVo.setTrdSubOrderNo(logisticFollowDto.getThirdOrderNo());
        orderShippingPackageVo.setPackageName(mallShipping.getShippingCompany());
        orderShippingPackageVo.setReceiptsFlag(Boolean.valueOf(LogisticStatus.LOGISTIC_STATUS_RECEIVING.getValue().equals(logisticFollowDto.getLogisticStatus())));
        orderShippingPackageVo.setStatus((String)LogisticStatus.logisticStatusMap.get(logisticFollowDto.getLogisticStatus()));
        OrderShippingTrackVo orderShippingTrackVo = null;
        JSONObject jsonObject = null;
        for (Object obj : logisticInfos) {
            jsonObject = (JSONObject)obj;
            orderShippingTrackVo = new OrderShippingTrackVo();
            orderShippingTrackVo.setMsgTime(jsonObject.getDate("time"));
            orderShippingTrackVo.setContent(jsonObject.getString("context"));
            orderShippingPackages.add(orderShippingTrackVo);
        }
        orderShippingPackageVo.setTrackInfoList(orderShippingPackages);
    }

    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        return null;
    }

    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        HandlerRespVo respVo = new HandlerRespVo();
        BaseResponse orderStatus = this.localStoreApi.findOrderStatus(trdOrderNo, storeId);
        if (Lang.isEmpty((Object)orderStatus.getResult())) {
            respVo.setErrorCode(Integer.valueOf(3));
            respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            respVo.setMessage("\u7b2c\u4e09\u65b9\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u5931\u8d25");
            respVo.setData(null);
            return respVo;
        }
        OrderMainDto result = (OrderMainDto)orderStatus.getResult();
        respVo.setErrorCode(Integer.valueOf(0));
        respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        respVo.setMessage("\u7b2c\u4e09\u65b9\u8ba2\u5355\u53f7\u67e5\u8be2\u6210\u529f");
        respVo.setData((Object)result.getOutsideStatus());
        return respVo;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        return null;
    }

    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo(null);
    }

    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo((Object)true);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

