/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import goods.dto.product.ProductFashionDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import member.api.AddressCommonApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.ProductFashionApiStub;
import outsideapi.service.service.stub.ProtocolApiStub;
import outsideapi.vo.FacProductConfirmRequestVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.FashionPricesRequestVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.OrderShippingTrackVo;
import outsideapi.vo.ReserveOrderIdVo;
import outsideapi.vo.ReserveOrderVo;
import outsideapi.vo.ReserveVo;
import outsideapi.vo.ShipTimeResVo;
import outsideapi.vo.ShippLogistRequestVo;
import outsideapi.vo.ShippLogistResVo;
import outsideapi.vo.ShippingFeeRequetVo;
import shipping.api.definition.LogisticStatus;
import shipping.api.dto.LogisticFollowDto;
import shipping.api.vo.showapi.LogisticsFollowVo;
import uninogift.vo.protocol.ProductQueryVo;
import uninogift.vo.protocol.ProtocolFashionStateVo;
import uninogift.vo.protocol.ProtocolOrderLogisticDto;
import utils.Lang;

@Component
@Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
public class ProtocolOutsideApiHandler
implements OutsideApiHandler {
    private static Logger logger = LoggerFactory.getLogger(ProtocolOutsideApiHandler.class);
    @Autowired
    ProtocolApiStub protocolApi;
    @Autowired
    ProductFashionApiStub productFashionApi;

    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        ArrayList<FashionStockStateVo> fashionStockStateVos = new ArrayList<FashionStockStateVo>();
        HandlerRespVo respVo = new HandlerRespVo();
        List fashionIds = requet.getFashionNums().stream().filter(f -> !Lang.isEmpty((Object)f.getFactionId())).map(i -> i.getFactionId()).collect(Collectors.toList());
        List productFashionList = this.productFashionApi.findByIds(fashionIds);
        List productQueryList = productFashionList.stream().filter(p -> p != null && p.getOnSale() != false).map(p -> {
            ProductQueryVo queryVo = new ProductQueryVo();
            queryVo.setProductFashionId(p.getId());
            return queryVo;
        }).collect(Collectors.toList());
        List notOnSaleFashions = productFashionList.stream().filter(p -> p != null && p.getOnSale() == false).collect(Collectors.toList());
        for (ProductFashionDto f2 : notOnSaleFashions) {
            FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
            fashionStockStateVo.setFashionId(f2.getId());
            fashionStockStateVo.setProductCode(f2.getProductCode());
            fashionStockStateVo.setIsAreaRestrict(Boolean.valueOf(false));
            fashionStockStateVo.setStockCount(Integer.valueOf(-1));
            fashionStockStateVo.setOnSale(Boolean.valueOf(false));
            fashionStockStateVos.add(fashionStockStateVo);
        }
        if (productQueryList != null && productQueryList.size() > 0) {
            List procFashionStates = this.protocolApi.queryFashionState(productQueryList, requet.getCompanyId());
            for (ProtocolFashionStateVo state : procFashionStates) {
                FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
                fashionStockStateVo.setFashionId(state.getFashionId());
                fashionStockStateVo.setProductCode(state.getSku());
                fashionStockStateVo.setIsAreaRestrict(Boolean.valueOf(false));
                fashionStockStateVo.setStockCount(Integer.valueOf(-1));
                fashionStockStateVo.setOnSale(state.getOnSale());
                switch (state.getStockState()) {
                    case 1: {
                        fashionStockStateVo.setStockFlag(Integer.valueOf(1));
                        break;
                    }
                    case 0: {
                        fashionStockStateVo.setStockFlag(Integer.valueOf(0));
                        break;
                    }
                    case 2: {
                        fashionStockStateVo.setStockFlag(Integer.valueOf(2));
                        break;
                    }
                    default: {
                        fashionStockStateVo.setStockFlag(Integer.valueOf(0));
                    }
                }
                if ("2".equals(state.getNotsaleReason())) {
                    fashionStockStateVo.setNotsaleReason("2");
                } else if ("1".equals(state.getNotsaleReason())) {
                    fashionStockStateVo.setNotsaleReason("1");
                }
                fashionStockStateVos.add(fashionStockStateVo);
            }
        }
        respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        respVo.setData(fashionStockStateVos);
        return respVo;
    }

    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        return null;
    }

    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        HandlerRespVo respVo = new HandlerRespVo();
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
        data.put("freight", BigDecimal.ZERO);
        data.put("baseFreight", BigDecimal.ZERO);
        data.put("remoteRegionFreight", BigDecimal.ZERO);
        respVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        respVo.setData(data);
        return respVo;
    }

    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return areaCode;
    }

    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        return areaMap;
    }

    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        return BigDecimal.ONE;
    }

    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        ArrayList<LogisticFollowDto> saveLocalLogistics = new ArrayList<LogisticFollowDto>();
        List orderLogisticDtos = this.protocolApi.queryProtocolOrderLogistic(trdOrderNo);
        if (!Lang.isEmpty((Object)orderLogisticDtos)) {
            ArrayList<OrderShippingPackageVo> orderShippingPackageVos = new ArrayList<OrderShippingPackageVo>(orderLogisticDtos.size());
            OrderShippingPackageVo orderShippingPackageVo = null;
            try {
                JSONArray logisticInfos = null;
                ArrayList orderShippingPackages = null;
                for (ProtocolOrderLogisticDto orderLogisticDto : orderLogisticDtos) {
                    orderShippingPackageVo = new OrderShippingPackageVo();
                    LogisticFollowDto logisticFollowDto = this.protocolApi.queryLocalLogisticByLogisticNo(orderLogisticDto.getLogisticNo());
                    if (!Lang.isEmpty((Object)logisticFollowDto) && LogisticStatus.finallyStatus.contains(logisticFollowDto.getLogisticStatus()) && !Lang.isEmpty((Object)logisticFollowDto.getLogisticData())) {
                        logisticInfos = JSONArray.parseArray((String)logisticFollowDto.getLogisticData());
                        orderShippingPackages = new ArrayList(logisticInfos.size());
                        this.buildOrderShippingTrack(logisticInfos, orderShippingPackages, logisticFollowDto, orderShippingPackageVo);
                    } else {
                        LogisticsFollowVo logisticsFollowVo = this.protocolApi.queryLogisticsFollow(orderLogisticDto.getLogisticCompanySimpleName(), orderLogisticDto.getLogisticNo());
                        if (!Lang.isEmpty((Object)logisticsFollowVo)) {
                            LogisticFollowDto logisticFollow = new LogisticFollowDto();
                            logisticFollow.setLogisticStatus(logisticsFollowVo.getStatus());
                            logisticFollow.setLogisticData(logisticsFollowVo.getData());
                            logisticFollow.setLogisticCompany(logisticsFollowVo.getExpTextName());
                            logisticFollow.setThirdOrderNo(orderLogisticDto.getLogisticNo());
                            logisticFollow.setOrderNo(trdOrderNo);
                            if (LogisticStatus.finallyStatus.contains(logisticsFollowVo.getStatus())) {
                                saveLocalLogistics.add(logisticFollow);
                            }
                            if (!Lang.isEmpty((Object)logisticsFollowVo.getData())) {
                                logisticInfos = JSONArray.parseArray((String)logisticsFollowVo.getData());
                                orderShippingPackages = new ArrayList(logisticInfos.size());
                                this.buildOrderShippingTrack(logisticInfos, orderShippingPackages, logisticFollow, orderShippingPackageVo);
                            }
                        }
                    }
                    orderShippingPackageVos.add(orderShippingPackageVo);
                }
                if (!Lang.isEmpty(saveLocalLogistics)) {
                    this.protocolApi.syncLogisticLocal(saveLocalLogistics);
                }
            }
            catch (Exception e) {
                logger.info("#####{}", (Throwable)e);
            }
            return new HandlerRespVo(orderShippingPackageVos);
        }
        return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR, HandlerRespVo.RESPONSE_STATUS_ERROR, "\u672a\u67e5\u8be2\u5230\u7269\u6d41\u4fe1\u606f");
    }

    private void buildOrderShippingTrack(JSONArray logisticInfos, List<OrderShippingTrackVo> orderShippingPackages, LogisticFollowDto logisticFollowDto, OrderShippingPackageVo orderShippingPackageVo) {
        orderShippingPackageVo.setPackageId(logisticFollowDto.getThirdOrderNo());
        orderShippingPackageVo.setReceiptsFlag(Boolean.valueOf(LogisticStatus.LOGISTIC_STATUS_RECEIVING.getValue().equals(logisticFollowDto.getLogisticStatus())));
        orderShippingPackageVo.setStatus((String)LogisticStatus.logisticStatusMap.get(logisticFollowDto.getLogisticStatus()));
        OrderShippingTrackVo orderShippingTrackVo = null;
        JSONObject jsonObject = null;
        for (Object obj : logisticInfos) {
            jsonObject = (JSONObject)obj;
            orderShippingTrackVo = new OrderShippingTrackVo();
            orderShippingTrackVo.setMsgTime(jsonObject.getDate("time"));
            orderShippingTrackVo.setContent(jsonObject.getString("context"));
            orderShippingPackages.add(orderShippingTrackVo);
        }
        orderShippingPackageVo.setTrackInfoList(orderShippingPackages);
    }

    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        return null;
    }

    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        return null;
    }

    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo(null);
    }

    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo((Object)true);
    }

    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        return null;
    }
}

