/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import cart.api.dto.order.SubOrderDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.suning.api.entity.govbus.FacProductConfirmRequest;
import com.suning.api.entity.govbus.FacProductConfirmResponse;
import com.suning.api.entity.govbus.OrderAddRequest;
import com.suning.api.entity.govbus.OrderLogistGetRequest;
import com.suning.api.entity.govbus.OrderLogistGetResponse;
import com.suning.api.entity.govbus.OrderStatusGetRequest;
import com.suning.api.entity.govbus.OrderStatusGetResponse;
import com.suning.api.entity.govbus.OrderlogistnewGetRequest;
import com.suning.api.entity.govbus.OrderlogistnewGetResponse;
import com.suning.api.entity.govbus.ShipCarriageGetRequest;
import com.suning.api.entity.govbus.ShipCarriageGetResponse;
import com.suning.api.entity.govbus.ShipTimeGetRequest;
import com.suning.api.entity.govbus.ShipTimeGetResponse;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.dto.goods.GoodsPictureDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.AddressCommonApiStub;
import outsideapi.service.service.stub.GoodsPictureApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.service.service.stub.SnCommonConvertApiStub;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.vo.AddressVo;
import outsideapi.vo.FacProductConfirmRequestVo;
import outsideapi.vo.FacProductConfirmVo;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.FashionPricesRequestVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.GoodsInfoVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.OrderLogisticStatusVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.OrderShippingTrackVo;
import outsideapi.vo.ReserveOrderIdVo;
import outsideapi.vo.ReserveOrderVo;
import outsideapi.vo.ReserveVo;
import outsideapi.vo.ShipTimeResVo;
import outsideapi.vo.ShippLogistRequestVo;
import outsideapi.vo.ShippLogistResVo;
import outsideapi.vo.ShippingFeeRequetVo;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderReceiver;
import outsideapi.vo.orderrequest.OrderRequst;
import suning.api.order.SnOrderApi;
import suning.model.SnAddressRelation;
import suning.model.SnNationalAddress;
import suning.model.repository.SnAddressRelationRepos;
import suning.model.repository.SnNationalAddressRepos;
import sysmg.api.SystemConfigApi;
import utils.Lang;

@Component
@Transactional
public class SnOutsideApiHandler
implements OutsideApiHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SnOutsideApiHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    SnNationalAddressRepos snNationalAddressRepos;
    @Autowired
    SnAddressRelationRepos snAddressRelationRepos;
    @Autowired
    AddressCommonApiStub addressCommonApi;
    @Autowired
    SnCommonConvertApiStub snCommonConvertApi;
    @Autowired
    GoodsPictureApiStub goodsPictureApi;
    @Autowired
    OrderMainApiStub orderMainApi;
    @Autowired
    OutsideProductApi outsideProductApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @MotanReferer
    SnOrderApi snOrderApi;

    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        System.out.println("SnOutsideApiHandler.queryFashionStockState invoked...");
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        ArrayList<FashionStockStateVo> resStateVoList = new ArrayList<FashionStockStateVo>();
        handlerRespVo.setData(resStateVoList);
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        HashMap<String, String> factionIdMap = new HashMap<String, String>();
        List fashionNumsVos = requet.getFashionNums();
        Map addrMap = this.transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        if (!Lang.isEmpty((Object)addrMap)) {
            List batchProdSaleStatuList;
            Object state;
            FashionStockStateVo fashionStockStateVo;
            ArrayList paramList = new ArrayList();
            for (FashionNumsVo fashionNumsVo : fashionNumsVos) {
                Map map = new HashMap<String, String>();
                map.put("skuId", fashionNumsVo.getProductCode());
                if (!Lang.isEmpty((Object)fashionNumsVo.getCounts())) {
                    map.put("num", fashionNumsVo.getCounts().toString());
                }
                factionIdMap.put(fashionNumsVo.getProductCode(), fashionNumsVo.getFactionId());
                paramList.add(map);
            }
            if (((FashionNumsVo)fashionNumsVos.get(0)).getCounts() == null) {
                List goodsMprodStock = this.snCommonConvertApi.queryGoodsMprodStock(paramList, (String)addrMap.get("cityId"));
                if (Lang.isEmpty((Object)goodsMprodStock)) {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1aqueryGoodsMprodStock \u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                    handlerRespVo.setErrorCode(Integer.valueOf(3));
                    return handlerRespVo;
                }
                for (Map map : goodsMprodStock) {
                    fashionStockStateVo = new FashionStockStateVo();
                    fashionStockStateVo.setProductCode((String)map.get("skuId"));
                    fashionStockStateVo.setFashionId((String)factionIdMap.get(map.get("skuId")));
                    state = Integer.valueOf((String)map.get("state"));
                    switch ((Integer)state) {
                        case 0: {
                            fashionStockStateVo.setStockFlag(Integer.valueOf(1));
                            break;
                        }
                        case 1: {
                            fashionStockStateVo.setStockFlag(Integer.valueOf(1));
                            break;
                        }
                        case 2: {
                            fashionStockStateVo.setStockFlag(Integer.valueOf(0));
                        }
                    }
                    fashionStockStateVo.setStockCount(Integer.valueOf(-1));
                    resStateVoList.add(fashionStockStateVo);
                }
            } else {
                List inventoryList = this.snCommonConvertApi.getGoodsInventory(paramList, (String)addrMap.get("cityId"), (String)addrMap.get("countyId"));
                if (Lang.isEmpty((Object)inventoryList)) {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1agetGoodsInventory \u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                    handlerRespVo.setErrorCode(Integer.valueOf(3));
                    return handlerRespVo;
                }
                for (Map map : inventoryList) {
                    map.get("state");
                    fashionStockStateVo = new FashionStockStateVo();
                    fashionStockStateVo.setProductCode((String)map.get("skuId"));
                    fashionStockStateVo.setFashionId((String)factionIdMap.get(map.get("skuId")));
                    state = (String)map.get("state");
                    fashionStockStateVo.setOnSale(Boolean.valueOf(!"01".equals(state)));
                    switch (state) {
                        case "00": {
                            fashionStockStateVo.setStockFlag(Integer.valueOf(1));
                            break;
                        }
                        case "01": {
                            fashionStockStateVo.setStockFlag(Integer.valueOf(0));
                            break;
                        }
                        case "02": {
                            fashionStockStateVo.setStockFlag(Integer.valueOf(0));
                            break;
                        }
                        case "03": {
                            fashionStockStateVo.setStockFlag(Integer.valueOf(0));
                        }
                    }
                    fashionStockStateVo.setStockCount(Integer.valueOf(-1));
                    resStateVoList.add(fashionStockStateVo);
                }
            }
            if (Lang.isEmpty((Object)(batchProdSaleStatuList = this.snCommonConvertApi.getBatchProdSaleStatus(paramList)))) {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1agetBatchProdSaleStatus \u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                handlerRespVo.setErrorCode(Integer.valueOf(3));
                return handlerRespVo;
            }
            for (Map map : batchProdSaleStatuList) {
                String skuId = (String)map.get("skuId");
                state = (String)map.get("state");
                for (FashionStockStateVo vo : resStateVoList) {
                    vo.setIsAreaRestrict(Boolean.valueOf(false));
                    if (!Lang.equals((Object)vo.getProductCode(), (Object)skuId)) continue;
                    vo.setOnSale(Boolean.valueOf(true));
                }
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u5730\u533a\u4ee3\u7801\u8f6c\u6362\u5931\u8d25");
            handlerRespVo.setErrorCode(Integer.valueOf(2));
        }
        handlerRespVo.setData(resStateVoList);
        return handlerRespVo;
    }

    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        Map addrMap = this.transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (Lang.isEmpty((Object)requet.getAddrDetail())) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(Integer.valueOf(1));
            handlerRespVo.setMessage("\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a");
            return handlerRespVo;
        }
        if (Lang.isEmpty((Object)addrMap)) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(Integer.valueOf(1));
            handlerRespVo.setMessage("\u8be5\u5e97\u94fa\u4e0d\u652f\u6301\u5f53\u524d\u914d\u9001\u5730\u5740");
        } else {
            ShipCarriageGetRequest request = new ShipCarriageGetRequest();
            List fashionNumsVos = requet.getFashionNums();
            HashMap fashionIdMap = new HashMap();
            ArrayList<ShipCarriageGetRequest.SkuIds> skuIdses = new ArrayList<ShipCarriageGetRequest.SkuIds>();
            for (FashionNumsVo fashionNumsVo : fashionNumsVos) {
                ShipCarriageGetRequest.SkuIds skuIds = new ShipCarriageGetRequest.SkuIds();
                skuIds.setSkuId(fashionNumsVo.getProductCode());
                skuIds.setPiece(String.valueOf(fashionNumsVo.getCounts()));
                skuIdses.add(skuIds);
            }
            request.setCityId((String)addrMap.get("cityId"));
            request.setAddrDetail(requet.getAddrDetail());
            request.setTownId((String)addrMap.get("townId"));
            request.setDistrictId((String)addrMap.get("countyId"));
            request.setSkuIds(skuIdses);
            String respJson = this.snCommonConvertApi.getShipCarriage(JSON.toJSONString((Object)request));
            if (!Lang.isEmpty((Object)respJson)) {
                ShipCarriageGetResponse response = (ShipCarriageGetResponse)JSON.parseObject((String)respJson, ShipCarriageGetResponse.class);
                if (response.getSnerror() != null) {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setErrorCode(Integer.valueOf(1));
                    handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
                }
                HashMap<String, BigDecimal> d = new HashMap<String, BigDecimal>();
                String freightFare = response.getSnbody().getGetShipCarriage().getFreightFare();
                BigDecimal freightBigDecimal = Lang.isEmpty((Object)freightFare) ? BigDecimal.ZERO : new BigDecimal(freightFare);
                d.put("freight", freightBigDecimal);
                d.put("baseFreight", freightBigDecimal);
                d.put("remoteRegionFreight", freightBigDecimal);
                handlerRespVo.setData(d);
            }
        }
        return handlerRespVo;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)orderStatusGetRequest), "snOrderService", "getOrderStatus", OrderStatusGetRequest.class);
            OrderStatusGetResponse response = (OrderStatusGetResponse)JSON.parseObject((String)respJson, OrderStatusGetResponse.class);
            if (response != null && (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {
                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                ArrayList<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<OrderlogistnewGetRequest.OrderItemIds>();
                for (OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);
                respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)logistnewGetRequest), "snShippingService", "getOrderLogistNew", OrderlogistnewGetRequest.class);
                OrderlogistnewGetResponse logistnewGetResponse = (OrderlogistnewGetResponse)JSON.parseObject((String)respJson, OrderlogistnewGetResponse.class);
                if (logistnewGetResponse != null && (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {
                    for (OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if (o == null) continue;
                        String trdSubOrderNo = logistnewGetResponse.getSnbody().getGetOrderlogistnew().getOrderId();
                        OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                        packageVo.setTrdSubOrderNo(trdSubOrderNo);
                        packageVo.setPackageId(o.getPackageId());
                        packageVo.setShippingTime(o.getShippingTime());
                        packageVo.setReceiveTime(o.getReceiveTime());
                        SubOrderDto subOrder = this.orderMainApi.findSubOrderBySubOrderNo(trdSubOrderNo);
                        if (!Lang.isEmpty((Object)subOrder)) {
                            if (!Lang.isEmpty((Object)subOrder.getTrdSpState()) && Lang.equals((Object)subOrder.getTrdSpState(), (Object)"1")) {
                                packageVo.setReceiptsFlag(Boolean.valueOf(true));
                            } else {
                                packageVo.setReceiptsFlag(Boolean.valueOf(false));
                            }
                        } else {
                            packageVo.setReceiptsFlag(Boolean.valueOf(false));
                        }
                        ArrayList<String> skuses = new ArrayList<String>();
                        for (OrderlogistnewGetResponse.OrderItemIds orderItemIds : o.getOrderItemIds()) {
                            skuses.add(orderItemIds.getSkuId());
                        }
                        List goodsPicturees = this.goodsPictureApi.findByGoods_Skuses(skuses);
                        Map picMap = Lang.beanListToKeyMap((List)goodsPicturees, GoodsPictureDto.class, (String)"picturePath");
                        Collection pictures = picMap.values();
                        ArrayList<GoodsInfoVo> goodsInfos = new ArrayList<GoodsInfoVo>();
                        for (GoodsPictureDto picture : pictures) {
                            GoodsInfoVo goodsInfo = new GoodsInfoVo();
                            goodsInfo.setGoodsId(picture.getGoods().getId());
                            goodsInfo.setGoodsName(picture.getGoods().getName());
                            goodsInfo.setGoodsPictrue(picture.getPicturePath());
                            goodsInfos.add(goodsInfo);
                        }
                        packageVo.setGoodsInfos(goodsInfos);
                        ArrayList<OrderShippingTrackVo> trackVoList = new ArrayList<OrderShippingTrackVo>();
                        for (OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(logistics.getOperateState());
                            try {
                                orderShippingTrackVo.setMsgTime(Lang.isEmpty((Object)logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                            }
                            catch (ParseException e) {
                                orderShippingTrackVo.setMsgTime(null);
                            }
                            trackVoList.add(orderShippingTrackVo);
                        }
                        packageVo.setTrackInfoList(trackVoList);
                        resultList.add(packageVo);
                    }
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                    handlerRespVo.setErrorCode(Integer.valueOf(0));
                    handlerRespVo.setData(resultList);
                } else {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                    handlerRespVo.setErrorCode(Integer.valueOf(1));
                }
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                handlerRespVo.setErrorCode(Integer.valueOf(1));
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(Integer.valueOf(2));
        }
        return handlerRespVo;
    }

    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)orderStatusGetRequest), "snOrderService", "getOrderStatus", OrderStatusGetRequest.class);
            OrderStatusGetResponse response = (OrderStatusGetResponse)JSON.parseObject((String)respJson, OrderStatusGetResponse.class);
            if (response != null && (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {
                if ("4".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) {
                    handlerRespVo.setData((Object)"2");
                } else if ("5".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) {
                    handlerRespVo.setData((Object)"3");
                } else {
                    handlerRespVo.setData((Object)"1");
                }
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                handlerRespVo.setErrorCode(Integer.valueOf(1));
                handlerRespVo.setData((Object)"0");
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(Integer.valueOf(0));
            handlerRespVo.setData((Object)"0");
        }
        return handlerRespVo;
    }

    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)orderStatusGetRequest), "snOrderService", "getOrderStatus", OrderStatusGetRequest.class);
            OrderStatusGetResponse response = (OrderStatusGetResponse)JSON.parseObject((String)respJson, OrderStatusGetResponse.class);
            if (response != null && (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {
                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                ArrayList<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<OrderlogistnewGetRequest.OrderItemIds>();
                for (OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);
                respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)logistnewGetRequest), "snShippingService", "getOrderLogistNew", OrderlogistnewGetRequest.class);
                OrderlogistnewGetResponse logistnewGetResponse = (OrderlogistnewGetResponse)JSON.parseObject((String)respJson, OrderlogistnewGetResponse.class);
                if (logistnewGetResponse != null && (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {
                    for (OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if (o == null) continue;
                        OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                        packageVo.setPackageId(o.getPackageId());
                        packageVo.setShippingTime(o.getShippingTime());
                        packageVo.setReceiveTime(o.getReceiveTime());
                        ArrayList<OrderShippingTrackVo> trackVoList = new ArrayList<OrderShippingTrackVo>();
                        for (OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(logistics.getOperateState());
                            try {
                                orderShippingTrackVo.setMsgTime(Lang.isEmpty((Object)logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                            }
                            catch (ParseException e) {
                                orderShippingTrackVo.setMsgTime(null);
                            }
                            trackVoList.add(orderShippingTrackVo);
                        }
                        packageVo.setTrackInfoList(trackVoList);
                        resultList.add(packageVo);
                    }
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
                    handlerRespVo.setErrorCode(Integer.valueOf(0));
                    handlerRespVo.setData(resultList);
                } else {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                    handlerRespVo.setErrorCode(Integer.valueOf(1));
                }
            } else {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("TRD_API_HAS_NOT_RESPONSE");
                handlerRespVo.setErrorCode(Integer.valueOf(1));
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("TRD_ORDER_NO_NOT_FOUND");
            handlerRespVo.setErrorCode(Integer.valueOf(2));
        }
        return handlerRespVo;
    }

    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        return new HandlerRespVo(null);
    }

    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        return new HandlerRespVo((Object)true);
    }

    private Map transToNationAddress(String provinceCode, String cityCode, String countyCode, String areaCode) {
        HashMap<String, String> addrMap = new HashMap<String, String>();
        if (!Lang.isEmpty((Object)areaCode) && !"0".equals(areaCode)) {
            SnNationalAddress sna = this.transSingleToNationAddress(areaCode, AddressCommonApi.AddressLevel.TOWN);
            if (Lang.isEmpty((Object)sna)) {
                AddressDto address = this.addressCommonApi.findFirstChild(countyCode, "suning", Boolean.valueOf(false));
                AddressDto addressDto = address = address == null ? this.addressCommonApi.findFirstChild(countyCode, "common", Boolean.valueOf(false)) : address;
                if (!Lang.isEmpty((Object)address)) {
                    sna = this.transSingleToNationAddress(address.getId(), AddressCommonApi.AddressLevel.TOWN);
                }
            }
            addrMap.put("townId", sna == null ? "" : sna.getId());
        }
        if (!Lang.isEmpty((Object)countyCode) && !"0".equals(countyCode)) {
            SnNationalAddress county;
            AddressDto addr = this.addressCommonApi.findById(countyCode);
            if (!addr.getStoreCode().equals("common") && !addr.getStoreCode().equals("suning")) {
                String pCode = addr.getParent().getId();
                addr = (addr = this.addressCommonApi.findFirstChild(pCode, "suning", Boolean.valueOf(false))) == null ? this.addressCommonApi.findFirstChild(pCode, "common", Boolean.valueOf(false)) : addr;
                countyCode = addr == null ? countyCode : addr.getId();
            }
            addrMap.put("cityId", (county = this.transSingleToNationAddress(countyCode, AddressCommonApi.AddressLevel.AREA)) == null ? "" : county.getpId());
            addrMap.put("countyId", county == null ? "" : county.getId());
        }
        if (!Lang.isEmpty((Object)cityCode) && !"0".equals(cityCode)) {
            SnNationalAddress snCity = this.transSingleToNationAddress(cityCode, AddressCommonApi.AddressLevel.CITY);
            addrMap.put("cityId", snCity == null ? "" : snCity.getId());
            addrMap.put("provinceId", snCity == null ? "" : snCity.getpId());
        }
        if (!Lang.isEmpty((Object)provinceCode) && !"0".equals(provinceCode)) {
            SnNationalAddress snProvince = this.transSingleToNationAddress(provinceCode, AddressCommonApi.AddressLevel.PROVINCE);
            addrMap.put("provinceId", snProvince == null ? "" : snProvince.getId());
        }
        if (addrMap.size() < 2) {
            return null;
        }
        return addrMap;
    }

    @Transactional(readOnly=true)
    public SnNationalAddress transSingleToNationAddress(String code, AddressCommonApi.AddressLevel lv) {
        SnNationalAddress nAddr = null;
        List snNationalAddressList = this.snNationalAddressRepos.findByLinkId(code);
        if (!Lang.isEmpty((Object)code) && !"0".equals(code)) {
            SnAddressRelation snAddressRelation;
            if (snNationalAddressList != null && snNationalAddressList.size() > 0) {
                nAddr = (SnNationalAddress)snNationalAddressList.get(0);
            } else if (lv == AddressCommonApi.AddressLevel.TOWN && !Lang.isEmpty((Object)(snAddressRelation = this.snAddressRelationRepos.findByAddressId(code)))) {
                SnNationalAddress snNationalAddress;
                nAddr = snNationalAddress = (SnNationalAddress)this.snNationalAddressRepos.findOne((Serializable)((Object)snAddressRelation.getSuningId()));
            }
        }
        return nAddr;
    }

    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        HashMap<Integer, String> trdAreaMap = new HashMap<Integer, String>();
        Map na = this.transToNationAddress(areaMap.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()), areaMap.get(AddressCommonApi.AddressLevel.CITY.getValue()), areaMap.get(AddressCommonApi.AddressLevel.AREA.getValue()), areaMap.get(AddressCommonApi.AddressLevel.TOWN.getValue()));
        if (na != null) {
            trdAreaMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), (String)na.get("provinceId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), (String)na.get("cityId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), (String)na.get("countyId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), (String)na.get("townId"));
            return trdAreaMap;
        }
        return null;
    }

    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return null;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        System.out.println("SnOutsideApiHandler.queryFashionPrice invoked...");
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        ArrayList<FashionPriceVo> resPriceVoList = new ArrayList<FashionPriceVo>();
        handlerRespVo.setData(resPriceVoList);
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        HashMap<String, String> fashionIdMap = new HashMap<String, String>();
        List priceParamVos = requet.getFashionPriceParamVos();
        Map addrMap = this.transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        if (!Lang.isEmpty((Object)addrMap)) {
            ArrayList priceParam = new ArrayList();
            for (FashionPriceParamVo priceParamVo : priceParamVos) {
                Map map = new HashMap<String, String>();
                map.put("skuId", priceParamVo.getProductCode());
                fashionIdMap.put(priceParamVo.getProductCode(), priceParamVo.getFactionId());
                priceParam.add(map);
            }
            List priceResult = this.snCommonConvertApi.queryGoodsPrice(priceParam, (String)addrMap.get("cityId"));
            if (Lang.isEmpty((Object)priceResult)) {
                handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1aqueryGoodsPrice \u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                handlerRespVo.setErrorCode(Integer.valueOf(3));
                return handlerRespVo;
            }
            for (Map map : priceResult) {
                FashionPriceVo fashionPriceVo = new FashionPriceVo();
                fashionPriceVo.setProductCode((String)map.get("skuId"));
                fashionPriceVo.setFashionId((String)fashionIdMap.get(map.get("skuId")));
                if (Lang.isEmpty(map.get("discountRate"))) {
                    fashionPriceVo.setDiscountRate(new BigDecimal(1.0));
                } else {
                    fashionPriceVo.setDiscountRate(new BigDecimal((String)map.get("discountRate")));
                }
                fashionPriceVo.setMarketPrice(new BigDecimal(Lang.isEmpty(map.get("snPrice")) ? "0" : (String)map.get("snPrice")));
                fashionPriceVo.setCostPrice(new BigDecimal(Lang.isEmpty(map.get("price")) ? "0" : (String)map.get("price")));
                fashionPriceVo.setSalePrice(new BigDecimal(Lang.isEmpty(map.get("price")) ? "0" : (String)map.get("price")));
                resPriceVoList.add(fashionPriceVo);
            }
        } else {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage("\u7b2c\u4e09\u65b9\u63a5\u53e3\u5730\u533a\u4ee3\u7801\u8f6c\u6362\u5931\u8d25");
            handlerRespVo.setErrorCode(Integer.valueOf(2));
        }
        return handlerRespVo;
    }

    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo requet) {
        if (!Lang.isEmpty((Object)requet.getCostPrice()) && !Lang.isEmpty((Object)requet.getMarkePrice())) {
            if (requet.getCostPrice().compareTo(BigDecimal.ZERO) < 1 || requet.getMarkePrice().compareTo(BigDecimal.ZERO) < 1) {
                return BigDecimal.ZERO;
            }
            BigDecimal rate = requet.getCostPrice().divide(requet.getMarkePrice(), 2, 1);
            return rate.compareTo(BigDecimal.ONE) > 0 ? BigDecimal.ONE : rate;
        }
        return new BigDecimal(1);
    }

    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo requet) {
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        OrderLogistGetRequest request = new OrderLogistGetRequest();
        request.setOrderId(requet.getOrderNo());
        request.setOrderItemId(requet.getOrderLineNo());
        request.setSkuId(requet.getProductCode());
        String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)request), "snShippingService", "getOrderLogist", request.getClass());
        OrderLogistGetResponse response = (OrderLogistGetResponse)JSON.parseObject((String)respJson, OrderLogistGetResponse.class);
        if (response.getSnerror() != null) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
            handlerRespVo.setErrorCode(Integer.valueOf(1));
            return handlerRespVo;
        }
        OrderLogistGetResponse.GetOrderLogist getOrderLogist = response.getSnbody().getGetOrderLogist();
        List statusList = getOrderLogist.getOrderLogisticStatus();
        ArrayList<OrderLogisticStatusVo> orderLogisticStatusVos = new ArrayList<OrderLogisticStatusVo>();
        for (OrderLogistGetResponse.OrderLogisticStatus orderLogisticStatus : statusList) {
            OrderLogisticStatusVo vo = new OrderLogisticStatusVo();
            vo.setOperateState(orderLogisticStatus.getOperateState());
            vo.setOperateTime(orderLogisticStatus.getOperateTime());
            orderLogisticStatusVos.add(vo);
        }
        ShippLogistResVo shippLogistResVo = new ShippLogistResVo();
        shippLogistResVo.setOrderLogisticStatusVoList(orderLogisticStatusVos);
        shippLogistResVo.setOrderLineId(getOrderLogist.getOrderItemId());
        shippLogistResVo.setOrderThirdId(getOrderLogist.getOrderId());
        shippLogistResVo.setReceiveTime(getOrderLogist.getReceiveTime());
        shippLogistResVo.setShippingTime(getOrderLogist.getShippingTime());
        shippLogistResVo.setProductCode(getOrderLogist.getSkuId());
        handlerRespVo.setData((Object)shippLogistResVo);
        return handlerRespVo;
    }

    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        Map addrMap = this.transToNationAddress(requet.getProvinceCode(), requet.getCityCode(), requet.getCountyCode(), requet.getTownCode());
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        if (Lang.isEmpty((Object)requet.getAddrDetail())) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(Integer.valueOf(1));
            handlerRespVo.setMessage("\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a");
            return handlerRespVo;
        }
        if (Lang.isEmpty((Object)addrMap)) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(Integer.valueOf(1));
            handlerRespVo.setMessage("\u8be5\u5e97\u94fa\u4e0d\u652f\u6301\u5f53\u524d\u914d\u9001\u5730\u5740");
        } else {
            ShipTimeGetRequest request = new ShipTimeGetRequest();
            request.setCityId((String)addrMap.get("cityId"));
            request.setAddrDetail(requet.getAddrDetail());
            request.setTownId((String)addrMap.get("townId"));
            request.setDistrictId((String)addrMap.get("countyId"));
            ArrayList<ShipTimeGetRequest.SkuIds> skuIdses = new ArrayList<ShipTimeGetRequest.SkuIds>();
            List fashionNumsVos = requet.getFashionNums();
            for (FashionNumsVo fashionNumsVo : fashionNumsVos) {
                ShipTimeGetRequest.SkuIds skuIds = new ShipTimeGetRequest.SkuIds();
                skuIds.setSkuId(fashionNumsVo.getProductCode());
                skuIdses.add(skuIds);
            }
            request.setSkuIds(skuIdses);
            String respJson = this.snCommonConvertApi.getShipTime(JSON.toJSONString((Object)request));
            if (!Lang.isEmpty((Object)respJson)) {
                ShipTimeGetResponse response = (ShipTimeGetResponse)JSON.parseObject((String)respJson, ShipTimeGetResponse.class);
                if (response.getSnerror() != null) {
                    handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
                    handlerRespVo.setErrorCode(Integer.valueOf(1));
                    handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
                    return handlerRespVo;
                }
                List resultInfos = response.getSnbody().getGetShipTime().getResultInfo();
                ArrayList<ShipTimeResVo> returnList = new ArrayList<ShipTimeResVo>();
                for (ShipTimeGetResponse.ResultInfo resultInfo : resultInfos) {
                    ShipTimeResVo vo = new ShipTimeResVo();
                    vo.setDeliveryToVillageFlag(resultInfo.getDeliveryToVillageFlag());
                    vo.setInstallType(resultInfo.getInstallType());
                    vo.setIsDelivery(resultInfo.getIsDelivery());
                    vo.setProductCode(resultInfo.getSkuId());
                    vo.setSrvCmmdtyCode(resultInfo.getSrvCmmdtyCode());
                    vo.setSupplierTel(resultInfo.getSupplierTel());
                    returnList.add(vo);
                }
                handlerRespVo.setData(returnList);
            }
        }
        return handlerRespVo;
    }

    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_SUCCESS);
        handlerRespVo.setErrorCode(Integer.valueOf(0));
        FacProductConfirmRequest request = new FacProductConfirmRequest();
        request.setOrderId(requst.getOrderThirdNo());
        ArrayList<FacProductConfirmRequest.SkuConfirmList> skuConfirmList = new ArrayList<FacProductConfirmRequest.SkuConfirmList>();
        List facProductConfirmVos = requst.getFacProductConfirmVos();
        for (FacProductConfirmVo facProductConfirmVo : facProductConfirmVos) {
            FacProductConfirmRequest.SkuConfirmList skuConfirm = new FacProductConfirmRequest.SkuConfirmList();
            skuConfirm.setConfirmTime(facProductConfirmVo.getConfirmTime());
            skuConfirm.setSkuId(facProductConfirmVo.getProductCode());
            skuConfirmList.add(skuConfirm);
        }
        String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)request), "snShippingService", "confirmFacProduct", request.getClass());
        FacProductConfirmResponse response = (FacProductConfirmResponse)JSON.parseObject((String)respJson, FacProductConfirmResponse.class);
        if (response.getSnerror() != null) {
            handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
            handlerRespVo.setErrorCode(Integer.valueOf(1));
            handlerRespVo.setMessage(response.getSnerror().getErrorMsg());
            return handlerRespVo;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("apiIsSuccess", "N");
        if ("Y".equalsIgnoreCase(response.getSnbody().getConfirmFacProduct().getApiIsSuccess())) {
            returnMap.put("apiIsSuccess", "Y");
        }
        handlerRespVo.setData(returnMap);
        return handlerRespVo;
    }

    private void checkOrderWanner() throws SupplierTakeOrderFalidException {
        String snOrderWarnStr = this.systemConfigApi.getConfigValue("COMMON", "SUNINGORDERCONFIGWARN", "SUNINGORDERCONSTANTWARN", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)snOrderWarnStr) && !TrdOrderHandlerUtils.checkOrderWannerConfigJson((String)snOrderWarnStr).booleanValue()) {
            throw new SupplierTakeOrderFalidException("\u4e0b\u5355\u62e6\u622a\u5df2\u914d\u7f6e", SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
        }
    }

    private void gennerSuningOrderConstant(OrderAddRequest request) {
        String suningOrderConstantStr = this.systemConfigApi.getConfigValue("COMMON", "SUNINGORDERCONFIG", "SUNINGORDERCONSTANT", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)suningOrderConstantStr)) {
            try {
                JSONObject obj = JSON.parseObject((String)suningOrderConstantStr);
                String invoiceContent = (String)obj.get((Object)"invoiceContent");
                String invoiceType = (String)obj.get((Object)"invoiceType");
                String invoiceState = (String)obj.get((Object)"invoiceState");
                String invoiceName = (String)obj.get((Object)"invoiceName");
                String orderType = (String)obj.get((Object)"orderType");
                String paymentType = (String)obj.get((Object)"paymentType");
                request.setInvoiceContent(invoiceContent);
                request.setInvoiceType(invoiceType);
                request.setInvoiceState(invoiceState);
                request.setInvoiceTitle(invoiceName);
                request.setOrderType(orderType);
                request.setPayment(paymentType);
            }
            catch (Exception e) {
                log.info("\u6570\u636e\u5e93\u4fdd\u5b58\u7684\u53c2\u6570\u4fe1\u606f\u662f\u9519\u8bef\u7684\uff0c\u8bf7\u4fee\u6539");
                e.printStackTrace();
                this.defaultGennerSuningOrderConstant(request);
            }
        } else {
            this.defaultGennerSuningOrderConstant(request);
        }
    }

    private void defaultGennerSuningOrderConstant(OrderAddRequest request) {
        request.setInvoiceContent("1");
        request.setInvoiceType("6");
        request.setInvoiceState("1");
        request.setInvoiceTitle("\u592a\u5e73\u91d1\u878d\u670d\u52a1\u6709\u9650\u516c\u53f8");
        request.setOrderType("1");
        request.setPayment("09");
    }

    public AddressVo findSnAddressId(OrderReceiver receiver) {
        AddressVo addressVo = new AddressVo();
        HashMap<Integer, String> areaCodeMap = new HashMap<Integer, String>();
        areaCodeMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), receiver.getProvinceCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), receiver.getCityCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), receiver.getAreaCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), receiver.getTownCode());
        Map apiAddrRs = this.transAreaCodeMap(areaCodeMap);
        String snProvince = (String)apiAddrRs.get(AddressCommonApi.AddressLevel.PROVINCE.getValue());
        String snCity = (String)apiAddrRs.get(AddressCommonApi.AddressLevel.CITY.getValue());
        String snTown = (String)apiAddrRs.get(AddressCommonApi.AddressLevel.TOWN.getValue());
        if (Lang.isEmpty((Object)snProvince) && Lang.isEmpty((Object)snCity) && Lang.isEmpty((Object)snTown)) {
            return null;
        }
        if (!Lang.isEmpty((Object)receiver.getTownCode())) {
            addressVo.setTownId(snTown);
        }
        addressVo.setProvinceId(snProvince);
        addressVo.setCityId(snCity);
        addressVo.setAreaId((String)apiAddrRs.get(AddressCommonApi.AddressLevel.AREA.getValue()));
        if (snProvince == null && snCity == null) {
            return null;
        }
        return addressVo;
    }

    private List<OrderAddRequest.Sku> genSkuReqList(OrderRequst orderRequst, List<Map> snPriceLinks) {
        ArrayList<OrderAddRequest.Sku> retList = new ArrayList<OrderAddRequest.Sku>();
        for (OrderItemVo orderItem : orderRequst.getOrderItems()) {
            BigDecimal snPrice;
            OrderAddRequest.Sku returnSku = new OrderAddRequest.Sku();
            returnSku.setSkuId(orderItem.getSku());
            if (Lang.isEmpty((Object)orderItem.getSalePrice()) || Lang.isEmpty((Object)orderItem.getCount())) continue;
            returnSku.setNum(orderItem.getCount().toString());
            Map snPriceLink = (Map)Lang.findInBeanList(snPriceLinks, (String)"productId", (Object)orderItem.getProductId());
            if (snPriceLink == null || (snPrice = (BigDecimal)snPriceLink.get("price")) == null) continue;
            returnSku.setUnitPrice(snPrice.setScale(2, 4).toString());
            retList.add(returnSku);
        }
        return retList;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

