/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.suning.api.entity.govbus.ApplyRejectedAddRequest;
import com.suning.api.entity.govbus.ApplyRejectedAddResponse;
import com.suning.api.entity.govbus.ConfirmOrderAddRequest;
import com.suning.api.entity.govbus.ConfirmOrderAddResponse;
import com.suning.api.entity.govbus.OrderAddRequest;
import com.suning.api.entity.govbus.OrderAddResponse;
import com.suning.api.entity.govbus.OrderStatusGetRequest;
import com.suning.api.entity.govbus.OrderStatusGetResponse;
import com.suning.api.entity.govbus.OrderlogistnewGetRequest;
import com.suning.api.entity.govbus.OrderlogistnewGetResponse;
import com.suning.api.entity.govbus.RejectOrderDeleteRequest;
import com.suning.api.entity.govbus.RejectOrderDeleteResponse;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.dto.goods.GoodsPictureDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.api.OutsideProductApi;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.SupplierOrderApiHandler;
import outsideapi.service.service.stub.AddressCommonApiStub;
import outsideapi.service.service.stub.GoodsPictureApiStub;
import outsideapi.service.service.stub.OrderMainApiStub;
import outsideapi.service.service.stub.SnCommonConvertApiStub;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.utils.Constants;
import outsideapi.vo.AddressVo;
import outsideapi.vo.BackOrderDetail;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.GoodsInfoVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.OrderShippingTrackVo;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.order.TrdOrderSku;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderReceiver;
import outsideapi.vo.orderrequest.OrderRequst;
import suning.api.order.SnOrderApi;
import suning.model.SnAddressRelation;
import suning.model.SnNationalAddress;
import suning.model.repository.SnAddressRelationRepos;
import suning.model.repository.SnNationalAddressRepos;
import sysmg.api.SystemConfigApi;
import utils.Lang;

@Component
@Transactional
public class SnSupplierOrderApiHandler
implements SupplierOrderApiHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SnSupplierOrderApiHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    SnNationalAddressRepos snNationalAddressRepos;
    @Autowired
    SnAddressRelationRepos snAddressRelationRepos;
    @Autowired
    AddressCommonApiStub addressCommonApi;
    @Autowired
    SnCommonConvertApiStub snCommonConvertApi;
    @Autowired
    GoodsPictureApiStub goodsPictureApi;
    @Autowired
    OrderMainApiStub orderMainApi;
    @Autowired
    OutsideProductApi outsideProductApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @MotanReferer
    SnOrderApi snOrderApi;

    public String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        OrderMainDto orderMainDto = this.orderMainApi.findOrderByThirdOrderNo(trdOrderKey.getTrdOrderNo());
        return orderMainDto == null ? null : orderMainDto.getThirdOrderNo();
    }

    public Boolean cancelOrder(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException, OrderCancelException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        RejectOrderDeleteRequest request = new RejectOrderDeleteRequest();
        request.setOrderId(trdOrderKey.getTrdOrderNo());
        String returnStr = this.snCommonConvertApi.cancelOrder(JSON.toJSONString((Object)request));
        if (Lang.isEmpty((Object)returnStr)) {
            throw new SupplierInterfaceInvokeException("\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
        }
        RejectOrderDeleteResponse response = (RejectOrderDeleteResponse)JSON.parseObject((String)returnStr, RejectOrderDeleteResponse.class);
        if (response.getSnerror() != null) {
            returnMap.put("status", "error");
            String errorCode = "";
            if ("106".equals(response.getSnerror().getErrorCode())) {
                throw new OrderCancelException(OrderCancelException.ERROR_CODES.TRD_ORDER_COMFIRMED);
            }
            if ("104".equals(response.getSnerror().getErrorCode())) {
                throw new OrderCancelException(response.getSnerror().getErrorMsg(), OrderCancelException.ERROR_CODES.API_ERROR);
            }
            throw new OrderCancelException(response.getSnerror().getErrorCode() + ":" + response.getSnerror().getErrorMsg(), OrderCancelException.ERROR_CODES.API_ERROR);
        }
        return true;
    }

    public List<OrderShippingPackageVo> getShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)orderStatusGetRequest), "snOrderService", "getOrderStatus", OrderStatusGetRequest.class);
            OrderStatusGetResponse response = (OrderStatusGetResponse)JSON.parseObject((String)respJson, OrderStatusGetResponse.class);
            if (response != null && (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {
                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                ArrayList<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<OrderlogistnewGetRequest.OrderItemIds>();
                for (OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);
                respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)logistnewGetRequest), "snShippingService", "getOrderLogistNew", OrderlogistnewGetRequest.class);
                OrderlogistnewGetResponse logistnewGetResponse = (OrderlogistnewGetResponse)JSON.parseObject((String)respJson, OrderlogistnewGetResponse.class);
                if (logistnewGetResponse != null && (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {
                    for (OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if (o == null) continue;
                        String trdSubOrderNo = logistnewGetResponse.getSnbody().getGetOrderlogistnew().getOrderId();
                        OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                        packageVo.setTrdSubOrderNo(trdSubOrderNo);
                        packageVo.setPackageId(o.getPackageId());
                        packageVo.setShippingTime(o.getShippingTime());
                        packageVo.setReceiveTime(o.getReceiveTime());
                        SubOrderDto subOrder = this.orderMainApi.findSubOrderBySubOrderNo(trdSubOrderNo);
                        if (!Lang.isEmpty((Object)subOrder)) {
                            if (!Lang.isEmpty((Object)subOrder.getTrdSpState()) && Lang.equals((Object)subOrder.getTrdSpState(), (Object)"1")) {
                                packageVo.setReceiptsFlag(Boolean.valueOf(true));
                            } else {
                                packageVo.setReceiptsFlag(Boolean.valueOf(false));
                            }
                        } else {
                            packageVo.setReceiptsFlag(Boolean.valueOf(false));
                        }
                        ArrayList<String> skuses = new ArrayList<String>();
                        for (OrderlogistnewGetResponse.OrderItemIds orderItemIds : o.getOrderItemIds()) {
                            skuses.add(orderItemIds.getSkuId());
                        }
                        List goodsPicturees = this.goodsPictureApi.findByGoods_Skuses(skuses);
                        Map picMap = Lang.beanListToKeyMap((List)goodsPicturees, GoodsPictureDto.class, (String)"picturePath");
                        Collection pictures = picMap.values();
                        ArrayList<GoodsInfoVo> goodsInfos = new ArrayList<GoodsInfoVo>();
                        for (GoodsPictureDto picture : pictures) {
                            GoodsInfoVo goodsInfo = new GoodsInfoVo();
                            goodsInfo.setGoodsId(picture.getGoods().getId());
                            goodsInfo.setGoodsName(picture.getGoods().getName());
                            goodsInfo.setGoodsPictrue(picture.getPicturePath());
                            goodsInfos.add(goodsInfo);
                        }
                        packageVo.setGoodsInfos(goodsInfos);
                        ArrayList<OrderShippingTrackVo> trackVoList = new ArrayList<OrderShippingTrackVo>();
                        for (OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(logistics.getOperateState());
                            try {
                                orderShippingTrackVo.setMsgTime(Lang.isEmpty((Object)logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                            }
                            catch (ParseException e) {
                                orderShippingTrackVo.setMsgTime(null);
                            }
                            trackVoList.add(orderShippingTrackVo);
                        }
                        packageVo.setTrackInfoList(trackVoList);
                        resultList.add(packageVo);
                    }
                    return resultList;
                }
                throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
            }
            throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
        }
        throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOrderStatus(String trdOrderNo) throws SupplierInterfaceInvokeException {
        String status = null;
        if (Lang.isEmpty((Object)trdOrderNo)) throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
        OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
        orderStatusGetRequest.setOrderId(trdOrderNo);
        String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)orderStatusGetRequest), "snOrderService", "getOrderStatus", OrderStatusGetRequest.class);
        OrderStatusGetResponse response = (OrderStatusGetResponse)JSON.parseObject((String)respJson, OrderStatusGetResponse.class);
        if (response == null) throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
        if (response.getSnerror() != null) {
            if (!response.getSnerror().getErrorCode().equals("0")) throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
        }
        if ("4".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) {
            return "2";
        }
        if (!"5".equals(response.getSnbody().getGetOrderStatus().getOrderStatus())) return "1";
        return "3";
    }

    public List<OrderShippingPackageVo> getCTShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        ArrayList<OrderShippingPackageVo> resultList = new ArrayList<OrderShippingPackageVo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmSS");
        if (!Lang.isEmpty((Object)trdOrderNo)) {
            OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();
            OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
            orderStatusGetRequest.setOrderId(trdOrderNo);
            String respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)orderStatusGetRequest), "snOrderService", "getOrderStatus", OrderStatusGetRequest.class);
            OrderStatusGetResponse response = (OrderStatusGetResponse)JSON.parseObject((String)respJson, OrderStatusGetResponse.class);
            if (response != null && (response.getSnerror() == null || response.getSnerror().getErrorCode().equals("0"))) {
                OrderlogistnewGetRequest logistnewGetRequest = new OrderlogistnewGetRequest();
                logistnewGetRequest.setOrderId(trdOrderNo);
                ArrayList<OrderlogistnewGetRequest.OrderItemIds> orderItemIdsList = new ArrayList<OrderlogistnewGetRequest.OrderItemIds>();
                for (OrderStatusGetResponse.OrderItemInfoList oii : response.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                    OrderlogistnewGetRequest.OrderItemIds orderItemIds = new OrderlogistnewGetRequest.OrderItemIds();
                    orderItemIds.setSkuId(oii.getSkuId());
                    orderItemIds.setOrderItemId(oii.getOrderItemId());
                    orderItemIdsList.add(orderItemIds);
                }
                logistnewGetRequest.setOrderItemIds(orderItemIdsList);
                respJson = this.snCommonConvertApi.commonJsonInvoke(JSON.toJSONString((Object)logistnewGetRequest), "snShippingService", "getOrderLogistNew", OrderlogistnewGetRequest.class);
                OrderlogistnewGetResponse logistnewGetResponse = (OrderlogistnewGetResponse)JSON.parseObject((String)respJson, OrderlogistnewGetResponse.class);
                if (logistnewGetResponse != null && (logistnewGetResponse.getSnerror() == null || logistnewGetResponse.getSnerror().getErrorCode().equals("0"))) {
                    for (OrderlogistnewGetResponse.PackageIds o : logistnewGetResponse.getSnbody().getGetOrderlogistnew().getPackageIds()) {
                        if (o == null) continue;
                        OrderShippingPackageVo packageVo = new OrderShippingPackageVo();
                        packageVo.setPackageId(o.getPackageId());
                        packageVo.setShippingTime(o.getShippingTime());
                        packageVo.setReceiveTime(o.getReceiveTime());
                        ArrayList<OrderShippingTrackVo> trackVoList = new ArrayList<OrderShippingTrackVo>();
                        for (OrderlogistnewGetResponse.OrderLogistics logistics : o.getOrderLogistics()) {
                            OrderShippingTrackVo orderShippingTrackVo = new OrderShippingTrackVo();
                            orderShippingTrackVo.setContent(logistics.getOperateState());
                            try {
                                orderShippingTrackVo.setMsgTime(Lang.isEmpty((Object)logistics.getOperateTime()) ? null : sdf.parse(logistics.getOperateTime()));
                            }
                            catch (ParseException e) {
                                orderShippingTrackVo.setMsgTime(null);
                            }
                            trackVoList.add(orderShippingTrackVo);
                        }
                        packageVo.setTrackInfoList(trackVoList);
                        resultList.add(packageVo);
                    }
                    return resultList;
                }
                throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
            }
            throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
        }
        throw new SupplierInterfaceInvokeException(SupplierInterfaceInvokeException.ERROR_CODES.TRD_ORDER_NO_NOTFOUND);
    }

    public TrdOrder takeOrder(OrderRequst orderRequst) throws SupplierInterfaceInvokeException, SupplierTakeOrderFalidException {
        log.info("### \u82cf\u5b81\u9884\u5360\u5e93\u5b58 ###");
        log.info("\u5f00\u59cb\u67e5\u8be2\u8ba2\u5355...");
        long orderMainTime = System.currentTimeMillis();
        log.info("\u67e5\u8be2\u8ba2\u5355\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - orderMainTime));
        log.info("\u5f00\u59cb\u67e5\u8be2\u914d\u7f6e\u4e0b\u5355\u9884\u8b66...");
        long warnOrderMessageTime = System.currentTimeMillis();
        this.checkOrderWanner();
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e0b\u5355\u9884\u8b66\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - warnOrderMessageTime));
        OrderReceiver receiver = orderRequst.getOrderReceiver();
        log.info("\u5f00\u59cb\u8f6c\u6362\u82cf\u5b81\u5730\u5740...");
        long orderAddressSNTime = System.currentTimeMillis();
        AddressVo addr = this.findSnAddressId(receiver);
        log.info("\u8f6c\u6362\u82cf\u5b81\u5730\u5740\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - orderAddressSNTime));
        log.info("\u82cf\u5b81\u5730\u5740 : {}", (Object)JSON.toJSONString((Object)addr));
        if (Lang.isEmpty((Object)addr)) {
            throw new SupplierTakeOrderFalidException(SupplierTakeOrderFalidException.ERROR_CODES.ADDRESS_TRANS_ERROR);
        }
        OrderAddRequest request = new OrderAddRequest();
        ArrayList priceParam = new ArrayList();
        ArrayList<HashMap<String, String>> productSnPriceLinks = new ArrayList<HashMap<String, String>>();
        for (OrderItemVo oi : orderRequst.getOrderItems()) {
            if (oi == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> snPriceLinkMap = (HashMap<String, String>)Lang.findInBeanList(productSnPriceLinks, (String)"productId", (Object)oi.getProductId());
            boolean newNodeFlag = false;
            if (snPriceLinkMap == null) {
                newNodeFlag = true;
                snPriceLinkMap = new HashMap<String, String>();
            }
            snPriceLinkMap.put("sku", oi.getSku());
            snPriceLinkMap.put("productId", oi.getProductId());
            map.put("skuId", oi.getSku());
            priceParam.add(map);
            if (!newNodeFlag) continue;
            productSnPriceLinks.add(snPriceLinkMap);
        }
        log.info("\u5f00\u59cb\u67e5\u8be2\u4ef7\u683c...");
        long queryGoodsPriceTime = System.currentTimeMillis();
        List priceResult = this.snCommonConvertApi.queryGoodsPrice(priceParam, addr.getCityId());
        log.info("\u67e5\u8be2\u4ef7\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryGoodsPriceTime));
        log.info("\u82cf\u5b81\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de : {}", (Object)JSON.toJSONString((Object)priceResult));
        if (Lang.isEmpty((Object)priceResult)) {
            log.error("\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6\u63a5\u53e3\u62a5\u9519\uff0c\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            throw new SupplierInterfaceInvokeException("\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6\u63a5\u53e3\u62a5\u9519\uff0c\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
        }
        BigDecimal snOrderPriceSum = BigDecimal.ZERO;
        for (Map map : priceResult) {
            BigDecimal snPrice = new BigDecimal(Lang.isEmpty(map.get("snPrice")) ? (Lang.isEmpty(map.get("price")) ? "0" : (String)map.get("price")) : (String)map.get("snPrice"));
            BigDecimal price = new BigDecimal(Lang.isEmpty(map.get("price")) ? "0" : (String)map.get("price"));
            BigDecimal count = BigDecimal.ONE;
            for (OrderItemVo oi : orderRequst.getOrderItems()) {
                if (!oi.getSku().equals(map.get("skuId"))) continue;
                count = new BigDecimal(oi.getCount());
            }
            snOrderPriceSum = snOrderPriceSum.add(price.multiply(count));
            Map snPriceLinkMap = (Map)Lang.findInBeanList(productSnPriceLinks, (String)"sku", map.get("skuId"));
            if (snPriceLinkMap == null) continue;
            snPriceLinkMap.put("snPrice", snPrice);
            snPriceLinkMap.put("price", price);
        }
        log.info("\u5f00\u59cb\u751f\u6210sku\u8bf7\u6c42VO ...");
        long genSkuReqListTime = System.currentTimeMillis();
        request.setSku(this.genSkuReqList(orderRequst, productSnPriceLinks));
        log.info("\u751f\u6210sku\u8bf7\u6c42VO\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - genSkuReqListTime));
        request.setServFee(orderRequst.getFreight().toString());
        request.setAmount(snOrderPriceSum.setScale(2, 4).toString());
        request.setTradeNo(orderRequst.getOrderNo());
        request.setAddress(receiver.getAddressDetail());
        request.setReceiverName(receiver.getUsername());
        request.setMobile(receiver.getPhone());
        request.setProvinceId(addr.getProvinceId());
        request.setCityId(addr.getCityId());
        request.setCountyId(addr.getAreaId());
        request.setTownId(addr.getTownId());
        log.info("\u5f00\u59cb\u67e5\u8be2\u82cf\u5b81\u4e0b\u5355\u914d\u7f6e\u5316\u53c2\u6570...");
        long gennerSuningOrderConstantTime = System.currentTimeMillis();
        this.gennerSuningOrderConstant(request);
        log.info("\u751f\u6210sku\u8bf7\u6c42VO\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - gennerSuningOrderConstantTime));
        log.info("\u5f00\u59cb\u82cf\u5b81\u7b2c\u4e09\u65b9\u63a5\u53e3\u9884\u5360\u5e93\u5b58\u8c03\u7528...");
        long addOrderTime = System.currentTimeMillis();
        String returnStr = this.snCommonConvertApi.addOrder(JSON.toJSONString((Object)request));
        log.info("\u82cf\u5b81\u9884\u5360\u5e93\u5b58\u8fd4\u56de\u4fe1\u606f{}", (Object)returnStr);
        log.info("\u82cf\u5b81\u7b2c\u4e09\u65b9\u63a5\u53e3\u9884\u5360\u5e93\u5b58\u8c03\u7528\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - addOrderTime));
        if (Lang.isEmpty((Object)returnStr)) {
            throw new SupplierInterfaceInvokeException("\u82cf\u5b81\u9884\u5360\u5e93\u5b58\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
        }
        OrderAddResponse response = (OrderAddResponse)JSON.parseObject((String)returnStr, OrderAddResponse.class);
        log.info("\u82cf\u5b81\u9884\u5360\u5e93\u5b58\u8fd4\u56deresponse\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)response));
        if (response.getSnerror() != null) {
            throw new SupplierTakeOrderFalidException(response.getSnerror().getErrorMsg(), SupplierTakeOrderFalidException.ERROR_CODES.SUPPLIER_CUSTOM_ERROR);
        }
        OrderAddResponse.AddOrder addOrder = response.getSnbody().getAddOrder();
        List skusesRes = addOrder.getSkus();
        List updateOrderItems = orderRequst.getOrderItems();
        ArrayList salesPriceCalVoList = new ArrayList();
        ArrayList<TrdOrder> cOrders = new ArrayList<TrdOrder>();
        for (OrderAddResponse.Skus sku : skusesRes) {
            for (OrderItemVo orderItem : updateOrderItems) {
                Map snPriceLinkMap = (Map)Lang.findInBeanList(productSnPriceLinks, (String)"productId", (Object)orderItem.getProductId());
                BigDecimal price = (BigDecimal)snPriceLinkMap.get("price");
                if (!Lang.equals((Object)orderItem.getSku(), (Object)sku.getSkuId())) continue;
                orderItem.setArriveDate(sku.getArriveData());
                orderItem.setOrderLineNumId(sku.getOrderItemId());
                TrdOrder corder = new TrdOrder();
                corder.setTrdOrderNo(sku.getOrderItemId());
                corder.setOrderstate(1);
                corder.setSubmitstate(1);
                corder.setOrderPrice(price.multiply(new BigDecimal(orderItem.getCount())));
                corder.setFreight(new BigDecimal(0));
                TrdOrderSku corderSku = new TrdOrderSku();
                corderSku.setNum(Integer.parseInt(sku.getNum()));
                corderSku.setSkuId(sku.getSkuId());
                corderSku.setPrice(price);
                corderSku.setName(orderItem.getProductName());
                corder.setSku(new ArrayList());
                corder.getSku().add(corderSku);
                cOrders.add(corder);
            }
        }
        TrdOrder trdOrder = new TrdOrder();
        trdOrder.setCorders(cOrders);
        trdOrder.setTrdOrderNo(addOrder.getOrderId());
        trdOrder.setOrderPrice(new BigDecimal(addOrder.getAmount()));
        ArrayList orderSkus = new ArrayList();
        for (TrdOrder corder : cOrders) {
            orderSkus.addAll(corder.getSku());
        }
        trdOrder.setSku(orderSkus);
        trdOrder.setOrderstate(1);
        trdOrder.setSubmitstate(1);
        trdOrder.setFreight(new BigDecimal(0));
        trdOrder.setFinalStatus(TrdOrderHandlerUtils.judteStatus((TrdOrder)trdOrder));
        return trdOrder;
    }

    public void confirmOrder(OrderRequst orderMain) throws SupplierInterfaceInvokeException, SupplierOrderComfirmFalidException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            ConfirmOrderAddRequest request = new ConfirmOrderAddRequest();
            request.setOrderId(orderMain.getThirdOrderNo());
            String returnStr = this.snCommonConvertApi.addConfirmOrder(JSON.toJSONString((Object)request));
            if (Lang.isEmpty((Object)returnStr)) {
                throw new SupplierInterfaceInvokeException("\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6\u63a5\u53e3\u62a5\u9519\uff0c\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", SupplierInterfaceInvokeException.ERROR_CODES.NETWORK_CONNECTION_FAILD);
            }
            ConfirmOrderAddResponse response = (ConfirmOrderAddResponse)JSON.parseObject((String)returnStr, ConfirmOrderAddResponse.class);
            if (response.getSnerror() != null) {
                if ("105".equals(response.getSnerror().getErrorCode())) {
                    throw new SupplierOrderComfirmFalidException(SupplierOrderComfirmFalidException.ERROR_CODES.ALREADY_COMFIRMED_ORDER);
                }
                if ("107".equals(response.getSnerror().getErrorCode()) || "108".equals(response.getSnerror().getErrorCode())) {
                    throw new SupplierOrderComfirmFalidException(SupplierOrderComfirmFalidException.ERROR_CODES.ACCOUNT_BALANCE_ERROR);
                }
                if ("106".equals(response.getSnerror().getErrorCode())) {
                    throw new SupplierOrderComfirmFalidException(SupplierOrderComfirmFalidException.ERROR_CODES.ORDER_CANCELED);
                }
                throw new SupplierOrderComfirmFalidException(response.getSnerror().getErrorMsg(), SupplierOrderComfirmFalidException.ERROR_CODES.SUPPLIER_COMFIRMED_ERROR);
            }
            returnMap.put("returnCode", "success");
        }
        catch (Exception e) {
            returnMap.put("returnCode", "fail");
            returnMap.put("returnMsg", e.getMessage());
        }
    }

    public BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException {
        BackOrderResp resp = new BackOrderResp();
        ApplyRejectedAddRequest request = new ApplyRejectedAddRequest();
        request.setOrderId(orderMain.getThirdOrderNo());
        ArrayList<ApplyRejectedAddRequest.Skus> skuses = new ArrayList<ApplyRejectedAddRequest.Skus>();
        for (String skuId : skuIds) {
            ApplyRejectedAddRequest.Skus skus = new ApplyRejectedAddRequest.Skus();
            skus.setSkuId(skuId);
            skuses.add(skus);
        }
        request.setSkus(skuses);
        ApplyRejectedAddResponse response = this.snOrderApi.addApplyRejected(request);
        if (response.getSnerror() != null) {
            resp.setStatus(Constants.ResponseStatus.ERROR);
            resp.setMessage(response.getSnerror().getErrorMsg());
            return resp;
        }
        List infoLists = response.getSnbody().getAddApplyRejected().getInfoList();
        resp.setBackOrderDetails(new ArrayList());
        for (ApplyRejectedAddResponse.InfoList infoList : infoLists) {
            if (!"0".equals(infoList.getStatus())) continue;
            BackOrderDetail detail = new BackOrderDetail();
            detail.setSkuId(infoList.getSkuId());
            detail.setStatus(infoList.getStatus());
            detail.setUnableReason(infoList.getUnableReason());
            resp.getBackOrderDetails().add(detail);
        }
        return resp;
    }

    public TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        OrderMainDto orderMainDto = this.orderMainApi.findOrderByThirdOrderNo(trdOrderKey.getTrdOrderNo());
        TrdOrder trdOrder = new TrdOrder();
        trdOrder.setOrderPrice(orderMainDto.getOrderPrice());
        trdOrder.setTrdOrderNo(trdOrderKey.getTrdOrderNo());
        trdOrder.setPOrderNo(trdOrderKey.getTrdOrderNo());
        trdOrder.setSubmitstate(1);
        trdOrder.setOrderstate(1);
        return trdOrder;
    }

    private void checkOrderWanner() throws SupplierTakeOrderFalidException {
        String snOrderWarnStr = this.systemConfigApi.getConfigValue("COMMON", "SUNINGORDERCONFIGWARN", "SUNINGORDERCONSTANTWARN", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)snOrderWarnStr) && !TrdOrderHandlerUtils.checkOrderWannerConfigJson((String)snOrderWarnStr).booleanValue()) {
            throw new SupplierTakeOrderFalidException("\u4e0b\u5355\u62e6\u622a\u5df2\u914d\u7f6e", SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
        }
    }

    private void gennerSuningOrderConstant(OrderAddRequest request) {
        String suningOrderConstantStr = this.systemConfigApi.getConfigValue("COMMON", "SUNINGORDERCONFIG", "SUNINGORDERCONSTANT", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)suningOrderConstantStr)) {
            try {
                JSONObject obj = JSON.parseObject((String)suningOrderConstantStr);
                String invoiceContent = (String)obj.get((Object)"invoiceContent");
                String invoiceType = (String)obj.get((Object)"invoiceType");
                String invoiceState = (String)obj.get((Object)"invoiceState");
                String invoiceName = (String)obj.get((Object)"invoiceName");
                String orderType = (String)obj.get((Object)"orderType");
                String paymentType = (String)obj.get((Object)"paymentType");
                request.setInvoiceContent(invoiceContent);
                request.setInvoiceType(invoiceType);
                request.setInvoiceState(invoiceState);
                request.setInvoiceTitle(invoiceName);
                request.setOrderType(orderType);
                request.setPayment(paymentType);
            }
            catch (Exception e) {
                log.info("\u6570\u636e\u5e93\u4fdd\u5b58\u7684\u53c2\u6570\u4fe1\u606f\u662f\u9519\u8bef\u7684\uff0c\u8bf7\u4fee\u6539");
                e.printStackTrace();
                this.defaultGennerSuningOrderConstant(request);
            }
        } else {
            this.defaultGennerSuningOrderConstant(request);
        }
    }

    private void defaultGennerSuningOrderConstant(OrderAddRequest request) {
        request.setInvoiceContent("1");
        request.setInvoiceType("6");
        request.setInvoiceState("1");
        request.setInvoiceTitle("\u592a\u5e73\u91d1\u878d\u670d\u52a1\u6709\u9650\u516c\u53f8");
        request.setOrderType("1");
        request.setPayment("09");
    }

    public AddressVo findSnAddressId(OrderReceiver receiver) {
        AddressVo addressVo = new AddressVo();
        HashMap<Integer, String> areaCodeMap = new HashMap<Integer, String>();
        areaCodeMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), receiver.getProvinceCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), receiver.getCityCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), receiver.getAreaCode());
        areaCodeMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), receiver.getTownCode());
        Map apiAddrRs = this.transAreaCodeMap(areaCodeMap);
        String snProvince = (String)apiAddrRs.get(AddressCommonApi.AddressLevel.PROVINCE.getValue());
        String snCity = (String)apiAddrRs.get(AddressCommonApi.AddressLevel.CITY.getValue());
        String snTown = (String)apiAddrRs.get(AddressCommonApi.AddressLevel.TOWN.getValue());
        if (Lang.isEmpty((Object)snProvince) && Lang.isEmpty((Object)snCity) && Lang.isEmpty((Object)snTown)) {
            return null;
        }
        if (!Lang.isEmpty((Object)receiver.getTownCode())) {
            addressVo.setTownId(snTown);
        }
        addressVo.setProvinceId(snProvince);
        addressVo.setCityId(snCity);
        addressVo.setAreaId((String)apiAddrRs.get(AddressCommonApi.AddressLevel.AREA.getValue()));
        if (snProvince == null && snCity == null) {
            return null;
        }
        return addressVo;
    }

    private List<OrderAddRequest.Sku> genSkuReqList(OrderRequst orderRequst, List<Map> snPriceLinks) {
        ArrayList<OrderAddRequest.Sku> retList = new ArrayList<OrderAddRequest.Sku>();
        for (OrderItemVo orderItem : orderRequst.getOrderItems()) {
            BigDecimal snPrice;
            OrderAddRequest.Sku returnSku = new OrderAddRequest.Sku();
            returnSku.setSkuId(orderItem.getSku());
            if (Lang.isEmpty((Object)orderItem.getSalePrice()) || Lang.isEmpty((Object)orderItem.getCount())) continue;
            returnSku.setNum(orderItem.getCount().toString());
            Map snPriceLink = (Map)Lang.findInBeanList(snPriceLinks, (String)"productId", (Object)orderItem.getProductId());
            if (snPriceLink == null || (snPrice = (BigDecimal)snPriceLink.get("price")) == null) continue;
            returnSku.setUnitPrice(snPrice.setScale(2, 4).toString());
            retList.add(returnSku);
        }
        return retList;
    }

    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        HashMap<Integer, String> trdAreaMap = new HashMap<Integer, String>();
        Map na = this.transToNationAddress(areaMap.get(AddressCommonApi.AddressLevel.PROVINCE.getValue()), areaMap.get(AddressCommonApi.AddressLevel.CITY.getValue()), areaMap.get(AddressCommonApi.AddressLevel.AREA.getValue()), areaMap.get(AddressCommonApi.AddressLevel.TOWN.getValue()));
        if (na != null) {
            trdAreaMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), (String)na.get("provinceId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), (String)na.get("cityId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), (String)na.get("countyId"));
            trdAreaMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), (String)na.get("townId"));
            return trdAreaMap;
        }
        return null;
    }

    private Map transToNationAddress(String provinceCode, String cityCode, String countyCode, String areaCode) {
        HashMap<String, String> addrMap = new HashMap<String, String>();
        if (!Lang.isEmpty((Object)areaCode) && !"0".equals(areaCode)) {
            SnNationalAddress sna = this.transSingleToNationAddress(areaCode, AddressCommonApi.AddressLevel.TOWN);
            if (Lang.isEmpty((Object)sna)) {
                AddressDto address = this.addressCommonApi.findFirstChild(countyCode, "suning", Boolean.valueOf(false));
                AddressDto addressDto = address = address == null ? this.addressCommonApi.findFirstChild(countyCode, "common", Boolean.valueOf(false)) : address;
                if (!Lang.isEmpty((Object)address)) {
                    sna = this.transSingleToNationAddress(address.getId(), AddressCommonApi.AddressLevel.TOWN);
                }
            }
            addrMap.put("townId", sna == null ? "" : sna.getId());
        }
        if (!Lang.isEmpty((Object)countyCode) && !"0".equals(countyCode)) {
            SnNationalAddress county;
            AddressDto addr = this.addressCommonApi.findById(countyCode);
            if (!addr.getStoreCode().equals("common") && !addr.getStoreCode().equals("suning")) {
                String pCode = addr.getParent().getId();
                addr = (addr = this.addressCommonApi.findFirstChild(pCode, "suning", Boolean.valueOf(false))) == null ? this.addressCommonApi.findFirstChild(pCode, "common", Boolean.valueOf(false)) : addr;
                countyCode = addr == null ? countyCode : addr.getId();
            }
            addrMap.put("cityId", (county = this.transSingleToNationAddress(countyCode, AddressCommonApi.AddressLevel.AREA)) == null ? "" : county.getpId());
            addrMap.put("countyId", county == null ? "" : county.getId());
        }
        if (!Lang.isEmpty((Object)cityCode) && !"0".equals(cityCode)) {
            SnNationalAddress snCity = this.transSingleToNationAddress(cityCode, AddressCommonApi.AddressLevel.CITY);
            addrMap.put("cityId", snCity == null ? "" : snCity.getId());
            addrMap.put("provinceId", snCity == null ? "" : snCity.getpId());
        }
        if (!Lang.isEmpty((Object)provinceCode) && !"0".equals(provinceCode)) {
            SnNationalAddress snProvince = this.transSingleToNationAddress(provinceCode, AddressCommonApi.AddressLevel.PROVINCE);
            addrMap.put("provinceId", snProvince == null ? "" : snProvince.getId());
        }
        if (addrMap.size() < 2) {
            return null;
        }
        return addrMap;
    }

    @Transactional(readOnly=true)
    public SnNationalAddress transSingleToNationAddress(String code, AddressCommonApi.AddressLevel lv) {
        SnNationalAddress nAddr = null;
        List snNationalAddressList = this.snNationalAddressRepos.findByLinkId(code);
        if (!Lang.isEmpty((Object)code) && !"0".equals(code)) {
            SnAddressRelation snAddressRelation;
            if (snNationalAddressList != null && snNationalAddressList.size() > 0) {
                nAddr = (SnNationalAddress)snNationalAddressList.get(0);
            } else if (lv == AddressCommonApi.AddressLevel.TOWN && !Lang.isEmpty((Object)(snAddressRelation = this.snAddressRelationRepos.findByAddressId(code)))) {
                SnNationalAddress snNationalAddress;
                nAddr = snNationalAddress = (SnNationalAddress)this.snNationalAddressRepos.findOne((Serializable)((Object)snAddressRelation.getSuningId()));
            }
        }
        return nAddr;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

