/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.metadata.Type;
import member.api.AddressCommonApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.service.service.stub.StoreApiStub;
import outsideapi.vo.FacProductConfirmRequestVo;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.FashionPricesRequestVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import outsideapi.vo.OrderLogisticStatusVo;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.ReserveOrderIdVo;
import outsideapi.vo.ReserveOrderVo;
import outsideapi.vo.ReserveVo;
import outsideapi.vo.ShipTimeResVo;
import outsideapi.vo.ShippLogistRequestVo;
import outsideapi.vo.ShippLogistResVo;
import outsideapi.vo.ShippingFeeRequetVo;
import provider.trdsp.api.TrdspApi;
import provider.trdsp.vo.BusinessResponseVo;
import provider.trdsp.vo.in.FreightVo;
import provider.trdsp.vo.in.SkuVo;
import provider.trdsp.vo.in.SkuVoInput;
import provider.trdsp.vo.in.SubOrderNoVo;
import provider.trdsp.vo.out.LogisticsVo;
import provider.trdsp.vo.out.OrderTrackVo;
import provider.trdsp.vo.out.PriceResultVo;
import provider.trdsp.vo.out.PriceVo;
import provider.trdsp.vo.out.StockResultVo;
import provider.trdsp.vo.out.StockVo;
import provider.trdsp.vo.out.TrdSpFreightVo;
import utils.Lang;
import utils.data.BeanMapper;

@Component(value="trdspOutsideApiHandler")
public class TrdspOutsideApiHandler
implements OutsideApiHandler {
    @MotanReferer
    TrdspApi trdspApi;
    @Autowired
    StoreApiStub storeApi;

    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(FashionStatusRequetVo requet) {
        SkuVoInput skuVoInput = new SkuVoInput();
        ArrayList<String> skuList = new ArrayList<String>();
        List fashionNumsVos = requet.getFashionNums();
        HashMap<String, String> skuFahshionMap = new HashMap<String, String>();
        for (FashionNumsVo fashionNumsvo : fashionNumsVos) {
            String sku = fashionNumsvo.getProductCode();
            skuFahshionMap.put(fashionNumsvo.getProductCode(), fashionNumsvo.getFactionId());
            skuList.add(sku);
        }
        skuVoInput.setSkus(skuList);
        skuVoInput.setCity(requet.getCityCode());
        skuVoInput.setCounty(requet.getCountyCode());
        skuVoInput.setProvince(requet.getProvinceCode());
        skuVoInput.setTown(requet.getTownCode());
        String storeId = requet.getStoreId();
        BusinessResponseVo businessResponseVo = this.trdspApi.getStock(skuVoInput, storeId);
        if (businessResponseVo.getSuccess().booleanValue()) {
            StockResultVo stockResultVo = (StockResultVo)businessResponseVo.getResult();
            List stockVoList = stockResultVo.getSuccessList();
            ArrayList<FashionStockStateVo> fashionStockStateVoList = new ArrayList<FashionStockStateVo>();
            for (StockVo stockVo : stockVoList) {
                FashionStockStateVo fashionStockStateVo = new FashionStockStateVo();
                fashionStockStateVo.setProductCode(stockVo.getSku());
                fashionStockStateVo.setStockCount(stockVo.getCount());
                fashionStockStateVo.setStockFlag(Integer.valueOf(stockVo.getStatus()));
                fashionStockStateVo.setOnSale(Boolean.valueOf(true));
                fashionStockStateVo.setIsAreaRestrict(Boolean.valueOf(false));
                fashionStockStateVo.setFashionId((String)skuFahshionMap.get(stockVo.getSku()));
                fashionStockStateVoList.add(fashionStockStateVo);
            }
            return new HandlerRespVo(fashionStockStateVoList);
        }
        return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR, Integer.valueOf(businessResponseVo.getResultCode()), businessResponseVo.getResultMessage());
    }

    public HandlerRespVo<List<FashionPriceVo>> queryFashionPrice(FashionPriceRequestVo requet) {
        SkuVoInput skuVoInput = new SkuVoInput();
        ArrayList<String> skuList = new ArrayList<String>();
        List fashionPriceParamVos = requet.getFashionPriceParamVos();
        HashMap<String, String> skuFashinMap = new HashMap<String, String>();
        for (FashionPriceParamVo fashionPriceParamVo : fashionPriceParamVos) {
            String sku = fashionPriceParamVo.getProductCode();
            skuFashinMap.put(sku, fashionPriceParamVo.getFactionId());
            skuList.add(sku);
        }
        skuVoInput.setSkus(skuList);
        skuVoInput.setCity(requet.getCityCode());
        skuVoInput.setCounty(requet.getCountyCode());
        skuVoInput.setProvince(requet.getProvinceCode());
        skuVoInput.setTown(requet.getTownCode());
        String storeId = requet.getStoreId();
        BusinessResponseVo businessResponseVo = this.trdspApi.getPrice(skuVoInput, storeId);
        if (businessResponseVo.getSuccess().booleanValue()) {
            PriceResultVo priceResultVo = (PriceResultVo)businessResponseVo.getResult();
            List priceVoList = priceResultVo.getSuccessList();
            ArrayList<FashionPriceVo> fashionPriceVoList = new ArrayList<FashionPriceVo>();
            for (PriceVo priceVo : priceVoList) {
                FashionPriceVo fashionPriceVo = new FashionPriceVo();
                fashionPriceVo.setProductCode(priceVo.getSku());
                fashionPriceVo.setCostPrice(priceVo.getCostPrice());
                fashionPriceVo.setMarketPrice(priceVo.getMarketPrice());
                fashionPriceVo.setSalePrice(priceVo.getCostPrice());
                fashionPriceVo.setFashionId((String)skuFashinMap.get(priceVo.getSku()));
                fashionPriceVoList.add(fashionPriceVo);
            }
            return new HandlerRespVo(fashionPriceVoList);
        }
        return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR, Integer.valueOf(businessResponseVo.getResultCode()), businessResponseVo.getResultMessage());
    }

    public HandlerRespVo<Map<String, Object>> queryShippingFee(ShippingFeeRequetVo requet) {
        String storeId = requet.getStoreId();
        FreightVo freightVo = new FreightVo();
        ArrayList<SkuVo> skuVoList = new ArrayList<SkuVo>();
        List fashionNums = requet.getFashionNums();
        if (Lang.isEmpty((Object)fashionNums)) {
            return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR, Integer.valueOf(6006), "fashionNums\u4e3a\u7a7a");
        }
        for (FashionNumsVo fashionNumsVo : fashionNums) {
            SkuVo skuVo = new SkuVo();
            skuVo.setSku(fashionNumsVo.getProductCode());
            skuVo.setCount(Integer.valueOf(fashionNumsVo.getCounts().intValue()));
            skuVoList.add(skuVo);
        }
        freightVo.setSkuVos(skuVoList);
        freightVo.setCity(requet.getCityCode());
        freightVo.setCounty(requet.getCountyCode());
        freightVo.setProvince(requet.getProvinceCode());
        freightVo.setTown(requet.getTownCode());
        BusinessResponseVo businessResponseVo = this.trdspApi.getFreight(freightVo, storeId);
        if (businessResponseVo.getSuccess().booleanValue()) {
            TrdSpFreightVo trdSpFreightVo = (TrdSpFreightVo)businessResponseVo.getResult();
            HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
            resultMap.put("freight", trdSpFreightVo.getFreight());
            return new HandlerRespVo(resultMap);
        }
        return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR, Integer.valueOf(businessResponseVo.getResultCode()), businessResponseVo.getResultMessage());
    }

    public Object transAreaCode(String areaCode, AddressCommonApi.AddressLevel lv) {
        return null;
    }

    public Map<Integer, String> transAreaCodeMap(Map<Integer, String> areaMap) {
        return null;
    }

    public BigDecimal getSalesPriceRateRangeVal(FashionPricesRequestVo fashionPricesRequestVo) {
        return null;
    }

    public HandlerRespVo<ShippLogistResVo> getOrderLogist(ShippLogistRequestVo request) {
        String storeId = request.getStoreId();
        SubOrderNoVo subOrderNoVo = new SubOrderNoVo();
        subOrderNoVo.setSubOrderNo(request.getOrderNo());
        BusinessResponseVo businessResponseVo = this.trdspApi.getLogistics(subOrderNoVo, storeId);
        if (businessResponseVo.getSuccess().booleanValue()) {
            ShippLogistResVo shippLogistResVo = new ShippLogistResVo();
            ArrayList<OrderLogisticStatusVo> orderLogisticStatusVoList = new ArrayList<OrderLogisticStatusVo>();
            LogisticsVo logisticsVo = (LogisticsVo)businessResponseVo.getResult();
            List OrderTrackVoList = logisticsVo.getOrderTrack();
            for (OrderTrackVo orderTrackVo : OrderTrackVoList) {
                OrderLogisticStatusVo orderLogisticStatusVo = new OrderLogisticStatusVo();
                orderLogisticStatusVo.setOperateTime(orderTrackVo.getMsgTime().toString());
                orderLogisticStatusVoList.add(orderLogisticStatusVo);
            }
            shippLogistResVo.setOrderLogisticStatusVoList(orderLogisticStatusVoList);
            return new HandlerRespVo((Object)shippLogistResVo);
        }
        return new HandlerRespVo(HandlerRespVo.RESPONSE_STATUS_ERROR, Integer.valueOf(businessResponseVo.getResultCode()), businessResponseVo.getResultMessage());
    }

    public HandlerRespVo<Map<String, Object>> facProductConfirm(FacProductConfirmRequestVo requst) {
        return null;
    }

    public HandlerRespVo<List<ShipTimeResVo>> getShipTime(FashionStatusRequetVo requet) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getShipingTrace(String trdOrderNo) {
        HandlerRespVo handlerRespVo = new HandlerRespVo();
        handlerRespVo.setStatus(HandlerRespVo.RESPONSE_STATUS_ERROR);
        handlerRespVo.setMessage("STORE_NOT_SHIPPING");
        handlerRespVo.setErrorCode(Integer.valueOf(1));
        return handlerRespVo;
    }

    public HandlerRespVo<String> getOrderStatus(String trdOrderNo) {
        return null;
    }

    public HandlerRespVo<String> getTrdOrderStatus(String trdOrderNo, String storeId) {
        return null;
    }

    public HandlerRespVo<List<OrderShippingPackageVo>> getCTShipingTrace(String trdOrderNo) {
        return null;
    }

    public HandlerRespVo<ReserveVo> createReservation(ReserveOrderVo reserveOrderVo, String storeCode) {
        provider.trdsp.vo.in.ReserveOrderVo req = (provider.trdsp.vo.in.ReserveOrderVo)BeanMapper.map((Object)reserveOrderVo, (Type)BeanMapper.getType(ReserveOrderVo.class), (Type)BeanMapper.getType(provider.trdsp.vo.in.ReserveOrderVo.class));
        provider.trdsp.vo.out.ReserveVo outReserveVo = this.trdspApi.createReservation(req, this.storeApi.findStoreIdByCode(storeCode));
        return outReserveVo == null ? null : new HandlerRespVo(BeanMapper.map((Object)outReserveVo, (Type)BeanMapper.getType(provider.trdsp.vo.out.ReserveVo.class), (Type)BeanMapper.getType(ReserveVo.class)));
    }

    public HandlerRespVo<Boolean> delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeCode) {
        provider.trdsp.vo.in.ReserveOrderIdVo req = (provider.trdsp.vo.in.ReserveOrderIdVo)BeanMapper.map((Object)reserveOrderIdVo, (Type)BeanMapper.getType(ReserveOrderIdVo.class), (Type)BeanMapper.getType(provider.trdsp.vo.in.ReserveOrderIdVo.class));
        Boolean r = this.trdspApi.delReservation(req, this.storeApi.findStoreIdByCode(storeCode));
        return r == null ? new HandlerRespVo((Object)false) : new HandlerRespVo((Object)r);
    }
}

