/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import cart.api.OrderMainApi;
import cart.api.difinication.OrderMessageContent;
import cart.api.difinication.TrdSpOrderStatus;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import member.api.MemberAddressApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import outsideapi.exceptions.OrderCancelException;
import outsideapi.exceptions.SupplierInterfaceInvokeException;
import outsideapi.exceptions.SupplierOrderComfirmFalidException;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.service.handler.SupplierOrderApiHandler;
import outsideapi.service.utils.TrdOrderHandlerUtils;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.OrderShippingPackageVo;
import outsideapi.vo.order.TrdOrder;
import outsideapi.vo.order.TrdOrderKey;
import outsideapi.vo.order.TrdOrderSku;
import outsideapi.vo.orderrequest.OrderItemVo;
import outsideapi.vo.orderrequest.OrderReceiver;
import outsideapi.vo.orderrequest.OrderRequst;
import provider.message.api.ProviderMessageApi;
import provider.message.dto.ProviderMessageQueueDto;
import provider.trdsp.api.TrdspApi;
import provider.trdsp.vo.BusinessResponseVo;
import provider.trdsp.vo.in.MemberAddress;
import provider.trdsp.vo.in.OrderItem;
import provider.trdsp.vo.in.PreOrderVo;
import provider.trdsp.vo.in.ProviderOrderNoVo;
import store.api.StoreApi;

@Component
public class TrdspSupplierOrderApiHandler
implements SupplierOrderApiHandler {
    private static final Logger log = LoggerFactory.getLogger(TrdspSupplierOrderApiHandler.class);
    @MotanReferer
    private TrdspApi trdspApi;
    @MotanReferer
    private OrderMainApi orderMainApi;
    @MotanReferer
    private ProviderMessageApi providerMessageApi;
    @MotanReferer
    private StoreApi storeApi;
    @MotanReferer
    private MemberAddressApi memberAddressApi;

    public Boolean cancelOrder(TrdOrderKey trdOrderKey) throws OrderCancelException, SupplierInterfaceInvokeException {
        ProviderOrderNoVo providerOrderNoVo = new ProviderOrderNoVo();
        providerOrderNoVo.setProviderOrderNo(trdOrderKey.getTrdOrderNo());
        BusinessResponseVo businessResponseVo = this.trdspApi.delPreOrder(providerOrderNoVo, trdOrderKey.getStoreCode());
        if (businessResponseVo.getSuccess().booleanValue()) {
            if (((Boolean)businessResponseVo.getResult()).booleanValue()) {
                return true;
            }
            throw new OrderCancelException(businessResponseVo.getResultMessage(), OrderCancelException.ERROR_CODES.API_ERROR);
        }
        throw new SupplierInterfaceInvokeException(businessResponseVo.getResultMessage(), SupplierInterfaceInvokeException.ERROR_CODES.TRD_API_HAS_NOT_RESPONSE);
    }

    public TrdOrder takeOrder(OrderRequst orderRequst) throws SupplierTakeOrderFalidException {
        TrdOrder trdOrder = new TrdOrder();
        List orderItemVos = orderRequst.getOrderItems();
        ArrayList<OrderItem> preOrderItems = new ArrayList<OrderItem>();
        for (OrderItemVo orderItemVo : orderItemVos) {
            OrderItem preOrderItem = new OrderItem();
            preOrderItem.setCount(orderItemVo.getCount());
            preOrderItem.setSkuId(orderItemVo.getSku());
            preOrderItem.setCostPrice(orderItemVo.getCostPrice());
            preOrderItem.setName(orderItemVo.getProductName());
            preOrderItems.add(preOrderItem);
        }
        PreOrderVo preOrderVo = new PreOrderVo();
        preOrderVo.setOrderItems(preOrderItems);
        preOrderVo.setCreateTime(orderRequst.getCreateTime());
        preOrderVo.setOrderNo(orderRequst.getOrderNo());
        preOrderVo.setReserveOrderId(orderRequst.getThirdOrderNo());
        preOrderVo.setSumPrice(orderRequst.getSumPrice());
        preOrderVo.setPrice(orderRequst.getOrderPrice());
        preOrderVo.setFreight(orderRequst.getFreight());
        preOrderVo.setPrice(orderRequst.getSumNofreightPrice());
        preOrderVo.setReserveOrderId(orderRequst.getReservationCode());
        OrderReceiver orderReceiver = orderRequst.getOrderReceiver();
        MemberAddress ma = new MemberAddress();
        ma.setReceiverName(orderReceiver.getUsername());
        ma.setReceiverPhone(orderReceiver.getPhone());
        ma.setReceiverProvince(orderReceiver.getProvinceName());
        ma.setReceiverProvinceCode(orderReceiver.getProvinceCode());
        ma.setReceiverCtiy(orderReceiver.getCityName());
        ma.setReceiverCityCode(orderReceiver.getCityCode());
        ma.setReceiverCounty(orderReceiver.getAreaName());
        ma.setReceiverCountyCode(orderReceiver.getAreaCode());
        ma.setReceivertown(orderReceiver.getTownName());
        ma.setReceivertownCode(orderReceiver.getTownCode());
        ma.setReceiverAddressDetails(orderReceiver.getAddressDetail());
        preOrderVo.setMemberAddress(ma);
        BusinessResponseVo businessResponseVo = this.trdspApi.createPreOrder(preOrderVo, orderRequst.getStoreCode());
        if (!businessResponseVo.getSuccess().booleanValue()) {
            throw new SupplierTakeOrderFalidException(businessResponseVo.getResultMessage(), SupplierTakeOrderFalidException.ERROR_CODES.SUPPLIER_CUSTOM_ERROR);
        }
        trdOrder.setOrderPrice(orderRequst.getOrderPrice());
        trdOrder.setFreight(orderRequst.getFreight());
        trdOrder.setPOrderNo(orderRequst.getPOrder());
        trdOrder.setState(0);
        trdOrder.setSubmitstate(0);
        trdOrder.setOrderstate(1);
        trdOrder.setFinalStatus(TrdOrderHandlerUtils.judteStatus((TrdOrder)trdOrder));
        List trdOrderSkuList = orderRequst.getOrderItems().stream().map(it -> {
            TrdOrderSku trdOrderSku = new TrdOrderSku();
            trdOrderSku.setSkuId(it.getSku());
            trdOrderSku.setNum(it.getCount().intValue());
            trdOrderSku.setName(it.getProductName());
            trdOrderSku.setNakedPrice(it.getCostPrice());
            trdOrderSku.setPrice(it.getCostPrice());
            trdOrderSku.setType("0");
            return trdOrderSku;
        }).collect(Collectors.toList());
        trdOrder.setSku(trdOrderSkuList);
        ProviderOrderNoVo providerOrderNoVo = (ProviderOrderNoVo)businessResponseVo.getResult();
        trdOrder.setTrdOrderNo(providerOrderNoVo.getProviderOrderNo());
        return trdOrder;
    }

    public void confirmOrder(OrderRequst orderRequst) throws SupplierOrderComfirmFalidException {
        this.orderMainApi.updateTrdSpStatus(TrdSpOrderStatus.TrdSpNew.getCode(), orderRequst.getThirdOrderNo(), orderRequst.getStoreCode());
        ProviderMessageQueueDto providerMessageQueueDto = new ProviderMessageQueueDto();
        providerMessageQueueDto.setType("1");
        providerMessageQueueDto.setProviderId(this.storeApi.findStoreIdByCode(orderRequst.getStoreCode()));
        OrderMessageContent orderMessageContent = new OrderMessageContent();
        orderMessageContent.setOrderNo(orderRequst.getOrderNo());
        orderMessageContent.setProviderOrderNo(orderRequst.getThirdOrderNo());
        orderMessageContent.setStatus("0");
        providerMessageQueueDto.setMessageContent(JSON.toJSONString((Object)orderMessageContent));
        try {
            this.providerMessageApi.saveMessage(providerMessageQueueDto);
        }
        catch (Exception e) {
            throw new SupplierOrderComfirmFalidException(e.getMessage(), SupplierOrderComfirmFalidException.ERROR_CODES.SUPPLIER_COMFIRMED_ERROR);
        }
    }

    public BackOrderResp backOrder(OrderRequst orderMain, List<String> skuIds) throws SupplierInterfaceInvokeException {
        return null;
    }

    public TrdOrder getDetail(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return null;
    }

    public List<OrderShippingPackageVo> getShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        return null;
    }

    public String getOrderStatus(String trdOrderNo) throws SupplierInterfaceInvokeException {
        return null;
    }

    public List<OrderShippingPackageVo> getCTShipingTrace(String trdOrderNo) throws SupplierInterfaceInvokeException {
        return null;
    }

    public String queryTrdOrderNo(TrdOrderKey trdOrderKey) throws SupplierInterfaceInvokeException {
        return null;
    }
}

