/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.handler.impl;

import cart.api.dto.payment.PaymentDto;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.service.handler.OutsideOrderApiHandler;
import outsideapi.service.service.stub.PaymentApiStub;
import outsideapi.service.service.stub.WnOrderApiStub;
import outsideapi.utils.Constants;
import outsideapi.vo.BackOrderResp;
import outsideapi.vo.CancelOrderResp;
import outsideapi.vo.ConfirmOrderResp;
import outsideapi.vo.OrderResp;
import outsideapi.vo.TakeOrderResp;
import outsideapi.vo.order.OrderItemDto;
import outsideapi.vo.order.OrderMainDto;
import outsideapi.vo.order.TrdOrderResp;
import recharge.center.api.weineng.api.definition.ErrorInfo;
import recharge.center.api.weineng.api.request.OrderEntity;
import utils.Lang;

@Component
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class WnOutsideOrderApiHandler
implements OutsideOrderApiHandler {
    private static final Logger log = LoggerFactory.getLogger(WnOutsideOrderApiHandler.class);
    private final WnOrderApiStub orderApi;
    private final PaymentApiStub paymentApi;

    public CancelOrderResp cancelOrder(String trdOrderNo, String storeId) {
        CancelOrderResp cancelOrderResp = new CancelOrderResp();
        cancelOrderResp.setCode("0");
        cancelOrderResp.setMessage("success");
        cancelOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        return cancelOrderResp;
    }

    public TakeOrderResp takeOrder(OrderMainDto orderMain) {
        recharge.center.api.weineng.api.response.OrderResp orderResp;
        TakeOrderResp takeOrderResp = new TakeOrderResp();
        PaymentDto payment = this.paymentApi.findOne(orderMain.getPaymentId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setCustomerNo(((OrderItemDto)orderMain.getOrderItems().get(0)).getBusinessCode());
        orderEntity.setCardBatchNo(((OrderItemDto)orderMain.getOrderItems().get(0)).getSku().split("_")[1]);
        orderEntity.setOrderId(orderMain.getOrderNo());
        orderEntity.setSubmitTimestamp(sdf.format(new Date()));
        orderEntity.setOrderQuantity(1);
        orderEntity.setOrderTime(sdf.format(new Date()));
        orderEntity.setOrderPoints(payment.getMoney().multiply(new BigDecimal("100")).intValue());
        log.info("\u5fae\u80fd\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570 : {}", (Object)JSON.toJSONString((Object)orderEntity));
        try {
            long takeOrderTime = System.currentTimeMillis();
            log.info("\u6b63\u5728\u8c03\u7528\u5fae\u80fd\u4f9b\u5e94\u5546\u63a5\u53e3\u4e0b\u5355...");
            orderResp = this.orderApi.takeOrder(orderEntity);
            log.info("\u8c03\u7528\u5fae\u80fd\u4f9b\u5e94\u5546\u63a5\u53e3\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - takeOrderTime));
            log.info("\u8c03\u7528\u5fae\u80fd\u4f9b\u5e94\u5546\u63a5\u53e3\u8fd4\u56de\u6570\u636e : {}", (Object)orderResp);
            if (Lang.isEmpty((Object)orderResp)) {
                throw new RuntimeException("\u7a7a\u7684\u54cd\u5e94\u5bf9\u8c61");
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u80fd\u4f9b\u5e94\u5546\u4e0b\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            takeOrderResp.setReturnCode("1");
            takeOrderResp.setReturnMsg("\u8c03\u7528\u5fae\u80fd\u4f9b\u5e94\u5546\u4e0b\u5355\u63a5\u53e3\u5f02\u5e38 : " + e.getMessage());
            takeOrderResp.setStatus(Constants.ResponseStatus.ERROR);
            return takeOrderResp;
        }
        String successCode = "0000";
        if ("0000".equals(orderResp.getRetResult())) {
            OrderResp returnOrderResp = new OrderResp();
            returnOrderResp.setTrdOrderNo(orderResp.getWnOrderId());
            takeOrderResp.setOrderResp(returnOrderResp);
            takeOrderResp.setReturnCode("0");
            takeOrderResp.setReturnMsg("\u5fae\u80fd\u4f9b\u5e94\u5546\u4e0b\u5355\u6210\u529f");
            takeOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        } else {
            takeOrderResp.setReturnCode("2");
            takeOrderResp.setReturnMsg("\u5fae\u80fd\u4f9b\u5e94\u5546\u4e0b\u5355\u5931\u8d25. " + orderResp.getRetResult() + " : " + (String)ErrorInfo.errorMap.get(orderResp.getRetResult()));
            takeOrderResp.setStatus(Constants.ResponseStatus.ERROR);
        }
        log.info("\u65b9\u6cd5\u7ed3\u675f\u8fd4\u56de\u5bf9\u8c61 : {}", (Object)JSON.toJSONString((Object)takeOrderResp));
        return takeOrderResp;
    }

    public ConfirmOrderResp confirmOrder(String trdOrderNo, String storeId) {
        ConfirmOrderResp confirmOrderResp = new ConfirmOrderResp();
        confirmOrderResp.setCode("0");
        confirmOrderResp.setMessage("SUCCESS");
        confirmOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        return confirmOrderResp;
    }

    public BackOrderResp backOrder(OrderMainDto orderMain, List<String> skuIds) {
        BackOrderResp backOrderResp = new BackOrderResp();
        backOrderResp.setCode("0");
        backOrderResp.setMessage("SUCCESS");
        backOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        return backOrderResp;
    }

    public String queryTrdOrderNo(String orderNo) {
        return orderNo + "_TRD";
    }

    public TrdOrderResp queryOrder(String trdOrderNo) {
        TrdOrderResp queryOrderResp = new TrdOrderResp();
        queryOrderResp.setCode("0");
        queryOrderResp.setMessage("SUCCESS");
        queryOrderResp.setStatus(Constants.ResponseStatus.SUCCESS);
        return queryOrderResp;
    }

    @Autowired
    public WnOutsideOrderApiHandler(WnOrderApiStub orderApi, PaymentApiStub paymentApi) {
        this.orderApi = orderApi;
        this.paymentApi = paymentApi;
    }
}

