/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import outsideapi.model.OutsideapiHandlerConfigs;
import outsideapi.model.OutsideapiHandlerConfigs_;
import outsideapi.model.repository.OutsideapiHandlerConfigsRepos;
import outsideapi.service.handler.OutsideApiHandler;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerKey;
import outsideapi.vo.HandlerRespVo;
import utils.Lang;

@Component
@Service
@Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
public class OutsideApiService {
    private static final Logger log = LoggerFactory.getLogger(OutsideApiService.class);
    @Autowired
    OutsideapiHandlerConfigsRepos outsideapiHandlerConfigsRepos;

    public HandlerRespVo<List<FashionStockStateVo>> queryFashionStockState(OutsideApiHandler handler, FashionStatusRequetVo requet) {
        return handler.queryFashionStockState(requet);
    }

    public OutsideapiHandlerConfigs getHandlerConfigs(HandlerKey handlerKey) {
        List dbRs = this.outsideapiHandlerConfigsRepos.findAll((root, query, cb) -> {
            ArrayList<Predicate> andQuerys = new ArrayList<Predicate>();
            if (!Lang.isEmpty((Object)handlerKey.getStoreType())) {
                andQuerys.add(cb.equal((Expression)root.get(OutsideapiHandlerConfigs_.storeType), (Object)handlerKey.getStoreType()));
            }
            if (!Lang.isEmpty((Object)handlerKey.getStoreCode())) {
                andQuerys.add(cb.equal((Expression)root.get(OutsideapiHandlerConfigs_.storeCode), (Object)handlerKey.getStoreCode()));
            }
            if (!Lang.isEmpty((Object)handlerKey.getProductType())) {
                andQuerys.add(cb.equal((Expression)root.get(OutsideapiHandlerConfigs_.productType), (Object)handlerKey.getProductType()));
            }
            if (!Lang.isEmpty((Object)handlerKey.getInterfaceName())) {
                andQuerys.add(cb.equal((Expression)root.get(OutsideapiHandlerConfigs_.handlerInterfaceName), (Object)handlerKey.getInterfaceName()));
            }
            andQuerys.add(cb.notEqual((Expression)root.get(OutsideapiHandlerConfigs_.isDelete), (Object)true));
            return cb.and(andQuerys.toArray(new Predicate[0]));
        });
        return dbRs != null && dbRs.size() > 0 ? (OutsideapiHandlerConfigs)dbRs.get(0) : null;
    }
}

