/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.service.stub;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.mapdto.UnreviewedStoreDto;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreExtDto;
import utils.Lang;

@Service
@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class StoreApiStub {
    private static final Logger log = LoggerFactory.getLogger(StoreApiStub.class);
    public static final String STORE_ID_CODE_CACHE_KEY = "OUTSIDE:STORE:ID_CODE_CACHE";
    public static final String STORE_OBJECT_CACHE_KEY = "OUTSIDE:STORE:OBJECT_CACHE";
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    RedisTemplate redisTemplate;

    public List<StoreDto> findByTpye(String type) {
        return this.storeApi.findByTpye(type);
    }

    public StoreDto findByStoreId(String storeId) {
        String key = String.format("%s:%s", STORE_OBJECT_CACHE_KEY, storeId);
        BoundValueOperations opt = this.redisTemplate.boundValueOps((Object)key);
        opt.expire(30L, TimeUnit.SECONDS);
        StoreDto v = (StoreDto)opt.get();
        if (v == null) {
            v = this.storeApi.findByStoreId(storeId);
        }
        return v;
    }

    public List<StoreDto> findByStoreIds(List<String> storeIds) {
        return this.storeApi.findByStoreIds(storeIds);
    }

    public StoreDto getStoreInfo(String storeId) {
        return this.storeApi.getStoreInfo(storeId);
    }

    public List<StoreDto> getStoreList() {
        return this.storeApi.getStoreList();
    }

    public List<StoreDto> findStoreList() {
        return this.storeApi.findStoreList();
    }

    public UnreviewedStoreDto getUnreviewedStores(String name, Pageable pageable) {
        return this.storeApi.getUnreviewedStores(name, pageable);
    }

    public Map loadStoreVoByStoreExt(StoreExtDto storeExt) {
        return this.storeApi.loadStoreVoByStoreExt(storeExt);
    }

    public Map<String, List<StoreDto>> listStoreForIndex() {
        return this.storeApi.listStoreForIndex();
    }

    public List<StoreDto> findStoreByMember(String memberId) {
        return this.storeApi.findStoreByMember(memberId);
    }

    public Map listToMap() {
        return this.storeApi.listToMap();
    }

    public String getStoreCode(String storeId) {
        return this.storeApi.getStoreCode(storeId);
    }

    public List<StoreDto> findPassStore() {
        return this.storeApi.findPassStore();
    }

    public StoreDto findByCode(String code) {
        return this.storeApi.findByCode(code);
    }

    public List<String> getMemberStoreIds(String memberId) {
        return this.storeApi.getMemberStoreIds(memberId);
    }

    public StoreDto saveStore(StoreDto store) {
        return this.storeApi.saveStore(store);
    }

    public String findStoreIdByCode(String storeCode) {
        BoundHashOperations ops = this.redisTemplate.boundHashOps((Object)STORE_ID_CODE_CACHE_KEY);
        String id = null;
        for (Map.Entry entry : ops.entries().entrySet()) {
            if (!((String)entry.getValue()).equals(storeCode)) continue;
            id = (String)entry.getKey();
            break;
        }
        if (Lang.isEmpty(id)) {
            id = this.storeApi.findStoreIdByCode(storeCode);
            ops.expire(100L, TimeUnit.SECONDS);
            ops.put((Object)storeCode, (Object)id);
        }
        return id;
    }

    public String findStoreCodeById(String id) {
        BoundHashOperations ops = this.redisTemplate.boundHashOps((Object)STORE_ID_CODE_CACHE_KEY);
        String v = (String)ops.get((Object)id);
        if (Lang.isEmpty((Object)v)) {
            v = this.storeApi.findStoreCodeById(id);
            ops.put((Object)id, (Object)v);
        }
        return v;
    }

    public StoreDto findByDVendorId(String dVendorId) {
        return this.storeApi.findByDVendorId(dVendorId);
    }
}

