/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.utils;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import outsideapi.service.factory.OutsideApiHandlerFactory;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;

@Component
public class OutsideApiFactoryUtil
implements ApplicationContextAware {
    private static final String FACTORY_NAME_CONFIG_KEY = "outside.common.apihandler.factor";
    private static final String FACTORY_BEAN_CONFIG_KEY = "outside.common.apihandler.factor.bean";
    private ApplicationContext applicationContext;
    @Autowired
    private Environment env;
    @MotanReferer
    StoreApi storeApi;

    public OutsideApiHandlerFactory getFactory() {
        return this.getFactory(this.readProp(FACTORY_BEAN_CONFIG_KEY));
    }

    public OutsideApiHandlerFactory getFactory(String factoryBeanName) {
        OutsideApiHandlerFactory factory = (OutsideApiHandlerFactory)this.applicationContext.getBean(factoryBeanName);
        return factory;
    }

    public OutsideApiHandlerFactory getFactory(Class factoryBeanName) {
        OutsideApiHandlerFactory factory = (OutsideApiHandlerFactory)this.applicationContext.getBean(factoryBeanName);
        return factory;
    }

    public String readProp(String key) {
        return this.env.getProperty(key);
    }

    public StoreDto findStoreById(String id) {
        return this.storeApi.getStoreInfo(id);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

