/*
 * Decompiled with CFR 0.152.
 */
package outsideapi.service.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import outsideapi.exceptions.SupplierTakeOrderFalidException;
import outsideapi.vo.order.TrdOrder;
import utils.GlobalContants;

public class TrdOrderHandlerUtils {
    private static final Logger log = LoggerFactory.getLogger(TrdOrderHandlerUtils.class);

    public static Boolean checkOrderWannerConfigJson(String configJson) throws SupplierTakeOrderFalidException {
        try {
            JSONObject obj = JSON.parseObject((String)configJson);
            Boolean isWarn = (Boolean)obj.get((Object)"isWarn");
            String message = (String)obj.get((Object)"message");
            if (isWarn.booleanValue()) {
                throw new SupplierTakeOrderFalidException(message, SupplierTakeOrderFalidException.ERROR_CODES.TAKE_ORDER_INTERCEPTED);
            }
        }
        catch (Exception e) {
            log.info("\u6570\u636e\u5e93\u4fdd\u5b58\u7684\u53c2\u6570\u4fe1\u606f\u662f\u9519\u8bef\u7684\uff0c\u8bf7\u4fee\u6539");
            throw new SupplierTakeOrderFalidException(e.getMessage(), SupplierTakeOrderFalidException.ERROR_CODES.ILLEGAL_TAKE_ORDER_INTERCEPT_CONFIG, (Throwable)e);
        }
        return true;
    }

    public static GlobalContants.ORDER_STATUS judteStatus(TrdOrder trdOrder) {
        List corders = trdOrder.getCorders();
        ArrayList<Integer> states = new ArrayList<Integer>();
        if (corders != null && corders.size() > 0) {
            for (TrdOrder corder : corders) {
                states.add(corder.getState());
            }
        } else {
            states.add(trdOrder.getState());
        }
        Boolean isConfirm = null;
        Boolean isRefuse = false;
        for (Integer state : states) {
            switch (state) {
                case 0: {
                    isConfirm = false;
                    break;
                }
                case 1: {
                    isConfirm = (isConfirm == null || isConfirm != false) && isConfirm != false;
                    break;
                }
                case 2: {
                    isConfirm = false;
                    isRefuse = true;
                }
            }
        }
        if (trdOrder.getSubmitstate() != 1) {
            return GlobalContants.ORDER_STATUS.NEWORDER;
        }
        if (trdOrder.getOrderstate() == 0) {
            return GlobalContants.ORDER_STATUS.OUTOFTIME_CANCEL;
        }
        if (isRefuse.booleanValue()) {
            return GlobalContants.ORDER_STATUS.REFUSE;
        }
        if (isConfirm.booleanValue()) {
            return GlobalContants.ORDER_STATUS.EVALUATE;
        }
        return GlobalContants.ORDER_STATUS.OUNFILLED;
    }
}

