package provider.trdsp.model.po;

import org.hibernate.annotations.GenericGenerator;
import provider.trdsp.model.po.base.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author Lans
 * @date 2018-8-27 11:22
 */
@Entity
@Table
public class TrdSpInfo extends BaseDomain implements Serializable {
    private String id;
    private String storeId;
    private String url;
    private String description;
    private String clientId;
    private String clientSecret;
    private String username;
    private String password;
    private String grantType;
    private String scope;

    private Integer version;
    private Boolean isDelete;
    private Timestamp dateCreated;
    private Timestamp deleteDate;
    private Timestamp lastUpdated;

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Basic
    @Column(name = "STORE_ID", nullable = false, length = 50)
    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Basic
    @Column(name = "URL", nullable = false, length = 1000)
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Basic
    @Column(name = "DESCRIPTION", nullable = true, length = 1000)
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }





    @Basic
    @Column(name = "CLIENT_ID", nullable = true, length = 100)
    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Basic
    @Column(name = "CLIENT_SECRET", nullable = true, length = 100)
    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Basic
    @Column(name = "USERNAME", nullable = true, length = 100)
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Basic
    @Column(name = "PASSWORD", nullable = true, length = 100)
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Basic
    @Column(name = "GRANT_TYPE", nullable = true, length = 100)
    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Basic
    @Column(name = "SCOPE", nullable = true, length = 100)
    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TrdSpInfo trdSpInfo = (TrdSpInfo) o;

        if (id != null ? !id.equals(trdSpInfo.id) : trdSpInfo.id != null) return false;
        if (storeId != null ? !storeId.equals(trdSpInfo.storeId) : trdSpInfo.storeId != null) return false;
        if (url != null ? !url.equals(trdSpInfo.url) : trdSpInfo.url != null) return false;
        if (description != null ? !description.equals(trdSpInfo.description) : trdSpInfo.description != null)
            return false;
        if (clientId != null ? !clientId.equals(trdSpInfo.clientId) : trdSpInfo.clientId != null) return false;
        if (clientSecret != null ? !clientSecret.equals(trdSpInfo.clientSecret) : trdSpInfo.clientSecret != null)
            return false;
        if (username != null ? !username.equals(trdSpInfo.username) : trdSpInfo.username != null) return false;
        if (password != null ? !password.equals(trdSpInfo.password) : trdSpInfo.password != null) return false;
        if (grantType != null ? !grantType.equals(trdSpInfo.grantType) : trdSpInfo.grantType != null) return false;
        if (scope != null ? !scope.equals(trdSpInfo.scope) : trdSpInfo.scope != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (storeId != null ? storeId.hashCode() : 0);
        result = 31 * result + (url != null ? url.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
               result = 31 * result + (clientId != null ? clientId.hashCode() : 0);
        result = 31 * result + (clientSecret != null ? clientSecret.hashCode() : 0);
        result = 31 * result + (username != null ? username.hashCode() : 0);
        result = 31 * result + (password != null ? password.hashCode() : 0);
        result = 31 * result + (grantType != null ? grantType.hashCode() : 0);
        result = 31 * result + (scope != null ? scope.hashCode() : 0);
        return result;
    }
}
