package provider.trdsp.model.po;

import org.hibernate.annotations.GenericGenerator;
import provider.trdsp.model.po.base.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author Lans
 * @date 2018-7-31 10:54
 */
@Entity
@Table
public class TrdSpUrl extends BaseDomain implements Serializable {
    private String id;
    private String storeId;
    private String url;
    private String description;


    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Basic
    @Column(name = "STORE_ID", nullable = false, length = 50)
    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Basic
    @Column(name = "URL", nullable = false, length = 1000)
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Basic
    @Column(name = "DESCRIPTION", nullable = true, length = 1000)
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TrdSpUrl trdSpUrl = (TrdSpUrl) o;

        if (id != null ? !id.equals(trdSpUrl.id) : trdSpUrl.id != null) {
            return false;
        }

        if (storeId != null ? !storeId.equals(trdSpUrl.storeId) : trdSpUrl.storeId != null) {
            return false;
        }
        if (url != null ? !url.equals(trdSpUrl.url) : trdSpUrl.url != null) {
            return false;
        }
        return description != null ? description.equals(trdSpUrl.description) : trdSpUrl.description == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (storeId != null ? storeId.hashCode() : 0);
        result = 31 * result + (url != null ? url.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        return result;
    }
}
