package provider.trdsp.service.apiImpl;

import cart.api.exception.BusinessException;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import provider.trdsp.ReturnMessage;
import provider.trdsp.api.TrdspApi;
import provider.trdsp.model.po.TrdSpInfo;
import provider.trdsp.service.config.ApiRestTemplate;
import provider.trdsp.service.config.Const;
import provider.trdsp.service.config.TrdspConfig;
import provider.trdsp.service.service.TrdSpUrlService;
import provider.trdsp.vo.BusinessResponseVo;
import provider.trdsp.vo.TokenVo;
import provider.trdsp.vo.in.*;
import provider.trdsp.vo.out.*;
import utils.Lang;
import utils.security.MD5Utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author Lans
 * @date 2018-7-13 14:30
 */

@MotanService
public  class TrdspApiImpl implements TrdspApi {
    @Autowired
    TrdspConfig trdspConfig;
    //    String baseServiceUrl ="127.0.0.1/api";
    //SslRestTemplate sslRestTemplate = new SslRestTemplate();
//    ApiRestTemplate sslRestTemplate = new ApiRestTemplate();
    @Autowired
    private ApiRestTemplate sslRestTemplate;
    public static Logger logger = LoggerFactory.getLogger(TrdspApiImpl.class);
    String urlParam = "?access_token={access_token}&version={version}&timestamp={timestamp}";

    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    TrdSpUrlService trdSpUrlService;

    public  String getBaseUrlByStoreId(String storeId){
        return this.getTrdSpInfoByStoreId(storeId).getUrl();
    }

    public TrdSpInfo getTrdSpInfoByStoreId(String storeId){
        return trdSpUrlService.getTrdSpInfoByStoreId(storeId);
    }

    /**
     * 8.3物流查询接口
     *
     *  @param subOrderNoVo @return 物流Ｖｏ
     * @param storeId
     */
    @Override
    public BusinessResponseVo<LogisticsVo> getLogistics(SubOrderNoVo subOrderNoVo, String storeId) {

      //  String url =getBaseUrlByStoreId(storeId) + "/get/logisitics" + urlParam;
        String url = getBaseUrlByStoreId(storeId)+ "/get/logisitics" + urlParam;
        Map<String, Object>
                params = initParam(storeId);
        try {
            logger.info("=====================获取三方供应商物流请求参数:{}", JSON.toJSONString(subOrderNoVo));
            BusinessResponseVo<LogisticsVo> businessResponseVo = sslRestTemplate.postForObject(url, subOrderNoVo, new ParameterizedTypeReference<BusinessResponseVo<LogisticsVo>>() {
            }, params);
//            LogisticsVo logisticsVo = businessResponseVo.getResult();
            logger.info("=====================获取三方供应商物流响应参数:{}", JSON.toJSONString(businessResponseVo));
            return businessResponseVo;
        } catch (Exception e) {
            logger.error("=====================获取三方供应商物流出错，错误信息:{}", e.getMessage());
            throw new BusinessException("获取三方供应商物流出错", e);
        }



    }

    /**
     * 8.4查询运费
     *
     * @param freightVo
     * @param storeId
     * @return 运费
     */
    @Override
    public BusinessResponseVo<TrdSpFreightVo> getFreight(FreightVo freightVo, String storeId) {
        String url = getBaseUrlByStoreId(storeId) + "/get/freight" + urlParam;
        Map<String, Object> params = initParam(storeId);

        try {
            logger.info("=====================获取三方供应商运费请求参数:{}", JSON.toJSONString(freightVo));
            BusinessResponseVo<TrdSpFreightVo> businessResponseVo = sslRestTemplate.postForObject(url, freightVo, new ParameterizedTypeReference<BusinessResponseVo<TrdSpFreightVo>>() {
            }, params);
          //  TrdSpFreightVo trdSpFreightVo = businessResponseVo.getResult();
            logger.info("=====================获取三方供应商运费响应参数:{}", JSON.toJSONString(businessResponseVo));
//            if(Lang.isEmpty(trdSpFreightVo)){
//            return null;
//            }else {
//                return trdSpFreightVo.getFreight();
//            }
            return businessResponseVo;
        } catch (Exception e) {
            logger.error("=====================获取三方供应商运费出错，错误信息:{}", e.getMessage());
            throw new BusinessException("获取三方供应商运费出错", e);
        }


    }


    /**
     * 8.5查询官网实时价格
     *
     * @param skuVoInput
     * @param storeId
     * @return OnlinePriceVo
     * @throws BusinessException
     */
    @Override
    public BusinessResponseVo<OnlinePriceResultVo> getOnlinePrice(SkuVoInput skuVoInput, String storeId) throws BusinessException {
        if (skuVoInput.getSkus().size() > Const.SKU_OPEREATE_LIMIT) {
            throw new BusinessException(ReturnMessage.PARAMS_LIMITED_100);
        }
        String url = getBaseUrlByStoreId(storeId) + "/get/online_price" + urlParam;
        Map<String, Object> params = initParam(storeId);
        try {
            logger.info("=====================获取三方供应商在线价格请求参数:{}", JSON.toJSONString(skuVoInput));
            BusinessResponseVo<OnlinePriceResultVo> businessResponseVo = sslRestTemplate.postForObject(url, skuVoInput, new ParameterizedTypeReference<BusinessResponseVo<OnlinePriceResultVo>>() {
            }, params);
            logger.info("=====================获取三方供应商在线价格响应参数:{}",  JSON.toJSONString(businessResponseVo));
            return businessResponseVo;
        } catch (Exception e) {
            logger.error("=====================获取三方供应商在线价格出错，错误信息:{}", e.getMessage());
            throw new BusinessException("获取三方供应商在线价格出错", e);
        }
    }

    /**
     * 8.6查询库存数量
     *
     * @param skuVoInput
     * @param storeId
     * @return 库存数量
     */
    @Override
    public BusinessResponseVo<StockResultVo> getStock(SkuVoInput skuVoInput, String storeId) throws BusinessException {
        if (skuVoInput.getSkus().size() > Const.SKU_OPEREATE_LIMIT) {
            throw new BusinessException(ReturnMessage.PARAMS_LIMITED_100);
        }
        String url = getBaseUrlByStoreId(storeId) + "/get/stock" + urlParam;

        Map<String, Object> params = initParam(storeId);
        try {
            logger.info("=====================获取三方库存数量请求参数:{}", JSON.toJSONString(skuVoInput));
            BusinessResponseVo<StockResultVo> businessResponseVo = sslRestTemplate.postForObject(url, skuVoInput, new ParameterizedTypeReference<BusinessResponseVo<StockResultVo>>() {
            }, params);
//            List<StockVo> stockVoList = businessResponseVo.getResult();
            logger.info("=====================获取三方库存数量响应参数:{}", JSON.toJSONString(businessResponseVo));
            return businessResponseVo;
        } catch (Exception e) {
            logger.error("=====================获取三方库存数量出错，错误信息:{}", e.getMessage());
            throw new BusinessException("获取三方库存数量出错", e);
        }
    }

    /**
     * 8.7查询价格
     *
     * @param skuVoInput
     * @param storeId
     * @return 价格信息
     */
    @Override
    public  BusinessResponseVo<PriceResultVo>  getPrice(SkuVoInput skuVoInput, String storeId) throws BusinessException  {
        if (skuVoInput.getSkus().size() > Const.SKU_OPEREATE_LIMIT) {
            throw new BusinessException(ReturnMessage.PARAMS_LIMITED_100);
        }
        String url = getBaseUrlByStoreId(storeId) + "/get/price" + urlParam;
        Map<String, Object> params = initParam(storeId);
        try {
            logger.info("=====================获取三方供应商价格请求参数:{}", JSON.toJSONString(skuVoInput));
            BusinessResponseVo<PriceResultVo> businessResponseVo = sslRestTemplate.postForObject(url, skuVoInput, new ParameterizedTypeReference<BusinessResponseVo<PriceResultVo>>() {
            }, params);
            logger.info("=====================获取三方供应商价格响应参数:{}", JSON.toJSONString(businessResponseVo));
            return businessResponseVo;
        } catch (Exception e) {
            logger.error("=====================获取三方供应商价格出错，错误信息:{}", e.getMessage());
            throw new BusinessException("获取三方供应商在线价格出错", e);
        }
    }

    /**
     * 8.8 生成预占单
     * @param reserveOrderVo
     * @param storeId
     * @return 预订单ｉｄ对象
     */
    @Override
    public ReserveVo createReservation(ReserveOrderVo reserveOrderVo, String storeId) {
        String url = getBaseUrlByStoreId(storeId) + "/create/reservation" + urlParam;
        Map<String, Object> params = initParam(storeId);
        try {
            logger.info("=====================三方供应商生成预占单请求参数:{}", JSON.toJSONString(reserveOrderVo));
            BusinessResponseVo<ReserveVo> businessResponseVo = sslRestTemplate.postForObject(url, reserveOrderVo, new ParameterizedTypeReference<BusinessResponseVo<ReserveVo>>() {
            }, params);
            ReserveVo reserveVo = businessResponseVo.getResult();
            logger.info("=====================三方供应商生成预占单响应参数:{}", JSON.toJSONString(businessResponseVo));
            return reserveVo;
        } catch (Exception e) {
            logger.error("=====================三方供应商生成预占单出错，错误信息:{}", e.getMessage());
            throw new BusinessException("三方供应商生成预占单出错", e);
        }
    }


    /**
     *8.9　删除预占单　
     * @param reserveOrderIdVo
     * @param storeId
     * @return true/false
     */
    @Override
    public Boolean delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeId) {
        String url = getBaseUrlByStoreId(storeId) + "/delete/reservation" + urlParam;
        Map<String, Object> params = initParam(storeId);
        try {
            logger.info("=====================三方供应商取消预占单请求参数:{}",reserveOrderIdVo.getReserveOrderId());
            BusinessResponseVo<Boolean> businessResponseVo = sslRestTemplate.postForObject(url, reserveOrderIdVo, new ParameterizedTypeReference<BusinessResponseVo<Boolean>>() {
            }, params);
            Boolean result = businessResponseVo.getResult();
            logger.info("=====================三方供应商取消预占单响应参数:{}", JSON.toJSONString(businessResponseVo));
            return result;
        } catch (Exception e) {
            logger.error("=====================三方供应商取消预占单出错，错误信息:{}", e.getMessage());
            throw new BusinessException("三方供应商取消预占单出错", e);
        }
    }

    /**
     * 8.10　生成预订单
     * @param preOrderVo
     * @param storeId
     * @return　预订单No
     */
    @Override
    public  BusinessResponseVo<ProviderOrderNoVo> createPreOrder(PreOrderVo preOrderVo, String storeId) {
        String url = getBaseUrlByStoreId(storeId) + "/create/pre_order" + urlParam;
        Map<String, Object> params = initParam(storeId);
        try {
            logger.info("=====================三方供应商生成预订单请求参数:{}", JSON.toJSONString(preOrderVo));
            BusinessResponseVo<ProviderOrderNoVo> businessResponseVo = sslRestTemplate.postForObject(url, preOrderVo, new ParameterizedTypeReference<BusinessResponseVo<ProviderOrderNoVo>>() {
            }, params);
//            ProviderOrderNoVo providerOrderNoVo = businessResponseVo.getResult();
            logger.info("=====================三方供应商生成预订单响应参数:{}", JSON.toJSONString(businessResponseVo));
                return businessResponseVo;
        } catch (Exception e) {
            logger.error("=====================三方供应商生成预订单出错，错误信息:{}", e.getMessage());
            throw new BusinessException("三方供应商生成预订单出错", e);
        }
    }

    /**
     * 取消预订单
     * @param providerOrderNoVo
     * @param storeId
     * @return　true/false
     */
    @Override
    public BusinessResponseVo<Boolean> delPreOrder(ProviderOrderNoVo providerOrderNoVo, String storeId) {
        String url = getBaseUrlByStoreId(storeId) + "/delete/pre_order" + urlParam;
        Map<String, Object> params = initParam(storeId);
        try {
            logger.info("=====================三方供应商取消预定单请求参数:{}", JSON.toJSONString(providerOrderNoVo));
            BusinessResponseVo<Boolean> businessResponseVo = sslRestTemplate.postForObject(url, providerOrderNoVo, new ParameterizedTypeReference<BusinessResponseVo<Boolean>>() {
            }, params);
            logger.info("=====================三方供应商取消预定单响应参数:{}", JSON.toJSONString(businessResponseVo));
            return businessResponseVo;
        } catch (Exception e) {
            logger.error("=====================三方供应商取消预定单出错，错误信息:{}", e.getMessage());
            throw new BusinessException("三方供应商取消预定单出错", e);
        }
    }

//    @Override
//    public TokenVo getTokenVo(String storeId) {
//        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
//        //得力
////        String clientId = "TaiPing";
////        String clientSecret = "123456";
//        //史泰博
//        //    String clientId = "9000002954";
////    String clientSecret = "9000002954";
//        String clientId = clientIdMap.get(storeId);
//        String clientSecret = clientSecretMap.get(storeId);
//
//        String username = "TaiPing";
//        String password = "adb360a0bf35b8340d7278065860fd26";
//        String grantType = "password";
////        String grantType = "access_token";
//        String timestamp = format.format(new Date());
//        String scope = "";
//        String signStr = new StringBuilder().append(clientSecret).append(timestamp).append(clientId).append(username).append(password).append(grantType).append(scope).append(clientSecret).toString();
//        String sign = null;
//        try {
//            sign = MD5Utils.encrypt(signStr).toUpperCase();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        Map<String, Object> params = new HashMap<>();
//        params.put("client_id", clientId);
//        params.put("client_secret", clientSecret);
//        params.put("username", username);
//        params.put("password", password);
//        params.put("grant_type", grantType);
//        params.put("timestamp", timestamp);
//        params.put("scope", scope);
//        params.put("sign", sign);
//        String tokenUrl = getBaseUrlByStoreId(storeId) + "/oauth/token?client_id={client_id}&client_secret={client_secret}&scope={scope}&grant_type={grant_type}&username={username}&password={password}&timestamp={timestamp}&sign={sign}";
//        BusinessResponseVo<TokenVo> businessResponseVo = sslRestTemplate.postForObject(tokenUrl, null, new ParameterizedTypeReference<BusinessResponseVo<TokenVo>>() {
//        }, params);
//        TokenVo tokenVo = businessResponseVo.getResult();
//        return tokenVo;
//    }

    @Override
    public TokenVo getTokenVo(String storeId) {
        String key = "TokenVo"+storeId;
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(key);
        if(boundValueOperations.get() !=null){
            TokenVo tokenVo = (TokenVo) boundValueOperations.get();
            return  tokenVo;
        }else {
            return  getTokenFromTrdSp(storeId);
        }

    }

    @Override
    public TokenVo  getTokenFromTrdSp(String storeId){
        TrdSpInfo trdSpInfo = getTrdSpInfoByStoreId(storeId);
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

        String clientId = trdSpInfo.getClientId();
        String clientSecret = trdSpInfo.getClientSecret();
        String username = trdSpInfo.getUsername();
        String password = trdSpInfo.getPassword();
        String grantType = trdSpInfo.getGrantType();
        String scope = trdSpInfo.getScope()==null?"":trdSpInfo.getScope();
//        String scope = "";

        String timestamp = format.format(new Date());

        String signStr = new StringBuilder().append(clientSecret).append(timestamp).append(clientId).append(username).append(password).append(grantType).append(scope).append(clientSecret).toString();
        String sign = null;
        try {
            sign = MD5Utils.encrypt(signStr).toUpperCase();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, Object> params = new HashMap<>();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("username", username);
        params.put("password", password);
        params.put("grant_type", grantType);
        params.put("timestamp", timestamp);
        params.put("scope", scope);
        params.put("sign", sign);
//        String tokenUrl = getBaseUrlByStoreId(storeId) + "/oauth/token?client_id={client_id}&client_secret={client_secret}&scope={scope}&grant_type={grant_type}&username={username}&password={password}&timestamp={timestamp}&sign={sign}";
        String tokenUrl = trdSpInfo.getUrl() + "/oauth/token?client_id={client_id}&client_secret={client_secret}&scope={scope}&grant_type={grant_type}&username={username}&password={password}&timestamp={timestamp}&sign={sign}";
        BusinessResponseVo<TokenVo> businessResponseVo = sslRestTemplate.postForObject(tokenUrl, null, new ParameterizedTypeReference<BusinessResponseVo<TokenVo>>() {
        }, params);
        TokenVo tokenVo = businessResponseVo.getResult();
        if(!Lang.isEmpty(tokenVo)) {
            //set tokenVo 进缓存
            String key = "TokenVo" + storeId;
            BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(key);
            boundValueOperations.set(tokenVo, 10, TimeUnit.MINUTES);
        }
        return tokenVo;
    }


    Map<String, Object> initParam(String storeId) {
        Map<String, Object> params = new HashMap<>();
        params.put("access_token", getTokenVo(storeId).getAccess_token());
        params.put("version", "1.0");
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        params.put("timestamp", format.format(new Date()));
        return params;
    }



}



