package provider.trdsp.service.config;

import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

/**
 * @author torvalds on 2018/7/10 17:21.
 * @version 1.0
 */
@Component
public class ApiRestTemplate extends RestTemplate {
//    MultiValueMap<String, String> headers =new LinkedMultiValueMap<>();
    public ApiRestTemplate() {
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        fastJsonHttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON,MediaType.TEXT_HTML));
        setMessageConverters(Arrays.asList(fastJsonHttpMessageConverter));
    }


    public <T> T postForObject(URI url, Object request,  ParameterizedTypeReference<T> parameterizedTypeReference) throws RestClientException {
        return exchange(url, HttpMethod.POST, new HttpEntity<>(request), parameterizedTypeReference).getBody();
    }


    public <T> T postForObject(String url, Object request,  ParameterizedTypeReference<T> parameterizedTypeReference, Object... uriVariables) throws RestClientException {
        return exchange(url, HttpMethod.POST, new HttpEntity<>(request), parameterizedTypeReference,uriVariables).getBody();
    }


    public <T> T postForObject(String url, Object request, ParameterizedTypeReference<T> parameterizedTypeReference, Map<String, ?> uriVariables) throws RestClientException {
        return exchange(url, HttpMethod.POST, new HttpEntity<>(request), parameterizedTypeReference,uriVariables).getBody();
    }

    public <T> T getForObject(String url, Object request, ParameterizedTypeReference<T> parameterizedTypeReference, Map<String, ?> uriVariables) throws RestClientException {
        return exchange(url, HttpMethod.GET, new HttpEntity<>(request), parameterizedTypeReference,uriVariables).getBody();
    }

}
