package provider.trdsp.service.config;

import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.SSLContext;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;

/**
 * @author Lans
 * @date 2018-7-13 16:16
 */
public class SslRestTemplate extends RestTemplate{

    public RestTemplate getSslRestTemplate(){
        org.apache.http.conn.ssl.TrustStrategy acceptingTrustStrategy = (X509Certificate[] chain, String authType) -> true;

        SSLContext sslContext = null;
        try {
            sslContext = org.apache.http.ssl.SSLContexts.custom()
                    .loadTrustMaterial(null, acceptingTrustStrategy)
                    .build();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        } catch (KeyStoreException e) {
            e.printStackTrace();
        }

        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);

        CloseableHttpClient httpClient = HttpClients.custom()
                .setSSLSocketFactory(csf)
                .build();

        HttpComponentsClientHttpRequestFactory requestFactory =
                new HttpComponentsClientHttpRequestFactory();

        requestFactory.setHttpClient(httpClient);
        RestTemplate restTemplate = new RestTemplate(requestFactory);

//////
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        fastJsonHttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON,MediaType.TEXT_HTML));
        restTemplate.setMessageConverters(Arrays.asList(fastJsonHttpMessageConverter));
//////
        return restTemplate;
    }


    public <T> T postForObject(URI url, Object request, ParameterizedTypeReference<T> parameterizedTypeReference) throws RestClientException {
        return getSslRestTemplate().exchange(url, HttpMethod.POST, new HttpEntity<>(request), parameterizedTypeReference).getBody();
    }


    public <T> T postForObject(String url, Object request,  ParameterizedTypeReference<T> parameterizedTypeReference, Object... uriVariables) throws RestClientException {
        return getSslRestTemplate().exchange(url, HttpMethod.POST, new HttpEntity<>(request), parameterizedTypeReference,uriVariables).getBody();
    }


    public <T> T postForObject(String url, Object request, ParameterizedTypeReference<T> parameterizedTypeReference, Map<String, ?> uriVariables) throws RestClientException {
        return getSslRestTemplate().exchange(url, HttpMethod.POST, new HttpEntity<>(request), parameterizedTypeReference,uriVariables).getBody();
    }

}
