package provider.trdsp.service.service;

import cart.api.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Service;
import provider.trdsp.model.po.TrdSpInfo;
import provider.trdsp.model.repository.TrdSpInfoRepos;
import provider.trdsp.model.repository.TrdSpUrlRepos;
import utils.Lang;

import java.util.concurrent.TimeUnit;

/**
 * @author Lans
 * @date 2018-7-31 14:02
 */
@Service
public class TrdSpUrlService {
    @Autowired
    private TrdSpUrlRepos trdSpUrlRepos;
    @Autowired
    private TrdSpInfoRepos trdSpInfoRepos;
    private RedisTemplate redisTemplate;
    @Autowired
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        redisTemplate.setKeySerializer(new StringRedisSerializer());
        this.redisTemplate = redisTemplate;
    }
//    public String getUrlByStoreId(String storeId){
//        String key = "trdspUrl" + storeId;
//        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(key);
//        if (boundValueOperations.get() != null) {
//                   return (String)boundValueOperations.get();
//        }else
//        {
//             TrdSpUrl trdSpUrl = trdSpUrlRepos.findByStoreId(storeId);
//            if (Lang.isEmpty(trdSpUrl) || Lang.isEmpty(trdSpUrl.getUrl())) {
//                throw new BusinessException("找不到第三方供应商的url");
//            } else {
//              //    boundValueOperations.set(trdSpUrl.getUrl(),12,TimeUnit.HOURS);
//                return trdSpUrl.getUrl();
//            }
//        }
//    }
//    public String getUrlByStoreId(String storeId){
//        String key = "TrdspUrlObject" + storeId;
//        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(key);
//        if (boundValueOperations.get() != null) {
//            TrdSpUrl trdSpUrl =  (TrdSpUrl)boundValueOperations.get();
//            return trdSpUrl.getUrl();
//        }else
//        {
//            TrdSpUrl trdSpUrl = trdSpUrlRepos.findByStoreId(storeId);
//            if (Lang.isEmpty(trdSpUrl) || Lang.isEmpty(trdSpUrl.getUrl())) {
//                throw new BusinessException("找不到第三方供应商的url");
//            } else {
//                    boundValueOperations.set(trdSpUrl,2,TimeUnit.MINUTES);
//                return trdSpUrl.getUrl();
//            }
//        }
//    }

//    public String getUrlByStoreId(String storeId){
//       return this.getTrdSpInfoByStoreId(storeId).getUrl();
//    }



    public TrdSpInfo getTrdSpInfoByStoreId(String storeId){
        String key = "TrdspInfo"+storeId;
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps(key);
        if(boundValueOperations.get() !=null){
            TrdSpInfo trdSpInfo = (TrdSpInfo)boundValueOperations.get();
            return  trdSpInfo;
        }else {
            TrdSpInfo trdSpInfo = trdSpInfoRepos.findByStoreId(storeId);
            if(Lang.isEmpty(trdSpInfo)){
                throw new BusinessException("找不到三方供应商的信息");
            }else {
                boundValueOperations.set(trdSpInfo,12,TimeUnit.MINUTES);
                return trdSpInfo;
            }
        }
    }
}
