/*
 * Decompiled with CFR 0.152.
 */
package provider.trdsp.service.apiImpl;

import cart.api.exception.BusinessException;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import provider.trdsp.api.TrdspApi;
import provider.trdsp.model.po.TrdSpInfo;
import provider.trdsp.service.config.ApiRestTemplate;
import provider.trdsp.service.config.Const;
import provider.trdsp.service.config.TrdspConfig;
import provider.trdsp.service.service.TrdSpUrlService;
import provider.trdsp.vo.BusinessResponseVo;
import provider.trdsp.vo.TokenVo;
import provider.trdsp.vo.in.FreightVo;
import provider.trdsp.vo.in.PreOrderVo;
import provider.trdsp.vo.in.ProviderOrderNoVo;
import provider.trdsp.vo.in.ReserveOrderIdVo;
import provider.trdsp.vo.in.ReserveOrderVo;
import provider.trdsp.vo.in.SkuVoInput;
import provider.trdsp.vo.in.SubOrderNoVo;
import provider.trdsp.vo.out.LogisticsVo;
import provider.trdsp.vo.out.OnlinePriceResultVo;
import provider.trdsp.vo.out.PriceResultVo;
import provider.trdsp.vo.out.ReserveVo;
import provider.trdsp.vo.out.StockResultVo;
import provider.trdsp.vo.out.TrdSpFreightVo;
import utils.Lang;
import utils.security.MD5Utils;

@MotanService
public class TrdspApiImpl
implements TrdspApi {
    @Autowired
    TrdspConfig trdspConfig;
    @Autowired
    private ApiRestTemplate sslRestTemplate;
    public static Logger logger = LoggerFactory.getLogger(TrdspApiImpl.class);
    String urlParam = "?access_token={access_token}&version={version}&timestamp={timestamp}";
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    TrdSpUrlService trdSpUrlService;

    public String getBaseUrlByStoreId(String storeId) {
        return this.getTrdSpInfoByStoreId(storeId).getUrl();
    }

    public TrdSpInfo getTrdSpInfoByStoreId(String storeId) {
        return this.trdSpUrlService.getTrdSpInfoByStoreId(storeId);
    }

    public BusinessResponseVo<LogisticsVo> getLogistics(SubOrderNoVo subOrderNoVo, String storeId) {
        String url = this.getBaseUrlByStoreId(storeId) + "/get/logisitics" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u7269\u6d41\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)subOrderNoVo));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)subOrderNoVo, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u7269\u6d41\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return businessResponseVo;
        }
        catch (Exception e) {
            logger.error("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u7269\u6d41\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u7269\u6d41\u51fa\u9519", (Throwable)e);
        }
    }

    public BusinessResponseVo<TrdSpFreightVo> getFreight(FreightVo freightVo, String storeId) {
        String url = this.getBaseUrlByStoreId(storeId) + "/get/freight" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u8fd0\u8d39\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)freightVo));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)freightVo, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u8fd0\u8d39\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return businessResponseVo;
        }
        catch (Exception e) {
            logger.error("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u8fd0\u8d39\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u8fd0\u8d39\u51fa\u9519", (Throwable)e);
        }
    }

    public BusinessResponseVo<OnlinePriceResultVo> getOnlinePrice(SkuVoInput skuVoInput, String storeId) throws BusinessException {
        if (skuVoInput.getSkus().size() > Const.SKU_OPEREATE_LIMIT) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef,\u4e0d\u80fd\u8d85\u8fc7100\u6761");
        }
        String url = this.getBaseUrlByStoreId(storeId) + "/get/online_price" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u5728\u7ebf\u4ef7\u683c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)skuVoInput));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)skuVoInput, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u5728\u7ebf\u4ef7\u683c\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return businessResponseVo;
        }
        catch (Exception e) {
            logger.error("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u5728\u7ebf\u4ef7\u683c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u5728\u7ebf\u4ef7\u683c\u51fa\u9519", (Throwable)e);
        }
    }

    public BusinessResponseVo<StockResultVo> getStock(SkuVoInput skuVoInput, String storeId) throws BusinessException {
        if (skuVoInput.getSkus().size() > Const.SKU_OPEREATE_LIMIT) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef,\u4e0d\u80fd\u8d85\u8fc7100\u6761");
        }
        String url = this.getBaseUrlByStoreId(storeId) + "/get/stock" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u5e93\u5b58\u6570\u91cf\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)skuVoInput));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)skuVoInput, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u5e93\u5b58\u6570\u91cf\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return businessResponseVo;
        }
        catch (Exception e) {
            logger.error("=====================\u83b7\u53d6\u4e09\u65b9\u5e93\u5b58\u6570\u91cf\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u4e09\u65b9\u5e93\u5b58\u6570\u91cf\u51fa\u9519", (Throwable)e);
        }
    }

    public BusinessResponseVo<PriceResultVo> getPrice(SkuVoInput skuVoInput, String storeId) throws BusinessException {
        if (skuVoInput.getSkus().size() > Const.SKU_OPEREATE_LIMIT) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef,\u4e0d\u80fd\u8d85\u8fc7100\u6761");
        }
        String url = this.getBaseUrlByStoreId(storeId) + "/get/price" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u4ef7\u683c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)skuVoInput));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)skuVoInput, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            logger.info("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u4ef7\u683c\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return businessResponseVo;
        }
        catch (Exception e) {
            logger.error("=====================\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u4ef7\u683c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u4e09\u65b9\u4f9b\u5e94\u5546\u5728\u7ebf\u4ef7\u683c\u51fa\u9519", (Throwable)e);
        }
    }

    public ReserveVo createReservation(ReserveOrderVo reserveOrderVo, String storeId) {
        String url = this.getBaseUrlByStoreId(storeId) + "/create/reservation" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u5360\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reserveOrderVo));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)reserveOrderVo, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            ReserveVo reserveVo = (ReserveVo)businessResponseVo.getResult();
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u5360\u5355\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return reserveVo;
        }
        catch (Exception e) {
            logger.error("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u5360\u5355\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u5360\u5355\u51fa\u9519", (Throwable)e);
        }
    }

    public Boolean delReservation(ReserveOrderIdVo reserveOrderIdVo, String storeId) {
        String url = this.getBaseUrlByStoreId(storeId) + "/delete/reservation" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5360\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)reserveOrderIdVo.getReserveOrderId());
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)reserveOrderIdVo, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            Boolean result = (Boolean)businessResponseVo.getResult();
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5360\u5355\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return result;
        }
        catch (Exception e) {
            logger.error("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5360\u5355\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5360\u5355\u51fa\u9519", (Throwable)e);
        }
    }

    public BusinessResponseVo<ProviderOrderNoVo> createPreOrder(PreOrderVo preOrderVo, String storeId) {
        String url = this.getBaseUrlByStoreId(storeId) + "/create/pre_order" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)preOrderVo));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)preOrderVo, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u8ba2\u5355\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return businessResponseVo;
        }
        catch (Exception e) {
            logger.error("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u8ba2\u5355\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u4e09\u65b9\u4f9b\u5e94\u5546\u751f\u6210\u9884\u8ba2\u5355\u51fa\u9519", (Throwable)e);
        }
    }

    public BusinessResponseVo<Boolean> delPreOrder(ProviderOrderNoVo providerOrderNoVo, String storeId) {
        String url = this.getBaseUrlByStoreId(storeId) + "/delete/pre_order" + this.urlParam;
        Map params = this.initParam(storeId);
        try {
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5b9a\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)providerOrderNoVo));
            BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(url, (Object)providerOrderNoVo, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            logger.info("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5b9a\u5355\u54cd\u5e94\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)businessResponseVo));
            return businessResponseVo;
        }
        catch (Exception e) {
            logger.error("=====================\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5b9a\u5355\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw new BusinessException("\u4e09\u65b9\u4f9b\u5e94\u5546\u53d6\u6d88\u9884\u5b9a\u5355\u51fa\u9519", (Throwable)e);
        }
    }

    public TokenVo getTokenVo(String storeId) {
        String key = "TokenVo" + storeId;
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        if (boundValueOperations.get() != null) {
            TokenVo tokenVo = (TokenVo)boundValueOperations.get();
            return tokenVo;
        }
        return this.getTokenFromTrdSp(storeId);
    }

    public TokenVo getTokenFromTrdSp(String storeId) {
        TrdSpInfo trdSpInfo = this.getTrdSpInfoByStoreId(storeId);
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        String clientId = trdSpInfo.getClientId();
        String clientSecret = trdSpInfo.getClientSecret();
        String username = trdSpInfo.getUsername();
        String password = trdSpInfo.getPassword();
        String grantType = trdSpInfo.getGrantType();
        String scope = trdSpInfo.getScope() == null ? "" : trdSpInfo.getScope();
        String timestamp = format.format(new Date());
        String signStr = clientSecret + timestamp + clientId + username + password + grantType + scope + clientSecret;
        String sign = null;
        try {
            sign = MD5Utils.encrypt((String)signStr).toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("username", username);
        params.put("password", password);
        params.put("grant_type", grantType);
        params.put("timestamp", timestamp);
        params.put("scope", scope);
        params.put("sign", sign);
        String tokenUrl = trdSpInfo.getUrl() + "/oauth/token?client_id={client_id}&client_secret={client_secret}&scope={scope}&grant_type={grant_type}&username={username}&password={password}&timestamp={timestamp}&sign={sign}";
        BusinessResponseVo businessResponseVo = (BusinessResponseVo)this.sslRestTemplate.postForObject(tokenUrl, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
        TokenVo tokenVo = (TokenVo)businessResponseVo.getResult();
        if (!Lang.isEmpty((Object)tokenVo)) {
            String key = "TokenVo" + storeId;
            BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
            boundValueOperations.set((Object)tokenVo, 10L, TimeUnit.MINUTES);
        }
        return tokenVo;
    }

    Map<String, Object> initParam(String storeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("access_token", this.getTokenVo(storeId).getAccess_token());
        params.put("version", "1.0");
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        params.put("timestamp", format.format(new Date()));
        return params;
    }
}

